/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.auth.api.signin.internal.zzk;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzpm;
import com.google.android.gms.internal.zzpp;
import com.google.android.gms.internal.zzpq;
import com.google.android.gms.internal.zzqa;
import com.google.android.gms.internal.zzqe;
import com.google.android.gms.internal.zzqh;
import com.google.android.gms.internal.zzqi;
import com.google.android.gms.internal.zzqn;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzqt;
import com.google.android.gms.internal.zzqu;
import com.google.android.gms.internal.zzqx;
import com.google.android.gms.internal.zzqy;
import com.google.android.gms.internal.zzre;
import com.google.android.gms.internal.zzvu;
import com.google.android.gms.internal.zzvv;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;

public final class zzpy
extends GoogleApiClient
implements zzqh.zza {
    private final Lock tr;
    private final zzl ua;
    private zzqh ub = null;
    private final int sf;
    private final Context mContext;
    private final Looper zzahv;
    final Queue<zzpm.zza<?, ?>> uc = new LinkedList();
    private volatile boolean ud;
    private long ue = 120000L;
    private long uf = 5000L;
    private final zza ug;
    private final GoogleApiAvailability sh;
    zzqe uh;
    final Map<Api.zzc<?>, Api.zze> ui;
    Set<Scope> uj = new HashSet<Scope>();
    final zzg tN;
    final Map<Api<?>, Integer> tO;
    final Api.zza<? extends zzvu, zzvv> si;
    private final zzqo uk = new zzqo();
    private final ArrayList<zzpp> ul;
    private Integer um = null;
    Set<zzqx> un = null;
    final zzqy uo;
    private final zzl.zza up = new zzl.zza(){

        @Override
        public boolean isConnected() {
            return zzpy.this.isConnected();
        }

        @Override
        public Bundle zzamh() {
            return null;
        }
    };

    public zzpy(Context context, Lock lock, Looper looper, zzg zzg2, GoogleApiAvailability googleApiAvailability, Api.zza<? extends zzvu, zzvv> zza2, Map<Api<?>, Integer> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.zzc<?>, Api.zze> map2, int n, int n2, ArrayList<zzpp> arrayList) {
        this.mContext = context;
        this.tr = lock;
        this.ua = new zzl(looper, this.up);
        this.zzahv = looper;
        this.ug = new zza(looper);
        this.sh = googleApiAvailability;
        this.sf = n;
        if (this.sf >= 0) {
            this.um = n2;
        }
        this.tO = map;
        this.ui = map2;
        this.ul = arrayList;
        this.uo = new zzqy(this.ui);
        for (GoogleApiClient.ConnectionCallbacks object : list) {
            this.ua.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : list2) {
            this.ua.registerConnectionFailedListener(onConnectionFailedListener);
        }
        this.tN = zzg2;
        this.si = zza2;
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzpm.zza<R, A>> T zzc(@NonNull T t) {
        zzab.zzb((t.zzans() != null ? 1 : 0) != 0, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        String string2 = t.zzanz() != null ? t.zzanz().getName() : "the API";
        zzab.zzb((boolean)this.ui.containsKey(t.zzans()), (Object)new StringBuilder(65 + String.valueOf(string2).length()).append("GoogleApiClient is not configured to use ").append(string2).append(" required for this call.").toString());
        this.tr.lock();
        try {
            if (this.ub == null) {
                this.uc.add(t);
                string2 = t;
                return (T)string2;
            }
            string2 = this.ub.zzc(t);
            return (T)string2;
        }
        finally {
            this.tr.unlock();
        }
    }

    @Override
    public <A extends Api.zzb, T extends zzpm.zza<? extends Result, A>> T zzd(@NonNull T t) {
        zzab.zzb((t.zzans() != null ? 1 : 0) != 0, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        Object object = t.zzanz() != null ? t.zzanz().getName() : "the API";
        zzab.zzb((boolean)this.ui.containsKey(t.zzans()), (Object)new StringBuilder(65 + String.valueOf(object).length()).append("GoogleApiClient is not configured to use ").append((String)object).append(" required for this call.").toString());
        this.tr.lock();
        try {
            if (this.ub == null) {
                throw new IllegalStateException("GoogleApiClient is not connected yet.");
            }
            if (this.isResuming()) {
                this.uc.add(t);
                while (!this.uc.isEmpty()) {
                    object = this.uc.remove();
                    this.uo.zzg(object);
                    ((zzpm.zza)object).zzz(Status.ss);
                }
                object = t;
                return (T)object;
            }
            object = this.ub.zzd(t);
            return (T)object;
        }
        finally {
            this.tr.unlock();
        }
    }

    @Override
    public <L> zzqn<L> zzs(@NonNull L l) {
        this.tr.lock();
        try {
            zzqn<L> zzqn2 = this.uk.zzb(l, this.zzahv);
            return zzqn2;
        }
        finally {
            this.tr.unlock();
        }
    }

    @Override
    @NonNull
    public <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        Api.zze zze2 = this.ui.get(zzc2);
        zzab.zzb((Object)zze2, (Object)"Appropriate Api was not requested.");
        return (C)zze2;
    }

    <C extends Api.zze> C zzb(Api.zzc<?> zzc2) {
        Api.zze zze2 = this.ui.get(zzc2);
        zzab.zzb((Object)zze2, (Object)"Appropriate Api was not requested.");
        return (C)zze2;
    }

    @Override
    public boolean zza(@NonNull Api<?> api) {
        return this.ui.containsKey(api.zzans());
    }

    @Override
    public boolean hasConnectedApi(@NonNull Api<?> api) {
        Api.zze zze2 = this.ui.get(api.zzans());
        return zze2 != null && zze2.isConnected();
    }

    @Override
    @NonNull
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        this.tr.lock();
        try {
            if (!this.isConnected() && !this.isResuming()) {
                throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
            }
            if (this.ui.containsKey(api.zzans())) {
                ConnectionResult connectionResult = this.ub.getConnectionResult(api);
                if (connectionResult == null) {
                    if (this.isResuming()) {
                        ConnectionResult connectionResult2 = ConnectionResult.rb;
                        return connectionResult2;
                    }
                    Log.w((String)"GoogleApiClientImpl", (String)this.zzapy());
                    Log.wtf((String)"GoogleApiClientImpl", (String)String.valueOf(api.getName()).concat(" requested in getConnectionResult is not connected but is not present in the failed  connections map"), (Throwable)new Exception());
                    ConnectionResult connectionResult3 = new ConnectionResult(8, null);
                    return connectionResult3;
                }
                ConnectionResult connectionResult4 = connectionResult;
                return connectionResult4;
            }
            throw new IllegalArgumentException(String.valueOf(api.getName()).concat(" was never registered with GoogleApiClient"));
        }
        finally {
            this.tr.unlock();
        }
    }

    @Override
    public void connect() {
        this.tr.lock();
        try {
            if (this.sf >= 0) {
                zzab.zza((this.um != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.um == null) {
                this.um = zzpy.zza(this.ui.values(), false);
            } else if (this.um == 2) {
                throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.connect(this.um);
        }
        finally {
            this.tr.unlock();
        }
    }

    @Override
    public void connect(int n) {
        this.tr.lock();
        try {
            zzab.zzb((n == 3 || n == 1 || n == 2 ? 1 : 0) != 0, (Object)new StringBuilder(33).append("Illegal sign-in mode: ").append(n).toString());
            this.zzfk(n);
            this.zzapt();
        }
        finally {
            this.tr.unlock();
        }
    }

    @Override
    public ConnectionResult blockingConnect() {
        zzab.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        this.tr.lock();
        try {
            if (this.sf >= 0) {
                zzab.zza((this.um != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.um == null) {
                this.um = zzpy.zza(this.ui.values(), false);
            } else if (this.um == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzfk(this.um);
            this.ua.zzasx();
            ConnectionResult connectionResult = this.ub.blockingConnect();
            return connectionResult;
        }
        finally {
            this.tr.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        zzab.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        zzab.zzb((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        this.tr.lock();
        try {
            if (this.um == null) {
                this.um = zzpy.zza(this.ui.values(), false);
            } else if (this.um == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzfk(this.um);
            this.ua.zzasx();
            ConnectionResult connectionResult = this.ub.blockingConnect(l, timeUnit);
            return connectionResult;
        }
        finally {
            this.tr.unlock();
        }
    }

    @Override
    public void disconnect() {
        this.tr.lock();
        try {
            this.uo.release();
            if (this.ub != null) {
                this.ub.disconnect();
            }
            this.uk.release();
            for (zzpm.zza zza2 : this.uc) {
                zza2.zza((zzqy.zzb)null);
                zza2.cancel();
            }
            this.uc.clear();
            if (this.ub == null) {
                return;
            }
            this.zzapw();
            this.ua.zzasw();
        }
        finally {
            this.tr.unlock();
        }
    }

    @Override
    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    @Override
    public PendingResult<Status> clearDefaultAccountAndReconnect() {
        zzab.zza((boolean)this.isConnected(), (Object)"GoogleApiClient is not connected yet.");
        zzab.zza((this.um != 2 ? 1 : 0) != 0, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        final zzqu zzqu2 = new zzqu(this);
        if (this.ui.containsKey(zzre.bJ)) {
            this.zza(this, zzqu2, false);
        } else {
            final AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

                @Override
                public void onConnected(Bundle bundle) {
                    zzpy.this.zza((GoogleApiClient)atomicReference.get(), zzqu2, true);
                }

                @Override
                public void onConnectionSuspended(int n) {
                }
            };
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(){

                @Override
                public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
                    zzqu2.zzc(new Status(8));
                }
            };
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(zzre.API).addConnectionCallbacks(connectionCallbacks).addOnConnectionFailedListener(onConnectionFailedListener).setHandler(this.ug).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return zzqu2;
    }

    private void zza(final GoogleApiClient googleApiClient, final zzqu zzqu2, final boolean bl) {
        zzre.zt.zzg(googleApiClient).setResultCallback(new ResultCallback<Status>(){

            public void zzp(@NonNull Status status) {
                zzk.zzbc(zzpy.this.mContext).zzagl();
                if (status.isSuccess() && zzpy.this.isConnected()) {
                    zzpy.this.reconnect();
                }
                zzqu2.zzc(status);
                if (bl) {
                    googleApiClient.disconnect();
                }
            }

            public /* synthetic */ void onResult(@NonNull Result result) {
                this.zzp((Status)result);
            }
        });
    }

    @Override
    public void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        this.zzb(new zzqi((Activity)fragmentActivity));
    }

    private void zzb(@NonNull zzqi zzqi2) {
        if (this.sf < 0) {
            throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
        }
        zzpk.zza(zzqi2).zzfh(this.sf);
    }

    @Override
    public boolean isConnected() {
        return this.ub != null && this.ub.isConnected();
    }

    @Override
    public boolean isConnecting() {
        return this.ub != null && this.ub.isConnecting();
    }

    boolean isResuming() {
        return this.ud;
    }

    private void zzfk(int n) {
        if (this.um == null) {
            this.um = n;
        } else if (this.um != n) {
            String string2 = String.valueOf(zzpy.zzfl(n));
            String string3 = String.valueOf(zzpy.zzfl(this.um));
            throw new IllegalStateException(new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Cannot use sign-in mode: ").append(string2).append(". Mode was already set to ").append(string3).toString());
        }
        if (this.ub != null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Api.zze zze2 : this.ui.values()) {
            if (zze2.zzafk()) {
                bl = true;
            }
            if (!zze2.zzafz()) continue;
            bl2 = true;
        }
        switch (this.um) {
            case 3: {
                break;
            }
            case 1: {
                if (!bl) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl2) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (!bl) break;
                this.ub = zzpq.zza(this.mContext, this, this.tr, this.zzahv, this.sh, this.ui, this.tN, this.tO, this.si, this.ul);
                return;
            }
        }
        this.ub = new zzqa(this.mContext, this, this.tr, this.zzahv, this.sh, this.ui, this.tN, this.tO, this.si, this.ul, this);
    }

    private void zzapt() {
        this.ua.zzasx();
        this.ub.connect();
    }

    private void resume() {
        this.tr.lock();
        try {
            if (this.isResuming()) {
                this.zzapt();
            }
        }
        finally {
            this.tr.unlock();
        }
    }

    private void zzapu() {
        this.tr.lock();
        try {
            boolean bl = this.zzapw();
            if (bl) {
                this.zzapt();
            }
        }
        finally {
            this.tr.unlock();
        }
    }

    void zzapv() {
        if (this.isResuming()) {
            return;
        }
        this.ud = true;
        if (this.uh == null) {
            this.uh = this.sh.zza(this.mContext.getApplicationContext(), new zzb(this));
        }
        this.ug.sendMessageDelayed(this.ug.obtainMessage(1), this.ue);
        this.ug.sendMessageDelayed(this.ug.obtainMessage(2), this.uf);
    }

    boolean zzapw() {
        if (!this.isResuming()) {
            return false;
        }
        this.ud = false;
        this.ug.removeMessages(2);
        this.ug.removeMessages(1);
        if (this.uh != null) {
            this.uh.unregister();
            this.uh = null;
        }
        return true;
    }

    @Override
    public void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.ua.registerConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.ua.isConnectionCallbacksRegistered(connectionCallbacks);
    }

    @Override
    public void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.ua.unregisterConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.ua.registerConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.ua.isConnectionFailedListenerRegistered(onConnectionFailedListener);
    }

    @Override
    public void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.ua.unregisterConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public void zzm(Bundle bundle) {
        while (!this.uc.isEmpty()) {
            this.zzd(this.uc.remove());
        }
        this.ua.zzo(bundle);
    }

    @Override
    public void zzd(ConnectionResult connectionResult) {
        if (!this.sh.zzc(this.mContext, connectionResult.getErrorCode())) {
            this.zzapw();
        }
        if (!this.isResuming()) {
            this.ua.zzm(connectionResult);
            this.ua.zzasw();
        }
    }

    @Override
    public void zzc(int n, boolean bl) {
        if (n == 1 && !bl) {
            this.zzapv();
        }
        this.uo.zzaqz();
        this.ua.zzgf(n);
        this.ua.zzasw();
        if (n == 2) {
            this.zzapt();
        }
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public Looper getLooper() {
        return this.zzahv;
    }

    @Override
    public boolean zza(zzqt zzqt2) {
        return this.ub != null && this.ub.zza(zzqt2);
    }

    @Override
    public void zzaof() {
        if (this.ub != null) {
            this.ub.zzaof();
        }
    }

    @Override
    public void zza(zzqx zzqx2) {
        this.tr.lock();
        try {
            if (this.un == null) {
                this.un = new HashSet<zzqx>();
            }
            this.un.add(zzqx2);
        }
        finally {
            this.tr.unlock();
        }
    }

    @Override
    public void zzb(zzqx zzqx2) {
        this.tr.lock();
        try {
            if (this.un == null) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
            } else if (!this.un.remove(zzqx2)) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
            } else if (!this.zzapx()) {
                this.ub.zzapb();
            }
        }
        finally {
            this.tr.unlock();
        }
    }

    boolean zzapx() {
        this.tr.lock();
        try {
            if (this.un == null) {
                boolean bl = false;
                return false;
            }
            boolean bl = !this.un.isEmpty();
            return bl;
        }
        finally {
            this.tr.unlock();
        }
    }

    String zzapy() {
        StringWriter stringWriter = new StringWriter();
        this.dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(this.mContext);
        printWriter.append(string2).append("mResuming=").print(this.ud);
        printWriter.append(" mWorkQueue.size()=").print(this.uc.size());
        this.uo.dump(printWriter);
        if (this.ub != null) {
            this.ub.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    public int getSessionId() {
        return System.identityHashCode(this);
    }

    public static int zza(Iterable<Api.zze> iterable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (Api.zze zze2 : iterable) {
            if (zze2.zzafk()) {
                bl2 = true;
            }
            if (!zze2.zzafz()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    static String zzfl(int n) {
        switch (n) {
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 1: {
                return "SIGN_IN_MODE_REQUIRED";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
        }
        return "UNKNOWN";
    }

    final class zza
    extends Handler {
        zza(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    zzpy.this.zzapu();
                    break;
                }
                case 2: {
                    zzpy.this.resume();
                    break;
                }
                default: {
                    int n = message.what;
                    Log.w((String)"GoogleApiClientImpl", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                }
            }
        }
    }

    static class zzb
    extends zzqe.zza {
        private WeakReference<zzpy> uu;

        zzb(zzpy zzpy2) {
            this.uu = new WeakReference<zzpy>(zzpy2);
        }

        @Override
        public void zzaou() {
            zzpy zzpy2 = (zzpy)this.uu.get();
            if (zzpy2 == null) {
                return;
            }
            zzpy2.resume();
        }
    }
}

