/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzah;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.internal.zzpi;
import com.google.android.gms.internal.zzpj;
import com.google.android.gms.internal.zzpl;
import com.google.android.gms.internal.zzpm;
import com.google.android.gms.internal.zzpr;
import com.google.android.gms.internal.zzqm;
import com.google.android.gms.internal.zzqw;
import com.google.android.gms.internal.zzqy;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class zzqc
implements Handler.Callback {
    private long uf = 5000L;
    private long ue = 120000L;
    private long uF = 10000L;
    private static final Object zzamr = new Object();
    private static zzqc uG;
    private final Context mContext;
    private final GoogleApiAvailability sh;
    private int uH = -1;
    private final AtomicInteger uI = new AtomicInteger(1);
    private final SparseArray<zzc<?>> uJ = new SparseArray();
    private final Map<zzpj<?>, zzc<?>> uK = new ConcurrentHashMap(5, 0.75f, 1);
    private zzpr uL = null;
    private final Set<zzpj<?>> uM = new com.google.android.gms.common.util.zza();
    private final Handler mHandler;
    private final ReferenceQueue<com.google.android.gms.common.api.zzc<?>> uN = new ReferenceQueue();
    private final SparseArray<zza> uO = new SparseArray();
    private zzb uP;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<zzqc, Integer> zza(Context context, com.google.android.gms.common.api.zzc<?> zzc2) {
        Object object = zzamr;
        synchronized (object) {
            if (uG == null) {
                uG = new zzqc(context.getApplicationContext());
            }
            int n = uG.zza(zzc2);
            return Pair.create((Object)uG, (Object)n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzqc zzaqd() {
        Object object = zzamr;
        synchronized (object) {
            return uG;
        }
    }

    private zzqc(Context context) {
        this(context, GoogleApiAvailability.getInstance());
    }

    private zzqc(Context context, GoogleApiAvailability googleApiAvailability) {
        this.mContext = context;
        HandlerThread handlerThread = new HandlerThread("GoogleApiHandler", 9);
        handlerThread.start();
        this.mHandler = new Handler(handlerThread.getLooper(), (Handler.Callback)this);
        this.sh = googleApiAvailability;
    }

    private int zza(com.google.android.gms.common.api.zzc<?> zzc2) {
        int n = this.uI.getAndIncrement();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6, n, 0, zzc2));
        return n;
    }

    @WorkerThread
    private void zza(com.google.android.gms.common.api.zzc<?> zzc2, int n) {
        zzpj<?> zzpj2 = zzc2.zzaob();
        if (!this.uK.containsKey(zzpj2)) {
            this.uK.put(zzpj2, new zzc(zzc2));
        }
        zzc<?> zzc3 = this.uK.get(zzpj2);
        zzc3.zzfn(n);
        this.uJ.put(n, zzc3);
        ((zzc)zzc3).connect();
        this.uO.put(n, (Object)new zza(zzc2, n, this.uN));
        if (this.uP == null || !this.uP.uR.get()) {
            this.uP = new zzb(this.uN, this.uO);
            this.uP.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(zzpr zzpr2) {
        Object object = zzamr;
        synchronized (object) {
            if (zzpr2 == null) {
                this.uL = null;
                this.uM.clear();
            }
        }
    }

    @WorkerThread
    public void zza(zzpl zzpl2) {
        Set<zzpj<?>> set = zzpl2.zzaoq();
        for (zzpj<?> zzpj2 : set) {
            zzc<?> zzc2 = this.uK.get(zzpj2);
            if (zzc2 == null) {
                zzpl2.cancel();
                return;
            }
            if (zzc2.isConnected()) {
                zzpl2.zza(zzpj2, ConnectionResult.rb);
                continue;
            }
            if (zzc2.zzaqj() != null) {
                zzpl2.zza(zzpj2, zzc2.zzaqj());
                continue;
            }
            zzc2.zzb(zzpl2);
        }
    }

    public void zzaoo() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3));
    }

    @WorkerThread
    private void zzaqe() {
        for (zzc<?> zzc2 : this.uK.values()) {
            zzc2.zzaqi();
            ((zzc)zzc2).connect();
        }
    }

    public void zzd(int n, boolean bl) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, n, bl ? 1 : 2));
    }

    @WorkerThread
    private void zze(int n, boolean bl) {
        zzc zzc2 = (zzc)this.uJ.get(n);
        if (zzc2 != null) {
            if (!bl) {
                this.uJ.delete(n);
            }
            zzc2.zzf(n, bl);
        } else {
            Log.wtf((String)"GoogleApiManager", (String)new StringBuilder(52).append("onRelease received for unknown instance: ").append(n).toString(), (Throwable)new Exception());
        }
    }

    @WorkerThread
    private void zzfm(int n) {
        zzc zzc2 = (zzc)this.uJ.get(n);
        if (zzc2 != null) {
            this.uJ.delete(n);
            zzc2.zzfo(n);
        } else {
            Log.wtf((String)"GoogleApiManager", (String)new StringBuilder(64).append("onCleanupLeakInternal received for unknown instance: ").append(n).toString(), (Throwable)new Exception());
        }
    }

    public <O extends Api.ApiOptions> void zza(com.google.android.gms.common.api.zzc<O> zzc2, int n, zzpm.zza<? extends Result, Api.zzb> zza2) {
        zzpi.zza zza3 = new zzpi.zza(zzc2.getInstanceId(), n, zza2);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)zza3));
    }

    public <O extends Api.ApiOptions, TResult> void zza(com.google.android.gms.common.api.zzc<O> zzc2, int n, zzqw<Api.zzb, TResult> zzqw2, TaskCompletionSource<TResult> taskCompletionSource) {
        zzpi.zzb<TResult> zzb2 = new zzpi.zzb<TResult>(zzc2.getInstanceId(), n, zzqw2, taskCompletionSource);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, zzb2));
    }

    @WorkerThread
    private void zza(zzpi zzpi2) {
        ((zzc)this.uJ.get(zzpi2.sx)).zzb(zzpi2);
    }

    @WorkerThread
    public boolean handleMessage(Message message) {
        switch (message.what) {
            case 1: {
                this.zza((zzpl)message.obj);
                break;
            }
            case 6: {
                this.zza((com.google.android.gms.common.api.zzc)message.obj, message.arg1);
                break;
            }
            case 3: {
                this.zzaqe();
                break;
            }
            case 2: {
                this.zzfm(message.arg1);
                break;
            }
            case 7: {
                this.zze(message.arg1, message.arg2 == 1);
                break;
            }
            case 4: {
                this.zza((zzpi)message.obj);
                break;
            }
            case 5: {
                if (this.uJ.get(message.arg1) == null) break;
                ((zzc)this.uJ.get(message.arg1)).zzab(new Status(17, "Error resolution was canceled by the user."));
                break;
            }
            case 8: {
                if (!this.uK.containsKey(message.obj)) break;
                ((zzc)this.uK.get(message.obj)).resume();
                break;
            }
            case 9: {
                if (!this.uK.containsKey(message.obj)) break;
                ((zzc)this.uK.get(message.obj)).zzapu();
                break;
            }
            case 10: {
                if (!this.uK.containsKey(message.obj)) break;
                ((zzc)this.uK.get(message.obj)).zzaqm();
                break;
            }
            default: {
                int n = message.what;
                Log.w((String)"GoogleApiManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                return false;
            }
        }
        return true;
    }

    boolean zzc(ConnectionResult connectionResult, int n) {
        if (connectionResult.hasResolution() || this.sh.isUserResolvableError(connectionResult.getErrorCode())) {
            this.sh.zza(this.mContext, connectionResult, n);
            return true;
        }
        return false;
    }

    public void zza(ConnectionResult connectionResult, int n) {
        if (!this.zzc(connectionResult, n)) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(5, n, 0));
        }
    }

    static /* synthetic */ zzpr zzd(zzqc zzqc2) {
        return null;
    }

    private static final class zzb
    extends Thread {
        private final ReferenceQueue<com.google.android.gms.common.api.zzc<?>> uN;
        private final SparseArray<zza> uO;
        private final AtomicBoolean uR = new AtomicBoolean();

        public zzb(ReferenceQueue<com.google.android.gms.common.api.zzc<?>> referenceQueue, SparseArray<zza> sparseArray) {
            super("GoogleApiCleanup");
            this.uN = referenceQueue;
            this.uO = sparseArray;
        }

        @Override
        public void run() {
            this.uR.set(true);
            Process.setThreadPriority((int)10);
            try {
                while (this.uR.get()) {
                    zza zza2 = (zza)this.uN.remove();
                    this.uO.remove(zza2.sx);
                    zza2.zzaqg();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.uR.set(false);
            }
        }
    }

    private final class zza
    extends PhantomReference<com.google.android.gms.common.api.zzc<?>> {
        private final int sx;

        public zza(com.google.android.gms.common.api.zzc zzc2, int n, ReferenceQueue<com.google.android.gms.common.api.zzc<?>> referenceQueue) {
            super(zzc2, referenceQueue);
            this.sx = n;
        }

        public void zzaqg() {
            zzqc.this.mHandler.sendMessage(zzqc.this.mHandler.obtainMessage(2, this.sx, 2));
        }
    }

    private class zzd
    implements zzd.zzf {
        private final Api.zze uT;
        private final zzpj<?> rQ;

        public zzd(Api.zze zze2, zzpj<?> zzpj2) {
            this.uT = zze2;
            this.rQ = zzpj2;
        }

        @WorkerThread
        public void zzh(@NonNull ConnectionResult connectionResult) {
            if (connectionResult.isSuccess()) {
                this.uT.zza(null, Collections.emptySet());
            } else {
                ((zzc)zzqc.this.uK.get(this.rQ)).onConnectionFailed(connectionResult);
            }
        }
    }

    private class zzc<O extends Api.ApiOptions>
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private final Queue<zzpi> uS = new LinkedList<zzpi>();
        private final Api.zze uT;
        private final Api.zzb uU;
        private final zzpj<O> rQ;
        private final SparseArray<zzqy> uV = new SparseArray();
        private final Set<zzpl> uW = new HashSet<zzpl>();
        private final SparseArray<Map<Object, zzpm.zza>> uX = new SparseArray();
        private boolean ud;
        private ConnectionResult uY = null;

        @WorkerThread
        public zzc(com.google.android.gms.common.api.zzc<O> zzc2) {
            this.uT = this.zzb(zzc2);
            this.uU = this.uT instanceof zzah ? ((zzah)this.uT).zzatn() : this.uT;
            this.rQ = zzc2.zzaob();
        }

        @Override
        @WorkerThread
        public void onConnected(@Nullable Bundle bundle) {
            this.zzaqi();
            this.zzj(ConnectionResult.rb);
            this.zzaqk();
            for (int i = 0; i < this.uX.size(); ++i) {
                Map map = (Map)this.uX.get(this.uX.keyAt(i));
                for (zzpm.zza zza2 : map.values()) {
                    try {
                        zza2.zzb(this.uU);
                    }
                    catch (DeadObjectException deadObjectException) {
                        this.uT.disconnect();
                        this.onConnectionSuspended(1);
                    }
                }
            }
            this.zzaqh();
            this.zzaql();
        }

        @Override
        @WorkerThread
        public void onConnectionSuspended(int n) {
            this.zzaqi();
            this.ud = true;
            zzqc.this.mHandler.sendMessageDelayed(Message.obtain((Handler)zzqc.this.mHandler, (int)8, this.rQ), zzqc.this.uf);
            zzqc.this.mHandler.sendMessageDelayed(Message.obtain((Handler)zzqc.this.mHandler, (int)9, this.rQ), zzqc.this.ue);
            zzqc.this.uH = -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @WorkerThread
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            this.zzaqi();
            zzqc.this.uH = -1;
            this.zzj(connectionResult);
            int n = this.uV.keyAt(0);
            if (this.uS.isEmpty()) {
                this.uY = connectionResult;
                return;
            }
            Object object = zzamr;
            synchronized (object) {
                if (zzqc.zzd(zzqc.this) != null && zzqc.this.uM.contains(this.rQ)) {
                    zzqc.zzd(zzqc.this).zzb(connectionResult, n);
                    return;
                }
            }
            if (!zzqc.this.zzc(connectionResult, n)) {
                if (connectionResult.getErrorCode() == 18) {
                    this.ud = true;
                }
                if (this.ud) {
                    zzqc.this.mHandler.sendMessageDelayed(Message.obtain((Handler)zzqc.this.mHandler, (int)8, this.rQ), zzqc.this.uf);
                } else {
                    object = String.valueOf(this.rQ.zzaon());
                    this.zzab(new Status(17, new StringBuilder(38 + String.valueOf(object).length()).append("API: ").append((String)object).append(" is not available on this device.").toString()));
                }
            }
        }

        @WorkerThread
        public void zzaqh() {
            while (this.uT.isConnected() && !this.uS.isEmpty()) {
                zzpi zzpi2 = this.uS.remove();
                this.zzc(zzpi2);
            }
        }

        @WorkerThread
        public void zzb(zzpi zzpi2) {
            if (this.uT.isConnected()) {
                this.zzc(zzpi2);
                this.zzaql();
            } else {
                this.uS.add(zzpi2);
                if (this.uY != null && this.uY.hasResolution()) {
                    this.onConnectionFailed(this.uY);
                } else {
                    this.connect();
                }
            }
        }

        @WorkerThread
        public void zzfn(int n) {
            this.uV.put(n, (Object)new zzqy(this.rQ.zzans(), this.uT));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void zzf(int n, boolean bl) {
            Object object;
            Iterator iterator = this.uS.iterator();
            while (iterator.hasNext()) {
                object = (zzpi)iterator.next();
                if (((zzpi)object).sx != n || ((zzpi)object).iq == 1 || !((zzpi)object).cancel()) continue;
                iterator.remove();
            }
            ((zzqy)this.uV.get(n)).release();
            this.uX.delete(n);
            if (!bl) {
                this.uV.remove(n);
                zzqc.this.uO.remove(n);
                if (this.uV.size() == 0 && this.uS.isEmpty()) {
                    this.zzaqk();
                    this.uT.disconnect();
                    zzqc.this.uK.remove(this.rQ);
                    object = zzamr;
                    synchronized (object) {
                        zzqc.this.uM.remove(this.rQ);
                    }
                }
            }
        }

        @WorkerThread
        public void zzfo(final int n) {
            ((zzqy)this.uV.get(n)).zza(new zzqy.zzc(){

                @Override
                public void zzaqn() {
                    if (zzc.this.uS.isEmpty()) {
                        zzc.this.zzf(n, false);
                    }
                }
            });
        }

        @WorkerThread
        public void zzaqi() {
            this.uY = null;
        }

        ConnectionResult zzaqj() {
            return this.uY;
        }

        @WorkerThread
        private void zzc(zzpi zzpi2) {
            zzpi2.zza(this.uV);
            if (zzpi2.iq == 3) {
                try {
                    Map map = (Map)this.uX.get(zzpi2.sx);
                    if (map == null) {
                        map = new ArrayMap(1);
                        this.uX.put(zzpi2.sx, (Object)map);
                    }
                    zzpm.zza<? extends Result, Api.zzb> zza2 = ((zzpi.zza)zzpi2).sy;
                    zzqm zzqm2 = (zzqm)((Object)zza2);
                    map.put(zzqm2.zzaqu(), zza2);
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalStateException("Listener registration methods must implement ListenerApiMethod");
                }
            }
            if (zzpi2.iq == 4) {
                try {
                    Map map = (Map)this.uX.get(zzpi2.sx);
                    zzqm zzqm3 = (zzqm)((Object)((zzpi.zza)zzpi2).sy);
                    if (map != null) {
                        map.remove(zzqm3.zzaqu());
                    } else {
                        Log.w((String)"GoogleApiManager", (String)"Received call to unregister a listener without a matching registration call.");
                    }
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalStateException("Listener unregistration methods must implement ListenerApiMethod");
                }
            }
            try {
                zzpi2.zzb(this.uU);
            }
            catch (DeadObjectException deadObjectException) {
                this.uT.disconnect();
                this.onConnectionSuspended(1);
            }
        }

        @WorkerThread
        private void zzab(Status status) {
            for (zzpi zzpi2 : this.uS) {
                zzpi2.zzx(status);
            }
            this.uS.clear();
        }

        @WorkerThread
        private void resume() {
            if (this.ud) {
                this.connect();
            }
        }

        @WorkerThread
        private void zzaqk() {
            if (this.ud) {
                zzqc.this.mHandler.removeMessages(9, this.rQ);
                zzqc.this.mHandler.removeMessages(8, this.rQ);
                this.ud = false;
            }
        }

        @WorkerThread
        private void zzapu() {
            if (this.ud) {
                this.zzaqk();
                int n = zzqc.this.sh.isGooglePlayServicesAvailable(zzqc.this.mContext);
                Status status = n == 18 ? new Status(8, "Connection timed out while waiting for Google Play services update to complete.") : new Status(8, "API failed to connect while resuming due to an unknown error.");
                this.zzab(status);
                this.uT.disconnect();
            }
        }

        private void zzaql() {
            zzqc.this.mHandler.removeMessages(10, this.rQ);
            zzqc.this.mHandler.sendMessageDelayed(zzqc.this.mHandler.obtainMessage(10, this.rQ), zzqc.this.uF);
        }

        private void zzaqm() {
            if (this.uT.isConnected() && this.uX.size() == 0) {
                for (int i = 0; i < this.uV.size(); ++i) {
                    zzqy zzqy2 = (zzqy)this.uV.get(this.uV.keyAt(i));
                    if (!zzqy2.zzara()) continue;
                    this.zzaql();
                    return;
                }
                this.uT.disconnect();
            }
        }

        @WorkerThread
        private Api.zze zzb(com.google.android.gms.common.api.zzc zzc2) {
            Api api = zzc2.zzanz();
            if (api.zzant()) {
                Api.zzh zzh2 = api.zzanr();
                return new zzah(zzc2.getApplicationContext(), zzqc.this.mHandler.getLooper(), zzh2.zzanw(), this, this, zzg.zzcd(zzc2.getApplicationContext()), zzh2.zzr(zzc2.zzaoa()));
            }
            return zzc2.zzanz().zzanq().zza(zzc2.getApplicationContext(), zzqc.this.mHandler.getLooper(), zzg.zzcd(zzc2.getApplicationContext()), zzc2.zzaoa(), this, this);
        }

        @WorkerThread
        private void connect() {
            if (this.uT.isConnected() || this.uT.isConnecting()) {
                return;
            }
            if (this.uT.zzanu() && zzqc.this.uH != 0) {
                zzqc.this.uH = zzqc.this.sh.isGooglePlayServicesAvailable(zzqc.this.mContext);
                if (zzqc.this.uH != 0) {
                    ConnectionResult connectionResult = new ConnectionResult(zzqc.this.uH, null);
                    this.onConnectionFailed(connectionResult);
                    return;
                }
            }
            this.uT.zza(new zzd(this.uT, this.rQ));
        }

        @WorkerThread
        public void zzb(zzpl zzpl2) {
            this.uW.add(zzpl2);
        }

        @WorkerThread
        private void zzj(ConnectionResult connectionResult) {
            for (zzpl zzpl2 : this.uW) {
                zzpl2.zza(this.rQ, connectionResult);
            }
            this.uW.clear();
        }

        boolean isConnected() {
            return this.uT.isConnected();
        }
    }
}

