/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.common.util.zzs;

public final class zzra
extends Drawable
implements Drawable.Callback {
    private int wQ = 0;
    private long zzczg;
    private int mFrom;
    private int wR;
    private int wS = 255;
    private int wT;
    private int wU = 0;
    private boolean wK = true;
    private boolean wV;
    private zzb wW;
    private Drawable wX;
    private Drawable wY;
    private boolean wZ;
    private boolean xa;
    private boolean xb;
    private int xc;

    public zzra(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zza.xd;
        }
        this.wX = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.wW.xf |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zza.xd;
        }
        this.wY = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.wW.xf |= drawable3.getChangingConfigurations();
    }

    zzra(zzb zzb2) {
        this.wW = new zzb(zzb2);
    }

    @TargetApi(value=11)
    public void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback;
        if (zzs.zzavn() && (callback = this.getCallback()) != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    @TargetApi(value=11)
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback;
        if (zzs.zzavn() && (callback = this.getCallback()) != null) {
            callback.scheduleDrawable((Drawable)this, runnable, l);
        }
    }

    @TargetApi(value=11)
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback;
        if (zzs.zzavn() && (callback = this.getCallback()) != null) {
            callback.unscheduleDrawable((Drawable)this, runnable);
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.wW.mChangingConfigurations | this.wW.xf;
    }

    public void setAlpha(int n) {
        if (this.wU == this.wS) {
            this.wU = n;
        }
        this.wS = n;
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.wX.setColorFilter(colorFilter);
        this.wY.setColorFilter(colorFilter);
    }

    public int getIntrinsicWidth() {
        return Math.max(this.wX.getIntrinsicWidth(), this.wY.getIntrinsicWidth());
    }

    public int getIntrinsicHeight() {
        return Math.max(this.wX.getIntrinsicHeight(), this.wY.getIntrinsicHeight());
    }

    protected void onBoundsChange(Rect rect) {
        this.wX.setBounds(rect);
        this.wY.setBounds(rect);
    }

    public Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.wW.mChangingConfigurations = this.getChangingConfigurations();
            return this.wW;
        }
        return null;
    }

    public int getOpacity() {
        if (!this.xb) {
            this.xc = Drawable.resolveOpacity((int)this.wX.getOpacity(), (int)this.wY.getOpacity());
            this.xb = true;
        }
        return this.xc;
    }

    public boolean canConstantState() {
        if (!this.wZ) {
            this.xa = this.wX.getConstantState() != null && this.wY.getConstantState() != null;
            this.wZ = true;
        }
        return this.xa;
    }

    public Drawable mutate() {
        if (!this.wV && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.wX.mutate();
            this.wY.mutate();
            this.wV = true;
        }
        return this;
    }

    public Drawable zzarq() {
        return this.wY;
    }

    public void startTransition(int n) {
        this.mFrom = 0;
        this.wR = this.wS;
        this.wU = 0;
        this.wT = n;
        this.wQ = 1;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.wQ) {
            case 1: {
                this.zzczg = SystemClock.uptimeMillis();
                bl = false;
                this.wQ = 2;
                break;
            }
            case 2: {
                if (this.zzczg < 0L) break;
                float f = (float)(SystemClock.uptimeMillis() - this.zzczg) / (float)this.wT;
                boolean bl2 = bl = f >= 1.0f;
                if (bl) {
                    this.wQ = 0;
                }
                f = Math.min(f, 1.0f);
                this.wU = (int)(0.0f + (float)(this.wR - 0) * f);
            }
        }
        int n = this.wU;
        boolean bl3 = this.wK;
        Drawable drawable2 = this.wX;
        Drawable drawable3 = this.wY;
        if (bl) {
            if (!bl3 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.wS) {
                drawable3.setAlpha(this.wS);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl3) {
            drawable2.setAlpha(this.wS - n);
        }
        drawable2.draw(canvas);
        if (bl3) {
            drawable2.setAlpha(this.wS);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.wS);
        }
        this.invalidateSelf();
    }

    private static final class com.google.android.gms.internal.zzra$zza
    extends Drawable {
        private static final com.google.android.gms.internal.zzra$zza xd = new com.google.android.gms.internal.zzra$zza();
        private static final zza xe = new zza();

        private com.google.android.gms.internal.zzra$zza() {
        }

        public void draw(Canvas canvas) {
        }

        public void setAlpha(int n) {
        }

        public void setColorFilter(ColorFilter colorFilter) {
        }

        public int getOpacity() {
            return -2;
        }

        public Drawable.ConstantState getConstantState() {
            return xe;
        }

        private static final class zza
        extends Drawable.ConstantState {
            private zza() {
            }

            public Drawable newDrawable() {
                return xd;
            }

            public int getChangingConfigurations() {
                return 0;
            }
        }
    }

    static final class zzb
    extends Drawable.ConstantState {
        int mChangingConfigurations;
        int xf;

        zzb(zzb zzb2) {
            if (zzb2 != null) {
                this.mChangingConfigurations = zzb2.mChangingConfigurations;
                this.xf = zzb2.xf;
            }
        }

        public Drawable newDrawable() {
            return new zzra(this);
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }
    }
}

