/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.ContentValues;
import android.database.CharArrayBuffer;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.data.zze;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzc;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@KeepName
public final class DataHolder
extends AbstractSafeParcelable
implements Closeable {
    public static final Parcelable.Creator<DataHolder> CREATOR = new zze();
    private final int mVersionCode;
    private final String[] zO;
    Bundle zP;
    private final CursorWindow[] zQ;
    private final int rR;
    private final Bundle zR;
    int[] zS;
    int zT;
    boolean mClosed = false;
    private boolean zU = true;
    private static final zza zV = new zza(new String[0], null){

        @Override
        public zza zzb(HashMap<String, Object> hashMap) {
            throw new UnsupportedOperationException("Cannot add data to empty builder");
        }

        @Override
        public zza zza(ContentValues contentValues) {
            throw new UnsupportedOperationException("Cannot add data to empty builder");
        }
    };

    DataHolder(int n, String[] stringArray, CursorWindow[] cursorWindowArray, int n2, Bundle bundle) {
        this.mVersionCode = n;
        this.zO = stringArray;
        this.zQ = cursorWindowArray;
        this.rR = n2;
        this.zR = bundle;
    }

    public DataHolder(String[] stringArray, CursorWindow[] cursorWindowArray, int n, Bundle bundle) {
        this.mVersionCode = 1;
        this.zO = (String[])zzac.zzy((Object)stringArray);
        this.zQ = (CursorWindow[])zzac.zzy((Object)cursorWindowArray);
        this.rR = n;
        this.zR = bundle;
        this.zzate();
    }

    private DataHolder(zza zza2, int n, Bundle bundle) {
        this(zza2.zO, DataHolder.zza(zza2, -1), n, bundle);
    }

    public void zzate() {
        int n;
        this.zP = new Bundle();
        for (n = 0; n < this.zO.length; ++n) {
            this.zP.putInt(this.zO[n], n);
        }
        this.zS = new int[this.zQ.length];
        n = 0;
        for (int i = 0; i < this.zQ.length; ++i) {
            this.zS[i] = n;
            int n2 = this.zQ[i].getStartPosition();
            int n3 = n - n2;
            n += this.zQ[i].getNumRows() - n3;
        }
        this.zT = n;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    String[] zzatf() {
        return this.zO;
    }

    CursorWindow[] zzatg() {
        return this.zQ;
    }

    public int getStatusCode() {
        return this.rR;
    }

    public Bundle zzasz() {
        return this.zR;
    }

    private static CursorWindow[] zza(zza zza2, int n) {
        if (zza2.zO.length == 0) {
            return new CursorWindow[0];
        }
        List list = n < 0 || n >= zza2.zW.size() ? zza2.zW : zza2.zW.subList(0, n);
        int n2 = list.size();
        CursorWindow cursorWindow = new CursorWindow(false);
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        arrayList.add(cursorWindow);
        cursorWindow.setNumColumns(zza2.zO.length);
        boolean bl = false;
        try {
            for (int i = 0; i < n2; ++i) {
                int n3;
                if (!cursorWindow.allocRow()) {
                    int n4 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(72).append("Allocating additional cursor window for large data set (row ").append(n4).append(")").toString());
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.zO.length);
                    arrayList.add(cursorWindow);
                    if (!cursorWindow.allocRow()) {
                        Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                        arrayList.remove(cursorWindow);
                        return arrayList.toArray(new CursorWindow[arrayList.size()]);
                    }
                }
                Map map = (Map)list.get(i);
                boolean bl2 = true;
                for (n3 = 0; n3 < zza2.zO.length && bl2; ++n3) {
                    String string2 = zza2.zO[n3];
                    Object v = map.get(string2);
                    if (v == null) {
                        bl2 = cursorWindow.putNull(i, n3);
                        continue;
                    }
                    if (v instanceof String) {
                        bl2 = cursorWindow.putString((String)v, i, n3);
                        continue;
                    }
                    if (v instanceof Long) {
                        bl2 = cursorWindow.putLong(((Long)v).longValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Integer) {
                        bl2 = cursorWindow.putLong((long)((Integer)v).intValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Boolean) {
                        boolean bl3 = (Boolean)v;
                        bl2 = cursorWindow.putLong(bl3 ? 1L : 0L, i, n3);
                        continue;
                    }
                    if (v instanceof byte[]) {
                        bl2 = cursorWindow.putBlob((byte[])v, i, n3);
                        continue;
                    }
                    if (v instanceof Double) {
                        bl2 = cursorWindow.putDouble(((Double)v).doubleValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Float) {
                        bl2 = cursorWindow.putDouble((double)((Float)v).floatValue(), i, n3);
                        continue;
                    }
                    String string3 = String.valueOf(v);
                    throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Unsupported object for column ").append(string2).append(": ").append(string3).toString());
                }
                if (!bl2) {
                    if (bl) {
                        String string4 = "Could not add the value to a new CursorWindow. The size of value may be larger than what a CursorWindow can handle.";
                        throw new zzb(string4);
                    }
                    n3 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(74).append("Couldn't populate window data for row ").append(n3).append(" - allocating new window.").toString());
                    cursorWindow.freeLastRow();
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.zO.length);
                    arrayList.add(cursorWindow);
                    --i;
                    bl = true;
                    continue;
                }
                bl = false;
            }
        }
        catch (RuntimeException runtimeException) {
            int n5 = arrayList.size();
            for (int i = 0; i < n5; ++i) {
                ((CursorWindow)arrayList.get(i)).close();
            }
            throw runtimeException;
        }
        return arrayList.toArray(new CursorWindow[arrayList.size()]);
    }

    private void zzi(String string2, int n) {
        if (this.zP == null || !this.zP.containsKey(string2)) {
            String string3 = String.valueOf(string2);
            throw new IllegalArgumentException(string3.length() != 0 ? "No such column: ".concat(string3) : new String("No such column: "));
        }
        if (this.isClosed()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n < 0 || n >= this.zT) {
            throw new CursorIndexOutOfBoundsException(n, this.zT);
        }
    }

    public boolean zzhm(String string2) {
        return this.zP.containsKey(string2);
    }

    public long zzb(String string2, int n, int n2) {
        this.zzi(string2, n);
        return this.zQ[n2].getLong(n, this.zP.getInt(string2));
    }

    public int zzc(String string2, int n, int n2) {
        this.zzi(string2, n);
        return this.zQ[n2].getInt(n, this.zP.getInt(string2));
    }

    public String zzd(String string2, int n, int n2) {
        this.zzi(string2, n);
        return this.zQ[n2].getString(n, this.zP.getInt(string2));
    }

    public boolean zze(String string2, int n, int n2) {
        this.zzi(string2, n);
        Long l = this.zQ[n2].getLong(n, this.zP.getInt(string2));
        return l == 1L;
    }

    public float zzf(String string2, int n, int n2) {
        this.zzi(string2, n);
        return this.zQ[n2].getFloat(n, this.zP.getInt(string2));
    }

    public byte[] zzg(String string2, int n, int n2) {
        this.zzi(string2, n);
        return this.zQ[n2].getBlob(n, this.zP.getInt(string2));
    }

    public Uri zzh(String string2, int n, int n2) {
        String string3 = this.zzd(string2, n, n2);
        return string3 == null ? null : Uri.parse((String)string3);
    }

    public void zza(String string2, int n, int n2, CharArrayBuffer charArrayBuffer) {
        this.zzi(string2, n);
        this.zQ[n2].copyStringToBuffer(n, this.zP.getInt(string2), charArrayBuffer);
    }

    public boolean zzi(String string2, int n, int n2) {
        this.zzi(string2, n);
        return this.zQ[n2].isNull(n, this.zP.getInt(string2));
    }

    public int getCount() {
        return this.zT;
    }

    public int zzgb(int n) {
        int n2;
        zzac.zzbr((n >= 0 && n < this.zT ? 1 : 0) != 0);
        for (n2 = 0; n2 < this.zS.length; ++n2) {
            if (n >= this.zS[n2]) continue;
            --n2;
            break;
        }
        if (n2 == this.zS.length) {
            --n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            return this.mClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            if (!this.mClosed) {
                this.mClosed = true;
                for (int i = 0; i < this.zQ.length; ++i) {
                    this.zQ[i].close();
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.zU && this.zQ.length > 0 && !this.isClosed()) {
                this.close();
                String string2 = String.valueOf(this.toString());
                Log.e((String)"DataBuffer", (String)new StringBuilder(178 + String.valueOf(string2).length()).append("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call release() on all DataBuffer extending objects when you are done with them. (internal object: ").append(string2).append(")").toString());
            }
        }
        finally {
            super.finalize();
        }
    }

    public static zza zzc(String[] stringArray) {
        return new zza(stringArray, null);
    }

    public static DataHolder zzgc(int n) {
        return DataHolder.zza(n, null);
    }

    public static DataHolder zza(int n, Bundle bundle) {
        return new DataHolder(zV, n, bundle);
    }

    public static class zzb
    extends RuntimeException {
        public zzb(String string2) {
            super(string2);
        }
    }

    public static class zza {
        private final String[] zO;
        private final ArrayList<HashMap<String, Object>> zW;
        private final String zX;
        private final HashMap<Object, Integer> zY;
        private boolean zZ;
        private String Aa;

        private zza(String[] stringArray, String string2) {
            this.zO = (String[])zzac.zzy((Object)stringArray);
            this.zW = new ArrayList();
            this.zX = string2;
            this.zY = new HashMap();
            this.zZ = false;
            this.Aa = null;
        }

        public zza zzb(HashMap<String, Object> hashMap) {
            zzc.zzu(hashMap);
            int n = this.zzc(hashMap);
            if (n == -1) {
                this.zW.add(hashMap);
            } else {
                this.zW.remove(n);
                this.zW.add(n, hashMap);
            }
            this.zZ = false;
            return this;
        }

        private int zzc(HashMap<String, Object> hashMap) {
            if (this.zX == null) {
                return -1;
            }
            Object object = hashMap.get(this.zX);
            if (object == null) {
                return -1;
            }
            Integer n = this.zY.get(object);
            if (n == null) {
                this.zY.put(object, this.zW.size());
                return -1;
            }
            return n;
        }

        public zza zza(ContentValues contentValues) {
            zzc.zzu((Object)contentValues);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(contentValues.size());
            Set set = contentValues.valueSet();
            for (Map.Entry entry : set) {
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
            return this.zzb(hashMap);
        }

        public DataHolder zzgd(int n) {
            return new DataHolder(this, n, null);
        }
    }
}

