/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.support.v4.util.LruCache;
import android.util.Log;
import android.widget.ImageView;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.images.zza;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzrv;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ImageManager {
    private static final Object Ae = new Object();
    private static HashSet<Uri> Af = new HashSet();
    private static ImageManager Ag;
    private static ImageManager Ah;
    private final Context mContext;
    private final Handler mHandler;
    private final ExecutorService Ai;
    private final zzb Aj;
    private final zzrv Ak;
    private final Map<com.google.android.gms.common.images.zza, ImageReceiver> Al;
    private final Map<Uri, ImageReceiver> Am;
    private final Map<Uri, Long> An;

    public static ImageManager create(Context context) {
        return ImageManager.zzg(context, false);
    }

    public static ImageManager zzg(Context context, boolean bl) {
        if (bl) {
            if (Ah == null) {
                Ah = new ImageManager(context, true);
            }
            return Ah;
        }
        if (Ag == null) {
            Ag = new ImageManager(context, false);
        }
        return Ag;
    }

    private ImageManager(Context context, boolean bl) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.Ai = Executors.newFixedThreadPool(4);
        if (bl) {
            this.Aj = new zzb(this.mContext);
            if (zzs.zzaxn()) {
                this.zzatk();
            }
        } else {
            this.Aj = null;
        }
        this.Ak = new zzrv();
        this.Al = new HashMap<com.google.android.gms.common.images.zza, ImageReceiver>();
        this.Am = new HashMap<Uri, ImageReceiver>();
        this.An = new HashMap<Uri, Long>();
    }

    @TargetApi(value=14)
    private void zzatk() {
        this.mContext.registerComponentCallbacks((ComponentCallbacks)new zze(this.Aj));
    }

    public void loadImage(ImageView imageView, Uri uri) {
        zza.zzb zzb2 = new zza.zzb(imageView, uri);
        this.zza(zzb2);
    }

    public void loadImage(ImageView imageView, int n) {
        zza.zzb zzb2 = new zza.zzb(imageView, n);
        this.zza(zzb2);
    }

    public void loadImage(ImageView imageView, Uri uri, int n) {
        zza.zzb zzb2 = new zza.zzb(imageView, uri);
        zzb2.zzgh(n);
        this.zza(zzb2);
    }

    public void loadImage(OnImageLoadedListener onImageLoadedListener, Uri uri) {
        zza.zzc zzc2 = new zza.zzc(onImageLoadedListener, uri);
        this.zza(zzc2);
    }

    public void loadImage(OnImageLoadedListener onImageLoadedListener, Uri uri, int n) {
        zza.zzc zzc2 = new zza.zzc(onImageLoadedListener, uri);
        zzc2.zzgh(n);
        this.zza(zzc2);
    }

    public void zza(com.google.android.gms.common.images.zza zza2) {
        com.google.android.gms.common.internal.zzc.zzhq((String)"ImageManager.loadImage() must be called in the main thread");
        zzd zzd2 = new zzd(zza2);
        zzd2.run();
    }

    private Bitmap zza(zza.zza zza2) {
        if (this.Aj == null) {
            return null;
        }
        Bitmap bitmap = (Bitmap)this.Aj.get(zza2);
        return bitmap;
    }

    @TargetApi(value=11)
    private static final class zza {
        static int zza(ActivityManager activityManager) {
            return activityManager.getLargeMemoryClass();
        }
    }

    private static final class zzb
    extends LruCache<zza.zza, Bitmap> {
        public zzb(Context context) {
            super(zzb.zzcc(context));
        }

        protected void zza(boolean bl, zza.zza zza2, Bitmap bitmap, Bitmap bitmap2) {
            super.entryRemoved(bl, (Object)zza2, (Object)bitmap, (Object)bitmap2);
        }

        @TargetApi(value=11)
        private static int zzcc(Context context) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            boolean bl = (context.getApplicationInfo().flags & 0x100000) != 0;
            int n = bl && zzs.zzaxk() ? zza.zza(activityManager) : activityManager.getMemoryClass();
            int n2 = 0x100000 * n;
            return (int)(0.33f * (float)n2);
        }

        protected int zza(zza.zza zza2, Bitmap bitmap) {
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        protected /* synthetic */ int sizeOf(Object object, Object object2) {
            return this.zza((zza.zza)object, (Bitmap)object2);
        }

        protected /* synthetic */ void entryRemoved(boolean bl, Object object, Object object2, Object object3) {
            this.zza(bl, (zza.zza)object, (Bitmap)object2, (Bitmap)object3);
        }
    }

    @TargetApi(value=14)
    private static final class zze
    implements ComponentCallbacks2 {
        private final zzb Aj;

        public zze(zzb zzb2) {
            this.Aj = zzb2;
        }

        public void onConfigurationChanged(Configuration configuration) {
        }

        public void onLowMemory() {
            this.Aj.evictAll();
        }

        public void onTrimMemory(int n) {
            if (n >= 60) {
                this.Aj.evictAll();
            } else if (n >= 20) {
                this.Aj.trimToSize(this.Aj.size() / 2);
            }
        }
    }

    private final class zzf
    implements Runnable {
        private final Uri mUri;
        private final Bitmap mBitmap;
        private final CountDownLatch zzamx;
        private boolean As;

        public zzf(Uri uri, Bitmap bitmap, boolean bl, CountDownLatch countDownLatch) {
            this.mUri = uri;
            this.mBitmap = bitmap;
            this.As = bl;
            this.zzamx = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ImageReceiver imageReceiver;
            boolean bl;
            com.google.android.gms.common.internal.zzc.zzhq((String)"OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl2 = bl = this.mBitmap != null;
            if (ImageManager.this.Aj != null) {
                if (this.As) {
                    ImageManager.this.Aj.evictAll();
                    System.gc();
                    this.As = false;
                    ImageManager.this.mHandler.post((Runnable)this);
                    return;
                }
                if (bl) {
                    ImageManager.this.Aj.put(new zza.zza(this.mUri), this.mBitmap);
                }
            }
            if ((imageReceiver = (ImageReceiver)((Object)ImageManager.this.Am.remove(this.mUri))) != null) {
                this.zza(imageReceiver, bl);
            }
            this.zzamx.countDown();
            Object object = Ae;
            synchronized (object) {
                Af.remove(this.mUri);
            }
        }

        private void zza(ImageReceiver imageReceiver, boolean bl) {
            ArrayList arrayList = imageReceiver.Ao;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                com.google.android.gms.common.images.zza zza2 = (com.google.android.gms.common.images.zza)arrayList.get(i);
                if (bl) {
                    zza2.zza(ImageManager.this.mContext, this.mBitmap, false);
                } else {
                    ImageManager.this.An.put(this.mUri, SystemClock.elapsedRealtime());
                    zza2.zza(ImageManager.this.mContext, ImageManager.this.Ak, false);
                }
                if (zza2 instanceof zza.zzc) continue;
                ImageManager.this.Al.remove(zza2);
            }
        }
    }

    private final class zzc
    implements Runnable {
        private final Uri mUri;
        private final ParcelFileDescriptor Aq;

        public zzc(Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.mUri = uri;
            this.Aq = parcelFileDescriptor;
        }

        @Override
        public void run() {
            com.google.android.gms.common.internal.zzc.zzhr((String)"LoadBitmapFromDiskRunnable can't be executed in the main thread");
            boolean bl = false;
            Bitmap bitmap = null;
            if (this.Aq != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.Aq.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    String string2 = String.valueOf(this.mUri);
                    Log.e((String)"ImageManager", (String)new StringBuilder(34 + String.valueOf(string2).length()).append("OOM while loading bitmap for uri: ").append(string2).toString(), (Throwable)outOfMemoryError);
                    bl = true;
                }
                try {
                    this.Aq.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ImageManager.this.mHandler.post((Runnable)new zzf(this.mUri, bitmap, bl, countDownLatch));
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                String string3 = String.valueOf(this.mUri);
                Log.w((String)"ImageManager", (String)new StringBuilder(32 + String.valueOf(string3).length()).append("Latch interrupted while posting ").append(string3).toString());
            }
        }
    }

    @KeepName
    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri mUri;
        private final ArrayList<com.google.android.gms.common.images.zza> Ao;

        ImageReceiver(Uri uri) {
            super(new Handler(Looper.getMainLooper()));
            this.mUri = uri;
            this.Ao = new ArrayList();
        }

        public void zzb(com.google.android.gms.common.images.zza zza2) {
            com.google.android.gms.common.internal.zzc.zzhq((String)"ImageReceiver.addImageRequest() must be called in the main thread");
            this.Ao.add(zza2);
        }

        public void zzc(com.google.android.gms.common.images.zza zza2) {
            com.google.android.gms.common.internal.zzc.zzhq((String)"ImageReceiver.removeImageRequest() must be called in the main thread");
            this.Ao.remove(zza2);
        }

        public void zzatm() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.mUri);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.mContext.sendBroadcast(intent);
        }

        public void onReceiveResult(int n, Bundle bundle) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)bundle.getParcelable("com.google.android.gms.extra.fileDescriptor");
            ImageManager.this.Ai.execute(new zzc(this.mUri, parcelFileDescriptor));
        }
    }

    private final class zzd
    implements Runnable {
        private final com.google.android.gms.common.images.zza Ar;

        public zzd(com.google.android.gms.common.images.zza zza2) {
            this.Ar = zza2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            com.google.android.gms.common.internal.zzc.zzhq((String)"LoadImageRunnable must be executed on the main thread");
            ImageReceiver imageReceiver = (ImageReceiver)((Object)ImageManager.this.Al.get(this.Ar));
            if (imageReceiver != null) {
                ImageManager.this.Al.remove(this.Ar);
                imageReceiver.zzc(this.Ar);
            }
            zza.zza zza2 = this.Ar.At;
            if (zza2.uri == null) {
                this.Ar.zza(ImageManager.this.mContext, ImageManager.this.Ak, true);
                return;
            }
            Bitmap bitmap = ImageManager.this.zza(zza2);
            if (bitmap != null) {
                this.Ar.zza(ImageManager.this.mContext, bitmap, true);
                return;
            }
            Long l = (Long)ImageManager.this.An.get(zza2.uri);
            if (l != null) {
                if (SystemClock.elapsedRealtime() - l < 3600000L) {
                    this.Ar.zza(ImageManager.this.mContext, ImageManager.this.Ak, true);
                    return;
                }
                ImageManager.this.An.remove(zza2.uri);
            }
            this.Ar.zza(ImageManager.this.mContext, ImageManager.this.Ak);
            imageReceiver = (ImageReceiver)((Object)ImageManager.this.Am.get(zza2.uri));
            if (imageReceiver == null) {
                imageReceiver = new ImageReceiver(zza2.uri);
                ImageManager.this.Am.put(zza2.uri, imageReceiver);
            }
            imageReceiver.zzb(this.Ar);
            if (!(this.Ar instanceof zza.zzc)) {
                ImageManager.this.Al.put(this.Ar, imageReceiver);
            }
            Object object = Ae;
            synchronized (object) {
                boolean bl = Af.contains(zza2.uri);
                if (!bl) {
                    Af.add(zza2.uri);
                    imageReceiver.zzatm();
                }
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2, boolean var3);
    }
}

