/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.support.annotation.NonNull;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzqd;
import com.google.android.gms.internal.zzqz;
import com.google.android.gms.internal.zzra;
import com.google.android.gms.internal.zzrb;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class zzqa
extends zzqd {
    private final SparseArray<zza> wq = new SparseArray();

    public static zzqa zza(zzqz zzqz2) {
        zzrb zzrb2 = zzqa.zzc((zzqz)zzqz2);
        zzqa zzqa2 = (zzqa)zzrb2.zza("AutoManageHelper", zzqa.class);
        if (zzqa2 != null) {
            return zzqa2;
        }
        return new zzqa(zzrb2);
    }

    private zzqa(zzrb zzrb2) {
        super(zzrb2);
        this.yY.zza("AutoManageHelper", (zzra)this);
    }

    public void zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzac.zzb((Object)googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        zzac.zza((this.wq.indexOfKey(n) < 0 ? 1 : 0) != 0, (Object)new StringBuilder(54).append("Already managing a GoogleApiClient with id ").append(n).toString());
        boolean bl = this.mStarted;
        boolean bl2 = this.wy;
        Log.d((String)"AutoManageHelper", (String)new StringBuilder(54).append("starting AutoManage for client ").append(n).append(" ").append(bl).append(" ").append(bl2).toString());
        zza zza2 = new zza(n, googleApiClient, onConnectionFailedListener);
        this.wq.put(n, (Object)zza2);
        if (this.mStarted && !this.wy) {
            String string2 = String.valueOf(googleApiClient);
            Log.d((String)"AutoManageHelper", (String)new StringBuilder(11 + String.valueOf(string2).length()).append("connecting ").append(string2).toString());
            googleApiClient.connect();
        }
    }

    public void zzfq(int n) {
        zza zza2 = (zza)this.wq.get(n);
        this.wq.remove(n);
        if (zza2 != null) {
            zza2.zzaql();
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        int n = this.mStarted;
        Object object = String.valueOf(this.wq);
        Log.d((String)"AutoManageHelper", (String)new StringBuilder(14 + String.valueOf(object).length()).append("onStart ").append(n != 0).append(" ").append((String)object).toString());
        if (!this.wy) {
            for (n = 0; n < this.wq.size(); ++n) {
                object = (zza)this.wq.valueAt(n);
                ((zza)object).ws.connect();
            }
        }
    }

    @Override
    public void onStop() {
        super.onStop();
        for (int i = 0; i < this.wq.size(); ++i) {
            zza zza2 = (zza)this.wq.valueAt(i);
            zza2.ws.disconnect();
        }
    }

    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        for (int i = 0; i < this.wq.size(); ++i) {
            zza zza2 = (zza)this.wq.valueAt(i);
            zza2.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    @Override
    protected void zza(ConnectionResult connectionResult, int n) {
        Log.w((String)"AutoManageHelper", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        if (n < 0) {
            Log.wtf((String)"AutoManageHelper", (String)"AutoManageLifecycleHelper received onErrorResolutionFailed callback but no failing client ID is set", (Throwable)new Exception());
            return;
        }
        zza zza2 = (zza)this.wq.get(n);
        if (zza2 != null) {
            this.zzfq(n);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = zza2.wt;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
    }

    @Override
    protected void zzaqk() {
        for (int i = 0; i < this.wq.size(); ++i) {
            zza zza2 = (zza)this.wq.valueAt(i);
            zza2.ws.connect();
        }
    }

    private class zza
    implements GoogleApiClient.OnConnectionFailedListener {
        public final int wr;
        public final GoogleApiClient ws;
        public final GoogleApiClient.OnConnectionFailedListener wt;

        public zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.wr = n;
            this.ws = googleApiClient;
            this.wt = onConnectionFailedListener;
            googleApiClient.registerConnectionFailedListener(this);
        }

        @Override
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            String string2 = String.valueOf(connectionResult);
            Log.d((String)"AutoManageHelper", (String)new StringBuilder(27 + String.valueOf(string2).length()).append("beginFailureResolution for ").append(string2).toString());
            zzqa.this.zzb(connectionResult, this.wr);
        }

        public void zzaql() {
            this.ws.unregisterConnectionFailedListener(this);
            this.ws.disconnect();
        }

        public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
            printWriter.append(string2).append("GoogleApiClient #").print(this.wr);
            printWriter.println(":");
            this.ws.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        }
    }
}

