/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Dialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.annotation.MainThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.GoogleApiActivity;
import com.google.android.gms.internal.zzqv;
import com.google.android.gms.internal.zzra;
import com.google.android.gms.internal.zzrb;

public abstract class zzqd
extends zzra
implements DialogInterface.OnCancelListener {
    protected boolean mStarted;
    protected boolean wy;
    private ConnectionResult wz;
    private int wA = -1;
    private final Handler wB = new Handler(Looper.getMainLooper());
    protected final GoogleApiAvailability vP;

    protected zzqd(zzrb zzrb2) {
        this(zzrb2, GoogleApiAvailability.getInstance());
    }

    zzqd(zzrb zzrb2, GoogleApiAvailability googleApiAvailability) {
        super(zzrb2);
        this.vP = googleApiAvailability;
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zza(new ConnectionResult(13, null), this.wA);
        this.zzaqo();
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (bundle != null) {
            this.wy = bundle.getBoolean("resolving_error", false);
            if (this.wy) {
                this.wA = bundle.getInt("failed_client_id", -1);
                this.wz = new ConnectionResult(bundle.getInt("failed_status"), (PendingIntent)bundle.getParcelable("failed_resolution"));
            }
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("resolving_error", this.wy);
        if (this.wy) {
            bundle.putInt("failed_client_id", this.wA);
            bundle.putInt("failed_status", this.wz.getErrorCode());
            bundle.putParcelable("failed_resolution", (Parcelable)this.wz.getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        this.mStarted = true;
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        boolean bl = false;
        switch (n) {
            case 2: {
                int n3 = this.vP.isGooglePlayServicesAvailable((Context)this.getActivity());
                if (n3 == 0) {
                    bl = true;
                }
                if (this.wz.getErrorCode() != 18 || n3 != 18) break;
                return;
            }
            case 1: {
                if (n2 == -1) {
                    bl = true;
                    break;
                }
                if (n2 != 0) break;
                int n4 = 13;
                if (intent != null) {
                    n4 = intent.getIntExtra("<<ResolutionFailureErrorDetail>>", 13);
                }
                this.wz = new ConnectionResult(n4, null);
            }
        }
        if (bl) {
            this.zzaqo();
        } else {
            this.zza(this.wz, this.wA);
        }
    }

    public void onStop() {
        super.onStop();
        this.mStarted = false;
    }

    protected abstract void zza(ConnectionResult var1, int var2);

    protected abstract void zzaqk();

    protected void zzaqo() {
        this.wA = -1;
        this.wy = false;
        this.wz = null;
        this.zzaqk();
    }

    public void zzb(ConnectionResult connectionResult, int n) {
        if (!this.wy) {
            this.wy = true;
            this.wA = n;
            this.wz = connectionResult;
            this.wB.post((Runnable)new zza());
        }
    }

    private class zza
    implements Runnable {
        private zza() {
        }

        @Override
        @MainThread
        public void run() {
            if (!zzqd.this.mStarted) {
                return;
            }
            if (zzqd.this.wz.hasResolution()) {
                zzqd.this.yY.startActivityForResult(GoogleApiActivity.zzb((Context)zzqd.this.getActivity(), zzqd.this.wz.getResolution(), zzqd.this.wA, false), 1);
            } else if (zzqd.this.vP.isUserResolvableError(zzqd.this.wz.getErrorCode())) {
                zzqd.this.vP.zza(zzqd.this.getActivity(), zzqd.this.yY, zzqd.this.wz.getErrorCode(), 2, zzqd.this);
            } else if (zzqd.this.wz.getErrorCode() == 18) {
                final Dialog dialog = zzqd.this.vP.zza(zzqd.this.getActivity(), zzqd.this);
                zzqd.this.vP.zza(zzqd.this.getActivity().getApplicationContext(), new zzqv.zza(){

                    @Override
                    public void zzaqp() {
                        zzqd.this.zzaqo();
                        if (dialog.isShowing()) {
                            dialog.dismiss();
                        }
                    }
                });
            } else {
                zzqd.this.zza(zzqd.this.wz, zzqd.this.wA);
            }
        }
    }
}

