/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.ContentValues;
import android.database.CharArrayBuffer;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.data.zze;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzc;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@KeepName
public final class DataHolder
extends AbstractSafeParcelable
implements Closeable {
    public static final Parcelable.Creator<DataHolder> CREATOR = new zze();
    final int mVersionCode;
    private final String[] BY;
    Bundle BZ;
    private final CursorWindow[] Ca;
    private final int uo;
    private final Bundle Cb;
    int[] Cc;
    int Cd;
    boolean mClosed = false;
    private boolean Ce = true;
    private static final zza Cf = new zza(new String[0], null){

        @Override
        public zza zzb(HashMap<String, Object> hashMap) {
            throw new UnsupportedOperationException("Cannot add data to empty builder");
        }

        @Override
        public zza zza(ContentValues contentValues) {
            throw new UnsupportedOperationException("Cannot add data to empty builder");
        }
    };

    DataHolder(int n, String[] stringArray, CursorWindow[] cursorWindowArray, int n2, Bundle bundle) {
        this.mVersionCode = n;
        this.BY = stringArray;
        this.Ca = cursorWindowArray;
        this.uo = n2;
        this.Cb = bundle;
    }

    public DataHolder(String[] stringArray, CursorWindow[] cursorWindowArray, int n, Bundle bundle) {
        this.mVersionCode = 1;
        this.BY = (String[])zzaa.zzy((Object)stringArray);
        this.Ca = (CursorWindow[])zzaa.zzy((Object)cursorWindowArray);
        this.uo = n;
        this.Cb = bundle;
        this.zzaun();
    }

    private DataHolder(zza zza2, int n, Bundle bundle) {
        this(zza2.BY, DataHolder.zza(zza2, -1), n, bundle);
    }

    public void zzaun() {
        int n;
        this.BZ = new Bundle();
        for (n = 0; n < this.BY.length; ++n) {
            this.BZ.putInt(this.BY[n], n);
        }
        this.Cc = new int[this.Ca.length];
        n = 0;
        for (int i = 0; i < this.Ca.length; ++i) {
            this.Cc[i] = n;
            int n2 = this.Ca[i].getStartPosition();
            int n3 = n - n2;
            n += this.Ca[i].getNumRows() - n3;
        }
        this.Cd = n;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n);
    }

    String[] zzauo() {
        return this.BY;
    }

    CursorWindow[] zzaup() {
        return this.Ca;
    }

    public int getStatusCode() {
        return this.uo;
    }

    public Bundle zzaui() {
        return this.Cb;
    }

    private static CursorWindow[] zza(zza zza2, int n) {
        if (zza2.BY.length == 0) {
            return new CursorWindow[0];
        }
        List list = n < 0 || n >= zza2.Cg.size() ? zza2.Cg : zza2.Cg.subList(0, n);
        int n2 = list.size();
        CursorWindow cursorWindow = new CursorWindow(false);
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        arrayList.add(cursorWindow);
        cursorWindow.setNumColumns(zza2.BY.length);
        boolean bl = false;
        try {
            for (int i = 0; i < n2; ++i) {
                int n3;
                if (!cursorWindow.allocRow()) {
                    int n4 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(72).append("Allocating additional cursor window for large data set (row ").append(n4).append(")").toString());
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.BY.length);
                    arrayList.add(cursorWindow);
                    if (!cursorWindow.allocRow()) {
                        Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                        arrayList.remove(cursorWindow);
                        return arrayList.toArray(new CursorWindow[arrayList.size()]);
                    }
                }
                Map map = (Map)list.get(i);
                boolean bl2 = true;
                for (n3 = 0; n3 < zza2.BY.length && bl2; ++n3) {
                    String string2 = zza2.BY[n3];
                    Object v = map.get(string2);
                    if (v == null) {
                        bl2 = cursorWindow.putNull(i, n3);
                        continue;
                    }
                    if (v instanceof String) {
                        bl2 = cursorWindow.putString((String)v, i, n3);
                        continue;
                    }
                    if (v instanceof Long) {
                        bl2 = cursorWindow.putLong(((Long)v).longValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Integer) {
                        bl2 = cursorWindow.putLong((long)((Integer)v).intValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Boolean) {
                        boolean bl3 = (Boolean)v;
                        bl2 = cursorWindow.putLong(bl3 ? 1L : 0L, i, n3);
                        continue;
                    }
                    if (v instanceof byte[]) {
                        bl2 = cursorWindow.putBlob((byte[])v, i, n3);
                        continue;
                    }
                    if (v instanceof Double) {
                        bl2 = cursorWindow.putDouble(((Double)v).doubleValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Float) {
                        bl2 = cursorWindow.putDouble((double)((Float)v).floatValue(), i, n3);
                        continue;
                    }
                    String string3 = String.valueOf(v);
                    throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Unsupported object for column ").append(string2).append(": ").append(string3).toString());
                }
                if (!bl2) {
                    if (bl) {
                        String string4 = "Could not add the value to a new CursorWindow. The size of value may be larger than what a CursorWindow can handle.";
                        throw new zzb(string4);
                    }
                    n3 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(74).append("Couldn't populate window data for row ").append(n3).append(" - allocating new window.").toString());
                    cursorWindow.freeLastRow();
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.BY.length);
                    arrayList.add(cursorWindow);
                    --i;
                    bl = true;
                    continue;
                }
                bl = false;
            }
        }
        catch (RuntimeException runtimeException) {
            int n5 = arrayList.size();
            for (int i = 0; i < n5; ++i) {
                ((CursorWindow)arrayList.get(i)).close();
            }
            throw runtimeException;
        }
        return arrayList.toArray(new CursorWindow[arrayList.size()]);
    }

    private void zzi(String string2, int n) {
        if (this.BZ == null || !this.BZ.containsKey(string2)) {
            String string3 = String.valueOf(string2);
            throw new IllegalArgumentException(string3.length() != 0 ? "No such column: ".concat(string3) : new String("No such column: "));
        }
        if (this.isClosed()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n < 0 || n >= this.Cd) {
            throw new CursorIndexOutOfBoundsException(n, this.Cd);
        }
    }

    public boolean zzho(String string2) {
        return this.BZ.containsKey(string2);
    }

    public long zzb(String string2, int n, int n2) {
        this.zzi(string2, n);
        return this.Ca[n2].getLong(n, this.BZ.getInt(string2));
    }

    public int zzc(String string2, int n, int n2) {
        this.zzi(string2, n);
        return this.Ca[n2].getInt(n, this.BZ.getInt(string2));
    }

    public String zzd(String string2, int n, int n2) {
        this.zzi(string2, n);
        return this.Ca[n2].getString(n, this.BZ.getInt(string2));
    }

    public boolean zze(String string2, int n, int n2) {
        this.zzi(string2, n);
        Long l = this.Ca[n2].getLong(n, this.BZ.getInt(string2));
        return l == 1L;
    }

    public float zzf(String string2, int n, int n2) {
        this.zzi(string2, n);
        return this.Ca[n2].getFloat(n, this.BZ.getInt(string2));
    }

    public byte[] zzg(String string2, int n, int n2) {
        this.zzi(string2, n);
        return this.Ca[n2].getBlob(n, this.BZ.getInt(string2));
    }

    public Uri zzh(String string2, int n, int n2) {
        String string3 = this.zzd(string2, n, n2);
        return string3 == null ? null : Uri.parse((String)string3);
    }

    public void zza(String string2, int n, int n2, CharArrayBuffer charArrayBuffer) {
        this.zzi(string2, n);
        this.Ca[n2].copyStringToBuffer(n, this.BZ.getInt(string2), charArrayBuffer);
    }

    public boolean zzi(String string2, int n, int n2) {
        this.zzi(string2, n);
        return this.Ca[n2].isNull(n, this.BZ.getInt(string2));
    }

    public int getCount() {
        return this.Cd;
    }

    public int zzga(int n) {
        int n2;
        zzaa.zzbs((n >= 0 && n < this.Cd ? 1 : 0) != 0);
        for (n2 = 0; n2 < this.Cc.length; ++n2) {
            if (n >= this.Cc[n2]) continue;
            --n2;
            break;
        }
        if (n2 == this.Cc.length) {
            --n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            return this.mClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            if (!this.mClosed) {
                this.mClosed = true;
                for (int i = 0; i < this.Ca.length; ++i) {
                    this.Ca[i].close();
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.Ce && this.Ca.length > 0 && !this.isClosed()) {
                this.close();
                String string2 = String.valueOf(this.toString());
                Log.e((String)"DataBuffer", (String)new StringBuilder(178 + String.valueOf(string2).length()).append("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call release() on all DataBuffer extending objects when you are done with them. (internal object: ").append(string2).append(")").toString());
            }
        }
        finally {
            super.finalize();
        }
    }

    public static zza zzc(String[] stringArray) {
        return new zza(stringArray, null);
    }

    public static DataHolder zzgb(int n) {
        return DataHolder.zza(n, null);
    }

    public static DataHolder zza(int n, Bundle bundle) {
        return new DataHolder(Cf, n, bundle);
    }

    public static class zzb
    extends RuntimeException {
        public zzb(String string2) {
            super(string2);
        }
    }

    public static class zza {
        private final String[] BY;
        private final ArrayList<HashMap<String, Object>> Cg;
        private final String Ch;
        private final HashMap<Object, Integer> Ci;
        private boolean Cj;
        private String Ck;

        private zza(String[] stringArray, String string2) {
            this.BY = (String[])zzaa.zzy((Object)stringArray);
            this.Cg = new ArrayList();
            this.Ch = string2;
            this.Ci = new HashMap();
            this.Cj = false;
            this.Ck = null;
        }

        public zza zzb(HashMap<String, Object> hashMap) {
            zzc.zzu(hashMap);
            int n = this.zzc(hashMap);
            if (n == -1) {
                this.Cg.add(hashMap);
            } else {
                this.Cg.remove(n);
                this.Cg.add(n, hashMap);
            }
            this.Cj = false;
            return this;
        }

        private int zzc(HashMap<String, Object> hashMap) {
            if (this.Ch == null) {
                return -1;
            }
            Object object = hashMap.get(this.Ch);
            if (object == null) {
                return -1;
            }
            Integer n = this.Ci.get(object);
            if (n == null) {
                this.Ci.put(object, this.Cg.size());
                return -1;
            }
            return n;
        }

        public zza zza(ContentValues contentValues) {
            zzc.zzu((Object)contentValues);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(contentValues.size());
            Set set = contentValues.valueSet();
            for (Map.Entry entry : set) {
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
            return this.zzb(hashMap);
        }

        public DataHolder zzgc(int n) {
            return new DataHolder(this, n, null);
        }
    }
}

