/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.support.annotation.NonNull;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzqp;
import com.google.android.gms.internal.zzrn;
import com.google.android.gms.internal.zzro;
import com.google.android.gms.internal.zzrp;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class zzqm
extends zzqp {
    private final SparseArray<zza> yq = new SparseArray();

    public static zzqm zza(zzrn zzrn2) {
        zzrp zzrp2 = zzqm.zzc((zzrn)zzrn2);
        zzqm zzqm2 = (zzqm)zzrp2.zza("AutoManageHelper", zzqm.class);
        if (zzqm2 != null) {
            return zzqm2;
        }
        return new zzqm(zzrp2);
    }

    private zzqm(zzrp zzrp2) {
        super(zzrp2);
        this.Bf.zza("AutoManageHelper", (zzro)this);
    }

    public void zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzaa.zzb((Object)googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        zzaa.zza((this.yq.indexOfKey(n) < 0 ? 1 : 0) != 0, (Object)new StringBuilder(54).append("Already managing a GoogleApiClient with id ").append(n).toString());
        boolean bl = this.mStarted;
        boolean bl2 = this.yz;
        Log.d((String)"AutoManageHelper", (String)new StringBuilder(54).append("starting AutoManage for client ").append(n).append(" ").append(bl).append(" ").append(bl2).toString());
        zza zza2 = new zza(n, googleApiClient, onConnectionFailedListener);
        this.yq.put(n, (Object)zza2);
        if (this.mStarted && !this.yz) {
            String string2 = String.valueOf(googleApiClient);
            Log.d((String)"AutoManageHelper", (String)new StringBuilder(11 + String.valueOf(string2).length()).append("connecting ").append(string2).toString());
            googleApiClient.connect();
        }
    }

    public void zzfs(int n) {
        zza zza2 = (zza)this.yq.get(n);
        this.yq.remove(n);
        if (zza2 != null) {
            zza2.zzarn();
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        int n = this.mStarted;
        Object object = String.valueOf(this.yq);
        Log.d((String)"AutoManageHelper", (String)new StringBuilder(14 + String.valueOf(object).length()).append("onStart ").append(n != 0).append(" ").append((String)object).toString());
        if (!this.yz) {
            for (n = 0; n < this.yq.size(); ++n) {
                object = (zza)this.yq.valueAt(n);
                ((zza)object).ys.connect();
            }
        }
    }

    @Override
    public void onStop() {
        super.onStop();
        for (int i = 0; i < this.yq.size(); ++i) {
            zza zza2 = (zza)this.yq.valueAt(i);
            zza2.ys.disconnect();
        }
    }

    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        for (int i = 0; i < this.yq.size(); ++i) {
            zza zza2 = (zza)this.yq.valueAt(i);
            zza2.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    @Override
    protected void zza(ConnectionResult connectionResult, int n) {
        Log.w((String)"AutoManageHelper", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        if (n < 0) {
            Log.wtf((String)"AutoManageHelper", (String)"AutoManageLifecycleHelper received onErrorResolutionFailed callback but no failing client ID is set", (Throwable)new Exception());
            return;
        }
        zza zza2 = (zza)this.yq.get(n);
        if (zza2 != null) {
            this.zzfs(n);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = zza2.yt;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
    }

    @Override
    protected void zzarm() {
        for (int i = 0; i < this.yq.size(); ++i) {
            zza zza2 = (zza)this.yq.valueAt(i);
            zza2.ys.connect();
        }
    }

    private class zza
    implements GoogleApiClient.OnConnectionFailedListener {
        public final int yr;
        public final GoogleApiClient ys;
        public final GoogleApiClient.OnConnectionFailedListener yt;

        public zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.yr = n;
            this.ys = googleApiClient;
            this.yt = onConnectionFailedListener;
            googleApiClient.registerConnectionFailedListener(this);
        }

        @Override
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            String string2 = String.valueOf(connectionResult);
            Log.d((String)"AutoManageHelper", (String)new StringBuilder(27 + String.valueOf(string2).length()).append("beginFailureResolution for ").append(string2).toString());
            zzqm.this.zzb(connectionResult, this.yr);
        }

        public void zzarn() {
            this.ys.unregisterConnectionFailedListener(this);
            this.ys.disconnect();
        }

        public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
            printWriter.append(string2).append("GoogleApiClient #").print(this.yr);
            printWriter.println(":");
            this.ys.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        }
    }
}

