/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.common.util.zzs;

public final class zzsj
extends Drawable
implements Drawable.Callback {
    private int CM = 0;
    private long eg;
    private int mFrom;
    private int CN;
    private int CO = 255;
    private int CP;
    private int CQ = 0;
    private boolean CH = true;
    private boolean CR;
    private zzb CS;
    private Drawable CT;
    private Drawable CU;
    private boolean CV;
    private boolean CW;
    private boolean CX;
    private int CY;

    public zzsj(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zza.CZ;
        }
        this.CT = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.CS.Db |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zza.CZ;
        }
        this.CU = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.CS.Db |= drawable3.getChangingConfigurations();
    }

    zzsj(zzb zzb2) {
        this.CS = new zzb(zzb2);
    }

    @TargetApi(value=11)
    public void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback;
        if (zzs.zzayn() && (callback = this.getCallback()) != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    @TargetApi(value=11)
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback;
        if (zzs.zzayn() && (callback = this.getCallback()) != null) {
            callback.scheduleDrawable((Drawable)this, runnable, l);
        }
    }

    @TargetApi(value=11)
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback;
        if (zzs.zzayn() && (callback = this.getCallback()) != null) {
            callback.unscheduleDrawable((Drawable)this, runnable);
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.CS.mChangingConfigurations | this.CS.Db;
    }

    public void setAlpha(int n) {
        if (this.CQ == this.CO) {
            this.CQ = n;
        }
        this.CO = n;
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.CT.setColorFilter(colorFilter);
        this.CU.setColorFilter(colorFilter);
    }

    public int getIntrinsicWidth() {
        return Math.max(this.CT.getIntrinsicWidth(), this.CU.getIntrinsicWidth());
    }

    public int getIntrinsicHeight() {
        return Math.max(this.CT.getIntrinsicHeight(), this.CU.getIntrinsicHeight());
    }

    protected void onBoundsChange(Rect rect) {
        this.CT.setBounds(rect);
        this.CU.setBounds(rect);
    }

    public Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.CS.mChangingConfigurations = this.getChangingConfigurations();
            return this.CS;
        }
        return null;
    }

    public int getOpacity() {
        if (!this.CX) {
            this.CY = Drawable.resolveOpacity((int)this.CT.getOpacity(), (int)this.CU.getOpacity());
            this.CX = true;
        }
        return this.CY;
    }

    public boolean canConstantState() {
        if (!this.CV) {
            this.CW = this.CT.getConstantState() != null && this.CU.getConstantState() != null;
            this.CV = true;
        }
        return this.CW;
    }

    public Drawable mutate() {
        if (!this.CR && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.CT.mutate();
            this.CU.mutate();
            this.CR = true;
        }
        return this;
    }

    public Drawable zzauw() {
        return this.CU;
    }

    public void startTransition(int n) {
        this.mFrom = 0;
        this.CN = this.CO;
        this.CQ = 0;
        this.CP = n;
        this.CM = 1;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.CM) {
            case 1: {
                this.eg = SystemClock.uptimeMillis();
                bl = false;
                this.CM = 2;
                break;
            }
            case 2: {
                if (this.eg < 0L) break;
                float f = (float)(SystemClock.uptimeMillis() - this.eg) / (float)this.CP;
                boolean bl2 = bl = f >= 1.0f;
                if (bl) {
                    this.CM = 0;
                }
                f = Math.min(f, 1.0f);
                this.CQ = (int)(0.0f + (float)(this.CN - 0) * f);
            }
        }
        int n = this.CQ;
        boolean bl3 = this.CH;
        Drawable drawable2 = this.CT;
        Drawable drawable3 = this.CU;
        if (bl) {
            if (!bl3 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.CO) {
                drawable3.setAlpha(this.CO);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl3) {
            drawable2.setAlpha(this.CO - n);
        }
        drawable2.draw(canvas);
        if (bl3) {
            drawable2.setAlpha(this.CO);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.CO);
        }
        this.invalidateSelf();
    }

    private static final class com.google.android.gms.internal.zzsj$zza
    extends Drawable {
        private static final com.google.android.gms.internal.zzsj$zza CZ = new com.google.android.gms.internal.zzsj$zza();
        private static final zza Da = new zza();

        private com.google.android.gms.internal.zzsj$zza() {
        }

        public void draw(Canvas canvas) {
        }

        public void setAlpha(int n) {
        }

        public void setColorFilter(ColorFilter colorFilter) {
        }

        public int getOpacity() {
            return -2;
        }

        public Drawable.ConstantState getConstantState() {
            return Da;
        }

        private static final class zza
        extends Drawable.ConstantState {
            private zza() {
            }

            public Drawable newDrawable() {
                return CZ;
            }

            public int getChangingConfigurations() {
                return 0;
            }
        }
    }

    static final class zzb
    extends Drawable.ConstantState {
        int mChangingConfigurations;
        int Db;

        zzb(zzb zzb2) {
            if (zzb2 != null) {
                this.mChangingConfigurations = zzb2.mChangingConfigurations;
                this.Db = zzb2.Db;
            }
        }

        public Drawable newDrawable() {
            return new zzsj(this);
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }
    }
}

