/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zzaf;
import com.google.android.gms.common.internal.zzag;
import com.google.android.gms.common.internal.zzal;
import com.google.android.gms.common.internal.zzam;
import com.google.android.gms.common.internal.zzax;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.common.internal.zzn;
import com.google.android.gms.common.internal.zzo;
import com.google.android.gms.common.internal.zzy;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zze;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class zzd<T extends IInterface> {
    private int zzfsi;
    private long zzfsj;
    private long zzfsk;
    private int zzfsl;
    private long zzfsm;
    private zzal zzfsn;
    private final Context mContext;
    private final Looper zzakl;
    private final zzaf zzfso;
    private final zze zzfki;
    final Handler mHandler;
    private final Object mLock = new Object();
    private final Object zzfsp = new Object();
    private zzax zzfsq;
    protected zzj zzfsr;
    private T zzfss;
    private final ArrayList<zzi<?>> zzfst = new ArrayList();
    private zzl zzfsu;
    private int zzfsv = 1;
    private final zzf zzfsw;
    private final zzg zzfsx;
    private final int zzfsy;
    private final String zzfsz;
    private ConnectionResult zzfta = null;
    private boolean zzftb = false;
    protected AtomicInteger zzftc = new AtomicInteger(0);
    private static String[] zzftd = new String[]{"service_esmobile", "service_googleme"};

    protected zzd(Context context, Looper looper, int n, zzf zzf2, zzg zzg2, String string2) {
        this(context, looper, zzaf.zzcf(context), zze.zzaew(), n, zzbp.zzu(zzf2), zzbp.zzu(zzg2), null);
    }

    protected zzd(Context context, Looper looper, zzaf zzaf2, zze zze2, int n, zzf zzf2, zzg zzg2, String string2) {
        this.mContext = zzbp.zzb(context, (Object)"Context must not be null");
        this.zzakl = zzbp.zzb(looper, (Object)"Looper must not be null");
        this.zzfso = zzbp.zzb(zzaf2, (Object)"Supervisor must not be null");
        this.zzfki = zzbp.zzb(zze2, (Object)"API availability must not be null");
        this.mHandler = new zzh(this, looper);
        this.zzfsy = n;
        this.zzfsw = zzf2;
        this.zzfsx = zzg2;
        this.zzfsz = string2;
    }

    @NonNull
    protected abstract String zzhc();

    protected String zzajd() {
        return "com.google.android.gms";
    }

    @NonNull
    protected abstract String zzhd();

    @Nullable
    private final String zzaje() {
        if (this.zzfsz == null) {
            return this.mContext.getClass().getName();
        }
        return this.zzfsz;
    }

    @Nullable
    protected abstract T zze(IBinder var1);

    @CallSuper
    protected void zza(@NonNull T t) {
        this.zzfsk = System.currentTimeMillis();
    }

    @CallSuper
    protected final void onConnectionSuspended(int n) {
        this.zzfsi = n;
        this.zzfsj = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionFailed(ConnectionResult connectionResult) {
        this.zzfsl = connectionResult.getErrorCode();
        this.zzfsm = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(int n, T t) {
        zzbp.zzbh(n == 4 == (t != null));
        Object object = this.mLock;
        synchronized (object) {
            this.zzfsv = n;
            this.zzfss = t;
            switch (n) {
                case 2: 
                case 3: {
                    String string2;
                    zzd zzd2 = this;
                    if (zzd2.zzfsu != null && zzd2.zzfsn != null) {
                        String string3 = zzd2.zzfsn.zzakk();
                        string2 = zzd2.zzfsn.getPackageName();
                        Log.e((String)"GmsClient", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Calling connect() while still connected, missing disconnect() for ").append(string3).append(" on ").append(string2).toString());
                        zzd2.zzfso.zza(zzd2.zzfsn.zzakk(), zzd2.zzfsn.getPackageName(), zzd2.zzfsn.zzakg(), zzd2.zzfsu, zzd2.zzaje());
                        zzd2.zzftc.incrementAndGet();
                    }
                    zzd2.zzfsu = new zzl(zzd2, zzd2.zzftc.get());
                    zzd zzd3 = zzd2;
                    zzd2.zzfsn = new zzal(zzd3.zzajd(), zzd3.zzhc(), false, 129);
                    String string4 = zzd2.zzaje();
                    zzl zzl2 = zzd2.zzfsu;
                    int n2 = zzd2.zzfsn.zzakg();
                    String string5 = zzd2.zzfsn.getPackageName();
                    String string6 = zzd2.zzfsn.zzakk();
                    if (zzd2.zzfso.zza(new zzag(string6, string5, n2), (ServiceConnection)zzl2, string4)) break;
                    string2 = zzd2.zzfsn.zzakk();
                    String string7 = zzd2.zzfsn.getPackageName();
                    Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string7).length()).append("unable to connect to service: ").append(string2).append(" on ").append(string7).toString());
                    zzd2.zza(16, null, zzd2.zzftc.get());
                    break;
                }
                case 4: {
                    this.zza(t);
                    break;
                }
                case 1: {
                    zzd zzd4 = this;
                    if (zzd4.zzfsu == null) break;
                    zzd4.zzfso.zza(zzd4.zzhc(), zzd4.zzajd(), 129, zzd4.zzfsu, zzd4.zzaje());
                    zzd4.zzfsu = null;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(int n, int n2, T t) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzfsv != n) {
                return false;
            }
            this.zza(n2, t);
            return true;
        }
    }

    public final void zzajf() {
        int n = this.zzfki.isGooglePlayServicesAvailable(this.mContext);
        if (n != 0) {
            this.zza(1, null);
            this.zza(new zzm(this), n, null);
            return;
        }
        this.zza(new zzm(this));
    }

    public void zza(@NonNull zzj zzj2) {
        this.zzfsr = zzbp.zzb(zzj2, (Object)"Connection progress callbacks cannot be null.");
        this.zza(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnected() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzfsv == 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnecting() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzfsv == 2 || this.zzfsv == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zzajg() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzfsv == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.zzftc.incrementAndGet();
        Object object = this.zzfst;
        synchronized (object) {
            int n = this.zzfst.size();
            for (int i = 0; i < n; ++i) {
                this.zzfst.get(i).removeListener();
            }
            this.zzfst.clear();
        }
        object = this.zzfsp;
        synchronized (object) {
            this.zzfsq = null;
        }
        this.zza(1, null);
    }

    public final void zzcb(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6, this.zzftc.get(), n));
    }

    private final void zzcc(int n) {
        int n2;
        if (this.zzajg()) {
            n2 = 5;
            this.zzftb = true;
        } else {
            n2 = 4;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(n2, this.zzftc.get(), 16));
    }

    protected final void zza(@NonNull zzj zzj2, int n, @Nullable PendingIntent pendingIntent) {
        this.zzfsr = zzbp.zzb(zzj2, (Object)"Connection progress callbacks cannot be null.");
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzftc.get(), n, (Object)pendingIntent));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final Looper getLooper() {
        return this.zzakl;
    }

    public Account getAccount() {
        return null;
    }

    public zzc[] zzajh() {
        return new zzc[0];
    }

    protected Bundle zzzs() {
        return new Bundle();
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n2, -1, (Object)new zzn(this, n, iBinder, bundle)));
    }

    protected final void zza(int n, @Nullable Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, n2, -1, (Object)new zzo(this, n, null)));
    }

    protected final void zzaji() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    public Bundle zzaeg() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T zzajj() throws DeadObjectException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzfsv == 5) {
                throw new DeadObjectException();
            }
            this.zzaji();
            zzbp.zza(this.zzfss != null, (Object)"Client is connected but service is null");
            return this.zzfss;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(zzam zzam2, Set<Scope> set) {
        Bundle bundle = this.zzzs();
        Object object = this.mContext.getPackageName();
        Object object2 = new zzy(this.zzfsy);
        new zzy(this.zzfsy).zzfty = object;
        object = bundle;
        v0.zzfub = object;
        zzy zzy2 = object2;
        if (set != null) {
            object = set;
            zzy2.zzfua = object.toArray(new Scope[object.size()]);
        }
        if (this.zzaaa()) {
            object2 = this;
            object = ((zzd)object2).getAccount() != null ? ((zzd)object2).getAccount() : new Account("<<default account>>", "com.google");
            object2 = zzy2;
            zzy2.zzfuc = object;
            object = zzam2;
            if (object != null) {
                ((zzy)object2).zzftz = object.asBinder();
            }
        } else if (this.zzajk()) {
            zzy2.zzfuc = object = this.getAccount();
        }
        object = this.zzajh();
        zzy2.zzfud = object;
        try {
            Object object3 = this.zzfsp;
            synchronized (object3) {
                if (this.zzfsq != null) {
                    this.zzfsq.zza(new zzk(this, this.zzftc.get()), zzy2);
                } else {
                    Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
                }
                return;
            }
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)deadObjectException);
            this.zzcb(1);
            return;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (RemoteException | RuntimeException throwable) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)throwable);
            this.zza(8, null, null, this.zzftc.get());
            return;
        }
    }

    public boolean zzaaa() {
        return false;
    }

    public boolean zzajk() {
        return false;
    }

    public boolean zzafe() {
        return true;
    }

    public boolean zzaak() {
        return false;
    }

    public Intent zzaal() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    protected Set<Scope> zzajl() {
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3;
        long l;
        zzax zzax2;
        T t;
        int n;
        Object object = this.mLock;
        synchronized (object) {
            n = this.zzfsv;
            t = this.zzfss;
        }
        object = this.zzfsp;
        synchronized (object) {
            zzax2 = this.zzfsq;
        }
        printWriter.append(string2).append("mConnectState=");
        switch (n) {
            case 2: {
                printWriter.print("REMOTE_CONNECTING");
                break;
            }
            case 3: {
                printWriter.print("LOCAL_CONNECTING");
                break;
            }
            case 4: {
                printWriter.print("CONNECTED");
                break;
            }
            case 5: {
                printWriter.print("DISCONNECTING");
                break;
            }
            case 1: {
                printWriter.print("DISCONNECTED");
                break;
            }
            default: {
                printWriter.print("UNKNOWN");
            }
        }
        printWriter.append(" mService=");
        if (t == null) {
            printWriter.append("null");
        } else {
            printWriter.append(this.zzhd()).append("@").append(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
        printWriter.append(" mServiceBroker=");
        if (zzax2 == null) {
            printWriter.println("null");
        } else {
            printWriter.append("IGmsServiceBroker@").println(Integer.toHexString(System.identityHashCode(zzax2.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (this.zzfsk > 0L) {
            l = this.zzfsk;
            string3 = ((DateFormat)object).format(new Date(this.zzfsk));
            printWriter.append(string2).append("lastConnectedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzfsj > 0L) {
            printWriter.append(string2).append("lastSuspendedCause=");
            switch (this.zzfsi) {
                case 1: {
                    printWriter.append("CAUSE_SERVICE_DISCONNECTED");
                    break;
                }
                case 2: {
                    printWriter.append("CAUSE_NETWORK_LOST");
                    break;
                }
                default: {
                    printWriter.append(String.valueOf(this.zzfsi));
                }
            }
            l = this.zzfsj;
            string3 = ((DateFormat)object).format(new Date(this.zzfsj));
            printWriter.append(" lastSuspendedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzfsm > 0L) {
            printWriter.append(string2).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(this.zzfsl));
            l = this.zzfsm;
            string3 = ((DateFormat)object).format(new Date(this.zzfsm));
            printWriter.append(" lastFailedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IBinder zzaff() {
        Object object = this.zzfsp;
        synchronized (object) {
            if (this.zzfsq == null) {
                return null;
            }
            return this.zzfsq.asBinder();
        }
    }

    private final boolean zzajm() {
        if (this.zzftb) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.zzhd())) {
            return false;
        }
        if (TextUtils.isEmpty(null)) {
            return false;
        }
        try {
            Class.forName(this.zzhd());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    static /* synthetic */ void zza(zzd zzd2, int n) {
        zzd2.zzcc(16);
    }

    static /* synthetic */ Object zza(zzd zzd2) {
        return zzd2.zzfsp;
    }

    static /* synthetic */ zzax zza(zzd zzd2, zzax zzax2) {
        zzd2.zzfsq = zzax2;
        return zzd2.zzfsq;
    }

    static /* synthetic */ ConnectionResult zza(zzd zzd2, ConnectionResult connectionResult) {
        zzd2.zzfta = connectionResult;
        return zzd2.zzfta;
    }

    static /* synthetic */ boolean zzb(zzd zzd2) {
        return zzd2.zzajm();
    }

    static /* synthetic */ boolean zzc(zzd zzd2) {
        return zzd2.zzftb;
    }

    static /* synthetic */ void zza(zzd zzd2, int n, IInterface iInterface) {
        zzd2.zza(n, null);
    }

    static /* synthetic */ ConnectionResult zzd(zzd zzd2) {
        return zzd2.zzfta;
    }

    static /* synthetic */ zzf zze(zzd zzd2) {
        return zzd2.zzfsw;
    }

    static /* synthetic */ boolean zza(zzd zzd2, int n, int n2, IInterface iInterface) {
        return zzd2.zza(n, n2, iInterface);
    }

    static /* synthetic */ ArrayList zzf(zzd zzd2) {
        return zzd2.zzfst;
    }

    static /* synthetic */ zzg zzg(zzd zzd2) {
        return zzd2.zzfsx;
    }
}

