/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;

@KeepForSdk
public final class BackgroundDetector
implements Application.ActivityLifecycleCallbacks,
ComponentCallbacks2 {
    private static final BackgroundDetector zza = new BackgroundDetector();
    private final AtomicBoolean zzb = new AtomicBoolean();
    private final AtomicBoolean zzc = new AtomicBoolean();
    @GuardedBy(value="instance")
    private final ArrayList zzd = new ArrayList();
    @GuardedBy(value="instance")
    private boolean zze = false;

    @KeepForSdk
    @NonNull
    public static BackgroundDetector getInstance() {
        return zza;
    }

    @KeepForSdk
    private BackgroundDetector() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public void addListener(@NonNull BackgroundStateChangeListener listener) {
        BackgroundDetector backgroundDetector = zza;
        synchronized (backgroundDetector) {
            void var1_2;
            this.zzd.add(var1_2);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public static void initialize(@NonNull Application application) {
        BackgroundDetector backgroundDetector = zza;
        synchronized (backgroundDetector) {
            Application application2;
            BackgroundDetector backgroundDetector2 = zza;
            boolean bl = backgroundDetector2.zze;
            if (bl) return;
            application2.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)backgroundDetector2);
            application2.registerComponentCallbacks((ComponentCallbacks)zza);
            BackgroundDetector.zza.zze = true;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final void onActivityCreated(@NonNull Activity object, @Nullable Bundle bundle) {
        object = this.zzc;
        boolean bl = this.zzb.compareAndSet(true, false);
        ((AtomicBoolean)object).set(true);
        if (bl) {
            this.zza(false);
            return;
        }
    }

    public final void onActivityDestroyed(@NonNull Activity activity) {
    }

    public final void onActivityPaused(@NonNull Activity activity) {
    }

    public final void onActivityResumed(@NonNull Activity object) {
        object = this.zzc;
        boolean bl = this.zzb.compareAndSet(true, false);
        ((AtomicBoolean)object).set(true);
        if (bl) {
            this.zza(false);
            return;
        }
    }

    public final void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle bundle) {
    }

    public final void onActivityStarted(@NonNull Activity activity) {
    }

    public final void onActivityStopped(@NonNull Activity activity) {
    }

    public final void onConfigurationChanged(@NonNull Configuration configuration) {
    }

    public final void onLowMemory() {
    }

    public final void onTrimMemory(int n) {
        if (n == 20 && this.zzb.compareAndSet(false, true)) {
            this.zzc.set(true);
            this.zza(true);
            return;
        }
    }

    @KeepForSdk
    public boolean isInBackground() {
        return this.zzb.get();
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=16)
    @KeepForSdk
    public boolean readCurrentStateIfPossible(boolean isInBackgroundDefault) {
        void var1_1;
        block5: {
            block4: {
                if (this.zzc.get()) break block4;
                if (!PlatformVersion.isAtLeastJellyBean()) break block5;
                ActivityManager.RunningAppProcessInfo runningAppProcessInfo = new ActivityManager.RunningAppProcessInfo();
                ActivityManager.getMyMemoryState((ActivityManager.RunningAppProcessInfo)runningAppProcessInfo);
                if (!this.zzc.getAndSet(true) && runningAppProcessInfo.importance > 100) {
                    this.zzb.set(true);
                }
            }
            return this.isInBackground();
        }
        return (boolean)var1_1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zza(boolean bl) {
        BackgroundDetector backgroundDetector = zza;
        synchronized (backgroundDetector) {
            boolean bl2;
            Iterator iterator = ((BackgroundDetector)((Object)iterator)).zzd.iterator();
            while (bl2 = iterator.hasNext()) {
                ((BackgroundStateChangeListener)iterator.next()).onBackgroundStateChanged(bl);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @KeepForSdk
    public static interface BackgroundStateChangeListener {
        @KeepForSdk
        public void onBackgroundStateChanged(boolean var1);
    }
}

