/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.GuardedBy;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zznu;
import com.google.android.gms.internal.measurement.zznx;
import com.google.android.gms.internal.measurement.zzod;
import com.google.android.gms.internal.measurement.zzpn;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzdy;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzev;
import com.google.android.gms.measurement.internal.zzez;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfa;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzhb;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzhg;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzhi;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzhk;
import com.google.android.gms.measurement.internal.zzhl;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzhn;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzhp;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzhr;
import com.google.android.gms.measurement.internal.zzhs;
import com.google.android.gms.measurement.internal.zzht;
import com.google.android.gms.measurement.internal.zzhu;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zzhw;
import com.google.android.gms.measurement.internal.zzhz;
import com.google.android.gms.measurement.internal.zzih;
import com.google.android.gms.measurement.internal.zzjo;
import com.google.android.gms.measurement.internal.zzkb;
import com.google.android.gms.measurement.internal.zzkc;
import com.google.android.gms.measurement.internal.zzkd;
import com.google.android.gms.measurement.internal.zzkv;
import com.google.android.gms.measurement.internal.zzky;
import com.google.android.gms.measurement.internal.zzkz;
import com.google.android.gms.measurement.internal.zzr;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzia
extends zzf {
    @VisibleForTesting
    protected zzhz zza;
    private zzgv zzd;
    private final Set<zzgw> zze;
    private boolean zzf;
    private final AtomicReference<String> zzg;
    private final Object zzh;
    @GuardedBy(value="consentLock")
    private zzag zzi;
    @GuardedBy(value="consentLock")
    private int zzj;
    private final AtomicLong zzk;
    private long zzl;
    private int zzm;
    final zzr zzb;
    @VisibleForTesting
    protected boolean zzc;
    private final zzky zzn;

    public final int zzh(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzs.zzf();
        return 25;
    }

    public final Boolean zzi() {
        AtomicReference atomicReference = new AtomicReference();
        zzgq zzgq2 = this.zzs;
        zzgq2 = ((zzfv)zzgq2).zzaz();
        zzhl zzhl2 = new zzhl(this, atomicReference);
        return (Boolean)((zzfs)zzgq2).zzd(atomicReference, 15000L, "boolean test flag value", zzhl2);
    }

    public final Double zzj() {
        AtomicReference atomicReference = new AtomicReference();
        zzgq zzgq2 = this.zzs;
        zzgq2 = ((zzfv)zzgq2).zzaz();
        zzhs zzhs2 = new zzhs(this, atomicReference);
        return (Double)((zzfs)zzgq2).zzd(atomicReference, 15000L, "double test flag value", zzhs2);
    }

    public final Integer zzl() {
        AtomicReference atomicReference = new AtomicReference();
        zzgq zzgq2 = this.zzs;
        zzgq2 = ((zzfv)zzgq2).zzaz();
        zzhr zzhr2 = new zzhr(this, atomicReference);
        return (Integer)((zzfs)zzgq2).zzd(atomicReference, 15000L, "int test flag value", zzhr2);
    }

    public final Long zzm() {
        AtomicReference atomicReference = new AtomicReference();
        zzgq zzgq2 = this.zzs;
        zzgq2 = ((zzfv)zzgq2).zzaz();
        zzhq zzhq2 = new zzhq(this, atomicReference);
        return (Long)((zzfs)zzgq2).zzd(atomicReference, 15000L, "long test flag value", zzhq2);
    }

    public final String zzo() {
        return this.zzg.get();
    }

    public final String zzp() {
        zzih zzih2 = ((zzia)((Object)zzih2)).zzs.zzs().zzi();
        if (zzih2 != null) {
            return zzih2.zzb;
        }
        return null;
    }

    public final String zzq() {
        zzih zzih2 = ((zzia)((Object)zzih2)).zzs.zzs().zzi();
        if (zzih2 != null) {
            return zzih2.zza;
        }
        return null;
    }

    public final String zzr() {
        AtomicReference atomicReference = new AtomicReference();
        zzgq zzgq2 = this.zzs;
        zzgq2 = ((zzfv)zzgq2).zzaz();
        zzhp zzhp2 = new zzhp(this, atomicReference);
        return (String)((zzfs)zzgq2).zzd(atomicReference, 15000L, "String test flag value", zzhp2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ArrayList<Bundle> zzs(String object, String string) {
        if (((zzgo)((Object)this)).zzs.zzaz().zzs()) {
            ((zzgo)((Object)this)).zzs.zzay().zzd().zza("Cannot get conditional user properties from analytics worker thread");
            return new ArrayList(0);
        }
        ((zzgo)((Object)this)).zzs.zzaw();
        if (zzaa.zza()) {
            ((zzgo)((Object)this)).zzs.zzay().zzd().zza("Cannot get conditional user properties from main thread");
            return new ArrayList(0);
        }
        AtomicReference atomicReference = new AtomicReference();
        zzgq zzgq2 = ((zzia)((Object)this)).zzs;
        zzgq2 = ((zzfv)zzgq2).zzaz();
        zzhm zzhm2 = new zzhm((zzia)((Object)this), atomicReference, null, (String)object, string);
        ((zzfs)zzgq2).zzd(atomicReference, 5000L, "get conditional user properties", zzhm2);
        object = (List)atomicReference.get();
        if (object != null) return zzkz.zzG((List<zzab>)object);
        ((zzgo)((Object)this)).zzs.zzay().zzd().zzb("Timed out waiting for get conditional user properties", null);
        return new ArrayList();
    }

    public final List<zzkv> zzt(boolean bl) {
        this.zza();
        this.zzs.zzay().zzj().zza("Getting user properties (FE)");
        if (!this.zzs.zzaz().zzs()) {
            this.zzs.zzaw();
            if (zzaa.zza()) {
                this.zzs.zzay().zzd().zza("Cannot get all user properties from main thread");
                return Collections.emptyList();
            }
            Object object = new AtomicReference();
            zzgq zzgq2 = this.zzs;
            zzgq2 = ((zzfv)zzgq2).zzaz();
            zzhh zzhh2 = new zzhh(this, (AtomicReference)object, bl);
            ((zzfs)zzgq2).zzd(object, 5000L, "get user properties", zzhh2);
            object = (List)((AtomicReference)object).get();
            if (object == null) {
                this.zzs.zzay().zzd().zzb("Timed out waiting for get user properties, includeInternal", bl);
                return Collections.emptyList();
            }
            return object;
        }
        this.zzs.zzay().zzd().zza("Cannot get all user properties from analytics worker thread");
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Map<String, Object> zzu(String iterator, String object, boolean bl) {
        void var3_5;
        if (((zzgo)object2).zzs.zzaz().zzs()) {
            ((zzgo)object2).zzs.zzay().zzd().zza("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        ((zzgo)object2).zzs.zzaw();
        if (zzaa.zza()) {
            ((zzgo)object2).zzs.zzay().zzd().zza("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        zzgq zzgq2 = ((zzia)object2).zzs;
        zzgq2 = ((zzfv)zzgq2).zzaz();
        zzhn zzhn2 = new zzhn((zzia)object2, atomicReference, null, (String)((Object)iterator), (String)object, (boolean)var3_5);
        ((zzfs)zzgq2).zzd(atomicReference, 5000L, "get user properties", zzhn2);
        iterator = (List)atomicReference.get();
        if (iterator == null) {
            ((zzgo)object2).zzs.zzay().zzd().zzb("Timed out waiting for handle get user properties, includeInternal", (boolean)var3_5);
            return Collections.emptyMap();
        }
        Object object2 = new ArrayMap(iterator.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            zzkv zzkv2 = (zzkv)((Object)iterator.next());
            Object object3 = zzkv2.zza();
            if (object3 == null) continue;
            object2.put(zzkv2.zzb, object3);
        }
        return object2;
    }

    static /* synthetic */ void zzv(zzia zzgq2, zzag atomicReference, int n, long l, boolean bl, boolean bl2) {
        ((zzgo)zzgq2).zzg();
        ((zzf)zzgq2).zza();
        if (l > ((zzia)zzgq2).zzl || !zzag.zzl(((zzia)zzgq2).zzm, n)) {
            zzfa zzfa2 = ((zzgo)zzgq2).zzs.zzm();
            zzfv cfr_ignored_0 = zzfa2.zzs;
            zzfa2.zzg();
            if (zzfa2.zzl(n)) {
                zzfa2 = zzfa2.zza().edit();
                zzfa2.putString("consent_settings", ((zzag)((Object)atomicReference)).zzi());
                zzfa2.putInt("consent_source", n);
                zzfa2.apply();
                ((zzia)zzgq2).zzl = l;
                ((zzia)zzgq2).zzm = n;
                ((zze)zzgq2).zzs.zzt().zzF(bl);
                if (bl2) {
                    zzgq2 = ((zze)zzgq2).zzs;
                    zzgq2 = ((zzfv)zzgq2).zzt();
                    atomicReference = new AtomicReference<String>();
                    ((zzjo)zzgq2).zzu(atomicReference);
                    return;
                }
                return;
            }
            ((zzgo)zzgq2).zzs.zzay().zzi().zzb("Lower precedence consent source ignored, proposed source", n);
            return;
        }
        ((zzgo)zzgq2).zzs.zzay().zzi().zzb("Dropped out-of-date consent setting, proposed settings", atomicReference);
    }

    static /* bridge */ /* synthetic */ void zzw(zzia zzia2, Boolean bl, boolean bl2) {
        zzia2.zzac(bl, true);
    }

    static /* bridge */ /* synthetic */ void zzx(zzia zzia2) {
        zzia2.zzad();
    }

    protected zzia(zzfv zzfv2) {
        super(zzfv2);
        Object object = new CopyOnWriteArraySet();
        this.zze = object;
        this.zzh = object = new Object();
        this.zzc = true;
        this.zzn = object = new zzho(this);
        object = new AtomicReference();
        this.zzg = object;
        this.zzi = object = new zzag(null, null);
        this.zzj = 100;
        this.zzl = -1L;
        this.zzm = 100;
        this.zzk = object = new AtomicLong(0L);
        this.zzb = object = new zzr(zzfv2);
    }

    @WorkerThread
    public final void zzy() {
        ((zzgo)this).zzg();
        this.zza();
        if (this.zzs.zzM()) {
            Object object;
            Object object2;
            if (this.zzs.zzf().zzs(null, zzdy.zzZ)) {
                object2 = this.zzs.zzf();
                ((zzgo)object2).zzs.zzaw();
                object2 = ((zzaf)object2).zzk("google_analytics_deferred_deep_link_enabled");
                if (object2 != null && ((Boolean)object2).booleanValue()) {
                    this.zzs.zzay().zzc().zza("Deferred Deep Link feature enabled.");
                    object2 = this.zzs;
                    object2 = ((zzfv)object2).zzaz();
                    object = new zzgz(this);
                    ((zzfs)object2).zzp((Runnable)object);
                }
            }
            this.zzs.zzt().zzq();
            this.zzc = false;
            object2 = this.zzs.zzm();
            ((zzgo)object2).zzg();
            object = ((zzfa)object2).zza().getString("previous_os_version", null);
            ((zzgo)object2).zzs.zzg().zzu();
            String string = Build.VERSION.RELEASE;
            if (!TextUtils.isEmpty((CharSequence)string) && !string.equals(object)) {
                object2 = ((zzfa)object2).zza().edit();
                object2.putString("previous_os_version", string);
                object2.apply();
            }
            if (!TextUtils.isEmpty((CharSequence)object)) {
                this.zzs.zzg().zzu();
                if (!((String)object).equals(Build.VERSION.RELEASE)) {
                    object2 = new Bundle();
                    object2.putString("_po", (String)object);
                    this.zzG("auto", "_ou", (Bundle)object2);
                    return;
                }
            }
            return;
        }
    }

    public final void zzz(String object, String object2, Bundle bundle) {
        zzfv zzfv2 = this.zzs;
        zzfv2 = zzfv2.zzav();
        long l = zzfv2.currentTimeMillis();
        Preconditions.checkNotEmpty((String)object);
        zzfv2 = new Bundle();
        zzfv2.putString("name", (String)object);
        zzfv2.putLong("creation_timestamp", l);
        if (object2 != null) {
            zzfv2.putString("expired_event_name", (String)object2);
            zzfv2.putBundle("expired_event_params", bundle);
        }
        object = this.zzs;
        object = ((zzfv)object).zzaz();
        object2 = new zzhk(this, (Bundle)zzfv2);
        ((zzfs)object).zzp((Runnable)object2);
    }

    public final void zzA() {
        if (this.zzs.zzau().getApplicationContext() instanceof Application && this.zza != null) {
            ((Application)this.zzs.zzau().getApplicationContext()).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zza);
            return;
        }
    }

    final /* synthetic */ void zzB(Bundle bundle, long l) {
        this.zzab(bundle, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    final /* synthetic */ void zzC(Bundle object) {
        Object object2;
        if (object == null) {
            Object object3 = ((zzgo)object3).zzs;
            object3 = ((zzfv)object3).zzm();
            object3 = ((zzfa)object3).zzr;
            object = new Bundle();
            ((zzev)object3).zzb((Bundle)object);
            return;
        }
        Bundle bundle = ((zzgo)object3).zzs.zzm().zzr.zza();
        for (Object object4 : object.keySet()) {
            object2 = object.get((String)object4);
            if (!(object2 == null || object2 instanceof String || object2 instanceof Long || object2 instanceof Double)) {
                if (((zzgo)object3).zzs.zzv().zzae(object2)) {
                    ((zzgo)object3).zzs.zzv().zzM(((zzia)object3).zzn, null, 27, null, null, 0);
                }
                ((zzgo)object3).zzs.zzay().zzl().zzc("Invalid default event parameter type. Name, value", object4, object2);
                continue;
            }
            if (zzkz.zzag((String)object4)) {
                ((zzgo)object3).zzs.zzay().zzl().zzb("Invalid default event parameter name. Name", object4);
                continue;
            }
            if (object2 == null) {
                bundle.remove((String)object4);
                continue;
            }
            zzgq zzgq2 = ((zzgo)object3).zzs;
            zzgq2 = ((zzfv)zzgq2).zzv();
            ((zzgo)object3).zzs.zzf();
            if (!((zzkz)zzgq2).zzZ("param", (String)object4, 100, object2)) continue;
            ((zzgo)object3).zzs.zzv().zzN(bundle, (String)object4, object2);
        }
        ((zzgo)object3).zzs.zzv();
        int n = ((zzgo)object3).zzs.zzf().zzc();
        if (bundle.size() > n) {
            Object object4;
            object = new TreeSet(bundle.keySet());
            object4 = object.iterator();
            int n2 = 0;
            while (object4.hasNext()) {
                object2 = (String)object4.next();
                if (++n2 <= n) continue;
                bundle.remove((String)object2);
            }
            ((zzgo)object3).zzs.zzv().zzM(((zzia)object3).zzn, null, 26, null, null, 0);
            ((zzgo)object3).zzs.zzay().zzl().zza("Too many default event parameters set. Discarding beyond event parameter limit");
        }
        ((zzgo)object3).zzs.zzm().zzr.zzb(bundle);
        ((zze)object3).zzs.zzt().zzH(bundle);
    }

    public final void zzD(String string, String string2, Bundle bundle) {
        this.zzE(string, string2, bundle, true, true, this.zzs.zzav().currentTimeMillis());
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzE(String string, String string2, Bundle bundle, boolean bl, boolean bl2, long l) {
        if (string == null) {
            string = "app";
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (zzkz.zzak(string2, "screen_view")) {
            this.zzs.zzs().zzx(bundle, l);
            return;
        }
        boolean bl3 = bl2 ? (this.zzd != null ? zzkz.zzag(string2) : true) : true;
        this.zzM(string, string2, l, bundle, bl2, bl3, bl, null);
    }

    public final void zzF(String string, String string2, Bundle bundle, String string3) {
        zzfv.zzO();
        this.zzM("auto", string2, this.zzs.zzav().currentTimeMillis(), bundle, false, true, true, string3);
    }

    @WorkerThread
    final void zzG(String string, String string2, Bundle bundle) {
        ((zzgo)this).zzg();
        this.zzH(string, string2, this.zzs.zzav().currentTimeMillis(), bundle);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzH(String string, String string2, long l, Bundle bundle) {
        ((zzgo)this).zzg();
        boolean bl = this.zzd != null ? zzkz.zzag(string2) : true;
        this.zzI(string, string2, l, bundle, true, bl, true, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    protected final void zzI(String object, String string, long l, Bundle object2, boolean n, boolean bl, boolean bl2, String string2) {
        int n2;
        int n3;
        Object object32;
        block53: {
            block54: {
                Object[] objectArray;
                Preconditions.checkNotEmpty((String)object);
                Preconditions.checkNotNull((Object)object2);
                ((zzgo)zzgq2).zzg();
                ((zzf)zzgq2).zza();
                if (!((zzia)zzgq2).zzs.zzJ()) {
                    ((zzgo)zzgq2).zzs.zzay().zzc().zza("Event not sent since app measurement is disabled");
                    return;
                }
                Object object4 = ((zze)zzgq2).zzs.zzh().zzo();
                if (object4 != null && !object4.contains(string)) {
                    ((zzgo)zzgq2).zzs.zzay().zzc().zzc("Dropping non-safelisted event. event name, origin", string, object);
                    return;
                }
                if (!((zzia)zzgq2).zzf) {
                    GenericDeclaration genericDeclaration;
                    ((zzia)zzgq2).zzf = true;
                    boolean bl3 = ((zzia)zzgq2).zzs.zzN();
                    if (bl3) {
                        genericDeclaration = "com.google.android.gms.tagmanager.TagManagerService";
                        genericDeclaration = Class.forName((String)((Object)genericDeclaration));
                    }
                    genericDeclaration = "com.google.android.gms.tagmanager.TagManagerService";
                    objectArray = ((zzgo)zzgq2).zzs.zzau();
                    genericDeclaration = Class.forName((String)((Object)genericDeclaration), true, objectArray.getClassLoader());
                    try {
                        objectArray = new Class[]{Context.class};
                        genericDeclaration = ((Class)genericDeclaration).getDeclaredMethod("initialize", (Class<?>[])objectArray);
                        objectArray = new Object[1];
                        object32 = ((zzgo)zzgq2).zzs.zzau();
                        objectArray[0] = object32;
                        ((Method)genericDeclaration).invoke(null, objectArray);
                    }
                    catch (Exception exception) {
                        try {
                            ((zzgo)zzgq2).zzs.zzay().zzk().zzb("Failed to invoke Tag Manager's initialize() method", exception);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            ((zzgo)zzgq2).zzs.zzay().zzi().zza("Tag Manager is not found and thus will not be used");
                        }
                    }
                }
                if ("_cmp".equals(string) && object2.containsKey("gclid")) {
                    ((zzgo)zzgq2).zzs.zzaw();
                    ((zzia)zzgq2).zzZ("auto", "_lgclid", object2.getString("gclid"), ((zzgo)zzgq2).zzs.zzav().currentTimeMillis());
                }
                ((zzgo)zzgq2).zzs.zzaw();
                if (n != 0 && zzkz.zzal(string)) {
                    ((zzgo)zzgq2).zzs.zzv().zzK((Bundle)object2, ((zzgo)zzgq2).zzs.zzm().zzr.zza());
                }
                if (!bl2) {
                    ((zzgo)zzgq2).zzs.zzaw();
                    if (!"_iap".equals(string)) {
                        int n4;
                        object4 = ((zzia)zzgq2).zzs.zzv();
                        if (!((zzkz)object4).zzab("event", string)) {
                            n4 = 2;
                        } else if (!((zzkz)object4).zzY("event", zzgs.zza, zzgs.zzb, string)) {
                            n4 = 13;
                        } else {
                            ((zzgo)object4).zzs.zzf();
                            n4 = !((zzkz)object4).zzX("event", 40, string) ? 2 : 0;
                        }
                        if (n4 != 0) {
                            ((zzgo)zzgq2).zzs.zzay().zze().zzb("Invalid public event name. Event will not be logged (FE)", ((zzgo)zzgq2).zzs.zzj().zzd(string));
                            object = ((zzia)zzgq2).zzs;
                            object = ((zzfv)object).zzv();
                            ((zzia)zzgq2).zzs.zzf();
                            object2 = ((zzkz)object).zzC(string, 40, true);
                            int n5 = string != null ? string.length() : 0;
                            ((zzia)zzgq2).zzs.zzv().zzM(((zzia)zzgq2).zzn, null, n4, "_ev", (String)object2, n5);
                            return;
                        }
                    }
                }
                zzpn.zzc();
                if (((zzgo)zzgq2).zzs.zzf().zzs(null, zzdy.zzaA)) {
                    ((zzgo)zzgq2).zzs.zzaw();
                    objectArray = ((zze)zzgq2).zzs.zzs().zzj(false);
                    if (objectArray != null && !object2.containsKey("_sc")) {
                        objectArray.zzd = true;
                    }
                    n3 = n != 0 ? (!bl2 ? 1 : 0) : 0;
                    zzkz.zzJ((zzih)objectArray, (Bundle)object2, n3 != 0);
                } else {
                    ((zzgo)zzgq2).zzs.zzaw();
                    objectArray = ((zze)zzgq2).zzs.zzs().zzj(false);
                    if (objectArray != null && !object2.containsKey("_sc")) {
                        objectArray.zzd = true;
                    }
                    n3 = n != 0 ? (!bl2 ? 1 : 0) : 0;
                    zzkz.zzJ((zzih)objectArray, (Bundle)object2, n3 != 0);
                }
                n3 = "am".equals(object);
                boolean bl4 = zzkz.zzag(string);
                if (n == 0) break block54;
                if (((zzia)zzgq2).zzd != null) {
                    if (!bl4) {
                        if (n3 == 0) {
                            ((zzgo)zzgq2).zzs.zzay().zzc().zzc("Passing event to registered event handler (FE)", ((zzgo)zzgq2).zzs.zzj().zzd(string), ((zzgo)zzgq2).zzs.zzj().zzb((Bundle)object2));
                            Preconditions.checkNotNull((Object)((zzia)zzgq2).zzd);
                            ((zzia)zzgq2).zzd.interceptEvent((String)object, string, (Bundle)object2, l);
                            return;
                        }
                        n = 1;
                        break block53;
                    } else {
                        n = n3;
                    }
                    break block53;
                } else {
                    n = n3;
                }
                break block53;
            }
            n = n3;
        }
        if (!((zzia)zzgq2).zzs.zzM()) {
            return;
        }
        n3 = ((zzgo)zzgq2).zzs.zzv().zzh(string);
        if (n3 != 0) {
            ((zzgo)zzgq2).zzs.zzay().zze().zzb("Invalid event name. Event will not be logged (FE)", ((zzgo)zzgq2).zzs.zzj().zzd(string));
            object = ((zzgo)zzgq2).zzs;
            object = ((zzfv)object).zzv();
            ((zzgo)zzgq2).zzs.zzf();
            object2 = ((zzkz)object).zzC(string, 40, true);
            int n6 = string != null ? string.length() : 0;
            ((zzia)zzgq2).zzs.zzv().zzM(((zzia)zzgq2).zzn, string2, n3, "_ev", (String)object2, n6);
            return;
        }
        String[] stringArray = new String[]{"_o", "_sn", "_sc", "_si"};
        stringArray = CollectionUtils.listOf((Object[])stringArray);
        stringArray = ((zzgo)zzgq2).zzs.zzv().zzy(string2, string, (Bundle)object2, (List<String>)stringArray, bl2);
        Preconditions.checkNotNull((Object)stringArray);
        ((zzgo)zzgq2).zzs.zzaw();
        if (((zze)zzgq2).zzs.zzs().zzj(false) != null && "_ae".equals(string)) {
            object2 = ((zze)zzgq2).zzs.zzu().zzb;
            long l2 = ((zzkb)object2).zzc.zzs.zzav().elapsedRealtime();
            long l3 = l2 - ((zzkb)object2).zzb;
            ((zzkb)object2).zzb = l2;
            if (l3 > 0L) {
                ((zzgo)zzgq2).zzs.zzv().zzH((Bundle)stringArray, l3);
            }
        }
        zznu.zzc();
        if (((zzgo)zzgq2).zzs.zzf().zzs(null, zzdy.zzah)) {
            if (!"auto".equals(object) && "_ssr".equals(string)) {
                zzkz zzkz2 = ((zzgo)zzgq2).zzs.zzv();
                object2 = stringArray.getString("_ffr");
                if (Strings.isEmptyOrWhitespace((String)object2)) {
                    object2 = null;
                } else if (object2 != null) {
                    object2 = ((String)object2).trim();
                }
                if (zzkz.zzak((String)object2, zzkz2.zzs.zzm().zzo.zza())) {
                    zzkz2.zzs.zzay().zzc().zza("Not logging duplicate session_start_with_rollout event");
                    return;
                }
                zzkz2.zzs.zzm().zzo.zzb((String)object2);
            } else if ("_ae".equals(string) && !TextUtils.isEmpty((CharSequence)(object2 = ((zzgo)zzgq2).zzs.zzv().zzs.zzm().zzo.zza()))) {
                stringArray.putString("_ffr", (String)object2);
            }
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add((Bundle)stringArray);
        if (((zzgo)zzgq2).zzs.zzm().zzj.zza() > 0L && ((zzgo)zzgq2).zzs.zzm().zzk(l) && ((zzgo)zzgq2).zzs.zzm().zzl.zzb()) {
            ((zzgo)zzgq2).zzs.zzay().zzj().zza("Current session is expired, remove the session number, ID, and engagement time");
            ((zzia)zzgq2).zzZ("auto", "_sid", null, ((zzgo)zzgq2).zzs.zzav().currentTimeMillis());
            ((zzia)zzgq2).zzZ("auto", "_sno", null, ((zzgo)zzgq2).zzs.zzav().currentTimeMillis());
            ((zzia)zzgq2).zzZ("auto", "_se", null, ((zzgo)zzgq2).zzs.zzav().currentTimeMillis());
        }
        if (stringArray.getLong("extend_session", 0L) == 1L) {
            ((zzgo)zzgq2).zzs.zzay().zzj().zza("EXTEND_SESSION param attached: initiate a new session or extend the current active session");
            ((zzia)zzgq2).zzs.zzu().zza.zzb(l, true);
        }
        object32 = new ArrayList(stringArray.keySet());
        Collections.sort(object32);
        int n7 = object32.size();
        for (n2 = 0; n2 < n7; ++n2) {
            String string3 = (String)object32.get(n2);
            if (string3 == null) continue;
            ((zzgo)zzgq2).zzs.zzv();
            Object object5 = stringArray.get(string3);
            if (object5 instanceof Bundle) {
                Bundle[] bundleArray = new Bundle[]{(Bundle)object5};
                object5 = bundleArray;
            } else if (object5 instanceof Parcelable[]) {
                object5 = (Parcelable[])object5;
                object5 = (Bundle[])Arrays.copyOf(object5, ((Parcelable[])object5).length, Bundle[].class);
            } else if (object5 instanceof ArrayList) {
                object5 = (ArrayList)object5;
                object5 = ((ArrayList)object5).toArray(new Bundle[((ArrayList)object5).size()]);
            } else {
                object5 = null;
            }
            if (object5 == null) continue;
            stringArray.putParcelableArray(string3, (Parcelable[])object5);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            stringArray = (Bundle)arrayList.get(n2);
            String string4 = n2 != 0 ? "_ep" : string;
            stringArray.putString("_o", (String)object);
            if (bl) {
                stringArray = ((zzgo)zzgq2).zzs.zzv().zzt((Bundle)stringArray);
            }
            zzar zzar2 = new zzar((Bundle)stringArray);
            object32 = new zzat(string4, zzar2, (String)object, l);
            ((zze)zzgq2).zzs.zzt().zzA((zzat)((Object)object32), string2);
            if (n != 0) continue;
            for (Object object32 : ((zzia)zzgq2).zze) {
                object32 = (zzgw)object32;
                zzar2 = new Bundle((Bundle)stringArray);
                object32.onEvent((String)object, string, (Bundle)zzar2, l);
            }
        }
        ((zzgo)zzgq2).zzs.zzaw();
        if (((zze)zzgq2).zzs.zzs().zzj(false) != null && "_ae".equals(string)) {
            object = ((zze)zzgq2).zzs;
            object = ((zzfv)object).zzu();
            zzgq zzgq2 = ((zzgo)zzgq2).zzs;
            zzgq2 = ((zzfv)zzgq2).zzav();
            l = zzgq2.elapsedRealtime();
            ((zzkd)object).zzb.zzd(true, true, l);
            return;
        }
    }

    public final void zzJ(zzgw zzgw2) {
        this.zza();
        Preconditions.checkNotNull((Object)zzgw2);
        if (!this.zze.add(zzgw2)) {
            this.zzs.zzay().zzk().zza("OnEventListener already registered");
            return;
        }
    }

    public final void zzK(long l) {
        this.zzg.set(null);
        zzgq zzgq2 = this.zzs;
        zzgq2 = ((zzfv)zzgq2).zzaz();
        zzhi zzhi2 = new zzhi(this, l);
        ((zzfs)zzgq2).zzp(zzhi2);
    }

    final void zzL(long l, boolean bl) {
        ((zzgo)this).zzg();
        this.zza();
        this.zzs.zzay().zzc().zza("Resetting analytics data (FE)");
        zzkd zzkd2 = this.zzs.zzu();
        ((zzgo)zzkd2).zzg();
        zzkc cfr_ignored_0 = zzkd2.zza;
        zzkd2.zzb.zza();
        boolean bl2 = this.zzs.zzJ();
        zzfa zzfa2 = this.zzs.zzm();
        zzfa2.zzc.zzb(l);
        if (!TextUtils.isEmpty((CharSequence)zzfa2.zzs.zzm().zzo.zza())) {
            zzfa2.zzo.zzb(null);
        }
        zzod.zzc();
        if (zzfa2.zzs.zzf().zzs(null, zzdy.zzai)) {
            zzfa2.zzj.zzb(0L);
        }
        if (!zzfa2.zzs.zzf().zzv()) {
            zzfa2.zzi(bl2 ^ true);
        }
        zzfa2.zzp.zzb(null);
        zzfa2.zzq.zzb(0L);
        zzfa2.zzr.zzb(null);
        if (bl) {
            this.zzs.zzt().zzC();
        }
        zzod.zzc();
        if (this.zzs.zzf().zzs(null, zzdy.zzai)) {
            this.zzs.zzu().zza.zza();
        }
        this.zzc = bl2 ^ true;
    }

    protected final void zzM(String string, String string2, long l, Bundle object2, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle = new Bundle((Bundle)object2);
        for (Object object2 : bundle.keySet()) {
            Bundle bundle2;
            Object object3;
            Object object4 = bundle.get((String)object2);
            if (object4 instanceof Bundle) {
                object3 = new Bundle((Bundle)object4);
                bundle.putBundle((String)object2, object3);
                continue;
            }
            if (object4 instanceof Parcelable[]) {
                object4 = (Parcelable[])object4;
                for (int i = 0; i < ((Parcelable[])object4).length; ++i) {
                    object3 = object4[i];
                    if (!(object3 instanceof Bundle)) continue;
                    bundle2 = new Bundle(object3);
                    object4[i] = bundle2;
                }
                continue;
            }
            if (!(object4 instanceof List)) continue;
            object4 = (List)object4;
            for (int i = 0; i < object4.size(); ++i) {
                object3 = object4.get(i);
                if (!(object3 instanceof Bundle)) continue;
                bundle2 = new Bundle(object3);
                object4.set(i, bundle2);
            }
        }
        object2 = this.zzs;
        object2 = ((zzfv)object2).zzaz();
        Object object5 = new zzhf(this, string, string2, l, bundle, bl, bl2, bl3, string3);
        ((zzfs)object2).zzp((Runnable)object5);
    }

    final void zzN(String string, String string2, long l, Object object) {
        zzgq zzgq2 = this.zzs;
        zzgq2 = ((zzfv)zzgq2).zzaz();
        zzhg zzhg2 = new zzhg(this, string, string2, object, l);
        ((zzfs)zzgq2).zzp(zzhg2);
    }

    final void zzO(String string) {
        this.zzg.set(string);
    }

    public final void zzP(Bundle bundle) {
        this.zzQ(bundle, this.zzs.zzav().currentTimeMillis());
    }

    public final void zzQ(Bundle object, long l) {
        Preconditions.checkNotNull((Object)object);
        Bundle bundle = new Bundle((Bundle)object);
        if (!TextUtils.isEmpty((CharSequence)bundle.getString("app_id"))) {
            this.zzs.zzay().zzk().zza("Package name should be null when calling setConditionalUserProperty");
        }
        bundle.remove("app_id");
        Preconditions.checkNotNull((Object)bundle);
        zzgr.zza((Bundle)bundle, (String)"app_id", String.class, null);
        zzgr.zza((Bundle)bundle, (String)"origin", String.class, null);
        zzgr.zza((Bundle)bundle, (String)"name", String.class, null);
        zzgr.zza((Bundle)bundle, (String)"value", Object.class, null);
        zzgr.zza((Bundle)bundle, (String)"trigger_event_name", String.class, null);
        object = 0L;
        zzgr.zza((Bundle)bundle, (String)"trigger_timeout", Long.class, (Object)object);
        zzgr.zza((Bundle)bundle, (String)"timed_out_event_name", String.class, null);
        zzgr.zza((Bundle)bundle, (String)"timed_out_event_params", Bundle.class, null);
        zzgr.zza((Bundle)bundle, (String)"triggered_event_name", String.class, null);
        zzgr.zza((Bundle)bundle, (String)"triggered_event_params", Bundle.class, null);
        zzgr.zza((Bundle)bundle, (String)"time_to_live", Long.class, (Object)object);
        zzgr.zza((Bundle)bundle, (String)"expired_event_name", String.class, null);
        zzgr.zza((Bundle)bundle, (String)"expired_event_params", Bundle.class, null);
        Preconditions.checkNotEmpty((String)bundle.getString("name"));
        Preconditions.checkNotEmpty((String)bundle.getString("origin"));
        Preconditions.checkNotNull((Object)bundle.get("value"));
        bundle.putLong("creation_timestamp", l);
        object = bundle.getString("name");
        Object object2 = bundle.get("value");
        if (this.zzs.zzv().zzl((String)object) == 0) {
            if (this.zzs.zzv().zzd((String)object, object2) == 0) {
                Object object3 = this.zzs.zzv().zzB((String)object, object2);
                if (object3 == null) {
                    this.zzs.zzay().zzd().zzc("Unable to normalize conditional user property value", this.zzs.zzj().zzf((String)object), object2);
                    return;
                }
                zzgr.zzb((Bundle)bundle, (Object)object3);
                long l2 = bundle.getLong("trigger_timeout");
                if (!TextUtils.isEmpty((CharSequence)bundle.getString("trigger_event_name"))) {
                    this.zzs.zzf();
                    if (l2 > 15552000000L || l2 < 1L) {
                        this.zzs.zzay().zzd().zzc("Invalid conditional user property timeout", this.zzs.zzj().zzf((String)object), l2);
                        return;
                    }
                }
                long l3 = bundle.getLong("time_to_live");
                this.zzs.zzf();
                if (l3 > 15552000000L || l3 < 1L) {
                    this.zzs.zzay().zzd().zzc("Invalid conditional user property time to live", this.zzs.zzj().zzf((String)object), l3);
                    return;
                }
                object = this.zzs;
                object = ((zzfv)object).zzaz();
                object2 = new zzhj(this, bundle);
                ((zzfs)object).zzp((Runnable)object2);
                return;
            }
            this.zzs.zzay().zzd().zzc("Invalid conditional user property value", this.zzs.zzj().zzf((String)object), object2);
            return;
        }
        this.zzs.zzay().zzd().zzb("Invalid conditional user property name", this.zzs.zzj().zzf((String)object));
    }

    public final void zzR(Bundle bundle, int n, long l) {
        this.zza();
        String string = zzag.zzh(bundle);
        if (string != null) {
            this.zzs.zzay().zzl().zzb("Ignoring invalid consent setting", string);
            this.zzs.zzay().zzl().zza("Valid consent values are 'granted', 'denied'");
        }
        this.zzS(zzag.zza(bundle), n, l);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zzS(zzag zzag2, int n, long l) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        block9: {
            this.zza();
            if (n != -10 && zzag2.zze() == null && zzag2.zzf() == null) {
                this.zzs.zzay().zzl().zza("Discarding empty consent settings");
                return;
            }
            Object object = this.zzh;
            // MONITORENTER : object
            boolean bl4 = this.zzj;
            bl4 = zzag.zzl(n, bl4 ? 1 : 0);
            if (bl4) {
                bl3 = zzag2.zzm(this.zzi);
                bl4 = zzag2.zzk();
                bl4 = bl4 ? !(bl4 = (boolean)this.zzi.zzk()) : false;
                this.zzi = zzag2 = zzag2.zzd(this.zzi);
                this.zzj = n;
                bl2 = bl4;
                bl = true;
                // MONITOREXIT : object
                break block9;
            }
            bl3 = false;
            bl2 = false;
            bl = false;
            {
                catch (Throwable throwable) {}
                {
                    // MONITOREXIT : object
                    throw throwable;
                }
            }
        }
        if (!bl) {
            this.zzs.zzay().zzi().zzb("Ignoring lower-priority consent settings, proposed settings", zzag2);
            return;
        }
        long l2 = this.zzk.getAndIncrement();
        if (bl3) {
            this.zzg.set(null);
            zzgq zzgq2 = this.zzs;
            zzgq2 = ((zzfv)zzgq2).zzaz();
            zzhu zzhu2 = new zzhu(this, zzag2, l, n, l2, bl2);
            ((zzfs)zzgq2).zzq(zzhu2);
            return;
        }
        if (n != 30 && n != -10) {
            zzgq zzgq3 = this.zzs;
            zzgq3 = ((zzfv)zzgq3).zzaz();
            zzhw zzhw2 = new zzhw(this, zzag2, n, l2, bl2);
            ((zzfs)zzgq3).zzp(zzhw2);
            return;
        }
        zzgq zzgq4 = this.zzs;
        zzgq4 = ((zzfv)zzgq4).zzaz();
        zzhv zzhv2 = new zzhv(this, zzag2, n, l2, bl2);
        ((zzfs)zzgq4).zzq(zzhv2);
    }

    public final void zzT(Bundle bundle, long l) {
        zznx.zzc();
        if (this.zzs.zzf().zzs(null, zzdy.zzas)) {
            zzgq zzgq2 = this.zzs;
            zzgq2 = ((zzfv)zzgq2).zzaz();
            zzhb zzhb2 = new zzhb(this, bundle, l);
            ((zzfs)zzgq2).zzq(zzhb2);
            return;
        }
        this.zzab(bundle, l);
    }

    @WorkerThread
    private final void zzab(Bundle bundle, long l) {
        zznx.zzc();
        if (!this.zzs.zzf().zzs(null, zzdy.zzar) || TextUtils.isEmpty((CharSequence)this.zzs.zzh().zzn())) {
            this.zzR(bundle, 0, l);
            return;
        }
        this.zzs.zzay().zzl().zza("Using developer consent only; google app id found");
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public final void zzU(zzgv zzgv2) {
        zzgv zzgv3;
        ((zzgo)this).zzg();
        this.zza();
        if (zzgv2 != null && zzgv2 != (zzgv3 = this.zzd)) {
            boolean bl = zzgv3 == null;
            Preconditions.checkState((boolean)bl, (Object)"EventInterceptor already set.");
        }
        this.zzd = zzgv2;
    }

    public final void zzV(Boolean bl) {
        this.zza();
        zzgq zzgq2 = this.zzs;
        zzgq2 = ((zzfv)zzgq2).zzaz();
        zzht zzht2 = new zzht(this, bl);
        ((zzfs)zzgq2).zzp(zzht2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzW(zzag zzag2) {
        ((zzgo)this).zzg();
        boolean bl = !zzag2.zzk() || !zzag2.zzj() ? this.zzs.zzt().zzM() : true;
        if (bl != this.zzs.zzK()) {
            this.zzs.zzG(bl);
            Object object = this.zzs.zzm();
            zzfv cfr_ignored_0 = ((zzgo)object).zzs;
            ((zzgo)object).zzg();
            object = ((zzfa)object).zza().contains("measurement_enabled_from_api") ? Boolean.valueOf(((zzfa)object).zza().getBoolean("measurement_enabled_from_api", true)) : null;
            if (!bl || object == null || ((Boolean)object).booleanValue()) {
                this.zzac(bl, false);
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzac(Boolean bl, boolean bl2) {
        ((zzgo)this).zzg();
        this.zza();
        this.zzs.zzay().zzc().zzb("Setting app measurement enabled (FE)", bl);
        this.zzs.zzm().zzh(bl);
        if (bl2) {
            zzfa zzfa2 = this.zzs.zzm();
            zzfv cfr_ignored_0 = zzfa2.zzs;
            zzfa2.zzg();
            zzfa2 = zzfa2.zza().edit();
            if (bl != null) {
                zzfa2.putBoolean("measurement_enabled_from_api", bl);
            } else {
                zzfa2.remove("measurement_enabled_from_api");
            }
            zzfa2.apply();
        }
        if (this.zzs.zzK() || bl != null && !bl.booleanValue()) {
            this.zzad();
            return;
        }
    }

    public final void zzX(String string, String string2, Object object, boolean bl) {
        this.zzY("auto", "_ldl", object, true, this.zzs.zzav().currentTimeMillis());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void zzY(String object, String string, Object object2, boolean bl, long l) {
        void var5_15;
        void var4_8;
        if (object == null) {
            object = "app";
        }
        if (bl) {
            int n = this.zzs.zzv().zzl(string);
        } else {
            zzkz zzkz2 = this.zzs.zzv();
            if (!zzkz2.zzab("user property", string)) {
                int n = 6;
            } else if (!zzkz2.zzY("user property", zzgu.zza, null, string)) {
                int n = 15;
            } else {
                zzkz2.zzs.zzf();
                if (!zzkz2.zzX("user property", 24, string)) {
                    int n = 6;
                } else {
                    boolean bl2 = false;
                }
            }
        }
        if (var4_8 != false) {
            object = this.zzs;
            object = ((zzfv)object).zzv();
            this.zzs.zzf();
            object2 = ((zzkz)object).zzC(string, 24, true);
            int n = string != null ? string.length() : 0;
            this.zzs.zzv().zzM(this.zzn, null, (int)var4_8, "_ev", (String)object2, n);
            return;
        }
        if (object2 == null) {
            this.zzN((String)object, string, (long)var5_15, null);
            return;
        }
        int n = this.zzs.zzv().zzd(string, object2);
        if (n != 0) {
            object = this.zzs;
            object = ((zzfv)object).zzv();
            this.zzs.zzf();
            string = ((zzkz)object).zzC(string, 24, true);
            int n2 = object2 instanceof String || object2 instanceof CharSequence ? object2.toString().length() : 0;
            this.zzs.zzv().zzM(this.zzn, null, n, "_ev", string, n2);
            return;
        }
        object2 = this.zzs.zzv().zzB(string, object2);
        if (object2 != null) {
            this.zzN((String)object, string, (long)var5_15, object2);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzZ(String string, String string2, Object object, long l) {
        Object object2;
        block6: {
            block7: {
                Preconditions.checkNotEmpty((String)string);
                Preconditions.checkNotEmpty((String)string2);
                ((zzgo)this).zzg();
                this.zza();
                if (!"allow_personalized_ads".equals(string2)) break block7;
                if (object instanceof String && !TextUtils.isEmpty((CharSequence)(object2 = (String)object))) {
                    long l2 = true != "false".equals(((String)object2).toLowerCase(Locale.ENGLISH)) ? 0L : 1L;
                    object2 = l2;
                    object = this.zzs.zzm().zzh;
                    string2 = (Long)object2 == 1L ? "true" : "false";
                    ((zzez)object).zzb(string2);
                    string2 = "_npa";
                    break block6;
                } else if (object == null) {
                    this.zzs.zzm().zzh.zzb("unset");
                    string2 = "_npa";
                    object2 = object;
                    break block6;
                } else {
                    object2 = object;
                }
                break block6;
            }
            object2 = object;
        }
        if (!this.zzs.zzJ()) {
            this.zzs.zzay().zzj().zza("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzs.zzM()) {
            return;
        }
        object = new zzkv(string2, l, object2, string);
        this.zzs.zzt().zzK((zzkv)((Object)object));
    }

    public final void zzaa(zzgw zzgw2) {
        this.zza();
        Preconditions.checkNotNull((Object)zzgw2);
        if (!this.zze.remove(zzgw2)) {
            this.zzs.zzay().zzk().zza("OnEventListener had not been registered");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzad() {
        ((zzgo)this).zzg();
        Object object = this.zzs.zzm().zzh.zza();
        if (object != null) {
            if ("unset".equals(object)) {
                this.zzZ("app", "_npa", null, this.zzs.zzav().currentTimeMillis());
            } else {
                long l = true != "true".equals(object) ? 0L : 1L;
                this.zzZ("app", "_npa", l, this.zzs.zzav().currentTimeMillis());
            }
        }
        if (this.zzs.zzJ() && this.zzc) {
            this.zzs.zzay().zzc().zza("Recording app launch after enabling measurement for the first time (FE)");
            this.zzy();
            zzod.zzc();
            if (this.zzs.zzf().zzs(null, zzdy.zzai)) {
                this.zzs.zzu().zza.zza();
            }
            object = this.zzs;
            object = ((zzfv)object).zzaz();
            zzhd zzhd2 = new zzhd(this);
            ((zzfs)object).zzp(zzhd2);
            return;
        }
        this.zzs.zzay().zzc().zza("Updating Scion state (FE)");
        this.zzs.zzt().zzI();
    }

    @Override
    protected final boolean zzf() {
        return false;
    }
}

