/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzdz;
import com.google.android.gms.measurement.internal.zzeb;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzel;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzji;
import com.google.android.gms.measurement.internal.zzjj;
import com.google.android.gms.measurement.internal.zzjk;
import com.google.android.gms.measurement.internal.zzjl;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzjo;

@VisibleForTesting
public final class zzjn
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile zzeh zzc;
    final /* synthetic */ zzjo zza;

    static /* bridge */ /* synthetic */ void zza(zzjn zzjn2, boolean bl) {
        zzjn2.zzb = false;
    }

    protected zzjn(zzjo zzjo2) {
        this.zza = zzjo2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zzb(Intent object) {
        ((zzgo)this.zza).zzg();
        Context context = this.zza.zzs.zzau();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        synchronized (this) {
            boolean bl = this.zzb;
            if (bl) {
                object = this.zza;
                object = ((zzgo)object).zzs.zzay();
                ((zzel)object).zzj().zza("Connection attempt already in progress");
                return;
            }
            zzgo zzgo2 = this.zza;
            zzgo2 = zzgo2.zzs.zzay();
            ((zzel)zzgo2).zzj().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, (Intent)object, (ServiceConnection)zzjo.zzi(this.zza), 129);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zzc() {
        ((zzgo)this.zza).zzg();
        Object object = this.zza.zzs.zzau();
        synchronized (this) {
            zzeh zzeh2;
            boolean bl;
            boolean bl2 = this.zzb;
            if (bl2) {
                object = this.zza;
                object = ((zzgo)object).zzs.zzay();
                ((zzel)object).zzj().zza("Connection attempt already in progress");
                return;
            }
            zzeh zzeh3 = this.zzc;
            if (zzeh3 != null && ((bl = this.zzc.isConnecting()) || (bl = this.zzc.isConnected()))) {
                object = this.zza;
                object = ((zzgo)object).zzs.zzay();
                ((zzel)object).zzj().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = zzeh2 = new zzeh((Context)object, Looper.getMainLooper(), this, this);
            object = this.zza;
            object = ((zzgo)object).zzs.zzay();
            ((zzel)object).zzj().zza("Connecting to remote service");
            this.zzb = true;
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            this.zzc.checkAvailabilityAndConnect();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @WorkerThread
    public final void zzd() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onConnected(Bundle object) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        // MONITORENTER : this
        try {
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            object = (zzeb)this.zzc.getService();
            zzgo zzgo2 = this.zza;
            zzgo2 = zzgo2.zzs.zzaz();
            zzjk zzjk2 = new zzjk(this, (zzeb)object);
            ((zzfs)zzgo2).zzp(zzjk2);
            // MONITOREXIT : this
            return;
        }
        catch (DeadObjectException | IllegalStateException throwable) {
            this.zzc = null;
            this.zzb = false;
            return;
            {
                catch (Throwable throwable2) {}
                {
                    // MONITOREXIT : this
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult object) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        Object object2 = this.zza.zzs.zzl();
        if (object2 != null) {
            ((zzel)object2).zzk().zzb("Service connection failed", object);
        }
        synchronized (this) {
            this.zzb = false;
            this.zzc = null;
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl9 : MonitorExitStatement: MONITOREXIT : this
            object = this.zza;
            object = ((zzgo)object).zzs;
            object = ((zzfv)object).zzaz();
            object2 = new zzjm(this);
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        ((zzfs)object).zzp((Runnable)object2);
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        this.zza.zzs.zzay().zzc().zza("Service connection suspended");
        zzgq zzgq2 = this.zza;
        zzgq2 = ((zzgo)zzgq2).zzs;
        zzgq2 = ((zzfv)zzgq2).zzaz();
        zzjl zzjl2 = new zzjl(this);
        ((zzfs)zzgq2).zzp(zzjl2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onServiceConnected(ComponentName object, IBinder object2) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        // MONITORENTER : this
        if (object2 == null) {
            this.zzb = false;
            object = this.zza;
            object = ((zzgo)object).zzs.zzay();
            ((zzel)object).zzd().zza("Service connected with null binder");
            // MONITOREXIT : this
            return;
        }
        try {
            object = object2.getInterfaceDescriptor();
            boolean bl = "com.google.android.gms.measurement.internal.IMeasurementService".equals(object);
            if (bl) {
                object = object2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService");
                bl = object instanceof zzeb;
                object = bl ? (zzeb)object : new zzdz((IBinder)object2);
                object2 = this.zza;
                object2 = ((zzgo)object2).zzs.zzay();
                ((zzel)object2).zzj().zza("Bound to IMeasurementService interface");
                object2 = object;
            } else {
                object2 = this.zza;
                object2 = ((zzgo)object2).zzs.zzay();
                ((zzel)object2).zzd().zzb("Got binder with a wrong descriptor", object);
                object2 = null;
            }
            object = object2;
        }
        catch (RemoteException remoteException) {
            block14: {
                object = null;
                break block14;
                catch (RemoteException remoteException2) {}
            }
            object2 = this.zza;
            object2 = ((zzgo)object2).zzs.zzay();
            ((zzel)object2).zzd().zza("Service connect failed to get IMeasurementService");
        }
        if (object != null) {
            object2 = this.zza;
            object2 = ((zzgo)object2).zzs.zzaz();
            zzji zzji2 = new zzji(this, (zzeb)object);
            ((zzfs)object2).zzp(zzji2);
            return;
        }
        this.zzb = false;
        try {
            object = ConnectionTracker.getInstance();
            object2 = this.zza;
            object2 = ((zzgo)object2).zzs.zzau();
            object.unbindService((Context)object2, (ServiceConnection)zzjo.zzi(this.zza));
            // MONITOREXIT : this
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        this.zza.zzs.zzay().zzc().zza("Service disconnected");
        zzgq zzgq2 = this.zza;
        zzgq2 = ((zzgo)zzgq2).zzs;
        zzgq2 = ((zzfv)zzgq2).zzaz();
        zzjj zzjj2 = new zzjj(this, componentName);
        ((zzfs)zzgq2).zzp(zzjj2);
    }
}

