/*
 * Decompiled with CFR 0.152.
 */
package com.google.longrunning.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.CancelOperationRequest;
import com.google.longrunning.DeleteOperationRequest;
import com.google.longrunning.GetOperationRequest;
import com.google.longrunning.ListOperationsRequest;
import com.google.longrunning.ListOperationsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsSettings;
import com.google.longrunning.PagedResponseWrappers;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcOperationsStub
extends OperationsStub {
    private static final UnaryCallable<GetOperationRequest, Operation> directGetOperationCallable = GrpcCallableFactory.createDirectCallable(MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.longrunning.Operations/GetOperation", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)GetOperationRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Operation.getDefaultInstance())));
    private static final UnaryCallable<ListOperationsRequest, ListOperationsResponse> directListOperationsCallable = GrpcCallableFactory.createDirectCallable(MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.longrunning.Operations/ListOperations", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListOperationsRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListOperationsResponse.getDefaultInstance())));
    private static final UnaryCallable<CancelOperationRequest, Empty> directCancelOperationCallable = GrpcCallableFactory.createDirectCallable(MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.longrunning.Operations/CancelOperation", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)CancelOperationRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Empty.getDefaultInstance())));
    private static final UnaryCallable<DeleteOperationRequest, Empty> directDeleteOperationCallable = GrpcCallableFactory.createDirectCallable(MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.longrunning.Operations/DeleteOperation", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)DeleteOperationRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Empty.getDefaultInstance())));
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<GetOperationRequest, Operation> getOperationCallable;
    private final UnaryCallable<ListOperationsRequest, ListOperationsResponse> listOperationsCallable;
    private final UnaryCallable<ListOperationsRequest, PagedResponseWrappers.ListOperationsPagedResponse> listOperationsPagedCallable;
    private final UnaryCallable<CancelOperationRequest, Empty> cancelOperationCallable;
    private final UnaryCallable<DeleteOperationRequest, Empty> deleteOperationCallable;

    public static final GrpcOperationsStub create(OperationsSettings settings) throws IOException {
        return new GrpcOperationsStub(settings, ClientContext.create((ClientSettings)settings));
    }

    public static final GrpcOperationsStub create(ClientContext clientContext) throws IOException {
        return new GrpcOperationsStub(OperationsSettings.newBuilder().build(), clientContext);
    }

    protected GrpcOperationsStub(OperationsSettings settings, ClientContext clientContext) throws IOException {
        this.getOperationCallable = GrpcCallableFactory.create(directGetOperationCallable, settings.getOperationSettings(), clientContext);
        this.listOperationsCallable = GrpcCallableFactory.create(directListOperationsCallable, settings.listOperationsSettings(), clientContext);
        this.listOperationsPagedCallable = GrpcCallableFactory.createPagedVariant(directListOperationsCallable, settings.listOperationsSettings(), clientContext);
        this.cancelOperationCallable = GrpcCallableFactory.create(directCancelOperationCallable, settings.cancelOperationSettings(), clientContext);
        this.deleteOperationCallable = GrpcCallableFactory.create(directDeleteOperationCallable, settings.deleteOperationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<GetOperationRequest, Operation> getOperationCallable() {
        return this.getOperationCallable;
    }

    @Override
    public UnaryCallable<ListOperationsRequest, PagedResponseWrappers.ListOperationsPagedResponse> listOperationsPagedCallable() {
        return this.listOperationsPagedCallable;
    }

    @Override
    public UnaryCallable<ListOperationsRequest, ListOperationsResponse> listOperationsCallable() {
        return this.listOperationsCallable;
    }

    @Override
    public UnaryCallable<CancelOperationRequest, Empty> cancelOperationCallable() {
        return this.cancelOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteOperationRequest, Empty> deleteOperationCallable() {
        return this.deleteOperationCallable;
    }

    public final void close() throws Exception {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

