package com.google.api.gax.rpc;

import com.google.api.gax.rpc.mtls.MtlsProvider;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_EndpointContext extends EndpointContext {

  @Nullable
  private final String serviceName;

  @Nullable
  private final String universeDomain;

  @Nullable
  private final String clientSettingsEndpoint;

  @Nullable
  private final String transportChannelProviderEndpoint;

  @Nullable
  private final String mtlsEndpoint;

  private final boolean switchToMtlsEndpointAllowed;

  @Nullable
  private final MtlsProvider mtlsProvider;

  private final boolean usingGDCH;

  private final String resolvedUniverseDomain;

  private final String resolvedEndpoint;

  private AutoValue_EndpointContext(
      @Nullable String serviceName,
      @Nullable String universeDomain,
      @Nullable String clientSettingsEndpoint,
      @Nullable String transportChannelProviderEndpoint,
      @Nullable String mtlsEndpoint,
      boolean switchToMtlsEndpointAllowed,
      @Nullable MtlsProvider mtlsProvider,
      boolean usingGDCH,
      String resolvedUniverseDomain,
      String resolvedEndpoint) {
    this.serviceName = serviceName;
    this.universeDomain = universeDomain;
    this.clientSettingsEndpoint = clientSettingsEndpoint;
    this.transportChannelProviderEndpoint = transportChannelProviderEndpoint;
    this.mtlsEndpoint = mtlsEndpoint;
    this.switchToMtlsEndpointAllowed = switchToMtlsEndpointAllowed;
    this.mtlsProvider = mtlsProvider;
    this.usingGDCH = usingGDCH;
    this.resolvedUniverseDomain = resolvedUniverseDomain;
    this.resolvedEndpoint = resolvedEndpoint;
  }

  @Nullable
  @Override
  public String serviceName() {
    return serviceName;
  }

  @Nullable
  @Override
  public String universeDomain() {
    return universeDomain;
  }

  @Nullable
  @Override
  public String clientSettingsEndpoint() {
    return clientSettingsEndpoint;
  }

  @Nullable
  @Override
  public String transportChannelProviderEndpoint() {
    return transportChannelProviderEndpoint;
  }

  @Nullable
  @Override
  public String mtlsEndpoint() {
    return mtlsEndpoint;
  }

  @Override
  public boolean switchToMtlsEndpointAllowed() {
    return switchToMtlsEndpointAllowed;
  }

  @Nullable
  @Override
  public MtlsProvider mtlsProvider() {
    return mtlsProvider;
  }

  @Override
  public boolean usingGDCH() {
    return usingGDCH;
  }

  @Override
  String resolvedUniverseDomain() {
    return resolvedUniverseDomain;
  }

  @Override
  public String resolvedEndpoint() {
    return resolvedEndpoint;
  }

  @Override
  public String toString() {
    return "EndpointContext{"
        + "serviceName=" + serviceName + ", "
        + "universeDomain=" + universeDomain + ", "
        + "clientSettingsEndpoint=" + clientSettingsEndpoint + ", "
        + "transportChannelProviderEndpoint=" + transportChannelProviderEndpoint + ", "
        + "mtlsEndpoint=" + mtlsEndpoint + ", "
        + "switchToMtlsEndpointAllowed=" + switchToMtlsEndpointAllowed + ", "
        + "mtlsProvider=" + mtlsProvider + ", "
        + "usingGDCH=" + usingGDCH + ", "
        + "resolvedUniverseDomain=" + resolvedUniverseDomain + ", "
        + "resolvedEndpoint=" + resolvedEndpoint
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof EndpointContext) {
      EndpointContext that = (EndpointContext) o;
      return (this.serviceName == null ? that.serviceName() == null : this.serviceName.equals(that.serviceName()))
          && (this.universeDomain == null ? that.universeDomain() == null : this.universeDomain.equals(that.universeDomain()))
          && (this.clientSettingsEndpoint == null ? that.clientSettingsEndpoint() == null : this.clientSettingsEndpoint.equals(that.clientSettingsEndpoint()))
          && (this.transportChannelProviderEndpoint == null ? that.transportChannelProviderEndpoint() == null : this.transportChannelProviderEndpoint.equals(that.transportChannelProviderEndpoint()))
          && (this.mtlsEndpoint == null ? that.mtlsEndpoint() == null : this.mtlsEndpoint.equals(that.mtlsEndpoint()))
          && this.switchToMtlsEndpointAllowed == that.switchToMtlsEndpointAllowed()
          && (this.mtlsProvider == null ? that.mtlsProvider() == null : this.mtlsProvider.equals(that.mtlsProvider()))
          && this.usingGDCH == that.usingGDCH()
          && this.resolvedUniverseDomain.equals(that.resolvedUniverseDomain())
          && this.resolvedEndpoint.equals(that.resolvedEndpoint());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (serviceName == null) ? 0 : serviceName.hashCode();
    h$ *= 1000003;
    h$ ^= (universeDomain == null) ? 0 : universeDomain.hashCode();
    h$ *= 1000003;
    h$ ^= (clientSettingsEndpoint == null) ? 0 : clientSettingsEndpoint.hashCode();
    h$ *= 1000003;
    h$ ^= (transportChannelProviderEndpoint == null) ? 0 : transportChannelProviderEndpoint.hashCode();
    h$ *= 1000003;
    h$ ^= (mtlsEndpoint == null) ? 0 : mtlsEndpoint.hashCode();
    h$ *= 1000003;
    h$ ^= switchToMtlsEndpointAllowed ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (mtlsProvider == null) ? 0 : mtlsProvider.hashCode();
    h$ *= 1000003;
    h$ ^= usingGDCH ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= resolvedUniverseDomain.hashCode();
    h$ *= 1000003;
    h$ ^= resolvedEndpoint.hashCode();
    return h$;
  }

  @Override
  public EndpointContext.Builder toBuilder() {
    return new AutoValue_EndpointContext.Builder(this);
  }

  static final class Builder extends EndpointContext.Builder {
    private String serviceName;
    private String universeDomain;
    private String clientSettingsEndpoint;
    private String transportChannelProviderEndpoint;
    private String mtlsEndpoint;
    private boolean switchToMtlsEndpointAllowed;
    private MtlsProvider mtlsProvider;
    private boolean usingGDCH;
    private String resolvedUniverseDomain;
    private String resolvedEndpoint;
    private byte set$0;
    Builder() {
    }
    Builder(EndpointContext source) {
      this.serviceName = source.serviceName();
      this.universeDomain = source.universeDomain();
      this.clientSettingsEndpoint = source.clientSettingsEndpoint();
      this.transportChannelProviderEndpoint = source.transportChannelProviderEndpoint();
      this.mtlsEndpoint = source.mtlsEndpoint();
      this.switchToMtlsEndpointAllowed = source.switchToMtlsEndpointAllowed();
      this.mtlsProvider = source.mtlsProvider();
      this.usingGDCH = source.usingGDCH();
      this.resolvedUniverseDomain = source.resolvedUniverseDomain();
      this.resolvedEndpoint = source.resolvedEndpoint();
      set$0 = (byte) 3;
    }
    @Override
    public EndpointContext.Builder setServiceName(String serviceName) {
      this.serviceName = serviceName;
      return this;
    }
    @Override
    @Nullable String serviceName() {
      return serviceName;
    }
    @Override
    public EndpointContext.Builder setUniverseDomain(String universeDomain) {
      this.universeDomain = universeDomain;
      return this;
    }
    @Override
    @Nullable String universeDomain() {
      return universeDomain;
    }
    @Override
    public EndpointContext.Builder setClientSettingsEndpoint(String clientSettingsEndpoint) {
      this.clientSettingsEndpoint = clientSettingsEndpoint;
      return this;
    }
    @Override
    @Nullable String clientSettingsEndpoint() {
      return clientSettingsEndpoint;
    }
    @Override
    public EndpointContext.Builder setTransportChannelProviderEndpoint(String transportChannelProviderEndpoint) {
      this.transportChannelProviderEndpoint = transportChannelProviderEndpoint;
      return this;
    }
    @Override
    @Nullable String transportChannelProviderEndpoint() {
      return transportChannelProviderEndpoint;
    }
    @Override
    public EndpointContext.Builder setMtlsEndpoint(String mtlsEndpoint) {
      this.mtlsEndpoint = mtlsEndpoint;
      return this;
    }
    @Override
    @Nullable String mtlsEndpoint() {
      return mtlsEndpoint;
    }
    @Override
    public EndpointContext.Builder setSwitchToMtlsEndpointAllowed(boolean switchToMtlsEndpointAllowed) {
      this.switchToMtlsEndpointAllowed = switchToMtlsEndpointAllowed;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    boolean switchToMtlsEndpointAllowed() {
      if ((set$0 & 1) == 0) {
        throw new IllegalStateException("Property \"switchToMtlsEndpointAllowed\" has not been set");
      }
      return switchToMtlsEndpointAllowed;
    }
    @Override
    public EndpointContext.Builder setMtlsProvider(MtlsProvider mtlsProvider) {
      this.mtlsProvider = mtlsProvider;
      return this;
    }
    @Override
    @Nullable MtlsProvider mtlsProvider() {
      return mtlsProvider;
    }
    @Override
    public EndpointContext.Builder setUsingGDCH(boolean usingGDCH) {
      this.usingGDCH = usingGDCH;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    boolean usingGDCH() {
      if ((set$0 & 2) == 0) {
        throw new IllegalStateException("Property \"usingGDCH\" has not been set");
      }
      return usingGDCH;
    }
    @Override
    public EndpointContext.Builder setResolvedUniverseDomain(String resolvedUniverseDomain) {
      if (resolvedUniverseDomain == null) {
        throw new NullPointerException("Null resolvedUniverseDomain");
      }
      this.resolvedUniverseDomain = resolvedUniverseDomain;
      return this;
    }
    @Override
    String resolvedUniverseDomain() {
      if (this.resolvedUniverseDomain == null) {
        throw new IllegalStateException("Property \"resolvedUniverseDomain\" has not been set");
      }
      return resolvedUniverseDomain;
    }
    @Override
    public EndpointContext.Builder setResolvedEndpoint(String resolvedEndpoint) {
      if (resolvedEndpoint == null) {
        throw new NullPointerException("Null resolvedEndpoint");
      }
      this.resolvedEndpoint = resolvedEndpoint;
      return this;
    }
    @Override
    EndpointContext autoBuild() {
      if (set$0 != 3
          || this.resolvedUniverseDomain == null
          || this.resolvedEndpoint == null) {
        StringBuilder missing = new StringBuilder();
        if ((set$0 & 1) == 0) {
          missing.append(" switchToMtlsEndpointAllowed");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" usingGDCH");
        }
        if (this.resolvedUniverseDomain == null) {
          missing.append(" resolvedUniverseDomain");
        }
        if (this.resolvedEndpoint == null) {
          missing.append(" resolvedEndpoint");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_EndpointContext(
          this.serviceName,
          this.universeDomain,
          this.clientSettingsEndpoint,
          this.transportChannelProviderEndpoint,
          this.mtlsEndpoint,
          this.switchToMtlsEndpointAllowed,
          this.mtlsProvider,
          this.usingGDCH,
          this.resolvedUniverseDomain,
          this.resolvedEndpoint);
    }
  }

}
