/*
 * Decompiled with CFR 0.152.
 */
package com.google.pubsub.v1;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Empty;
import com.google.protobuf.MessageLite;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.DeleteSubscriptionRequest;
import com.google.pubsub.v1.GetSubscriptionRequest;
import com.google.pubsub.v1.ListSubscriptionsRequest;
import com.google.pubsub.v1.ListSubscriptionsResponse;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.pubsub.v1.ModifyPushConfigRequest;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.Subscription;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;

public class SubscriberGrpc {
    public static final String SERVICE_NAME = "google.pubsub.v1.Subscriber";
    public static final MethodDescriptor<Subscription, Subscription> METHOD_CREATE_SUBSCRIPTION = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"google.pubsub.v1.Subscriber", (String)"CreateSubscription"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)Subscription.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)Subscription.getDefaultInstance()));
    public static final MethodDescriptor<GetSubscriptionRequest, Subscription> METHOD_GET_SUBSCRIPTION = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"google.pubsub.v1.Subscriber", (String)"GetSubscription"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)GetSubscriptionRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)Subscription.getDefaultInstance()));
    public static final MethodDescriptor<ListSubscriptionsRequest, ListSubscriptionsResponse> METHOD_LIST_SUBSCRIPTIONS = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"google.pubsub.v1.Subscriber", (String)"ListSubscriptions"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)ListSubscriptionsRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)ListSubscriptionsResponse.getDefaultInstance()));
    public static final MethodDescriptor<DeleteSubscriptionRequest, Empty> METHOD_DELETE_SUBSCRIPTION = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"google.pubsub.v1.Subscriber", (String)"DeleteSubscription"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)DeleteSubscriptionRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)Empty.getDefaultInstance()));
    public static final MethodDescriptor<ModifyAckDeadlineRequest, Empty> METHOD_MODIFY_ACK_DEADLINE = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"google.pubsub.v1.Subscriber", (String)"ModifyAckDeadline"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)ModifyAckDeadlineRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)Empty.getDefaultInstance()));
    public static final MethodDescriptor<AcknowledgeRequest, Empty> METHOD_ACKNOWLEDGE = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"google.pubsub.v1.Subscriber", (String)"Acknowledge"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)AcknowledgeRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)Empty.getDefaultInstance()));
    public static final MethodDescriptor<PullRequest, PullResponse> METHOD_PULL = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"google.pubsub.v1.Subscriber", (String)"Pull"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)PullRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)PullResponse.getDefaultInstance()));
    public static final MethodDescriptor<ModifyPushConfigRequest, Empty> METHOD_MODIFY_PUSH_CONFIG = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"google.pubsub.v1.Subscriber", (String)"ModifyPushConfig"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)ModifyPushConfigRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)Empty.getDefaultInstance()));

    private SubscriberGrpc() {
    }

    public static SubscriberStub newStub(Channel channel) {
        return new SubscriberStub(channel);
    }

    public static SubscriberBlockingStub newBlockingStub(Channel channel) {
        return new SubscriberBlockingStub(channel);
    }

    public static SubscriberFutureStub newFutureStub(Channel channel) {
        return new SubscriberFutureStub(channel);
    }

    public static ServerServiceDefinition bindService(final Subscriber serviceImpl) {
        return ServerServiceDefinition.builder((String)SERVICE_NAME).addMethod(METHOD_CREATE_SUBSCRIPTION, ServerCalls.asyncUnaryCall((ServerCalls.UnaryMethod)new ServerCalls.UnaryMethod<Subscription, Subscription>(){

            public void invoke(Subscription request, StreamObserver<Subscription> responseObserver) {
                serviceImpl.createSubscription(request, responseObserver);
            }
        })).addMethod(METHOD_GET_SUBSCRIPTION, ServerCalls.asyncUnaryCall((ServerCalls.UnaryMethod)new ServerCalls.UnaryMethod<GetSubscriptionRequest, Subscription>(){

            public void invoke(GetSubscriptionRequest request, StreamObserver<Subscription> responseObserver) {
                serviceImpl.getSubscription(request, responseObserver);
            }
        })).addMethod(METHOD_LIST_SUBSCRIPTIONS, ServerCalls.asyncUnaryCall((ServerCalls.UnaryMethod)new ServerCalls.UnaryMethod<ListSubscriptionsRequest, ListSubscriptionsResponse>(){

            public void invoke(ListSubscriptionsRequest request, StreamObserver<ListSubscriptionsResponse> responseObserver) {
                serviceImpl.listSubscriptions(request, responseObserver);
            }
        })).addMethod(METHOD_DELETE_SUBSCRIPTION, ServerCalls.asyncUnaryCall((ServerCalls.UnaryMethod)new ServerCalls.UnaryMethod<DeleteSubscriptionRequest, Empty>(){

            public void invoke(DeleteSubscriptionRequest request, StreamObserver<Empty> responseObserver) {
                serviceImpl.deleteSubscription(request, responseObserver);
            }
        })).addMethod(METHOD_MODIFY_ACK_DEADLINE, ServerCalls.asyncUnaryCall((ServerCalls.UnaryMethod)new ServerCalls.UnaryMethod<ModifyAckDeadlineRequest, Empty>(){

            public void invoke(ModifyAckDeadlineRequest request, StreamObserver<Empty> responseObserver) {
                serviceImpl.modifyAckDeadline(request, responseObserver);
            }
        })).addMethod(METHOD_ACKNOWLEDGE, ServerCalls.asyncUnaryCall((ServerCalls.UnaryMethod)new ServerCalls.UnaryMethod<AcknowledgeRequest, Empty>(){

            public void invoke(AcknowledgeRequest request, StreamObserver<Empty> responseObserver) {
                serviceImpl.acknowledge(request, responseObserver);
            }
        })).addMethod(METHOD_PULL, ServerCalls.asyncUnaryCall((ServerCalls.UnaryMethod)new ServerCalls.UnaryMethod<PullRequest, PullResponse>(){

            public void invoke(PullRequest request, StreamObserver<PullResponse> responseObserver) {
                serviceImpl.pull(request, responseObserver);
            }
        })).addMethod(METHOD_MODIFY_PUSH_CONFIG, ServerCalls.asyncUnaryCall((ServerCalls.UnaryMethod)new ServerCalls.UnaryMethod<ModifyPushConfigRequest, Empty>(){

            public void invoke(ModifyPushConfigRequest request, StreamObserver<Empty> responseObserver) {
                serviceImpl.modifyPushConfig(request, responseObserver);
            }
        })).build();
    }

    public static class SubscriberFutureStub
    extends AbstractStub<SubscriberFutureStub>
    implements SubscriberFutureClient {
        private SubscriberFutureStub(Channel channel) {
            super(channel);
        }

        private SubscriberFutureStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected SubscriberFutureStub build(Channel channel, CallOptions callOptions) {
            return new SubscriberFutureStub(channel, callOptions);
        }

        @Override
        public ListenableFuture<Subscription> createSubscription(Subscription request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_CREATE_SUBSCRIPTION, this.getCallOptions()), (Object)request);
        }

        @Override
        public ListenableFuture<Subscription> getSubscription(GetSubscriptionRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_GET_SUBSCRIPTION, this.getCallOptions()), (Object)request);
        }

        @Override
        public ListenableFuture<ListSubscriptionsResponse> listSubscriptions(ListSubscriptionsRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_LIST_SUBSCRIPTIONS, this.getCallOptions()), (Object)request);
        }

        @Override
        public ListenableFuture<Empty> deleteSubscription(DeleteSubscriptionRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_DELETE_SUBSCRIPTION, this.getCallOptions()), (Object)request);
        }

        @Override
        public ListenableFuture<Empty> modifyAckDeadline(ModifyAckDeadlineRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_MODIFY_ACK_DEADLINE, this.getCallOptions()), (Object)request);
        }

        @Override
        public ListenableFuture<Empty> acknowledge(AcknowledgeRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_ACKNOWLEDGE, this.getCallOptions()), (Object)request);
        }

        @Override
        public ListenableFuture<PullResponse> pull(PullRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_PULL, this.getCallOptions()), (Object)request);
        }

        @Override
        public ListenableFuture<Empty> modifyPushConfig(ModifyPushConfigRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_MODIFY_PUSH_CONFIG, this.getCallOptions()), (Object)request);
        }
    }

    public static class SubscriberBlockingStub
    extends AbstractStub<SubscriberBlockingStub>
    implements SubscriberBlockingClient {
        private SubscriberBlockingStub(Channel channel) {
            super(channel);
        }

        private SubscriberBlockingStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected SubscriberBlockingStub build(Channel channel, CallOptions callOptions) {
            return new SubscriberBlockingStub(channel, callOptions);
        }

        @Override
        public Subscription createSubscription(Subscription request) {
            return (Subscription)ClientCalls.blockingUnaryCall((ClientCall)this.getChannel().newCall(METHOD_CREATE_SUBSCRIPTION, this.getCallOptions()), (Object)request);
        }

        @Override
        public Subscription getSubscription(GetSubscriptionRequest request) {
            return (Subscription)ClientCalls.blockingUnaryCall((ClientCall)this.getChannel().newCall(METHOD_GET_SUBSCRIPTION, this.getCallOptions()), (Object)request);
        }

        @Override
        public ListSubscriptionsResponse listSubscriptions(ListSubscriptionsRequest request) {
            return (ListSubscriptionsResponse)ClientCalls.blockingUnaryCall((ClientCall)this.getChannel().newCall(METHOD_LIST_SUBSCRIPTIONS, this.getCallOptions()), (Object)request);
        }

        @Override
        public Empty deleteSubscription(DeleteSubscriptionRequest request) {
            return (Empty)ClientCalls.blockingUnaryCall((ClientCall)this.getChannel().newCall(METHOD_DELETE_SUBSCRIPTION, this.getCallOptions()), (Object)request);
        }

        @Override
        public Empty modifyAckDeadline(ModifyAckDeadlineRequest request) {
            return (Empty)ClientCalls.blockingUnaryCall((ClientCall)this.getChannel().newCall(METHOD_MODIFY_ACK_DEADLINE, this.getCallOptions()), (Object)request);
        }

        @Override
        public Empty acknowledge(AcknowledgeRequest request) {
            return (Empty)ClientCalls.blockingUnaryCall((ClientCall)this.getChannel().newCall(METHOD_ACKNOWLEDGE, this.getCallOptions()), (Object)request);
        }

        @Override
        public PullResponse pull(PullRequest request) {
            return (PullResponse)ClientCalls.blockingUnaryCall((ClientCall)this.getChannel().newCall(METHOD_PULL, this.getCallOptions()), (Object)request);
        }

        @Override
        public Empty modifyPushConfig(ModifyPushConfigRequest request) {
            return (Empty)ClientCalls.blockingUnaryCall((ClientCall)this.getChannel().newCall(METHOD_MODIFY_PUSH_CONFIG, this.getCallOptions()), (Object)request);
        }
    }

    public static class SubscriberStub
    extends AbstractStub<SubscriberStub>
    implements Subscriber {
        private SubscriberStub(Channel channel) {
            super(channel);
        }

        private SubscriberStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected SubscriberStub build(Channel channel, CallOptions callOptions) {
            return new SubscriberStub(channel, callOptions);
        }

        @Override
        public void createSubscription(Subscription request, StreamObserver<Subscription> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_CREATE_SUBSCRIPTION, this.getCallOptions()), (Object)request, responseObserver);
        }

        @Override
        public void getSubscription(GetSubscriptionRequest request, StreamObserver<Subscription> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_GET_SUBSCRIPTION, this.getCallOptions()), (Object)request, responseObserver);
        }

        @Override
        public void listSubscriptions(ListSubscriptionsRequest request, StreamObserver<ListSubscriptionsResponse> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_LIST_SUBSCRIPTIONS, this.getCallOptions()), (Object)request, responseObserver);
        }

        @Override
        public void deleteSubscription(DeleteSubscriptionRequest request, StreamObserver<Empty> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_DELETE_SUBSCRIPTION, this.getCallOptions()), (Object)request, responseObserver);
        }

        @Override
        public void modifyAckDeadline(ModifyAckDeadlineRequest request, StreamObserver<Empty> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_MODIFY_ACK_DEADLINE, this.getCallOptions()), (Object)request, responseObserver);
        }

        @Override
        public void acknowledge(AcknowledgeRequest request, StreamObserver<Empty> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_ACKNOWLEDGE, this.getCallOptions()), (Object)request, responseObserver);
        }

        @Override
        public void pull(PullRequest request, StreamObserver<PullResponse> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_PULL, this.getCallOptions()), (Object)request, responseObserver);
        }

        @Override
        public void modifyPushConfig(ModifyPushConfigRequest request, StreamObserver<Empty> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_MODIFY_PUSH_CONFIG, this.getCallOptions()), (Object)request, responseObserver);
        }
    }

    public static interface SubscriberFutureClient {
        public ListenableFuture<Subscription> createSubscription(Subscription var1);

        public ListenableFuture<Subscription> getSubscription(GetSubscriptionRequest var1);

        public ListenableFuture<ListSubscriptionsResponse> listSubscriptions(ListSubscriptionsRequest var1);

        public ListenableFuture<Empty> deleteSubscription(DeleteSubscriptionRequest var1);

        public ListenableFuture<Empty> modifyAckDeadline(ModifyAckDeadlineRequest var1);

        public ListenableFuture<Empty> acknowledge(AcknowledgeRequest var1);

        public ListenableFuture<PullResponse> pull(PullRequest var1);

        public ListenableFuture<Empty> modifyPushConfig(ModifyPushConfigRequest var1);
    }

    public static interface SubscriberBlockingClient {
        public Subscription createSubscription(Subscription var1);

        public Subscription getSubscription(GetSubscriptionRequest var1);

        public ListSubscriptionsResponse listSubscriptions(ListSubscriptionsRequest var1);

        public Empty deleteSubscription(DeleteSubscriptionRequest var1);

        public Empty modifyAckDeadline(ModifyAckDeadlineRequest var1);

        public Empty acknowledge(AcknowledgeRequest var1);

        public PullResponse pull(PullRequest var1);

        public Empty modifyPushConfig(ModifyPushConfigRequest var1);
    }

    public static interface Subscriber {
        public void createSubscription(Subscription var1, StreamObserver<Subscription> var2);

        public void getSubscription(GetSubscriptionRequest var1, StreamObserver<Subscription> var2);

        public void listSubscriptions(ListSubscriptionsRequest var1, StreamObserver<ListSubscriptionsResponse> var2);

        public void deleteSubscription(DeleteSubscriptionRequest var1, StreamObserver<Empty> var2);

        public void modifyAckDeadline(ModifyAckDeadlineRequest var1, StreamObserver<Empty> var2);

        public void acknowledge(AcknowledgeRequest var1, StreamObserver<Empty> var2);

        public void pull(PullRequest var1, StreamObserver<PullResponse> var2);

        public void modifyPushConfig(ModifyPushConfigRequest var1, StreamObserver<Empty> var2);
    }
}

