/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.admin.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AppProfileName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/instances/{instance}/appProfiles/{app_profile}");
    private final String project;
    private final String instance;
    private final String appProfile;

    public String getProject() {
        return this.project;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getAppProfile() {
        return this.appProfile;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AppProfileName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.appProfile = (String)Preconditions.checkNotNull((Object)builder.getAppProfile());
    }

    public static AppProfileName of(String project, String instance, String appProfile) {
        return AppProfileName.newBuilder().setProject(project).setInstance(instance).setAppProfile(appProfile).build();
    }

    public static String format(String project, String instance, String appProfile) {
        return AppProfileName.newBuilder().setProject(project).setInstance(instance).setAppProfile(appProfile).build().toString();
    }

    public static AppProfileName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AppProfileName.parse: formattedString not in valid format");
        return AppProfileName.of((String)matchMap.get("project"), (String)matchMap.get("instance"), (String)matchMap.get("app_profile"));
    }

    public static List<AppProfileName> parseList(List<String> formattedStrings) {
        ArrayList<AppProfileName> list = new ArrayList<AppProfileName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AppProfileName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AppProfileName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AppProfileName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("AppProfileName.getType() not supported");
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "instance", this.instance, "app_profile", this.appProfile});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AppProfileName) {
            AppProfileName that = (AppProfileName)o;
            return this.project.equals(that.project) && this.instance.equals(that.instance) && this.appProfile.equals(that.appProfile);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.instance.hashCode();
        h *= 1000003;
        return h ^= this.appProfile.hashCode();
    }

    public static class Builder {
        private String project;
        private String instance;
        private String appProfile;

        public String getProject() {
            return this.project;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getAppProfile() {
            return this.appProfile;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setAppProfile(String appProfile) {
            this.appProfile = appProfile;
            return this;
        }

        private Builder() {
        }

        private Builder(AppProfileName appProfileName) {
            this.project = appProfileName.project;
            this.instance = appProfileName.instance;
            this.appProfile = appProfileName.appProfile;
        }

        public AppProfileName build() {
            return new AppProfileName(this);
        }
    }
}

