/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.admin.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LocationName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}");
    private final String project;
    private final String location;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private LocationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
    }

    public static LocationName of(String project, String location) {
        return LocationName.newBuilder().setProject(project).setLocation(location).build();
    }

    public static String format(String project, String location) {
        return LocationName.newBuilder().setProject(project).setLocation(location).build().toString();
    }

    public static LocationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "LocationName.parse: formattedString not in valid format");
        return LocationName.of((String)matchMap.get("project"), (String)matchMap.get("location"));
    }

    public static List<LocationName> parseList(List<String> formattedStrings) {
        ArrayList<LocationName> list = new ArrayList<LocationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LocationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LocationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LocationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("LocationName.getType() not supported");
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LocationName) {
            LocationName that = (LocationName)o;
            return this.project.equals(that.project) && this.location.equals(that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.location.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        private Builder() {
        }

        private Builder(LocationName locationName) {
            this.project = locationName.project;
            this.location = locationName.location;
        }

        public LocationName build() {
            return new LocationName(this);
        }
    }
}

