/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.logging.v2.BillingNameType;
import java.util.Map;

public class BillingName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"billingAccounts/{billing_account}");
    private final String billingAccount;

    public String getBillingAccount() {
        return this.billingAccount;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private BillingName(Builder builder) {
        this.billingAccount = (String)Preconditions.checkNotNull((Object)builder.getBillingAccount());
    }

    public static BillingName of(String billingAccount) {
        return BillingName.newBuilder().setBillingAccount(billingAccount).build();
    }

    @Deprecated
    public static BillingName create(String billingAccount) {
        return BillingName.of(billingAccount);
    }

    public static BillingName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "BillingName.parse: formattedString not in valid format");
        return BillingName.of((String)matchMap.get("billing_account"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return BillingNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"billing_account", this.billingAccount});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BillingName) {
            BillingName that = (BillingName)o;
            return this.billingAccount.equals(that.billingAccount);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= this.billingAccount.hashCode();
    }

    public static class Builder {
        private String billingAccount;

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public Builder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        private Builder() {
        }

        private Builder(BillingName billingName) {
            this.billingAccount = billingName.billingAccount;
        }

        public BillingName build() {
            return new BillingName(this);
        }
    }
}

