/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.api.resourcenames.UntypedResourceName;
import com.google.common.base.Preconditions;
import com.google.logging.v2.BillingExclusionName;
import com.google.logging.v2.ExclusionName;
import com.google.logging.v2.FolderExclusionName;
import com.google.logging.v2.OrganizationExclusionName;

public class ExclusionNameOneof
implements ResourceName {
    private final ResourceName resourceName;

    public ExclusionName getExclusionName() {
        if (this.resourceName instanceof ExclusionName) {
            return (ExclusionName)this.resourceName;
        }
        return null;
    }

    public OrganizationExclusionName getOrganizationExclusionName() {
        if (this.resourceName instanceof OrganizationExclusionName) {
            return (OrganizationExclusionName)this.resourceName;
        }
        return null;
    }

    public FolderExclusionName getFolderExclusionName() {
        if (this.resourceName instanceof FolderExclusionName) {
            return (FolderExclusionName)this.resourceName;
        }
        return null;
    }

    public BillingExclusionName getBillingExclusionName() {
        if (this.resourceName instanceof BillingExclusionName) {
            return (BillingExclusionName)this.resourceName;
        }
        return null;
    }

    public UntypedResourceName getUntypedResourceName() {
        if (this.resourceName instanceof UntypedResourceName) {
            return (UntypedResourceName)this.resourceName;
        }
        return null;
    }

    public ResourceName getResourceName() {
        return this.resourceName;
    }

    public ResourceNameType getType() {
        return this.getResourceName().getType();
    }

    private ExclusionNameOneof(ResourceName resourceName) {
        this.resourceName = (ResourceName)Preconditions.checkNotNull((Object)resourceName);
    }

    public static ExclusionNameOneof parse(String resourceNameString) {
        if (ExclusionName.isParsableFrom(resourceNameString)) {
            return new ExclusionNameOneof(ExclusionName.parse(resourceNameString));
        }
        if (OrganizationExclusionName.isParsableFrom(resourceNameString)) {
            return new ExclusionNameOneof(OrganizationExclusionName.parse(resourceNameString));
        }
        if (FolderExclusionName.isParsableFrom(resourceNameString)) {
            return new ExclusionNameOneof(FolderExclusionName.parse(resourceNameString));
        }
        if (BillingExclusionName.isParsableFrom(resourceNameString)) {
            return new ExclusionNameOneof(BillingExclusionName.parse(resourceNameString));
        }
        return new ExclusionNameOneof((ResourceName)UntypedResourceName.parse((String)resourceNameString));
    }

    public static ExclusionNameOneof from(ExclusionName exclusionName) {
        return new ExclusionNameOneof(exclusionName);
    }

    public static ExclusionNameOneof from(OrganizationExclusionName organizationExclusionName) {
        return new ExclusionNameOneof(organizationExclusionName);
    }

    public static ExclusionNameOneof from(FolderExclusionName folderExclusionName) {
        return new ExclusionNameOneof(folderExclusionName);
    }

    public static ExclusionNameOneof from(BillingExclusionName billingExclusionName) {
        return new ExclusionNameOneof(billingExclusionName);
    }

    public static ExclusionNameOneof fromUntyped(UntypedResourceName untypedResourceName) {
        return new ExclusionNameOneof((ResourceName)untypedResourceName);
    }

    public String toString() {
        return this.getResourceName().toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ExclusionNameOneof) {
            ExclusionNameOneof that = (ExclusionNameOneof)o;
            return this.resourceName.equals(that.resourceName);
        }
        return false;
    }

    public int hashCode() {
        return this.resourceName.hashCode();
    }
}

