/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.logging.v2.OrganizationExclusionNameType;
import java.util.Map;

public class OrganizationExclusionName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/exclusions/{exclusion}");
    private final String organization;
    private final String exclusion;

    public String getOrganization() {
        return this.organization;
    }

    public String getExclusion() {
        return this.exclusion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private OrganizationExclusionName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.exclusion = (String)Preconditions.checkNotNull((Object)builder.getExclusion());
    }

    public static OrganizationExclusionName of(String organization, String exclusion) {
        return OrganizationExclusionName.newBuilder().setOrganization(organization).setExclusion(exclusion).build();
    }

    @Deprecated
    public static OrganizationExclusionName create(String organization, String exclusion) {
        return OrganizationExclusionName.of(organization, exclusion);
    }

    public static OrganizationExclusionName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "OrganizationExclusionName.parse: formattedString not in valid format");
        return OrganizationExclusionName.of((String)matchMap.get("organization"), (String)matchMap.get("exclusion"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return OrganizationExclusionNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"organization", this.organization, "exclusion", this.exclusion});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OrganizationExclusionName) {
            OrganizationExclusionName that = (OrganizationExclusionName)o;
            return this.organization.equals(that.organization) && this.exclusion.equals(that.exclusion);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.organization.hashCode();
        h *= 1000003;
        return h ^= this.exclusion.hashCode();
    }

    public static class Builder {
        private String organization;
        private String exclusion;

        public String getOrganization() {
            return this.organization;
        }

        public String getExclusion() {
            return this.exclusion;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setExclusion(String exclusion) {
            this.exclusion = exclusion;
            return this;
        }

        private Builder() {
        }

        private Builder(OrganizationExclusionName organizationExclusionName) {
            this.organization = organizationExclusionName.organization;
            this.exclusion = organizationExclusionName.exclusion;
        }

        public OrganizationExclusionName build() {
            return new OrganizationExclusionName(this);
        }
    }
}

