/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.api.resourcenames.UntypedResourceName;
import com.google.common.base.Preconditions;
import com.google.logging.v2.BillingSinkName;
import com.google.logging.v2.FolderSinkName;
import com.google.logging.v2.OrganizationSinkName;
import com.google.logging.v2.SinkName;

public class SinkNameOneof
implements ResourceName {
    private final ResourceName resourceName;

    public SinkName getSinkName() {
        if (this.resourceName instanceof SinkName) {
            return (SinkName)this.resourceName;
        }
        return null;
    }

    public OrganizationSinkName getOrganizationSinkName() {
        if (this.resourceName instanceof OrganizationSinkName) {
            return (OrganizationSinkName)this.resourceName;
        }
        return null;
    }

    public FolderSinkName getFolderSinkName() {
        if (this.resourceName instanceof FolderSinkName) {
            return (FolderSinkName)this.resourceName;
        }
        return null;
    }

    public BillingSinkName getBillingSinkName() {
        if (this.resourceName instanceof BillingSinkName) {
            return (BillingSinkName)this.resourceName;
        }
        return null;
    }

    public UntypedResourceName getUntypedResourceName() {
        if (this.resourceName instanceof UntypedResourceName) {
            return (UntypedResourceName)this.resourceName;
        }
        return null;
    }

    public ResourceName getResourceName() {
        return this.resourceName;
    }

    public ResourceNameType getType() {
        return this.getResourceName().getType();
    }

    private SinkNameOneof(ResourceName resourceName) {
        this.resourceName = (ResourceName)Preconditions.checkNotNull((Object)resourceName);
    }

    public static SinkNameOneof parse(String resourceNameString) {
        if (SinkName.isParsableFrom(resourceNameString)) {
            return new SinkNameOneof(SinkName.parse(resourceNameString));
        }
        if (OrganizationSinkName.isParsableFrom(resourceNameString)) {
            return new SinkNameOneof(OrganizationSinkName.parse(resourceNameString));
        }
        if (FolderSinkName.isParsableFrom(resourceNameString)) {
            return new SinkNameOneof(FolderSinkName.parse(resourceNameString));
        }
        if (BillingSinkName.isParsableFrom(resourceNameString)) {
            return new SinkNameOneof(BillingSinkName.parse(resourceNameString));
        }
        return new SinkNameOneof((ResourceName)UntypedResourceName.parse((String)resourceNameString));
    }

    public static SinkNameOneof from(SinkName sinkName) {
        return new SinkNameOneof(sinkName);
    }

    public static SinkNameOneof from(OrganizationSinkName organizationSinkName) {
        return new SinkNameOneof(organizationSinkName);
    }

    public static SinkNameOneof from(FolderSinkName folderSinkName) {
        return new SinkNameOneof(folderSinkName);
    }

    public static SinkNameOneof from(BillingSinkName billingSinkName) {
        return new SinkNameOneof(billingSinkName);
    }

    public static SinkNameOneof fromUntyped(UntypedResourceName untypedResourceName) {
        return new SinkNameOneof((ResourceName)untypedResourceName);
    }

    public String toString() {
        return this.getResourceName().toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SinkNameOneof) {
            SinkNameOneof that = (SinkNameOneof)o;
            return this.resourceName.equals(that.resourceName);
        }
        return false;
    }

    public int hashCode() {
        return this.resourceName.hashCode();
    }
}

