/*
 * Decompiled with CFR 0.152.
 */
package com.google.pubsub.v1;

import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.pubsub.v1.TopicName;
import java.util.ArrayList;
import java.util.List;

public class UntypedTopicName
extends TopicName {
    private final String rawValue;

    private UntypedTopicName(String rawValue) {
        this.rawValue = (String)Preconditions.checkNotNull((Object)rawValue);
    }

    public static UntypedTopicName from(ResourceName resourceName) {
        return new UntypedTopicName(resourceName.toString());
    }

    public static UntypedTopicName parse(String formattedString) {
        return new UntypedTopicName(formattedString);
    }

    public static List<UntypedTopicName> parseList(List<String> formattedStrings) {
        ArrayList<UntypedTopicName> list = new ArrayList<UntypedTopicName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UntypedTopicName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UntypedTopicName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UntypedTopicName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return true;
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("UntypedTopicName.getType() not supported");
    }

    public String toString() {
        return this.rawValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UntypedTopicName) {
            UntypedTopicName that = (UntypedTopicName)o;
            return this.rawValue.equals(that.rawValue);
        }
        return false;
    }

    public int hashCode() {
        return this.rawValue.hashCode();
    }
}

