// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/v1/keys.proto

package com.google.spanner.v1;

/**
 * <pre>
 * KeyRange represents a range of rows in a table or index.
 * A range has a start key and an end key. These keys can be open or
 * closed, indicating if the range includes rows with that key.
 * Keys are represented by lists, where the ith value in the list
 * corresponds to the ith component of the table or index primary key.
 * Individual values are encoded as described [here][google.spanner.v1.TypeCode].
 * For example, consider the following table definition:
 *     CREATE TABLE UserEvents (
 *       UserName STRING(MAX),
 *       EventDate STRING(10)
 *     ) PRIMARY KEY(UserName, EventDate);
 * The following keys name rows in this table:
 *     ["Bob", "2014-09-23"]
 *     ["Alfred", "2015-06-12"]
 * Since the `UserEvents` table's `PRIMARY KEY` clause names two
 * columns, each `UserEvents` key has two elements; the first is the
 * `UserName`, and the second is the `EventDate`.
 * Key ranges with multiple components are interpreted
 * lexicographically by component using the table or index key's declared
 * sort order. For example, the following range returns all events for
 * user `"Bob"` that occurred in the year 2015:
 *     "start_closed": ["Bob", "2015-01-01"]
 *     "end_closed": ["Bob", "2015-12-31"]
 * Start and end keys can omit trailing key components. This affects the
 * inclusion and exclusion of rows that exactly match the provided key
 * components: if the key is closed, then rows that exactly match the
 * provided components are included; if the key is open, then rows
 * that exactly match are not included.
 * For example, the following range includes all events for `"Bob"` that
 * occurred during and after the year 2000:
 *     "start_closed": ["Bob", "2000-01-01"]
 *     "end_closed": ["Bob"]
 * The next example retrieves all events for `"Bob"`:
 *     "start_closed": ["Bob"]
 *     "end_closed": ["Bob"]
 * To retrieve events before the year 2000:
 *     "start_closed": ["Bob"]
 *     "end_open": ["Bob", "2000-01-01"]
 * The following range includes all rows in the table:
 *     "start_closed": []
 *     "end_closed": []
 * This range returns all users whose `UserName` begins with any
 * character from A to C:
 *     "start_closed": ["A"]
 *     "end_open": ["D"]
 * This range returns all users whose `UserName` begins with B:
 *     "start_closed": ["B"]
 *     "end_open": ["C"]
 * Key ranges honor column sort order. For example, suppose a table is
 * defined as follows:
 *     CREATE TABLE DescendingSortedTable {
 *       Key INT64,
 *       ...
 *     ) PRIMARY KEY(Key DESC);
 * The following range retrieves all rows with key values between 1
 * and 100 inclusive:
 *     "start_closed": ["100"]
 *     "end_closed": ["1"]
 * Note that 100 is passed as the start, and 1 is passed as the end,
 * because `Key` is a descending column in the schema.
 * </pre>
 *
 * Protobuf type {@code google.spanner.v1.KeyRange}
 */
public  final class KeyRange extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.spanner.v1.KeyRange)
    KeyRangeOrBuilder {
private static final long serialVersionUID = 0L;
  // Use KeyRange.newBuilder() to construct.
  private KeyRange(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private KeyRange() {
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private KeyRange(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            com.google.protobuf.ListValue.Builder subBuilder = null;
            if (startKeyTypeCase_ == 1) {
              subBuilder = ((com.google.protobuf.ListValue) startKeyType_).toBuilder();
            }
            startKeyType_ =
                input.readMessage(com.google.protobuf.ListValue.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((com.google.protobuf.ListValue) startKeyType_);
              startKeyType_ = subBuilder.buildPartial();
            }
            startKeyTypeCase_ = 1;
            break;
          }
          case 18: {
            com.google.protobuf.ListValue.Builder subBuilder = null;
            if (startKeyTypeCase_ == 2) {
              subBuilder = ((com.google.protobuf.ListValue) startKeyType_).toBuilder();
            }
            startKeyType_ =
                input.readMessage(com.google.protobuf.ListValue.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((com.google.protobuf.ListValue) startKeyType_);
              startKeyType_ = subBuilder.buildPartial();
            }
            startKeyTypeCase_ = 2;
            break;
          }
          case 26: {
            com.google.protobuf.ListValue.Builder subBuilder = null;
            if (endKeyTypeCase_ == 3) {
              subBuilder = ((com.google.protobuf.ListValue) endKeyType_).toBuilder();
            }
            endKeyType_ =
                input.readMessage(com.google.protobuf.ListValue.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((com.google.protobuf.ListValue) endKeyType_);
              endKeyType_ = subBuilder.buildPartial();
            }
            endKeyTypeCase_ = 3;
            break;
          }
          case 34: {
            com.google.protobuf.ListValue.Builder subBuilder = null;
            if (endKeyTypeCase_ == 4) {
              subBuilder = ((com.google.protobuf.ListValue) endKeyType_).toBuilder();
            }
            endKeyType_ =
                input.readMessage(com.google.protobuf.ListValue.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((com.google.protobuf.ListValue) endKeyType_);
              endKeyType_ = subBuilder.buildPartial();
            }
            endKeyTypeCase_ = 4;
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.spanner.v1.KeysProto.internal_static_google_spanner_v1_KeyRange_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.v1.KeysProto.internal_static_google_spanner_v1_KeyRange_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.v1.KeyRange.class, com.google.spanner.v1.KeyRange.Builder.class);
  }

  private int startKeyTypeCase_ = 0;
  private java.lang.Object startKeyType_;
  public enum StartKeyTypeCase
      implements com.google.protobuf.Internal.EnumLite {
    START_CLOSED(1),
    START_OPEN(2),
    STARTKEYTYPE_NOT_SET(0);
    private final int value;
    private StartKeyTypeCase(int value) {
      this.value = value;
    }
    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static StartKeyTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static StartKeyTypeCase forNumber(int value) {
      switch (value) {
        case 1: return START_CLOSED;
        case 2: return START_OPEN;
        case 0: return STARTKEYTYPE_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public StartKeyTypeCase
  getStartKeyTypeCase() {
    return StartKeyTypeCase.forNumber(
        startKeyTypeCase_);
  }

  private int endKeyTypeCase_ = 0;
  private java.lang.Object endKeyType_;
  public enum EndKeyTypeCase
      implements com.google.protobuf.Internal.EnumLite {
    END_CLOSED(3),
    END_OPEN(4),
    ENDKEYTYPE_NOT_SET(0);
    private final int value;
    private EndKeyTypeCase(int value) {
      this.value = value;
    }
    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EndKeyTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static EndKeyTypeCase forNumber(int value) {
      switch (value) {
        case 3: return END_CLOSED;
        case 4: return END_OPEN;
        case 0: return ENDKEYTYPE_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public EndKeyTypeCase
  getEndKeyTypeCase() {
    return EndKeyTypeCase.forNumber(
        endKeyTypeCase_);
  }

  public static final int START_CLOSED_FIELD_NUMBER = 1;
  /**
   * <pre>
   * If the start is closed, then the range includes all rows whose
   * first `len(start_closed)` key columns exactly match `start_closed`.
   * </pre>
   *
   * <code>.google.protobuf.ListValue start_closed = 1;</code>
   */
  public boolean hasStartClosed() {
    return startKeyTypeCase_ == 1;
  }
  /**
   * <pre>
   * If the start is closed, then the range includes all rows whose
   * first `len(start_closed)` key columns exactly match `start_closed`.
   * </pre>
   *
   * <code>.google.protobuf.ListValue start_closed = 1;</code>
   */
  public com.google.protobuf.ListValue getStartClosed() {
    if (startKeyTypeCase_ == 1) {
       return (com.google.protobuf.ListValue) startKeyType_;
    }
    return com.google.protobuf.ListValue.getDefaultInstance();
  }
  /**
   * <pre>
   * If the start is closed, then the range includes all rows whose
   * first `len(start_closed)` key columns exactly match `start_closed`.
   * </pre>
   *
   * <code>.google.protobuf.ListValue start_closed = 1;</code>
   */
  public com.google.protobuf.ListValueOrBuilder getStartClosedOrBuilder() {
    if (startKeyTypeCase_ == 1) {
       return (com.google.protobuf.ListValue) startKeyType_;
    }
    return com.google.protobuf.ListValue.getDefaultInstance();
  }

  public static final int START_OPEN_FIELD_NUMBER = 2;
  /**
   * <pre>
   * If the start is open, then the range excludes rows whose first
   * `len(start_open)` key columns exactly match `start_open`.
   * </pre>
   *
   * <code>.google.protobuf.ListValue start_open = 2;</code>
   */
  public boolean hasStartOpen() {
    return startKeyTypeCase_ == 2;
  }
  /**
   * <pre>
   * If the start is open, then the range excludes rows whose first
   * `len(start_open)` key columns exactly match `start_open`.
   * </pre>
   *
   * <code>.google.protobuf.ListValue start_open = 2;</code>
   */
  public com.google.protobuf.ListValue getStartOpen() {
    if (startKeyTypeCase_ == 2) {
       return (com.google.protobuf.ListValue) startKeyType_;
    }
    return com.google.protobuf.ListValue.getDefaultInstance();
  }
  /**
   * <pre>
   * If the start is open, then the range excludes rows whose first
   * `len(start_open)` key columns exactly match `start_open`.
   * </pre>
   *
   * <code>.google.protobuf.ListValue start_open = 2;</code>
   */
  public com.google.protobuf.ListValueOrBuilder getStartOpenOrBuilder() {
    if (startKeyTypeCase_ == 2) {
       return (com.google.protobuf.ListValue) startKeyType_;
    }
    return com.google.protobuf.ListValue.getDefaultInstance();
  }

  public static final int END_CLOSED_FIELD_NUMBER = 3;
  /**
   * <pre>
   * If the end is closed, then the range includes all rows whose
   * first `len(end_closed)` key columns exactly match `end_closed`.
   * </pre>
   *
   * <code>.google.protobuf.ListValue end_closed = 3;</code>
   */
  public boolean hasEndClosed() {
    return endKeyTypeCase_ == 3;
  }
  /**
   * <pre>
   * If the end is closed, then the range includes all rows whose
   * first `len(end_closed)` key columns exactly match `end_closed`.
   * </pre>
   *
   * <code>.google.protobuf.ListValue end_closed = 3;</code>
   */
  public com.google.protobuf.ListValue getEndClosed() {
    if (endKeyTypeCase_ == 3) {
       return (com.google.protobuf.ListValue) endKeyType_;
    }
    return com.google.protobuf.ListValue.getDefaultInstance();
  }
  /**
   * <pre>
   * If the end is closed, then the range includes all rows whose
   * first `len(end_closed)` key columns exactly match `end_closed`.
   * </pre>
   *
   * <code>.google.protobuf.ListValue end_closed = 3;</code>
   */
  public com.google.protobuf.ListValueOrBuilder getEndClosedOrBuilder() {
    if (endKeyTypeCase_ == 3) {
       return (com.google.protobuf.ListValue) endKeyType_;
    }
    return com.google.protobuf.ListValue.getDefaultInstance();
  }

  public static final int END_OPEN_FIELD_NUMBER = 4;
  /**
   * <pre>
   * If the end is open, then the range excludes rows whose first
   * `len(end_open)` key columns exactly match `end_open`.
   * </pre>
   *
   * <code>.google.protobuf.ListValue end_open = 4;</code>
   */
  public boolean hasEndOpen() {
    return endKeyTypeCase_ == 4;
  }
  /**
   * <pre>
   * If the end is open, then the range excludes rows whose first
   * `len(end_open)` key columns exactly match `end_open`.
   * </pre>
   *
   * <code>.google.protobuf.ListValue end_open = 4;</code>
   */
  public com.google.protobuf.ListValue getEndOpen() {
    if (endKeyTypeCase_ == 4) {
       return (com.google.protobuf.ListValue) endKeyType_;
    }
    return com.google.protobuf.ListValue.getDefaultInstance();
  }
  /**
   * <pre>
   * If the end is open, then the range excludes rows whose first
   * `len(end_open)` key columns exactly match `end_open`.
   * </pre>
   *
   * <code>.google.protobuf.ListValue end_open = 4;</code>
   */
  public com.google.protobuf.ListValueOrBuilder getEndOpenOrBuilder() {
    if (endKeyTypeCase_ == 4) {
       return (com.google.protobuf.ListValue) endKeyType_;
    }
    return com.google.protobuf.ListValue.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (startKeyTypeCase_ == 1) {
      output.writeMessage(1, (com.google.protobuf.ListValue) startKeyType_);
    }
    if (startKeyTypeCase_ == 2) {
      output.writeMessage(2, (com.google.protobuf.ListValue) startKeyType_);
    }
    if (endKeyTypeCase_ == 3) {
      output.writeMessage(3, (com.google.protobuf.ListValue) endKeyType_);
    }
    if (endKeyTypeCase_ == 4) {
      output.writeMessage(4, (com.google.protobuf.ListValue) endKeyType_);
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (startKeyTypeCase_ == 1) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(1, (com.google.protobuf.ListValue) startKeyType_);
    }
    if (startKeyTypeCase_ == 2) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, (com.google.protobuf.ListValue) startKeyType_);
    }
    if (endKeyTypeCase_ == 3) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, (com.google.protobuf.ListValue) endKeyType_);
    }
    if (endKeyTypeCase_ == 4) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, (com.google.protobuf.ListValue) endKeyType_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.spanner.v1.KeyRange)) {
      return super.equals(obj);
    }
    com.google.spanner.v1.KeyRange other = (com.google.spanner.v1.KeyRange) obj;

    boolean result = true;
    result = result && getStartKeyTypeCase().equals(
        other.getStartKeyTypeCase());
    if (!result) return false;
    switch (startKeyTypeCase_) {
      case 1:
        result = result && getStartClosed()
            .equals(other.getStartClosed());
        break;
      case 2:
        result = result && getStartOpen()
            .equals(other.getStartOpen());
        break;
      case 0:
      default:
    }
    result = result && getEndKeyTypeCase().equals(
        other.getEndKeyTypeCase());
    if (!result) return false;
    switch (endKeyTypeCase_) {
      case 3:
        result = result && getEndClosed()
            .equals(other.getEndClosed());
        break;
      case 4:
        result = result && getEndOpen()
            .equals(other.getEndOpen());
        break;
      case 0:
      default:
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (startKeyTypeCase_) {
      case 1:
        hash = (37 * hash) + START_CLOSED_FIELD_NUMBER;
        hash = (53 * hash) + getStartClosed().hashCode();
        break;
      case 2:
        hash = (37 * hash) + START_OPEN_FIELD_NUMBER;
        hash = (53 * hash) + getStartOpen().hashCode();
        break;
      case 0:
      default:
    }
    switch (endKeyTypeCase_) {
      case 3:
        hash = (37 * hash) + END_CLOSED_FIELD_NUMBER;
        hash = (53 * hash) + getEndClosed().hashCode();
        break;
      case 4:
        hash = (37 * hash) + END_OPEN_FIELD_NUMBER;
        hash = (53 * hash) + getEndOpen().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.v1.KeyRange parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.spanner.v1.KeyRange parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.spanner.v1.KeyRange parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.spanner.v1.KeyRange parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.spanner.v1.KeyRange parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.spanner.v1.KeyRange parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.spanner.v1.KeyRange parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.spanner.v1.KeyRange parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.spanner.v1.KeyRange parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.spanner.v1.KeyRange parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.spanner.v1.KeyRange parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.spanner.v1.KeyRange parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.spanner.v1.KeyRange prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * KeyRange represents a range of rows in a table or index.
   * A range has a start key and an end key. These keys can be open or
   * closed, indicating if the range includes rows with that key.
   * Keys are represented by lists, where the ith value in the list
   * corresponds to the ith component of the table or index primary key.
   * Individual values are encoded as described [here][google.spanner.v1.TypeCode].
   * For example, consider the following table definition:
   *     CREATE TABLE UserEvents (
   *       UserName STRING(MAX),
   *       EventDate STRING(10)
   *     ) PRIMARY KEY(UserName, EventDate);
   * The following keys name rows in this table:
   *     ["Bob", "2014-09-23"]
   *     ["Alfred", "2015-06-12"]
   * Since the `UserEvents` table's `PRIMARY KEY` clause names two
   * columns, each `UserEvents` key has two elements; the first is the
   * `UserName`, and the second is the `EventDate`.
   * Key ranges with multiple components are interpreted
   * lexicographically by component using the table or index key's declared
   * sort order. For example, the following range returns all events for
   * user `"Bob"` that occurred in the year 2015:
   *     "start_closed": ["Bob", "2015-01-01"]
   *     "end_closed": ["Bob", "2015-12-31"]
   * Start and end keys can omit trailing key components. This affects the
   * inclusion and exclusion of rows that exactly match the provided key
   * components: if the key is closed, then rows that exactly match the
   * provided components are included; if the key is open, then rows
   * that exactly match are not included.
   * For example, the following range includes all events for `"Bob"` that
   * occurred during and after the year 2000:
   *     "start_closed": ["Bob", "2000-01-01"]
   *     "end_closed": ["Bob"]
   * The next example retrieves all events for `"Bob"`:
   *     "start_closed": ["Bob"]
   *     "end_closed": ["Bob"]
   * To retrieve events before the year 2000:
   *     "start_closed": ["Bob"]
   *     "end_open": ["Bob", "2000-01-01"]
   * The following range includes all rows in the table:
   *     "start_closed": []
   *     "end_closed": []
   * This range returns all users whose `UserName` begins with any
   * character from A to C:
   *     "start_closed": ["A"]
   *     "end_open": ["D"]
   * This range returns all users whose `UserName` begins with B:
   *     "start_closed": ["B"]
   *     "end_open": ["C"]
   * Key ranges honor column sort order. For example, suppose a table is
   * defined as follows:
   *     CREATE TABLE DescendingSortedTable {
   *       Key INT64,
   *       ...
   *     ) PRIMARY KEY(Key DESC);
   * The following range retrieves all rows with key values between 1
   * and 100 inclusive:
   *     "start_closed": ["100"]
   *     "end_closed": ["1"]
   * Note that 100 is passed as the start, and 1 is passed as the end,
   * because `Key` is a descending column in the schema.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.KeyRange}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.spanner.v1.KeyRange)
      com.google.spanner.v1.KeyRangeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.spanner.v1.KeysProto.internal_static_google_spanner_v1_KeyRange_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.KeysProto.internal_static_google_spanner_v1_KeyRange_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.KeyRange.class, com.google.spanner.v1.KeyRange.Builder.class);
    }

    // Construct using com.google.spanner.v1.KeyRange.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      startKeyTypeCase_ = 0;
      startKeyType_ = null;
      endKeyTypeCase_ = 0;
      endKeyType_ = null;
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.spanner.v1.KeysProto.internal_static_google_spanner_v1_KeyRange_descriptor;
    }

    public com.google.spanner.v1.KeyRange getDefaultInstanceForType() {
      return com.google.spanner.v1.KeyRange.getDefaultInstance();
    }

    public com.google.spanner.v1.KeyRange build() {
      com.google.spanner.v1.KeyRange result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public com.google.spanner.v1.KeyRange buildPartial() {
      com.google.spanner.v1.KeyRange result = new com.google.spanner.v1.KeyRange(this);
      if (startKeyTypeCase_ == 1) {
        if (startClosedBuilder_ == null) {
          result.startKeyType_ = startKeyType_;
        } else {
          result.startKeyType_ = startClosedBuilder_.build();
        }
      }
      if (startKeyTypeCase_ == 2) {
        if (startOpenBuilder_ == null) {
          result.startKeyType_ = startKeyType_;
        } else {
          result.startKeyType_ = startOpenBuilder_.build();
        }
      }
      if (endKeyTypeCase_ == 3) {
        if (endClosedBuilder_ == null) {
          result.endKeyType_ = endKeyType_;
        } else {
          result.endKeyType_ = endClosedBuilder_.build();
        }
      }
      if (endKeyTypeCase_ == 4) {
        if (endOpenBuilder_ == null) {
          result.endKeyType_ = endKeyType_;
        } else {
          result.endKeyType_ = endOpenBuilder_.build();
        }
      }
      result.startKeyTypeCase_ = startKeyTypeCase_;
      result.endKeyTypeCase_ = endKeyTypeCase_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.v1.KeyRange) {
        return mergeFrom((com.google.spanner.v1.KeyRange)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.v1.KeyRange other) {
      if (other == com.google.spanner.v1.KeyRange.getDefaultInstance()) return this;
      switch (other.getStartKeyTypeCase()) {
        case START_CLOSED: {
          mergeStartClosed(other.getStartClosed());
          break;
        }
        case START_OPEN: {
          mergeStartOpen(other.getStartOpen());
          break;
        }
        case STARTKEYTYPE_NOT_SET: {
          break;
        }
      }
      switch (other.getEndKeyTypeCase()) {
        case END_CLOSED: {
          mergeEndClosed(other.getEndClosed());
          break;
        }
        case END_OPEN: {
          mergeEndOpen(other.getEndOpen());
          break;
        }
        case ENDKEYTYPE_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.spanner.v1.KeyRange parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.spanner.v1.KeyRange) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int startKeyTypeCase_ = 0;
    private java.lang.Object startKeyType_;
    public StartKeyTypeCase
        getStartKeyTypeCase() {
      return StartKeyTypeCase.forNumber(
          startKeyTypeCase_);
    }

    public Builder clearStartKeyType() {
      startKeyTypeCase_ = 0;
      startKeyType_ = null;
      onChanged();
      return this;
    }

    private int endKeyTypeCase_ = 0;
    private java.lang.Object endKeyType_;
    public EndKeyTypeCase
        getEndKeyTypeCase() {
      return EndKeyTypeCase.forNumber(
          endKeyTypeCase_);
    }

    public Builder clearEndKeyType() {
      endKeyTypeCase_ = 0;
      endKeyType_ = null;
      onChanged();
      return this;
    }


    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.ListValue, com.google.protobuf.ListValue.Builder, com.google.protobuf.ListValueOrBuilder> startClosedBuilder_;
    /**
     * <pre>
     * If the start is closed, then the range includes all rows whose
     * first `len(start_closed)` key columns exactly match `start_closed`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue start_closed = 1;</code>
     */
    public boolean hasStartClosed() {
      return startKeyTypeCase_ == 1;
    }
    /**
     * <pre>
     * If the start is closed, then the range includes all rows whose
     * first `len(start_closed)` key columns exactly match `start_closed`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue start_closed = 1;</code>
     */
    public com.google.protobuf.ListValue getStartClosed() {
      if (startClosedBuilder_ == null) {
        if (startKeyTypeCase_ == 1) {
          return (com.google.protobuf.ListValue) startKeyType_;
        }
        return com.google.protobuf.ListValue.getDefaultInstance();
      } else {
        if (startKeyTypeCase_ == 1) {
          return startClosedBuilder_.getMessage();
        }
        return com.google.protobuf.ListValue.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * If the start is closed, then the range includes all rows whose
     * first `len(start_closed)` key columns exactly match `start_closed`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue start_closed = 1;</code>
     */
    public Builder setStartClosed(com.google.protobuf.ListValue value) {
      if (startClosedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startKeyType_ = value;
        onChanged();
      } else {
        startClosedBuilder_.setMessage(value);
      }
      startKeyTypeCase_ = 1;
      return this;
    }
    /**
     * <pre>
     * If the start is closed, then the range includes all rows whose
     * first `len(start_closed)` key columns exactly match `start_closed`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue start_closed = 1;</code>
     */
    public Builder setStartClosed(
        com.google.protobuf.ListValue.Builder builderForValue) {
      if (startClosedBuilder_ == null) {
        startKeyType_ = builderForValue.build();
        onChanged();
      } else {
        startClosedBuilder_.setMessage(builderForValue.build());
      }
      startKeyTypeCase_ = 1;
      return this;
    }
    /**
     * <pre>
     * If the start is closed, then the range includes all rows whose
     * first `len(start_closed)` key columns exactly match `start_closed`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue start_closed = 1;</code>
     */
    public Builder mergeStartClosed(com.google.protobuf.ListValue value) {
      if (startClosedBuilder_ == null) {
        if (startKeyTypeCase_ == 1 &&
            startKeyType_ != com.google.protobuf.ListValue.getDefaultInstance()) {
          startKeyType_ = com.google.protobuf.ListValue.newBuilder((com.google.protobuf.ListValue) startKeyType_)
              .mergeFrom(value).buildPartial();
        } else {
          startKeyType_ = value;
        }
        onChanged();
      } else {
        if (startKeyTypeCase_ == 1) {
          startClosedBuilder_.mergeFrom(value);
        }
        startClosedBuilder_.setMessage(value);
      }
      startKeyTypeCase_ = 1;
      return this;
    }
    /**
     * <pre>
     * If the start is closed, then the range includes all rows whose
     * first `len(start_closed)` key columns exactly match `start_closed`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue start_closed = 1;</code>
     */
    public Builder clearStartClosed() {
      if (startClosedBuilder_ == null) {
        if (startKeyTypeCase_ == 1) {
          startKeyTypeCase_ = 0;
          startKeyType_ = null;
          onChanged();
        }
      } else {
        if (startKeyTypeCase_ == 1) {
          startKeyTypeCase_ = 0;
          startKeyType_ = null;
        }
        startClosedBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * If the start is closed, then the range includes all rows whose
     * first `len(start_closed)` key columns exactly match `start_closed`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue start_closed = 1;</code>
     */
    public com.google.protobuf.ListValue.Builder getStartClosedBuilder() {
      return getStartClosedFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * If the start is closed, then the range includes all rows whose
     * first `len(start_closed)` key columns exactly match `start_closed`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue start_closed = 1;</code>
     */
    public com.google.protobuf.ListValueOrBuilder getStartClosedOrBuilder() {
      if ((startKeyTypeCase_ == 1) && (startClosedBuilder_ != null)) {
        return startClosedBuilder_.getMessageOrBuilder();
      } else {
        if (startKeyTypeCase_ == 1) {
          return (com.google.protobuf.ListValue) startKeyType_;
        }
        return com.google.protobuf.ListValue.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * If the start is closed, then the range includes all rows whose
     * first `len(start_closed)` key columns exactly match `start_closed`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue start_closed = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.ListValue, com.google.protobuf.ListValue.Builder, com.google.protobuf.ListValueOrBuilder> 
        getStartClosedFieldBuilder() {
      if (startClosedBuilder_ == null) {
        if (!(startKeyTypeCase_ == 1)) {
          startKeyType_ = com.google.protobuf.ListValue.getDefaultInstance();
        }
        startClosedBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.ListValue, com.google.protobuf.ListValue.Builder, com.google.protobuf.ListValueOrBuilder>(
                (com.google.protobuf.ListValue) startKeyType_,
                getParentForChildren(),
                isClean());
        startKeyType_ = null;
      }
      startKeyTypeCase_ = 1;
      onChanged();;
      return startClosedBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.ListValue, com.google.protobuf.ListValue.Builder, com.google.protobuf.ListValueOrBuilder> startOpenBuilder_;
    /**
     * <pre>
     * If the start is open, then the range excludes rows whose first
     * `len(start_open)` key columns exactly match `start_open`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue start_open = 2;</code>
     */
    public boolean hasStartOpen() {
      return startKeyTypeCase_ == 2;
    }
    /**
     * <pre>
     * If the start is open, then the range excludes rows whose first
     * `len(start_open)` key columns exactly match `start_open`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue start_open = 2;</code>
     */
    public com.google.protobuf.ListValue getStartOpen() {
      if (startOpenBuilder_ == null) {
        if (startKeyTypeCase_ == 2) {
          return (com.google.protobuf.ListValue) startKeyType_;
        }
        return com.google.protobuf.ListValue.getDefaultInstance();
      } else {
        if (startKeyTypeCase_ == 2) {
          return startOpenBuilder_.getMessage();
        }
        return com.google.protobuf.ListValue.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * If the start is open, then the range excludes rows whose first
     * `len(start_open)` key columns exactly match `start_open`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue start_open = 2;</code>
     */
    public Builder setStartOpen(com.google.protobuf.ListValue value) {
      if (startOpenBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startKeyType_ = value;
        onChanged();
      } else {
        startOpenBuilder_.setMessage(value);
      }
      startKeyTypeCase_ = 2;
      return this;
    }
    /**
     * <pre>
     * If the start is open, then the range excludes rows whose first
     * `len(start_open)` key columns exactly match `start_open`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue start_open = 2;</code>
     */
    public Builder setStartOpen(
        com.google.protobuf.ListValue.Builder builderForValue) {
      if (startOpenBuilder_ == null) {
        startKeyType_ = builderForValue.build();
        onChanged();
      } else {
        startOpenBuilder_.setMessage(builderForValue.build());
      }
      startKeyTypeCase_ = 2;
      return this;
    }
    /**
     * <pre>
     * If the start is open, then the range excludes rows whose first
     * `len(start_open)` key columns exactly match `start_open`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue start_open = 2;</code>
     */
    public Builder mergeStartOpen(com.google.protobuf.ListValue value) {
      if (startOpenBuilder_ == null) {
        if (startKeyTypeCase_ == 2 &&
            startKeyType_ != com.google.protobuf.ListValue.getDefaultInstance()) {
          startKeyType_ = com.google.protobuf.ListValue.newBuilder((com.google.protobuf.ListValue) startKeyType_)
              .mergeFrom(value).buildPartial();
        } else {
          startKeyType_ = value;
        }
        onChanged();
      } else {
        if (startKeyTypeCase_ == 2) {
          startOpenBuilder_.mergeFrom(value);
        }
        startOpenBuilder_.setMessage(value);
      }
      startKeyTypeCase_ = 2;
      return this;
    }
    /**
     * <pre>
     * If the start is open, then the range excludes rows whose first
     * `len(start_open)` key columns exactly match `start_open`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue start_open = 2;</code>
     */
    public Builder clearStartOpen() {
      if (startOpenBuilder_ == null) {
        if (startKeyTypeCase_ == 2) {
          startKeyTypeCase_ = 0;
          startKeyType_ = null;
          onChanged();
        }
      } else {
        if (startKeyTypeCase_ == 2) {
          startKeyTypeCase_ = 0;
          startKeyType_ = null;
        }
        startOpenBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * If the start is open, then the range excludes rows whose first
     * `len(start_open)` key columns exactly match `start_open`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue start_open = 2;</code>
     */
    public com.google.protobuf.ListValue.Builder getStartOpenBuilder() {
      return getStartOpenFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * If the start is open, then the range excludes rows whose first
     * `len(start_open)` key columns exactly match `start_open`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue start_open = 2;</code>
     */
    public com.google.protobuf.ListValueOrBuilder getStartOpenOrBuilder() {
      if ((startKeyTypeCase_ == 2) && (startOpenBuilder_ != null)) {
        return startOpenBuilder_.getMessageOrBuilder();
      } else {
        if (startKeyTypeCase_ == 2) {
          return (com.google.protobuf.ListValue) startKeyType_;
        }
        return com.google.protobuf.ListValue.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * If the start is open, then the range excludes rows whose first
     * `len(start_open)` key columns exactly match `start_open`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue start_open = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.ListValue, com.google.protobuf.ListValue.Builder, com.google.protobuf.ListValueOrBuilder> 
        getStartOpenFieldBuilder() {
      if (startOpenBuilder_ == null) {
        if (!(startKeyTypeCase_ == 2)) {
          startKeyType_ = com.google.protobuf.ListValue.getDefaultInstance();
        }
        startOpenBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.ListValue, com.google.protobuf.ListValue.Builder, com.google.protobuf.ListValueOrBuilder>(
                (com.google.protobuf.ListValue) startKeyType_,
                getParentForChildren(),
                isClean());
        startKeyType_ = null;
      }
      startKeyTypeCase_ = 2;
      onChanged();;
      return startOpenBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.ListValue, com.google.protobuf.ListValue.Builder, com.google.protobuf.ListValueOrBuilder> endClosedBuilder_;
    /**
     * <pre>
     * If the end is closed, then the range includes all rows whose
     * first `len(end_closed)` key columns exactly match `end_closed`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue end_closed = 3;</code>
     */
    public boolean hasEndClosed() {
      return endKeyTypeCase_ == 3;
    }
    /**
     * <pre>
     * If the end is closed, then the range includes all rows whose
     * first `len(end_closed)` key columns exactly match `end_closed`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue end_closed = 3;</code>
     */
    public com.google.protobuf.ListValue getEndClosed() {
      if (endClosedBuilder_ == null) {
        if (endKeyTypeCase_ == 3) {
          return (com.google.protobuf.ListValue) endKeyType_;
        }
        return com.google.protobuf.ListValue.getDefaultInstance();
      } else {
        if (endKeyTypeCase_ == 3) {
          return endClosedBuilder_.getMessage();
        }
        return com.google.protobuf.ListValue.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * If the end is closed, then the range includes all rows whose
     * first `len(end_closed)` key columns exactly match `end_closed`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue end_closed = 3;</code>
     */
    public Builder setEndClosed(com.google.protobuf.ListValue value) {
      if (endClosedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endKeyType_ = value;
        onChanged();
      } else {
        endClosedBuilder_.setMessage(value);
      }
      endKeyTypeCase_ = 3;
      return this;
    }
    /**
     * <pre>
     * If the end is closed, then the range includes all rows whose
     * first `len(end_closed)` key columns exactly match `end_closed`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue end_closed = 3;</code>
     */
    public Builder setEndClosed(
        com.google.protobuf.ListValue.Builder builderForValue) {
      if (endClosedBuilder_ == null) {
        endKeyType_ = builderForValue.build();
        onChanged();
      } else {
        endClosedBuilder_.setMessage(builderForValue.build());
      }
      endKeyTypeCase_ = 3;
      return this;
    }
    /**
     * <pre>
     * If the end is closed, then the range includes all rows whose
     * first `len(end_closed)` key columns exactly match `end_closed`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue end_closed = 3;</code>
     */
    public Builder mergeEndClosed(com.google.protobuf.ListValue value) {
      if (endClosedBuilder_ == null) {
        if (endKeyTypeCase_ == 3 &&
            endKeyType_ != com.google.protobuf.ListValue.getDefaultInstance()) {
          endKeyType_ = com.google.protobuf.ListValue.newBuilder((com.google.protobuf.ListValue) endKeyType_)
              .mergeFrom(value).buildPartial();
        } else {
          endKeyType_ = value;
        }
        onChanged();
      } else {
        if (endKeyTypeCase_ == 3) {
          endClosedBuilder_.mergeFrom(value);
        }
        endClosedBuilder_.setMessage(value);
      }
      endKeyTypeCase_ = 3;
      return this;
    }
    /**
     * <pre>
     * If the end is closed, then the range includes all rows whose
     * first `len(end_closed)` key columns exactly match `end_closed`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue end_closed = 3;</code>
     */
    public Builder clearEndClosed() {
      if (endClosedBuilder_ == null) {
        if (endKeyTypeCase_ == 3) {
          endKeyTypeCase_ = 0;
          endKeyType_ = null;
          onChanged();
        }
      } else {
        if (endKeyTypeCase_ == 3) {
          endKeyTypeCase_ = 0;
          endKeyType_ = null;
        }
        endClosedBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * If the end is closed, then the range includes all rows whose
     * first `len(end_closed)` key columns exactly match `end_closed`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue end_closed = 3;</code>
     */
    public com.google.protobuf.ListValue.Builder getEndClosedBuilder() {
      return getEndClosedFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * If the end is closed, then the range includes all rows whose
     * first `len(end_closed)` key columns exactly match `end_closed`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue end_closed = 3;</code>
     */
    public com.google.protobuf.ListValueOrBuilder getEndClosedOrBuilder() {
      if ((endKeyTypeCase_ == 3) && (endClosedBuilder_ != null)) {
        return endClosedBuilder_.getMessageOrBuilder();
      } else {
        if (endKeyTypeCase_ == 3) {
          return (com.google.protobuf.ListValue) endKeyType_;
        }
        return com.google.protobuf.ListValue.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * If the end is closed, then the range includes all rows whose
     * first `len(end_closed)` key columns exactly match `end_closed`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue end_closed = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.ListValue, com.google.protobuf.ListValue.Builder, com.google.protobuf.ListValueOrBuilder> 
        getEndClosedFieldBuilder() {
      if (endClosedBuilder_ == null) {
        if (!(endKeyTypeCase_ == 3)) {
          endKeyType_ = com.google.protobuf.ListValue.getDefaultInstance();
        }
        endClosedBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.ListValue, com.google.protobuf.ListValue.Builder, com.google.protobuf.ListValueOrBuilder>(
                (com.google.protobuf.ListValue) endKeyType_,
                getParentForChildren(),
                isClean());
        endKeyType_ = null;
      }
      endKeyTypeCase_ = 3;
      onChanged();;
      return endClosedBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.ListValue, com.google.protobuf.ListValue.Builder, com.google.protobuf.ListValueOrBuilder> endOpenBuilder_;
    /**
     * <pre>
     * If the end is open, then the range excludes rows whose first
     * `len(end_open)` key columns exactly match `end_open`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue end_open = 4;</code>
     */
    public boolean hasEndOpen() {
      return endKeyTypeCase_ == 4;
    }
    /**
     * <pre>
     * If the end is open, then the range excludes rows whose first
     * `len(end_open)` key columns exactly match `end_open`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue end_open = 4;</code>
     */
    public com.google.protobuf.ListValue getEndOpen() {
      if (endOpenBuilder_ == null) {
        if (endKeyTypeCase_ == 4) {
          return (com.google.protobuf.ListValue) endKeyType_;
        }
        return com.google.protobuf.ListValue.getDefaultInstance();
      } else {
        if (endKeyTypeCase_ == 4) {
          return endOpenBuilder_.getMessage();
        }
        return com.google.protobuf.ListValue.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * If the end is open, then the range excludes rows whose first
     * `len(end_open)` key columns exactly match `end_open`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue end_open = 4;</code>
     */
    public Builder setEndOpen(com.google.protobuf.ListValue value) {
      if (endOpenBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endKeyType_ = value;
        onChanged();
      } else {
        endOpenBuilder_.setMessage(value);
      }
      endKeyTypeCase_ = 4;
      return this;
    }
    /**
     * <pre>
     * If the end is open, then the range excludes rows whose first
     * `len(end_open)` key columns exactly match `end_open`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue end_open = 4;</code>
     */
    public Builder setEndOpen(
        com.google.protobuf.ListValue.Builder builderForValue) {
      if (endOpenBuilder_ == null) {
        endKeyType_ = builderForValue.build();
        onChanged();
      } else {
        endOpenBuilder_.setMessage(builderForValue.build());
      }
      endKeyTypeCase_ = 4;
      return this;
    }
    /**
     * <pre>
     * If the end is open, then the range excludes rows whose first
     * `len(end_open)` key columns exactly match `end_open`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue end_open = 4;</code>
     */
    public Builder mergeEndOpen(com.google.protobuf.ListValue value) {
      if (endOpenBuilder_ == null) {
        if (endKeyTypeCase_ == 4 &&
            endKeyType_ != com.google.protobuf.ListValue.getDefaultInstance()) {
          endKeyType_ = com.google.protobuf.ListValue.newBuilder((com.google.protobuf.ListValue) endKeyType_)
              .mergeFrom(value).buildPartial();
        } else {
          endKeyType_ = value;
        }
        onChanged();
      } else {
        if (endKeyTypeCase_ == 4) {
          endOpenBuilder_.mergeFrom(value);
        }
        endOpenBuilder_.setMessage(value);
      }
      endKeyTypeCase_ = 4;
      return this;
    }
    /**
     * <pre>
     * If the end is open, then the range excludes rows whose first
     * `len(end_open)` key columns exactly match `end_open`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue end_open = 4;</code>
     */
    public Builder clearEndOpen() {
      if (endOpenBuilder_ == null) {
        if (endKeyTypeCase_ == 4) {
          endKeyTypeCase_ = 0;
          endKeyType_ = null;
          onChanged();
        }
      } else {
        if (endKeyTypeCase_ == 4) {
          endKeyTypeCase_ = 0;
          endKeyType_ = null;
        }
        endOpenBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * If the end is open, then the range excludes rows whose first
     * `len(end_open)` key columns exactly match `end_open`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue end_open = 4;</code>
     */
    public com.google.protobuf.ListValue.Builder getEndOpenBuilder() {
      return getEndOpenFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * If the end is open, then the range excludes rows whose first
     * `len(end_open)` key columns exactly match `end_open`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue end_open = 4;</code>
     */
    public com.google.protobuf.ListValueOrBuilder getEndOpenOrBuilder() {
      if ((endKeyTypeCase_ == 4) && (endOpenBuilder_ != null)) {
        return endOpenBuilder_.getMessageOrBuilder();
      } else {
        if (endKeyTypeCase_ == 4) {
          return (com.google.protobuf.ListValue) endKeyType_;
        }
        return com.google.protobuf.ListValue.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * If the end is open, then the range excludes rows whose first
     * `len(end_open)` key columns exactly match `end_open`.
     * </pre>
     *
     * <code>.google.protobuf.ListValue end_open = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.ListValue, com.google.protobuf.ListValue.Builder, com.google.protobuf.ListValueOrBuilder> 
        getEndOpenFieldBuilder() {
      if (endOpenBuilder_ == null) {
        if (!(endKeyTypeCase_ == 4)) {
          endKeyType_ = com.google.protobuf.ListValue.getDefaultInstance();
        }
        endOpenBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.ListValue, com.google.protobuf.ListValue.Builder, com.google.protobuf.ListValueOrBuilder>(
                (com.google.protobuf.ListValue) endKeyType_,
                getParentForChildren(),
                isClean());
        endKeyType_ = null;
      }
      endKeyTypeCase_ = 4;
      onChanged();;
      return endOpenBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.spanner.v1.KeyRange)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.v1.KeyRange)
  private static final com.google.spanner.v1.KeyRange DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.spanner.v1.KeyRange();
  }

  public static com.google.spanner.v1.KeyRange getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<KeyRange>
      PARSER = new com.google.protobuf.AbstractParser<KeyRange>() {
    public KeyRange parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
        return new KeyRange(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<KeyRange> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<KeyRange> getParserForType() {
    return PARSER;
  }

  public com.google.spanner.v1.KeyRange getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

