/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-09-26 19:19:48 UTC)
 * on 2017-09-29 at 23:23:20 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.cloudkms.v1.model;

/**
 * A CryptoKeyVersion represents an individual cryptographic key, and the associated key material.
 *
 * It can be used for cryptographic operations either directly, or via its parent CryptoKey, in
 * which case the server will choose the appropriate version for the operation.
 *
 * For security reasons, the raw cryptographic key material represented by a CryptoKeyVersion can
 * never be viewed or exported. It can only be used to encrypt or decrypt data when an authorized
 * user or application invokes Cloud KMS.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Key Management Service (KMS) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CryptoKeyVersion extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The time at which this CryptoKeyVersion was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * Output only. The time this CryptoKeyVersion's key material was destroyed. Only present if state
   * is DESTROYED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String destroyEventTime;

  /**
   * Output only. The time this CryptoKeyVersion's key material is scheduled for destruction. Only
   * present if state is DESTROY_SCHEDULED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String destroyTime;

  /**
   * Output only. The resource name for this CryptoKeyVersion in the format
   * `projects/locations/keyRings/cryptoKeys/cryptoKeyVersions`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The current state of the CryptoKeyVersion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Output only. The time at which this CryptoKeyVersion was created.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. The time at which this CryptoKeyVersion was created.
   * @param createTime createTime or {@code null} for none
   */
  public CryptoKeyVersion setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * Output only. The time this CryptoKeyVersion's key material was destroyed. Only present if state
   * is DESTROYED.
   * @return value or {@code null} for none
   */
  public String getDestroyEventTime() {
    return destroyEventTime;
  }

  /**
   * Output only. The time this CryptoKeyVersion's key material was destroyed. Only present if state
   * is DESTROYED.
   * @param destroyEventTime destroyEventTime or {@code null} for none
   */
  public CryptoKeyVersion setDestroyEventTime(String destroyEventTime) {
    this.destroyEventTime = destroyEventTime;
    return this;
  }

  /**
   * Output only. The time this CryptoKeyVersion's key material is scheduled for destruction. Only
   * present if state is DESTROY_SCHEDULED.
   * @return value or {@code null} for none
   */
  public String getDestroyTime() {
    return destroyTime;
  }

  /**
   * Output only. The time this CryptoKeyVersion's key material is scheduled for destruction. Only
   * present if state is DESTROY_SCHEDULED.
   * @param destroyTime destroyTime or {@code null} for none
   */
  public CryptoKeyVersion setDestroyTime(String destroyTime) {
    this.destroyTime = destroyTime;
    return this;
  }

  /**
   * Output only. The resource name for this CryptoKeyVersion in the format
   * `projects/locations/keyRings/cryptoKeys/cryptoKeyVersions`.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. The resource name for this CryptoKeyVersion in the format
   * `projects/locations/keyRings/cryptoKeys/cryptoKeyVersions`.
   * @param name name or {@code null} for none
   */
  public CryptoKeyVersion setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The current state of the CryptoKeyVersion.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * The current state of the CryptoKeyVersion.
   * @param state state or {@code null} for none
   */
  public CryptoKeyVersion setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  @Override
  public CryptoKeyVersion set(String fieldName, Object value) {
    return (CryptoKeyVersion) super.set(fieldName, value);
  }

  @Override
  public CryptoKeyVersion clone() {
    return (CryptoKeyVersion) super.clone();
  }

}
