/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-09-26 19:19:48 UTC)
 * on 2017-09-29 at 23:23:20 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.cloudkms.v1.model;

/**
 * Request message for KeyManagementService.Encrypt.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Key Management Service (KMS) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EncryptRequest extends com.google.api.client.json.GenericJson {

  /**
   * Optional data that, if specified, must also be provided during decryption through
   * DecryptRequest.additional_authenticated_data.  Must be no larger than 64KiB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String additionalAuthenticatedData;

  /**
   * Required. The data to encrypt. Must be no larger than 64KiB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String plaintext;

  /**
   * Optional data that, if specified, must also be provided during decryption through
   * DecryptRequest.additional_authenticated_data.  Must be no larger than 64KiB.
   * @see #decodeAdditionalAuthenticatedData()
   * @return value or {@code null} for none
   */
  public java.lang.String getAdditionalAuthenticatedData() {
    return additionalAuthenticatedData;
  }

  /**
   * Optional data that, if specified, must also be provided during decryption through
   * DecryptRequest.additional_authenticated_data.  Must be no larger than 64KiB.
   * @see #getAdditionalAuthenticatedData()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeAdditionalAuthenticatedData() {
    return com.google.api.client.util.Base64.decodeBase64(additionalAuthenticatedData);
  }

  /**
   * Optional data that, if specified, must also be provided during decryption through
   * DecryptRequest.additional_authenticated_data.  Must be no larger than 64KiB.
   * @see #encodeAdditionalAuthenticatedData()
   * @param additionalAuthenticatedData additionalAuthenticatedData or {@code null} for none
   */
  public EncryptRequest setAdditionalAuthenticatedData(java.lang.String additionalAuthenticatedData) {
    this.additionalAuthenticatedData = additionalAuthenticatedData;
    return this;
  }

  /**
   * Optional data that, if specified, must also be provided during decryption through
   * DecryptRequest.additional_authenticated_data.  Must be no larger than 64KiB.
   * @see #setAdditionalAuthenticatedData()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public EncryptRequest encodeAdditionalAuthenticatedData(byte[] additionalAuthenticatedData) {
    this.additionalAuthenticatedData = com.google.api.client.util.Base64.encodeBase64URLSafeString(additionalAuthenticatedData);
    return this;
  }

  /**
   * Required. The data to encrypt. Must be no larger than 64KiB.
   * @see #decodePlaintext()
   * @return value or {@code null} for none
   */
  public java.lang.String getPlaintext() {
    return plaintext;
  }

  /**
   * Required. The data to encrypt. Must be no larger than 64KiB.
   * @see #getPlaintext()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodePlaintext() {
    return com.google.api.client.util.Base64.decodeBase64(plaintext);
  }

  /**
   * Required. The data to encrypt. Must be no larger than 64KiB.
   * @see #encodePlaintext()
   * @param plaintext plaintext or {@code null} for none
   */
  public EncryptRequest setPlaintext(java.lang.String plaintext) {
    this.plaintext = plaintext;
    return this;
  }

  /**
   * Required. The data to encrypt. Must be no larger than 64KiB.
   * @see #setPlaintext()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public EncryptRequest encodePlaintext(byte[] plaintext) {
    this.plaintext = com.google.api.client.util.Base64.encodeBase64URLSafeString(plaintext);
    return this;
  }

  @Override
  public EncryptRequest set(String fieldName, Object value) {
    return (EncryptRequest) super.set(fieldName, value);
  }

  @Override
  public EncryptRequest clone() {
    return (EncryptRequest) super.clone();
  }

}
