/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-09-26 19:19:48 UTC)
 * on 2017-09-29 at 23:23:20 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.cloudkms.v1.model;

/**
 * Response message for KeyManagementService.ListCryptoKeyVersions.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Key Management Service (KMS) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListCryptoKeyVersionsResponse extends com.google.api.client.json.GenericJson {

  /**
   * The list of CryptoKeyVersions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CryptoKeyVersion> cryptoKeyVersions;

  /**
   * A token to retrieve next page of results. Pass this value in
   * ListCryptoKeyVersionsRequest.page_token to retrieve the next page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The total number of CryptoKeyVersions that matched the query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer totalSize;

  /**
   * The list of CryptoKeyVersions.
   * @return value or {@code null} for none
   */
  public java.util.List<CryptoKeyVersion> getCryptoKeyVersions() {
    return cryptoKeyVersions;
  }

  /**
   * The list of CryptoKeyVersions.
   * @param cryptoKeyVersions cryptoKeyVersions or {@code null} for none
   */
  public ListCryptoKeyVersionsResponse setCryptoKeyVersions(java.util.List<CryptoKeyVersion> cryptoKeyVersions) {
    this.cryptoKeyVersions = cryptoKeyVersions;
    return this;
  }

  /**
   * A token to retrieve next page of results. Pass this value in
   * ListCryptoKeyVersionsRequest.page_token to retrieve the next page of results.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * A token to retrieve next page of results. Pass this value in
   * ListCryptoKeyVersionsRequest.page_token to retrieve the next page of results.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListCryptoKeyVersionsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * The total number of CryptoKeyVersions that matched the query.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTotalSize() {
    return totalSize;
  }

  /**
   * The total number of CryptoKeyVersions that matched the query.
   * @param totalSize totalSize or {@code null} for none
   */
  public ListCryptoKeyVersionsResponse setTotalSize(java.lang.Integer totalSize) {
    this.totalSize = totalSize;
    return this;
  }

  @Override
  public ListCryptoKeyVersionsResponse set(String fieldName, Object value) {
    return (ListCryptoKeyVersionsResponse) super.set(fieldName, value);
  }

  @Override
  public ListCryptoKeyVersionsResponse clone() {
    return (ListCryptoKeyVersionsResponse) super.clone();
  }

}
