/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-01-08 17:48:37 UTC)
 * on 2016-01-13 at 22:10:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.cloudresourcemanager;

/**
 * Service definition for Cloudresourcemanager (v1beta1).
 *
 * <p>
 * The Google Cloud Resource Manager API provides methods for creating, reading, and updating project metadata.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/resource-manager" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link CloudresourcemanagerRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Cloudresourcemanager extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.21.0 of the Google Cloud Resource Manager API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://cloudresourcemanager.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Cloudresourcemanager(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Cloudresourcemanager(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Organizations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Cloudresourcemanager cloudresourcemanager = new Cloudresourcemanager(...);}
   *   {@code Cloudresourcemanager.Organizations.List request = cloudresourcemanager.organizations().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Organizations organizations() {
    return new Organizations();
  }

  /**
   * The "organizations" collection of methods.
   */
  public class Organizations {

    /**
     * Fetches an Organization resource identified by the specified `organization_id`.
     *
     * Create a request for the method "organizations.get".
     *
     * This request holds the parameters needed by the cloudresourcemanager server.  After setting any
     * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param organizationId The id of the Organization resource to fetch.
     * @return the request
     */
    public Get get(java.lang.String organizationId) throws java.io.IOException {
      Get result = new Get(organizationId);
      initialize(result);
      return result;
    }

    public class Get extends CloudresourcemanagerRequest<com.google.api.services.cloudresourcemanager.model.Organization> {

      private static final String REST_PATH = "v1beta1/organizations/{organizationId}";

      /**
       * Fetches an Organization resource identified by the specified `organization_id`.
       *
       * Create a request for the method "organizations.get".
       *
       * This request holds the parameters needed by the the cloudresourcemanager server.  After setting
       * any optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       * <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param organizationId The id of the Organization resource to fetch.
       * @since 1.13
       */
      protected Get(java.lang.String organizationId) {
        super(Cloudresourcemanager.this, "GET", REST_PATH, null, com.google.api.services.cloudresourcemanager.model.Organization.class);
        this.organizationId = com.google.api.client.util.Preconditions.checkNotNull(organizationId, "Required parameter organizationId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setBearerToken(java.lang.String bearerToken) {
        return (Get) super.setBearerToken(bearerToken);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPp(java.lang.Boolean pp) {
        return (Get) super.setPp(pp);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** The id of the Organization resource to fetch. */
      @com.google.api.client.util.Key
      private java.lang.String organizationId;

      /** The id of the Organization resource to fetch.
       */
      public java.lang.String getOrganizationId() {
        return organizationId;
      }

      /** The id of the Organization resource to fetch. */
      public Get setOrganizationId(java.lang.String organizationId) {
        this.organizationId = organizationId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Gets the access control policy for an Organization resource. May be empty if no such policy or
     * resource exists.
     *
     * Create a request for the method "organizations.getIamPolicy".
     *
     * This request holds the parameters needed by the cloudresourcemanager server.  After setting any
     * optional parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote
     * operation.
     *
     * @param resource REQUIRED: The resource for which the policy is being requested. `resource` is usually specified as a
     *        path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path specified in
     *        this value is resource specific and is specified in the `getIamPolicy` documentation.
     * @param content the {@link com.google.api.services.cloudresourcemanager.model.GetIamPolicyRequest}
     * @return the request
     */
    public GetIamPolicy getIamPolicy(java.lang.String resource, com.google.api.services.cloudresourcemanager.model.GetIamPolicyRequest content) throws java.io.IOException {
      GetIamPolicy result = new GetIamPolicy(resource, content);
      initialize(result);
      return result;
    }

    public class GetIamPolicy extends CloudresourcemanagerRequest<com.google.api.services.cloudresourcemanager.model.Policy> {

      private static final String REST_PATH = "v1beta1/organizations/{resource}:getIamPolicy";

      /**
       * Gets the access control policy for an Organization resource. May be empty if no such policy or
       * resource exists.
       *
       * Create a request for the method "organizations.getIamPolicy".
       *
       * This request holds the parameters needed by the the cloudresourcemanager server.  After setting
       * any optional parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote
       * operation. <p> {@link
       * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resource REQUIRED: The resource for which the policy is being requested. `resource` is usually specified as a
     *        path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path specified in
     *        this value is resource specific and is specified in the `getIamPolicy` documentation.
       * @param content the {@link com.google.api.services.cloudresourcemanager.model.GetIamPolicyRequest}
       * @since 1.13
       */
      protected GetIamPolicy(java.lang.String resource, com.google.api.services.cloudresourcemanager.model.GetIamPolicyRequest content) {
        super(Cloudresourcemanager.this, "POST", REST_PATH, content, com.google.api.services.cloudresourcemanager.model.Policy.class);
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
      }

      @Override
      public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
        return (GetIamPolicy) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetIamPolicy setAccessToken(java.lang.String accessToken) {
        return (GetIamPolicy) super.setAccessToken(accessToken);
      }

      @Override
      public GetIamPolicy setAlt(java.lang.String alt) {
        return (GetIamPolicy) super.setAlt(alt);
      }

      @Override
      public GetIamPolicy setBearerToken(java.lang.String bearerToken) {
        return (GetIamPolicy) super.setBearerToken(bearerToken);
      }

      @Override
      public GetIamPolicy setCallback(java.lang.String callback) {
        return (GetIamPolicy) super.setCallback(callback);
      }

      @Override
      public GetIamPolicy setFields(java.lang.String fields) {
        return (GetIamPolicy) super.setFields(fields);
      }

      @Override
      public GetIamPolicy setKey(java.lang.String key) {
        return (GetIamPolicy) super.setKey(key);
      }

      @Override
      public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
        return (GetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public GetIamPolicy setPp(java.lang.Boolean pp) {
        return (GetIamPolicy) super.setPp(pp);
      }

      @Override
      public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
        return (GetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetIamPolicy setUploadType(java.lang.String uploadType) {
        return (GetIamPolicy) super.setUploadType(uploadType);
      }

      @Override
      public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * REQUIRED: The resource for which the policy is being requested. `resource` is usually
       * specified as a path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path
       * specified in this value is resource specific and is specified in the `getIamPolicy`
       * documentation.
       */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** REQUIRED: The resource for which the policy is being requested. `resource` is usually specified as
     a path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path specified in this
     value is resource specific and is specified in the `getIamPolicy` documentation.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /**
       * REQUIRED: The resource for which the policy is being requested. `resource` is usually
       * specified as a path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path
       * specified in this value is resource specific and is specified in the `getIamPolicy`
       * documentation.
       */
      public GetIamPolicy setResource(java.lang.String resource) {
        this.resource = resource;
        return this;
      }

      @Override
      public GetIamPolicy set(String parameterName, Object value) {
        return (GetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Lists Organization resources that are visible to the user and satisfy the specified filter. This
     * method returns Organizations in an unspecified order. New Organizations do not necessarily appear
     * at the end of the list.
     *
     * Create a request for the method "organizations.list".
     *
     * This request holds the parameters needed by the cloudresourcemanager server.  After setting any
     * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends CloudresourcemanagerRequest<com.google.api.services.cloudresourcemanager.model.ListOrganizationsResponse> {

      private static final String REST_PATH = "v1beta1/organizations";

      /**
       * Lists Organization resources that are visible to the user and satisfy the specified filter.
       * This method returns Organizations in an unspecified order. New Organizations do not necessarily
       * appear at the end of the list.
       *
       * Create a request for the method "organizations.list".
       *
       * This request holds the parameters needed by the the cloudresourcemanager server.  After setting
       * any optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       * <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Cloudresourcemanager.this, "GET", REST_PATH, null, com.google.api.services.cloudresourcemanager.model.ListOrganizationsResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setBearerToken(java.lang.String bearerToken) {
        return (List) super.setBearerToken(bearerToken);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPp(java.lang.Boolean pp) {
        return (List) super.setPp(pp);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * An optional query string used to filter the Organizations to return in the response. Filter
       * rules are case-insensitive. Organizations may be filtered by `owner.directoryCustomerId` or
       * by `domain`, where the domain is a Google for Work domain, for example:
       * |Filter|Description| |------|-----------|
       * |owner.directorycustomerid:123456789|Organizations with `owner.directory_customer_id` equal
       * to `123456789`.| |domain:google.com|Organizations corresponding to the domain
       * `google.com`.| This field is optional.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** An optional query string used to filter the Organizations to return in the response. Filter rules
     are case-insensitive. Organizations may be filtered by `owner.directoryCustomerId` or by `domain`,
     where the domain is a Google for Work domain, for example: |Filter|Description|
     |------|-----------| |owner.directorycustomerid:123456789|Organizations with
     `owner.directory_customer_id` equal to `123456789`.| |domain:google.com|Organizations corresponding
     to the domain `google.com`.| This field is optional.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * An optional query string used to filter the Organizations to return in the response. Filter
       * rules are case-insensitive. Organizations may be filtered by `owner.directoryCustomerId` or
       * by `domain`, where the domain is a Google for Work domain, for example:
       * |Filter|Description| |------|-----------|
       * |owner.directorycustomerid:123456789|Organizations with `owner.directory_customer_id` equal
       * to `123456789`.| |domain:google.com|Organizations corresponding to the domain
       * `google.com`.| This field is optional.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * A pagination token returned from a previous call to `ListOrganizations` that indicates from
       * where listing should continue. This field is optional.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** A pagination token returned from a previous call to `ListOrganizations` that indicates from where
     listing should continue. This field is optional.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * A pagination token returned from a previous call to `ListOrganizations` that indicates from
       * where listing should continue. This field is optional.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** The maximum number of Organizations to return in the response. This field is optional. */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of Organizations to return in the response. This field is optional.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /** The maximum number of Organizations to return in the response. This field is optional. */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Sets the access control policy on an Organization resource. Replaces any existing policy.
     *
     * Create a request for the method "organizations.setIamPolicy".
     *
     * This request holds the parameters needed by the cloudresourcemanager server.  After setting any
     * optional parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote
     * operation.
     *
     * @param resource REQUIRED: The resource for which the policy is being specified. `resource` is usually specified as a
     *        path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path specified in
     *        this value is resource specific and is specified in the `setIamPolicy` documentation.
     * @param content the {@link com.google.api.services.cloudresourcemanager.model.SetIamPolicyRequest}
     * @return the request
     */
    public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.cloudresourcemanager.model.SetIamPolicyRequest content) throws java.io.IOException {
      SetIamPolicy result = new SetIamPolicy(resource, content);
      initialize(result);
      return result;
    }

    public class SetIamPolicy extends CloudresourcemanagerRequest<com.google.api.services.cloudresourcemanager.model.Policy> {

      private static final String REST_PATH = "v1beta1/organizations/{resource}:setIamPolicy";

      /**
       * Sets the access control policy on an Organization resource. Replaces any existing policy.
       *
       * Create a request for the method "organizations.setIamPolicy".
       *
       * This request holds the parameters needed by the the cloudresourcemanager server.  After setting
       * any optional parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote
       * operation. <p> {@link
       * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resource REQUIRED: The resource for which the policy is being specified. `resource` is usually specified as a
     *        path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path specified in
     *        this value is resource specific and is specified in the `setIamPolicy` documentation.
       * @param content the {@link com.google.api.services.cloudresourcemanager.model.SetIamPolicyRequest}
       * @since 1.13
       */
      protected SetIamPolicy(java.lang.String resource, com.google.api.services.cloudresourcemanager.model.SetIamPolicyRequest content) {
        super(Cloudresourcemanager.this, "POST", REST_PATH, content, com.google.api.services.cloudresourcemanager.model.Policy.class);
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
      }

      @Override
      public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
        return (SetIamPolicy) super.set$Xgafv($Xgafv);
      }

      @Override
      public SetIamPolicy setAccessToken(java.lang.String accessToken) {
        return (SetIamPolicy) super.setAccessToken(accessToken);
      }

      @Override
      public SetIamPolicy setAlt(java.lang.String alt) {
        return (SetIamPolicy) super.setAlt(alt);
      }

      @Override
      public SetIamPolicy setBearerToken(java.lang.String bearerToken) {
        return (SetIamPolicy) super.setBearerToken(bearerToken);
      }

      @Override
      public SetIamPolicy setCallback(java.lang.String callback) {
        return (SetIamPolicy) super.setCallback(callback);
      }

      @Override
      public SetIamPolicy setFields(java.lang.String fields) {
        return (SetIamPolicy) super.setFields(fields);
      }

      @Override
      public SetIamPolicy setKey(java.lang.String key) {
        return (SetIamPolicy) super.setKey(key);
      }

      @Override
      public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
        return (SetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public SetIamPolicy setPp(java.lang.Boolean pp) {
        return (SetIamPolicy) super.setPp(pp);
      }

      @Override
      public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
        return (SetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetIamPolicy setUploadType(java.lang.String uploadType) {
        return (SetIamPolicy) super.setUploadType(uploadType);
      }

      @Override
      public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
        return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * REQUIRED: The resource for which the policy is being specified. `resource` is usually
       * specified as a path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path
       * specified in this value is resource specific and is specified in the `setIamPolicy`
       * documentation.
       */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** REQUIRED: The resource for which the policy is being specified. `resource` is usually specified as
     a path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path specified in this
     value is resource specific and is specified in the `setIamPolicy` documentation.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /**
       * REQUIRED: The resource for which the policy is being specified. `resource` is usually
       * specified as a path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path
       * specified in this value is resource specific and is specified in the `setIamPolicy`
       * documentation.
       */
      public SetIamPolicy setResource(java.lang.String resource) {
        this.resource = resource;
        return this;
      }

      @Override
      public SetIamPolicy set(String parameterName, Object value) {
        return (SetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Returns permissions that a caller has on the specified Organization.
     *
     * Create a request for the method "organizations.testIamPermissions".
     *
     * This request holds the parameters needed by the cloudresourcemanager server.  After setting any
     * optional parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
     * operation.
     *
     * @param resource REQUIRED: The resource for which the policy detail is being requested. `resource` is usually
     *        specified as a path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path
     *        specified in this value is resource specific and is specified in the `testIamPermissions`
     *        documentation.
     * @param content the {@link com.google.api.services.cloudresourcemanager.model.TestIamPermissionsRequest}
     * @return the request
     */
    public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.cloudresourcemanager.model.TestIamPermissionsRequest content) throws java.io.IOException {
      TestIamPermissions result = new TestIamPermissions(resource, content);
      initialize(result);
      return result;
    }

    public class TestIamPermissions extends CloudresourcemanagerRequest<com.google.api.services.cloudresourcemanager.model.TestIamPermissionsResponse> {

      private static final String REST_PATH = "v1beta1/organizations/{resource}:testIamPermissions";

      /**
       * Returns permissions that a caller has on the specified Organization.
       *
       * Create a request for the method "organizations.testIamPermissions".
       *
       * This request holds the parameters needed by the the cloudresourcemanager server.  After setting
       * any optional parameters, call the {@link TestIamPermissions#execute()} method to invoke the
       * remote operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.ser
       * vices.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
       * after invoking the constructor. </p>
       *
       * @param resource REQUIRED: The resource for which the policy detail is being requested. `resource` is usually
     *        specified as a path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path
     *        specified in this value is resource specific and is specified in the `testIamPermissions`
     *        documentation.
       * @param content the {@link com.google.api.services.cloudresourcemanager.model.TestIamPermissionsRequest}
       * @since 1.13
       */
      protected TestIamPermissions(java.lang.String resource, com.google.api.services.cloudresourcemanager.model.TestIamPermissionsRequest content) {
        super(Cloudresourcemanager.this, "POST", REST_PATH, content, com.google.api.services.cloudresourcemanager.model.TestIamPermissionsResponse.class);
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
      }

      @Override
      public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
        return (TestIamPermissions) super.set$Xgafv($Xgafv);
      }

      @Override
      public TestIamPermissions setAccessToken(java.lang.String accessToken) {
        return (TestIamPermissions) super.setAccessToken(accessToken);
      }

      @Override
      public TestIamPermissions setAlt(java.lang.String alt) {
        return (TestIamPermissions) super.setAlt(alt);
      }

      @Override
      public TestIamPermissions setBearerToken(java.lang.String bearerToken) {
        return (TestIamPermissions) super.setBearerToken(bearerToken);
      }

      @Override
      public TestIamPermissions setCallback(java.lang.String callback) {
        return (TestIamPermissions) super.setCallback(callback);
      }

      @Override
      public TestIamPermissions setFields(java.lang.String fields) {
        return (TestIamPermissions) super.setFields(fields);
      }

      @Override
      public TestIamPermissions setKey(java.lang.String key) {
        return (TestIamPermissions) super.setKey(key);
      }

      @Override
      public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
        return (TestIamPermissions) super.setOauthToken(oauthToken);
      }

      @Override
      public TestIamPermissions setPp(java.lang.Boolean pp) {
        return (TestIamPermissions) super.setPp(pp);
      }

      @Override
      public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
        return (TestIamPermissions) super.setQuotaUser(quotaUser);
      }

      @Override
      public TestIamPermissions setUploadType(java.lang.String uploadType) {
        return (TestIamPermissions) super.setUploadType(uploadType);
      }

      @Override
      public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
        return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * REQUIRED: The resource for which the policy detail is being requested. `resource` is
       * usually specified as a path, such as `projectsprojectzoneszonedisksdisk*`. The format for
       * the path specified in this value is resource specific and is specified in the
       * `testIamPermissions` documentation.
       */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** REQUIRED: The resource for which the policy detail is being requested. `resource` is usually
     specified as a path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path
     specified in this value is resource specific and is specified in the `testIamPermissions`
     documentation.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /**
       * REQUIRED: The resource for which the policy detail is being requested. `resource` is
       * usually specified as a path, such as `projectsprojectzoneszonedisksdisk*`. The format for
       * the path specified in this value is resource specific and is specified in the
       * `testIamPermissions` documentation.
       */
      public TestIamPermissions setResource(java.lang.String resource) {
        this.resource = resource;
        return this;
      }

      @Override
      public TestIamPermissions set(String parameterName, Object value) {
        return (TestIamPermissions) super.set(parameterName, value);
      }
    }
    /**
     * Updates an Organization resource identified by the specified `organization_id`.
     *
     * Create a request for the method "organizations.update".
     *
     * This request holds the parameters needed by the cloudresourcemanager server.  After setting any
     * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param organizationId An immutable id for the Organization that is assigned on creation. This should be omitted when
     *        creating a new Organization. This field is read-only.
     * @param content the {@link com.google.api.services.cloudresourcemanager.model.Organization}
     * @return the request
     */
    public Update update(java.lang.String organizationId, com.google.api.services.cloudresourcemanager.model.Organization content) throws java.io.IOException {
      Update result = new Update(organizationId, content);
      initialize(result);
      return result;
    }

    public class Update extends CloudresourcemanagerRequest<com.google.api.services.cloudresourcemanager.model.Organization> {

      private static final String REST_PATH = "v1beta1/organizations/{organizationId}";

      /**
       * Updates an Organization resource identified by the specified `organization_id`.
       *
       * Create a request for the method "organizations.update".
       *
       * This request holds the parameters needed by the the cloudresourcemanager server.  After setting
       * any optional parameters, call the {@link Update#execute()} method to invoke the remote
       * operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param organizationId An immutable id for the Organization that is assigned on creation. This should be omitted when
     *        creating a new Organization. This field is read-only.
       * @param content the {@link com.google.api.services.cloudresourcemanager.model.Organization}
       * @since 1.13
       */
      protected Update(java.lang.String organizationId, com.google.api.services.cloudresourcemanager.model.Organization content) {
        super(Cloudresourcemanager.this, "PUT", REST_PATH, content, com.google.api.services.cloudresourcemanager.model.Organization.class);
        this.organizationId = com.google.api.client.util.Preconditions.checkNotNull(organizationId, "Required parameter organizationId must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setBearerToken(java.lang.String bearerToken) {
        return (Update) super.setBearerToken(bearerToken);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPp(java.lang.Boolean pp) {
        return (Update) super.setPp(pp);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * An immutable id for the Organization that is assigned on creation. This should be omitted
       * when creating a new Organization. This field is read-only.
       */
      @com.google.api.client.util.Key
      private java.lang.String organizationId;

      /** An immutable id for the Organization that is assigned on creation. This should be omitted when
     creating a new Organization. This field is read-only.
       */
      public java.lang.String getOrganizationId() {
        return organizationId;
      }

      /**
       * An immutable id for the Organization that is assigned on creation. This should be omitted
       * when creating a new Organization. This field is read-only.
       */
      public Update setOrganizationId(java.lang.String organizationId) {
        this.organizationId = organizationId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Cloudresourcemanager cloudresourcemanager = new Cloudresourcemanager(...);}
   *   {@code Cloudresourcemanager.Projects.List request = cloudresourcemanager.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * Creates a Project resource. Initially, the Project resource is owned by its creator exclusively.
     * The creator can later grant permission to others to read or update the Project. Several APIs are
     * activated automatically for the Project, including Google Cloud Storage.
     *
     * Create a request for the method "projects.create".
     *
     * This request holds the parameters needed by the cloudresourcemanager server.  After setting any
     * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.cloudresourcemanager.model.Project}
     * @return the request
     */
    public Create create(com.google.api.services.cloudresourcemanager.model.Project content) throws java.io.IOException {
      Create result = new Create(content);
      initialize(result);
      return result;
    }

    public class Create extends CloudresourcemanagerRequest<com.google.api.services.cloudresourcemanager.model.Project> {

      private static final String REST_PATH = "v1beta1/projects";

      /**
       * Creates a Project resource. Initially, the Project resource is owned by its creator
       * exclusively. The creator can later grant permission to others to read or update the Project.
       * Several APIs are activated automatically for the Project, including Google Cloud Storage.
       *
       * Create a request for the method "projects.create".
       *
       * This request holds the parameters needed by the the cloudresourcemanager server.  After setting
       * any optional parameters, call the {@link Create#execute()} method to invoke the remote
       * operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.cloudresourcemanager.model.Project}
       * @since 1.13
       */
      protected Create(com.google.api.services.cloudresourcemanager.model.Project content) {
        super(Cloudresourcemanager.this, "POST", REST_PATH, content, com.google.api.services.cloudresourcemanager.model.Project.class);
      }

      @Override
      public Create set$Xgafv(java.lang.String $Xgafv) {
        return (Create) super.set$Xgafv($Xgafv);
      }

      @Override
      public Create setAccessToken(java.lang.String accessToken) {
        return (Create) super.setAccessToken(accessToken);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setBearerToken(java.lang.String bearerToken) {
        return (Create) super.setBearerToken(bearerToken);
      }

      @Override
      public Create setCallback(java.lang.String callback) {
        return (Create) super.setCallback(callback);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPp(java.lang.Boolean pp) {
        return (Create) super.setPp(pp);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUploadType(java.lang.String uploadType) {
        return (Create) super.setUploadType(uploadType);
      }

      @Override
      public Create setUploadProtocol(java.lang.String uploadProtocol) {
        return (Create) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Marks the Project identified by the specified `project_id` (for example, `my-project-123`) for
     * deletion. This method will only affect the Project if the following criteria are met: + The
     * Project does not have a billing account associated with it. + The Project has a lifecycle state
     * of ACTIVE. This method changes the Project's lifecycle state from ACTIVE to DELETE_REQUESTED. The
     * deletion starts at an unspecified time, at which point the lifecycle state changes to
     * DELETE_IN_PROGRESS. Until the deletion completes, you can check the lifecycle state checked by
     * retrieving the Project with GetProject, and the Project remains visible to ListProjects. However,
     * you cannot update the project. After the deletion completes, the Project is not retrievable by
     * the GetProject and ListProjects methods. The caller must have modify permissions for this
     * Project.
     *
     * Create a request for the method "projects.delete".
     *
     * This request holds the parameters needed by the cloudresourcemanager server.  After setting any
     * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param projectId The Project ID (for example, `foo-bar-123`). Required.
     * @return the request
     */
    public Delete delete(java.lang.String projectId) throws java.io.IOException {
      Delete result = new Delete(projectId);
      initialize(result);
      return result;
    }

    public class Delete extends CloudresourcemanagerRequest<com.google.api.services.cloudresourcemanager.model.Empty> {

      private static final String REST_PATH = "v1beta1/projects/{projectId}";

      /**
       * Marks the Project identified by the specified `project_id` (for example, `my-project-123`) for
       * deletion. This method will only affect the Project if the following criteria are met: + The
       * Project does not have a billing account associated with it. + The Project has a lifecycle state
       * of ACTIVE. This method changes the Project's lifecycle state from ACTIVE to DELETE_REQUESTED.
       * The deletion starts at an unspecified time, at which point the lifecycle state changes to
       * DELETE_IN_PROGRESS. Until the deletion completes, you can check the lifecycle state checked by
       * retrieving the Project with GetProject, and the Project remains visible to ListProjects.
       * However, you cannot update the project. After the deletion completes, the Project is not
       * retrievable by the GetProject and ListProjects methods. The caller must have modify permissions
       * for this Project.
       *
       * Create a request for the method "projects.delete".
       *
       * This request holds the parameters needed by the the cloudresourcemanager server.  After setting
       * any optional parameters, call the {@link Delete#execute()} method to invoke the remote
       * operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId The Project ID (for example, `foo-bar-123`). Required.
       * @since 1.13
       */
      protected Delete(java.lang.String projectId) {
        super(Cloudresourcemanager.this, "DELETE", REST_PATH, null, com.google.api.services.cloudresourcemanager.model.Empty.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setBearerToken(java.lang.String bearerToken) {
        return (Delete) super.setBearerToken(bearerToken);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPp(java.lang.Boolean pp) {
        return (Delete) super.setPp(pp);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** The Project ID (for example, `foo-bar-123`). Required. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** The Project ID (for example, `foo-bar-123`). Required.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** The Project ID (for example, `foo-bar-123`). Required. */
      public Delete setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the Project identified by the specified `project_id` (for example, `my-project-123`).
     * The caller must have read permissions for this Project.
     *
     * Create a request for the method "projects.get".
     *
     * This request holds the parameters needed by the cloudresourcemanager server.  After setting any
     * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param projectId The Project ID (for example, `my-project-123`). Required.
     * @return the request
     */
    public Get get(java.lang.String projectId) throws java.io.IOException {
      Get result = new Get(projectId);
      initialize(result);
      return result;
    }

    public class Get extends CloudresourcemanagerRequest<com.google.api.services.cloudresourcemanager.model.Project> {

      private static final String REST_PATH = "v1beta1/projects/{projectId}";

      /**
       * Retrieves the Project identified by the specified `project_id` (for example, `my-project-123`).
       * The caller must have read permissions for this Project.
       *
       * Create a request for the method "projects.get".
       *
       * This request holds the parameters needed by the the cloudresourcemanager server.  After setting
       * any optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       * <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId The Project ID (for example, `my-project-123`). Required.
       * @since 1.13
       */
      protected Get(java.lang.String projectId) {
        super(Cloudresourcemanager.this, "GET", REST_PATH, null, com.google.api.services.cloudresourcemanager.model.Project.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setBearerToken(java.lang.String bearerToken) {
        return (Get) super.setBearerToken(bearerToken);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPp(java.lang.Boolean pp) {
        return (Get) super.setPp(pp);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** The Project ID (for example, `my-project-123`). Required. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** The Project ID (for example, `my-project-123`). Required.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** The Project ID (for example, `my-project-123`). Required. */
      public Get setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Returns the IAM access control policy for the specified Project. Permission is denied if the
     * policy or the resource does not exist.
     *
     * Create a request for the method "projects.getIamPolicy".
     *
     * This request holds the parameters needed by the cloudresourcemanager server.  After setting any
     * optional parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote
     * operation.
     *
     * @param resource REQUIRED: The resource for which the policy is being requested. `resource` is usually specified as a
     *        path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path specified in
     *        this value is resource specific and is specified in the `getIamPolicy` documentation.
     * @param content the {@link com.google.api.services.cloudresourcemanager.model.GetIamPolicyRequest}
     * @return the request
     */
    public GetIamPolicy getIamPolicy(java.lang.String resource, com.google.api.services.cloudresourcemanager.model.GetIamPolicyRequest content) throws java.io.IOException {
      GetIamPolicy result = new GetIamPolicy(resource, content);
      initialize(result);
      return result;
    }

    public class GetIamPolicy extends CloudresourcemanagerRequest<com.google.api.services.cloudresourcemanager.model.Policy> {

      private static final String REST_PATH = "v1beta1/projects/{resource}:getIamPolicy";

      /**
       * Returns the IAM access control policy for the specified Project. Permission is denied if the
       * policy or the resource does not exist.
       *
       * Create a request for the method "projects.getIamPolicy".
       *
       * This request holds the parameters needed by the the cloudresourcemanager server.  After setting
       * any optional parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote
       * operation. <p> {@link
       * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resource REQUIRED: The resource for which the policy is being requested. `resource` is usually specified as a
     *        path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path specified in
     *        this value is resource specific and is specified in the `getIamPolicy` documentation.
       * @param content the {@link com.google.api.services.cloudresourcemanager.model.GetIamPolicyRequest}
       * @since 1.13
       */
      protected GetIamPolicy(java.lang.String resource, com.google.api.services.cloudresourcemanager.model.GetIamPolicyRequest content) {
        super(Cloudresourcemanager.this, "POST", REST_PATH, content, com.google.api.services.cloudresourcemanager.model.Policy.class);
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
      }

      @Override
      public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
        return (GetIamPolicy) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetIamPolicy setAccessToken(java.lang.String accessToken) {
        return (GetIamPolicy) super.setAccessToken(accessToken);
      }

      @Override
      public GetIamPolicy setAlt(java.lang.String alt) {
        return (GetIamPolicy) super.setAlt(alt);
      }

      @Override
      public GetIamPolicy setBearerToken(java.lang.String bearerToken) {
        return (GetIamPolicy) super.setBearerToken(bearerToken);
      }

      @Override
      public GetIamPolicy setCallback(java.lang.String callback) {
        return (GetIamPolicy) super.setCallback(callback);
      }

      @Override
      public GetIamPolicy setFields(java.lang.String fields) {
        return (GetIamPolicy) super.setFields(fields);
      }

      @Override
      public GetIamPolicy setKey(java.lang.String key) {
        return (GetIamPolicy) super.setKey(key);
      }

      @Override
      public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
        return (GetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public GetIamPolicy setPp(java.lang.Boolean pp) {
        return (GetIamPolicy) super.setPp(pp);
      }

      @Override
      public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
        return (GetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetIamPolicy setUploadType(java.lang.String uploadType) {
        return (GetIamPolicy) super.setUploadType(uploadType);
      }

      @Override
      public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * REQUIRED: The resource for which the policy is being requested. `resource` is usually
       * specified as a path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path
       * specified in this value is resource specific and is specified in the `getIamPolicy`
       * documentation.
       */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** REQUIRED: The resource for which the policy is being requested. `resource` is usually specified as
     a path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path specified in this
     value is resource specific and is specified in the `getIamPolicy` documentation.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /**
       * REQUIRED: The resource for which the policy is being requested. `resource` is usually
       * specified as a path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path
       * specified in this value is resource specific and is specified in the `getIamPolicy`
       * documentation.
       */
      public GetIamPolicy setResource(java.lang.String resource) {
        this.resource = resource;
        return this;
      }

      @Override
      public GetIamPolicy set(String parameterName, Object value) {
        return (GetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Lists Projects that are visible to the user and satisfy the specified filter. This method returns
     * Projects in an unspecified order. New Projects do not necessarily appear at the end of the list.
     *
     * Create a request for the method "projects.list".
     *
     * This request holds the parameters needed by the cloudresourcemanager server.  After setting any
     * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends CloudresourcemanagerRequest<com.google.api.services.cloudresourcemanager.model.ListProjectsResponse> {

      private static final String REST_PATH = "v1beta1/projects";

      /**
       * Lists Projects that are visible to the user and satisfy the specified filter. This method
       * returns Projects in an unspecified order. New Projects do not necessarily appear at the end of
       * the list.
       *
       * Create a request for the method "projects.list".
       *
       * This request holds the parameters needed by the the cloudresourcemanager server.  After setting
       * any optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       * <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Cloudresourcemanager.this, "GET", REST_PATH, null, com.google.api.services.cloudresourcemanager.model.ListProjectsResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setBearerToken(java.lang.String bearerToken) {
        return (List) super.setBearerToken(bearerToken);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPp(java.lang.Boolean pp) {
        return (List) super.setPp(pp);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * An expression for filtering the results of the request. Filter rules are case insensitive.
       * The fields eligible for filtering are: + `name` + `id` + labels.key where *key* is the name
       * of a label Some examples of using labels as filters: |Filter|Description|
       * |------|-----------| |name:*|The project has a name.| |name:Howl|The project's name is
       * `Howl` or `howl`.| |name:HOWL|Equivalent to above.| |NAME:howl|Equivalent to above.|
       * |labels.color:*|The project has the label `color`.| |labels.color:red|The project's label
       * `color` has the value `red`.| |labels.color:red label.size:big|The project's label `color`
       * has the value `red` and its label `size` has the value `big`. Optional.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** An expression for filtering the results of the request. Filter rules are case insensitive. The
     fields eligible for filtering are: + `name` + `id` + labels.key where *key* is the name of a label
     Some examples of using labels as filters: |Filter|Description| |------|-----------| |name:*|The
     project has a name.| |name:Howl|The project's name is `Howl` or `howl`.| |name:HOWL|Equivalent to
     above.| |NAME:howl|Equivalent to above.| |labels.color:*|The project has the label `color`.|
     |labels.color:red|The project's label `color` has the value `red`.| |labels.color:red
     label.size:big|The project's label `color` has the value `red` and its label `size` has the value
     `big`. Optional.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * An expression for filtering the results of the request. Filter rules are case insensitive.
       * The fields eligible for filtering are: + `name` + `id` + labels.key where *key* is the name
       * of a label Some examples of using labels as filters: |Filter|Description|
       * |------|-----------| |name:*|The project has a name.| |name:Howl|The project's name is
       * `Howl` or `howl`.| |name:HOWL|Equivalent to above.| |NAME:howl|Equivalent to above.|
       * |labels.color:*|The project has the label `color`.| |labels.color:red|The project's label
       * `color` has the value `red`.| |labels.color:red label.size:big|The project's label `color`
       * has the value `red` and its label `size` has the value `big`. Optional.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * A pagination token returned from a previous call to ListProjects that indicates from where
       * listing should continue. Optional.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** A pagination token returned from a previous call to ListProjects that indicates from where listing
     should continue. Optional.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * A pagination token returned from a previous call to ListProjects that indicates from where
       * listing should continue. Optional.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * The maximum number of Projects to return in the response. The server can return fewer
       * Projects than requested. If unspecified, server picks an appropriate default. Optional.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of Projects to return in the response. The server can return fewer Projects than
     requested. If unspecified, server picks an appropriate default. Optional.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * The maximum number of Projects to return in the response. The server can return fewer
       * Projects than requested. If unspecified, server picks an appropriate default. Optional.
       */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Sets the IAM access control policy for the specified Project. Replaces any existing policy. The
     * following constraints apply when using `setIamPolicy()`: + Project currently supports only
     * `user:{emailid}` and `serviceAccount:{emailid}` members in a `Binding` of a `Policy`. + To be
     * added as an `owner`, a user must be invited via Cloud Platform console and must accept the
     * invitation. + Members cannot be added to more than one role in the same policy. + There must be
     * at least one owner who has accepted the Terms of Service (ToS) agreement in the policy. Calling
     * `setIamPolicy()` to to remove the last ToS-accepted owner from the policy will fail. + Calling
     * this method requires enabling the App Engine Admin API. Note: Removing service accounts from
     * policies or changing their roles can render services completely inoperable. It is important to
     * understand how the service account is being used before removing or updating its roles.
     *
     * Create a request for the method "projects.setIamPolicy".
     *
     * This request holds the parameters needed by the cloudresourcemanager server.  After setting any
     * optional parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote
     * operation.
     *
     * @param resource REQUIRED: The resource for which the policy is being specified. `resource` is usually specified as a
     *        path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path specified in
     *        this value is resource specific and is specified in the `setIamPolicy` documentation.
     * @param content the {@link com.google.api.services.cloudresourcemanager.model.SetIamPolicyRequest}
     * @return the request
     */
    public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.cloudresourcemanager.model.SetIamPolicyRequest content) throws java.io.IOException {
      SetIamPolicy result = new SetIamPolicy(resource, content);
      initialize(result);
      return result;
    }

    public class SetIamPolicy extends CloudresourcemanagerRequest<com.google.api.services.cloudresourcemanager.model.Policy> {

      private static final String REST_PATH = "v1beta1/projects/{resource}:setIamPolicy";

      /**
       * Sets the IAM access control policy for the specified Project. Replaces any existing policy. The
       * following constraints apply when using `setIamPolicy()`: + Project currently supports only
       * `user:{emailid}` and `serviceAccount:{emailid}` members in a `Binding` of a `Policy`. + To be
       * added as an `owner`, a user must be invited via Cloud Platform console and must accept the
       * invitation. + Members cannot be added to more than one role in the same policy. + There must be
       * at least one owner who has accepted the Terms of Service (ToS) agreement in the policy. Calling
       * `setIamPolicy()` to to remove the last ToS-accepted owner from the policy will fail. + Calling
       * this method requires enabling the App Engine Admin API. Note: Removing service accounts from
       * policies or changing their roles can render services completely inoperable. It is important to
       * understand how the service account is being used before removing or updating its roles.
       *
       * Create a request for the method "projects.setIamPolicy".
       *
       * This request holds the parameters needed by the the cloudresourcemanager server.  After setting
       * any optional parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote
       * operation. <p> {@link
       * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resource REQUIRED: The resource for which the policy is being specified. `resource` is usually specified as a
     *        path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path specified in
     *        this value is resource specific and is specified in the `setIamPolicy` documentation.
       * @param content the {@link com.google.api.services.cloudresourcemanager.model.SetIamPolicyRequest}
       * @since 1.13
       */
      protected SetIamPolicy(java.lang.String resource, com.google.api.services.cloudresourcemanager.model.SetIamPolicyRequest content) {
        super(Cloudresourcemanager.this, "POST", REST_PATH, content, com.google.api.services.cloudresourcemanager.model.Policy.class);
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
      }

      @Override
      public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
        return (SetIamPolicy) super.set$Xgafv($Xgafv);
      }

      @Override
      public SetIamPolicy setAccessToken(java.lang.String accessToken) {
        return (SetIamPolicy) super.setAccessToken(accessToken);
      }

      @Override
      public SetIamPolicy setAlt(java.lang.String alt) {
        return (SetIamPolicy) super.setAlt(alt);
      }

      @Override
      public SetIamPolicy setBearerToken(java.lang.String bearerToken) {
        return (SetIamPolicy) super.setBearerToken(bearerToken);
      }

      @Override
      public SetIamPolicy setCallback(java.lang.String callback) {
        return (SetIamPolicy) super.setCallback(callback);
      }

      @Override
      public SetIamPolicy setFields(java.lang.String fields) {
        return (SetIamPolicy) super.setFields(fields);
      }

      @Override
      public SetIamPolicy setKey(java.lang.String key) {
        return (SetIamPolicy) super.setKey(key);
      }

      @Override
      public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
        return (SetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public SetIamPolicy setPp(java.lang.Boolean pp) {
        return (SetIamPolicy) super.setPp(pp);
      }

      @Override
      public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
        return (SetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetIamPolicy setUploadType(java.lang.String uploadType) {
        return (SetIamPolicy) super.setUploadType(uploadType);
      }

      @Override
      public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
        return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * REQUIRED: The resource for which the policy is being specified. `resource` is usually
       * specified as a path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path
       * specified in this value is resource specific and is specified in the `setIamPolicy`
       * documentation.
       */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** REQUIRED: The resource for which the policy is being specified. `resource` is usually specified as
     a path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path specified in this
     value is resource specific and is specified in the `setIamPolicy` documentation.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /**
       * REQUIRED: The resource for which the policy is being specified. `resource` is usually
       * specified as a path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path
       * specified in this value is resource specific and is specified in the `setIamPolicy`
       * documentation.
       */
      public SetIamPolicy setResource(java.lang.String resource) {
        this.resource = resource;
        return this;
      }

      @Override
      public SetIamPolicy set(String parameterName, Object value) {
        return (SetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Returns permissions that a caller has on the specified Project.
     *
     * Create a request for the method "projects.testIamPermissions".
     *
     * This request holds the parameters needed by the cloudresourcemanager server.  After setting any
     * optional parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
     * operation.
     *
     * @param resource REQUIRED: The resource for which the policy detail is being requested. `resource` is usually
     *        specified as a path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path
     *        specified in this value is resource specific and is specified in the `testIamPermissions`
     *        documentation.
     * @param content the {@link com.google.api.services.cloudresourcemanager.model.TestIamPermissionsRequest}
     * @return the request
     */
    public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.cloudresourcemanager.model.TestIamPermissionsRequest content) throws java.io.IOException {
      TestIamPermissions result = new TestIamPermissions(resource, content);
      initialize(result);
      return result;
    }

    public class TestIamPermissions extends CloudresourcemanagerRequest<com.google.api.services.cloudresourcemanager.model.TestIamPermissionsResponse> {

      private static final String REST_PATH = "v1beta1/projects/{resource}:testIamPermissions";

      /**
       * Returns permissions that a caller has on the specified Project.
       *
       * Create a request for the method "projects.testIamPermissions".
       *
       * This request holds the parameters needed by the the cloudresourcemanager server.  After setting
       * any optional parameters, call the {@link TestIamPermissions#execute()} method to invoke the
       * remote operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.ser
       * vices.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
       * after invoking the constructor. </p>
       *
       * @param resource REQUIRED: The resource for which the policy detail is being requested. `resource` is usually
     *        specified as a path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path
     *        specified in this value is resource specific and is specified in the `testIamPermissions`
     *        documentation.
       * @param content the {@link com.google.api.services.cloudresourcemanager.model.TestIamPermissionsRequest}
       * @since 1.13
       */
      protected TestIamPermissions(java.lang.String resource, com.google.api.services.cloudresourcemanager.model.TestIamPermissionsRequest content) {
        super(Cloudresourcemanager.this, "POST", REST_PATH, content, com.google.api.services.cloudresourcemanager.model.TestIamPermissionsResponse.class);
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
      }

      @Override
      public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
        return (TestIamPermissions) super.set$Xgafv($Xgafv);
      }

      @Override
      public TestIamPermissions setAccessToken(java.lang.String accessToken) {
        return (TestIamPermissions) super.setAccessToken(accessToken);
      }

      @Override
      public TestIamPermissions setAlt(java.lang.String alt) {
        return (TestIamPermissions) super.setAlt(alt);
      }

      @Override
      public TestIamPermissions setBearerToken(java.lang.String bearerToken) {
        return (TestIamPermissions) super.setBearerToken(bearerToken);
      }

      @Override
      public TestIamPermissions setCallback(java.lang.String callback) {
        return (TestIamPermissions) super.setCallback(callback);
      }

      @Override
      public TestIamPermissions setFields(java.lang.String fields) {
        return (TestIamPermissions) super.setFields(fields);
      }

      @Override
      public TestIamPermissions setKey(java.lang.String key) {
        return (TestIamPermissions) super.setKey(key);
      }

      @Override
      public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
        return (TestIamPermissions) super.setOauthToken(oauthToken);
      }

      @Override
      public TestIamPermissions setPp(java.lang.Boolean pp) {
        return (TestIamPermissions) super.setPp(pp);
      }

      @Override
      public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
        return (TestIamPermissions) super.setQuotaUser(quotaUser);
      }

      @Override
      public TestIamPermissions setUploadType(java.lang.String uploadType) {
        return (TestIamPermissions) super.setUploadType(uploadType);
      }

      @Override
      public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
        return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * REQUIRED: The resource for which the policy detail is being requested. `resource` is
       * usually specified as a path, such as `projectsprojectzoneszonedisksdisk*`. The format for
       * the path specified in this value is resource specific and is specified in the
       * `testIamPermissions` documentation.
       */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** REQUIRED: The resource for which the policy detail is being requested. `resource` is usually
     specified as a path, such as `projectsprojectzoneszonedisksdisk*`. The format for the path
     specified in this value is resource specific and is specified in the `testIamPermissions`
     documentation.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /**
       * REQUIRED: The resource for which the policy detail is being requested. `resource` is
       * usually specified as a path, such as `projectsprojectzoneszonedisksdisk*`. The format for
       * the path specified in this value is resource specific and is specified in the
       * `testIamPermissions` documentation.
       */
      public TestIamPermissions setResource(java.lang.String resource) {
        this.resource = resource;
        return this;
      }

      @Override
      public TestIamPermissions set(String parameterName, Object value) {
        return (TestIamPermissions) super.set(parameterName, value);
      }
    }
    /**
     * Restores the Project identified by the specified `project_id` (for example, `my-project-123`).
     * You can only use this method for a Project that has a lifecycle state of DELETE_REQUESTED. After
     * deletion starts, as indicated by a lifecycle state of DELETE_IN_PROGRESS, the Project cannot be
     * restored. The caller must have modify permissions for this Project.
     *
     * Create a request for the method "projects.undelete".
     *
     * This request holds the parameters needed by the cloudresourcemanager server.  After setting any
     * optional parameters, call the {@link Undelete#execute()} method to invoke the remote operation.
     *
     * @param projectId The project ID (for example, `foo-bar-123`). Required.
     * @return the request
     */
    public Undelete undelete(java.lang.String projectId) throws java.io.IOException {
      Undelete result = new Undelete(projectId);
      initialize(result);
      return result;
    }

    public class Undelete extends CloudresourcemanagerRequest<com.google.api.services.cloudresourcemanager.model.Empty> {

      private static final String REST_PATH = "v1beta1/projects/{projectId}:undelete";

      /**
       * Restores the Project identified by the specified `project_id` (for example, `my-project-123`).
       * You can only use this method for a Project that has a lifecycle state of DELETE_REQUESTED.
       * After deletion starts, as indicated by a lifecycle state of DELETE_IN_PROGRESS, the Project
       * cannot be restored. The caller must have modify permissions for this Project.
       *
       * Create a request for the method "projects.undelete".
       *
       * This request holds the parameters needed by the the cloudresourcemanager server.  After setting
       * any optional parameters, call the {@link Undelete#execute()} method to invoke the remote
       * operation. <p> {@link
       * Undelete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId The project ID (for example, `foo-bar-123`). Required.
       * @since 1.13
       */
      protected Undelete(java.lang.String projectId) {
        super(Cloudresourcemanager.this, "POST", REST_PATH, null, com.google.api.services.cloudresourcemanager.model.Empty.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
      }

      @Override
      public Undelete set$Xgafv(java.lang.String $Xgafv) {
        return (Undelete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Undelete setAccessToken(java.lang.String accessToken) {
        return (Undelete) super.setAccessToken(accessToken);
      }

      @Override
      public Undelete setAlt(java.lang.String alt) {
        return (Undelete) super.setAlt(alt);
      }

      @Override
      public Undelete setBearerToken(java.lang.String bearerToken) {
        return (Undelete) super.setBearerToken(bearerToken);
      }

      @Override
      public Undelete setCallback(java.lang.String callback) {
        return (Undelete) super.setCallback(callback);
      }

      @Override
      public Undelete setFields(java.lang.String fields) {
        return (Undelete) super.setFields(fields);
      }

      @Override
      public Undelete setKey(java.lang.String key) {
        return (Undelete) super.setKey(key);
      }

      @Override
      public Undelete setOauthToken(java.lang.String oauthToken) {
        return (Undelete) super.setOauthToken(oauthToken);
      }

      @Override
      public Undelete setPp(java.lang.Boolean pp) {
        return (Undelete) super.setPp(pp);
      }

      @Override
      public Undelete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Undelete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Undelete setQuotaUser(java.lang.String quotaUser) {
        return (Undelete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Undelete setUploadType(java.lang.String uploadType) {
        return (Undelete) super.setUploadType(uploadType);
      }

      @Override
      public Undelete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Undelete) super.setUploadProtocol(uploadProtocol);
      }

      /** The project ID (for example, `foo-bar-123`). Required. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** The project ID (for example, `foo-bar-123`). Required.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** The project ID (for example, `foo-bar-123`). Required. */
      public Undelete setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      @Override
      public Undelete set(String parameterName, Object value) {
        return (Undelete) super.set(parameterName, value);
      }
    }
    /**
     * Updates the attributes of the Project identified by the specified `project_id` (for example, `my-
     * project-123`). The caller must have modify permissions for this Project.
     *
     * Create a request for the method "projects.update".
     *
     * This request holds the parameters needed by the cloudresourcemanager server.  After setting any
     * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param projectId The project ID (for example, `my-project-123`). Required.
     * @param content the {@link com.google.api.services.cloudresourcemanager.model.Project}
     * @return the request
     */
    public Update update(java.lang.String projectId, com.google.api.services.cloudresourcemanager.model.Project content) throws java.io.IOException {
      Update result = new Update(projectId, content);
      initialize(result);
      return result;
    }

    public class Update extends CloudresourcemanagerRequest<com.google.api.services.cloudresourcemanager.model.Project> {

      private static final String REST_PATH = "v1beta1/projects/{projectId}";

      /**
       * Updates the attributes of the Project identified by the specified `project_id` (for example,
       * `my-project-123`). The caller must have modify permissions for this Project.
       *
       * Create a request for the method "projects.update".
       *
       * This request holds the parameters needed by the the cloudresourcemanager server.  After setting
       * any optional parameters, call the {@link Update#execute()} method to invoke the remote
       * operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId The project ID (for example, `my-project-123`). Required.
       * @param content the {@link com.google.api.services.cloudresourcemanager.model.Project}
       * @since 1.13
       */
      protected Update(java.lang.String projectId, com.google.api.services.cloudresourcemanager.model.Project content) {
        super(Cloudresourcemanager.this, "PUT", REST_PATH, content, com.google.api.services.cloudresourcemanager.model.Project.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setBearerToken(java.lang.String bearerToken) {
        return (Update) super.setBearerToken(bearerToken);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPp(java.lang.Boolean pp) {
        return (Update) super.setPp(pp);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /** The project ID (for example, `my-project-123`). Required. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** The project ID (for example, `my-project-123`). Required.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** The project ID (for example, `my-project-123`). Required. */
      public Update setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Cloudresourcemanager}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link Cloudresourcemanager}. */
    @Override
    public Cloudresourcemanager build() {
      return new Cloudresourcemanager(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link CloudresourcemanagerRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setCloudresourcemanagerRequestInitializer(
        CloudresourcemanagerRequestInitializer cloudresourcemanagerRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(cloudresourcemanagerRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
