/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-01-08 17:48:37 UTC)
 * on 2016-01-13 at 22:10:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.cloudresourcemanager.model;

/**
 * The response returned from the `ListOrganizations` method.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Resource Manager API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListOrganizationsResponse extends com.google.api.client.json.GenericJson {

  /**
   * A pagination token to be used to retrieve the next page of results. If the result is too large
   * to fit within the page size specified in the request, this field will be set with a token that
   * can be used to fetch the next page of results. If this field is empty, it indicates that this
   * response contains the last page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The list of Organizations that matched the list query, possibly paginated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Organization> organizations;

  /**
   * A pagination token to be used to retrieve the next page of results. If the result is too large
   * to fit within the page size specified in the request, this field will be set with a token that
   * can be used to fetch the next page of results. If this field is empty, it indicates that this
   * response contains the last page of results.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * A pagination token to be used to retrieve the next page of results. If the result is too large
   * to fit within the page size specified in the request, this field will be set with a token that
   * can be used to fetch the next page of results. If this field is empty, it indicates that this
   * response contains the last page of results.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListOrganizationsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * The list of Organizations that matched the list query, possibly paginated.
   * @return value or {@code null} for none
   */
  public java.util.List<Organization> getOrganizations() {
    return organizations;
  }

  /**
   * The list of Organizations that matched the list query, possibly paginated.
   * @param organizations organizations or {@code null} for none
   */
  public ListOrganizationsResponse setOrganizations(java.util.List<Organization> organizations) {
    this.organizations = organizations;
    return this;
  }

  @Override
  public ListOrganizationsResponse set(String fieldName, Object value) {
    return (ListOrganizationsResponse) super.set(fieldName, value);
  }

  @Override
  public ListOrganizationsResponse clone() {
    return (ListOrganizationsResponse) super.clone();
  }

}
