/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-01-08 17:48:37 UTC)
 * on 2016-01-13 at 22:10:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.cloudresourcemanager.model;

/**
 * A container to reference an id for any resource type. A `resource` in Google Cloud Platform is a
 * generic term for something you (a developer) may want to interact with through one of our API's.
 * Some examples are an AppEngine app, a Compute Engine instance, a Cloud SQL database, and so on.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Resource Manager API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResourceId extends com.google.api.client.json.GenericJson {

  /**
   * Required field for the type-specific id. This should correspond to the id used in the type-
   * specific API's.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Required field representing the resource type this id is for. At present, the only valid type
   * is "organization".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Required field for the type-specific id. This should correspond to the id used in the type-
   * specific API's.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Required field for the type-specific id. This should correspond to the id used in the type-
   * specific API's.
   * @param id id or {@code null} for none
   */
  public ResourceId setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Required field representing the resource type this id is for. At present, the only valid type
   * is "organization".
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Required field representing the resource type this id is for. At present, the only valid type
   * is "organization".
   * @param type type or {@code null} for none
   */
  public ResourceId setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public ResourceId set(String fieldName, Object value) {
    return (ResourceId) super.set(fieldName, value);
  }

  @Override
  public ResourceId clone() {
    return (ResourceId) super.clone();
  }

}
