/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Contains output only fields. Use this sub-message for all output fields set on ResourcePolicy.
 * The internal structure of this "status" field should mimic the structure of ResourcePolicy proto
 * specification.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResourcePolicyResourceStatus extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Specifies a set of output values reffering to the instance_schedule_policy system
   * status. This field should have the same name as corresponding policy field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ResourcePolicyResourceStatusInstanceSchedulePolicyStatus instanceSchedulePolicy;

  /**
   * [Output Only] Specifies a set of output values reffering to the instance_schedule_policy system
   * status. This field should have the same name as corresponding policy field.
   * @return value or {@code null} for none
   */
  public ResourcePolicyResourceStatusInstanceSchedulePolicyStatus getInstanceSchedulePolicy() {
    return instanceSchedulePolicy;
  }

  /**
   * [Output Only] Specifies a set of output values reffering to the instance_schedule_policy system
   * status. This field should have the same name as corresponding policy field.
   * @param instanceSchedulePolicy instanceSchedulePolicy or {@code null} for none
   */
  public ResourcePolicyResourceStatus setInstanceSchedulePolicy(ResourcePolicyResourceStatusInstanceSchedulePolicyStatus instanceSchedulePolicy) {
    this.instanceSchedulePolicy = instanceSchedulePolicy;
    return this;
  }

  @Override
  public ResourcePolicyResourceStatus set(String fieldName, Object value) {
    return (ResourcePolicyResourceStatus) super.set(fieldName, value);
  }

  @Override
  public ResourcePolicyResourceStatus clone() {
    return (ResourcePolicyResourceStatus) super.clone();
  }

}
