/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for ScalingScheduleStatus.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ScalingScheduleStatus extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] The last time the scaling schedule became active. Note: this is a timestamp when
   * a schedule actually became active, not when it was planned to do so. The timestamp is in
   * RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lastStartTime;

  /**
   * [Output Only] The next time the scaling schedule is to become active. Note: this is a timestamp
   * when a schedule is planned to run, but the actual time might be slightly different. The
   * timestamp is in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextStartTime;

  /**
   * [Output Only] The current state of a scaling schedule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * [Output Only] The last time the scaling schedule became active. Note: this is a timestamp when
   * a schedule actually became active, not when it was planned to do so. The timestamp is in
   * RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getLastStartTime() {
    return lastStartTime;
  }

  /**
   * [Output Only] The last time the scaling schedule became active. Note: this is a timestamp when
   * a schedule actually became active, not when it was planned to do so. The timestamp is in
   * RFC3339 text format.
   * @param lastStartTime lastStartTime or {@code null} for none
   */
  public ScalingScheduleStatus setLastStartTime(java.lang.String lastStartTime) {
    this.lastStartTime = lastStartTime;
    return this;
  }

  /**
   * [Output Only] The next time the scaling schedule is to become active. Note: this is a timestamp
   * when a schedule is planned to run, but the actual time might be slightly different. The
   * timestamp is in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextStartTime() {
    return nextStartTime;
  }

  /**
   * [Output Only] The next time the scaling schedule is to become active. Note: this is a timestamp
   * when a schedule is planned to run, but the actual time might be slightly different. The
   * timestamp is in RFC3339 text format.
   * @param nextStartTime nextStartTime or {@code null} for none
   */
  public ScalingScheduleStatus setNextStartTime(java.lang.String nextStartTime) {
    this.nextStartTime = nextStartTime;
    return this;
  }

  /**
   * [Output Only] The current state of a scaling schedule.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * [Output Only] The current state of a scaling schedule.
   * @param state state or {@code null} for none
   */
  public ScalingScheduleStatus setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  @Override
  public ScalingScheduleStatus set(String fieldName, Object value) {
    return (ScalingScheduleStatus) super.set(fieldName, value);
  }

  @Override
  public ScalingScheduleStatus clone() {
    return (ScalingScheduleStatus) super.clone();
  }

}
