/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * This message defines settings for a consistent hash style load balancer.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ConsistentHashLoadBalancerSettings extends com.google.api.client.json.GenericJson {

  /**
   * Hash is based on HTTP Cookie. This field describes a HTTP cookie that will be used as the hash
   * key for the consistent hash load balancer. If the cookie is not present, it will be generated.
   * This field is applicable if the sessionAffinity is set to HTTP_COOKIE. Not supported when the
   * backend service is referenced by a URL map that is bound to target gRPC proxy that has
   * validateForProxyless field set to true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ConsistentHashLoadBalancerSettingsHttpCookie httpCookie;

  /**
   * The hash based on the value of the specified header field. This field is applicable if the
   * sessionAffinity is set to HEADER_FIELD.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String httpHeaderName;

  /**
   * The minimum number of virtual nodes to use for the hash ring. Defaults to 1024. Larger ring
   * sizes result in more granular load distributions. If the number of hosts in the load balancing
   * pool is larger than the ring size, each host will be assigned a single virtual node.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long minimumRingSize;

  /**
   * Hash is based on HTTP Cookie. This field describes a HTTP cookie that will be used as the hash
   * key for the consistent hash load balancer. If the cookie is not present, it will be generated.
   * This field is applicable if the sessionAffinity is set to HTTP_COOKIE. Not supported when the
   * backend service is referenced by a URL map that is bound to target gRPC proxy that has
   * validateForProxyless field set to true.
   * @return value or {@code null} for none
   */
  public ConsistentHashLoadBalancerSettingsHttpCookie getHttpCookie() {
    return httpCookie;
  }

  /**
   * Hash is based on HTTP Cookie. This field describes a HTTP cookie that will be used as the hash
   * key for the consistent hash load balancer. If the cookie is not present, it will be generated.
   * This field is applicable if the sessionAffinity is set to HTTP_COOKIE. Not supported when the
   * backend service is referenced by a URL map that is bound to target gRPC proxy that has
   * validateForProxyless field set to true.
   * @param httpCookie httpCookie or {@code null} for none
   */
  public ConsistentHashLoadBalancerSettings setHttpCookie(ConsistentHashLoadBalancerSettingsHttpCookie httpCookie) {
    this.httpCookie = httpCookie;
    return this;
  }

  /**
   * The hash based on the value of the specified header field. This field is applicable if the
   * sessionAffinity is set to HEADER_FIELD.
   * @return value or {@code null} for none
   */
  public java.lang.String getHttpHeaderName() {
    return httpHeaderName;
  }

  /**
   * The hash based on the value of the specified header field. This field is applicable if the
   * sessionAffinity is set to HEADER_FIELD.
   * @param httpHeaderName httpHeaderName or {@code null} for none
   */
  public ConsistentHashLoadBalancerSettings setHttpHeaderName(java.lang.String httpHeaderName) {
    this.httpHeaderName = httpHeaderName;
    return this;
  }

  /**
   * The minimum number of virtual nodes to use for the hash ring. Defaults to 1024. Larger ring
   * sizes result in more granular load distributions. If the number of hosts in the load balancing
   * pool is larger than the ring size, each host will be assigned a single virtual node.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMinimumRingSize() {
    return minimumRingSize;
  }

  /**
   * The minimum number of virtual nodes to use for the hash ring. Defaults to 1024. Larger ring
   * sizes result in more granular load distributions. If the number of hosts in the load balancing
   * pool is larger than the ring size, each host will be assigned a single virtual node.
   * @param minimumRingSize minimumRingSize or {@code null} for none
   */
  public ConsistentHashLoadBalancerSettings setMinimumRingSize(java.lang.Long minimumRingSize) {
    this.minimumRingSize = minimumRingSize;
    return this;
  }

  @Override
  public ConsistentHashLoadBalancerSettings set(String fieldName, Object value) {
    return (ConsistentHashLoadBalancerSettings) super.set(fieldName, value);
  }

  @Override
  public ConsistentHashLoadBalancerSettings clone() {
    return (ConsistentHashLoadBalancerSettings) super.clone();
  }

}
