/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for ImageFamilyView.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ImageFamilyView extends com.google.api.client.json.GenericJson {

  /**
   * The latest image that is part of the specified image family in the requested location, and that
   * is not deprecated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image image;

  /**
   * The latest image that is part of the specified image family in the requested location, and that
   * is not deprecated.
   * @return value or {@code null} for none
   */
  public Image getImage() {
    return image;
  }

  /**
   * The latest image that is part of the specified image family in the requested location, and that
   * is not deprecated.
   * @param image image or {@code null} for none
   */
  public ImageFamilyView setImage(Image image) {
    this.image = image;
    return this;
  }

  @Override
  public ImageFamilyView set(String fieldName, Object value) {
    return (ImageFamilyView) super.set(fieldName, value);
  }

  @Override
  public ImageFamilyView clone() {
    return (ImageFamilyView) super.clone();
  }

}
