/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Initial State for shielded instance, these are public keys which are safe to store in public
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InitialStateConfig extends com.google.api.client.json.GenericJson {

  /**
   * The Key Database (db).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<FileContentBuffer> dbs;

  static {
    // hack to force ProGuard to consider FileContentBuffer used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(FileContentBuffer.class);
  }

  /**
   * The forbidden key database (dbx).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<FileContentBuffer> dbxs;

  static {
    // hack to force ProGuard to consider FileContentBuffer used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(FileContentBuffer.class);
  }

  /**
   * The Key Exchange Key (KEK).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<FileContentBuffer> keks;

  static {
    // hack to force ProGuard to consider FileContentBuffer used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(FileContentBuffer.class);
  }

  /**
   * The Platform Key (PK).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FileContentBuffer pk;

  /**
   * The Key Database (db).
   * @return value or {@code null} for none
   */
  public java.util.List<FileContentBuffer> getDbs() {
    return dbs;
  }

  /**
   * The Key Database (db).
   * @param dbs dbs or {@code null} for none
   */
  public InitialStateConfig setDbs(java.util.List<FileContentBuffer> dbs) {
    this.dbs = dbs;
    return this;
  }

  /**
   * The forbidden key database (dbx).
   * @return value or {@code null} for none
   */
  public java.util.List<FileContentBuffer> getDbxs() {
    return dbxs;
  }

  /**
   * The forbidden key database (dbx).
   * @param dbxs dbxs or {@code null} for none
   */
  public InitialStateConfig setDbxs(java.util.List<FileContentBuffer> dbxs) {
    this.dbxs = dbxs;
    return this;
  }

  /**
   * The Key Exchange Key (KEK).
   * @return value or {@code null} for none
   */
  public java.util.List<FileContentBuffer> getKeks() {
    return keks;
  }

  /**
   * The Key Exchange Key (KEK).
   * @param keks keks or {@code null} for none
   */
  public InitialStateConfig setKeks(java.util.List<FileContentBuffer> keks) {
    this.keks = keks;
    return this;
  }

  /**
   * The Platform Key (PK).
   * @return value or {@code null} for none
   */
  public FileContentBuffer getPk() {
    return pk;
  }

  /**
   * The Platform Key (PK).
   * @param pk pk or {@code null} for none
   */
  public InitialStateConfig setPk(FileContentBuffer pk) {
    this.pk = pk;
    return this;
  }

  @Override
  public InitialStateConfig set(String fieldName, Object value) {
    return (InitialStateConfig) super.set(fieldName, value);
  }

  @Override
  public InitialStateConfig clone() {
    return (InitialStateConfig) super.clone();
  }

}
