/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Contains NAT IP information of a NAT config (i.e. usage status, mode).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NatIpInfo extends com.google.api.client.json.GenericJson {

  /**
   * A list of all NAT IPs assigned to this NAT config.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<NatIpInfoNatIpInfoMapping> natIpInfoMappings;

  /**
   * Name of the NAT config which the NAT IP belongs to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String natName;

  /**
   * A list of all NAT IPs assigned to this NAT config.
   * @return value or {@code null} for none
   */
  public java.util.List<NatIpInfoNatIpInfoMapping> getNatIpInfoMappings() {
    return natIpInfoMappings;
  }

  /**
   * A list of all NAT IPs assigned to this NAT config.
   * @param natIpInfoMappings natIpInfoMappings or {@code null} for none
   */
  public NatIpInfo setNatIpInfoMappings(java.util.List<NatIpInfoNatIpInfoMapping> natIpInfoMappings) {
    this.natIpInfoMappings = natIpInfoMappings;
    return this;
  }

  /**
   * Name of the NAT config which the NAT IP belongs to.
   * @return value or {@code null} for none
   */
  public java.lang.String getNatName() {
    return natName;
  }

  /**
   * Name of the NAT config which the NAT IP belongs to.
   * @param natName natName or {@code null} for none
   */
  public NatIpInfo setNatName(java.lang.String natName) {
    this.natName = natName;
    return this;
  }

  @Override
  public NatIpInfo set(String fieldName, Object value) {
    return (NatIpInfo) super.set(fieldName, value);
  }

  @Override
  public NatIpInfo clone() {
    return (NatIpInfo) super.clone();
  }

}
