/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents a sub PublicDelegatedPrefix.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PublicDelegatedPrefixPublicDelegatedSubPrefix extends com.google.api.client.json.GenericJson {

  /**
   * Name of the project scoping this PublicDelegatedSubPrefix.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String delegateeProject;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The IP address range, in CIDR format, represented by this sub public delegated prefix.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipCidrRange;

  /**
   * Whether the sub prefix is delegated to create Address resources in the delegatee project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isAddress;

  /**
   * The name of the sub public delegated prefix.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * [Output Only] The region of the sub public delegated prefix if it is regional. If absent, the
   * sub prefix is global.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * [Output Only] The status of the sub public delegated prefix.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * Name of the project scoping this PublicDelegatedSubPrefix.
   * @return value or {@code null} for none
   */
  public java.lang.String getDelegateeProject() {
    return delegateeProject;
  }

  /**
   * Name of the project scoping this PublicDelegatedSubPrefix.
   * @param delegateeProject delegateeProject or {@code null} for none
   */
  public PublicDelegatedPrefixPublicDelegatedSubPrefix setDelegateeProject(java.lang.String delegateeProject) {
    this.delegateeProject = delegateeProject;
    return this;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @param description description or {@code null} for none
   */
  public PublicDelegatedPrefixPublicDelegatedSubPrefix setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The IP address range, in CIDR format, represented by this sub public delegated prefix.
   * @return value or {@code null} for none
   */
  public java.lang.String getIpCidrRange() {
    return ipCidrRange;
  }

  /**
   * The IP address range, in CIDR format, represented by this sub public delegated prefix.
   * @param ipCidrRange ipCidrRange or {@code null} for none
   */
  public PublicDelegatedPrefixPublicDelegatedSubPrefix setIpCidrRange(java.lang.String ipCidrRange) {
    this.ipCidrRange = ipCidrRange;
    return this;
  }

  /**
   * Whether the sub prefix is delegated to create Address resources in the delegatee project.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsAddress() {
    return isAddress;
  }

  /**
   * Whether the sub prefix is delegated to create Address resources in the delegatee project.
   * @param isAddress isAddress or {@code null} for none
   */
  public PublicDelegatedPrefixPublicDelegatedSubPrefix setIsAddress(java.lang.Boolean isAddress) {
    this.isAddress = isAddress;
    return this;
  }

  /**
   * The name of the sub public delegated prefix.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the sub public delegated prefix.
   * @param name name or {@code null} for none
   */
  public PublicDelegatedPrefixPublicDelegatedSubPrefix setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * [Output Only] The region of the sub public delegated prefix if it is regional. If absent, the
   * sub prefix is global.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * [Output Only] The region of the sub public delegated prefix if it is regional. If absent, the
   * sub prefix is global.
   * @param region region or {@code null} for none
   */
  public PublicDelegatedPrefixPublicDelegatedSubPrefix setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * [Output Only] The status of the sub public delegated prefix.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * [Output Only] The status of the sub public delegated prefix.
   * @param status status or {@code null} for none
   */
  public PublicDelegatedPrefixPublicDelegatedSubPrefix setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  @Override
  public PublicDelegatedPrefixPublicDelegatedSubPrefix set(String fieldName, Object value) {
    return (PublicDelegatedPrefixPublicDelegatedSubPrefix) super.set(fieldName, value);
  }

  @Override
  public PublicDelegatedPrefixPublicDelegatedSubPrefix clone() {
    return (PublicDelegatedPrefixPublicDelegatedSubPrefix) super.clone();
  }

}
