/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Contains some information about a VPN tunnel.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VpnGatewayStatusTunnel extends com.google.api.client.json.GenericJson {

  /**
   * The VPN gateway interface this VPN tunnel is associated with.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long localGatewayInterface;

  /**
   * The peer gateway interface this VPN tunnel is connected to, the peer gateway could either be an
   * external VPN gateway or a Google Cloud VPN gateway.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long peerGatewayInterface;

  /**
   * URL reference to the VPN tunnel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tunnelUrl;

  /**
   * The VPN gateway interface this VPN tunnel is associated with.
   * @return value or {@code null} for none
   */
  public java.lang.Long getLocalGatewayInterface() {
    return localGatewayInterface;
  }

  /**
   * The VPN gateway interface this VPN tunnel is associated with.
   * @param localGatewayInterface localGatewayInterface or {@code null} for none
   */
  public VpnGatewayStatusTunnel setLocalGatewayInterface(java.lang.Long localGatewayInterface) {
    this.localGatewayInterface = localGatewayInterface;
    return this;
  }

  /**
   * The peer gateway interface this VPN tunnel is connected to, the peer gateway could either be an
   * external VPN gateway or a Google Cloud VPN gateway.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPeerGatewayInterface() {
    return peerGatewayInterface;
  }

  /**
   * The peer gateway interface this VPN tunnel is connected to, the peer gateway could either be an
   * external VPN gateway or a Google Cloud VPN gateway.
   * @param peerGatewayInterface peerGatewayInterface or {@code null} for none
   */
  public VpnGatewayStatusTunnel setPeerGatewayInterface(java.lang.Long peerGatewayInterface) {
    this.peerGatewayInterface = peerGatewayInterface;
    return this;
  }

  /**
   * URL reference to the VPN tunnel.
   * @return value or {@code null} for none
   */
  public java.lang.String getTunnelUrl() {
    return tunnelUrl;
  }

  /**
   * URL reference to the VPN tunnel.
   * @param tunnelUrl tunnelUrl or {@code null} for none
   */
  public VpnGatewayStatusTunnel setTunnelUrl(java.lang.String tunnelUrl) {
    this.tunnelUrl = tunnelUrl;
    return this;
  }

  @Override
  public VpnGatewayStatusTunnel set(String fieldName, Object value) {
    return (VpnGatewayStatusTunnel) super.set(fieldName, value);
  }

  @Override
  public VpnGatewayStatusTunnel clone() {
    return (VpnGatewayStatusTunnel) super.clone();
  }

}
