/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.datastore.client;

import com.google.api.services.datastore.client.BaseDatastoreFactory;
import com.google.api.services.datastore.client.Datastore;
import com.google.api.services.datastore.client.DatastoreOptions;
import java.net.URI;
import java.net.URISyntaxException;

public class DatastoreFactory
extends BaseDatastoreFactory<Datastore> {
    private static final DatastoreFactory INSTANCE = new DatastoreFactory();
    public static final String VERSION = "v1beta2";

    public static DatastoreFactory get() {
        return INSTANCE;
    }

    @Override
    public Datastore create(DatastoreOptions options) throws IllegalArgumentException {
        return new Datastore(this.newRemoteRpc(options));
    }

    @Override
    protected String buildUrl(DatastoreOptions options, String overrideUrl) {
        try {
            if (options.getDataset() == null) {
                throw new IllegalArgumentException("datastore dataset not set in options");
            }
            String url = overrideUrl != null ? String.format("%s/datasets/%s", overrideUrl, options.getDataset()) : String.format("%s/datastore/%s/datasets/%s", options.getHost(), VERSION, options.getDataset());
            return new URI(url).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

