/*
 * Copyright 2018 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;


/** Static methods for managing the status of ARCore on the device. */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class ArCoreApk {

  ArCoreApk() {
    // Method contents removed.
  }

  /** Returns the singleton instance of ArCoreApk. */
  @androidx.annotation.NonNull
  public static com.google.ar.core.ArCoreApk getInstance() {
    // Method contents removed.
  }

  /**
   * Determines if ARCore is supported on this device. This may initiate a query with a remote
   * service to determine if the device is compatible, in which case it will immediately return
   * {@link com.google.ar.core.ArCoreApk.Availability#UNKNOWN_CHECKING
   * Availability#UNKNOWN_CHECKING}.
   *
   * <p>For ARCore-required apps (as indicated by the <a
   * href="https://developers.google.com/ar/develop/java/enable-arcore#ar_required">manifest
   * meta-data</a>) this method will assume device compatibility and will always immediately return
   * one of {@link com.google.ar.core.ArCoreApk.Availability#SUPPORTED_INSTALLED
   * Availability#SUPPORTED_INSTALLED}, {@link
   * com.google.ar.core.ArCoreApk.Availability#SUPPORTED_APK_TOO_OLD
   * Availability#SUPPORTED_APK_TOO_OLD}, or {@link
   * com.google.ar.core.ArCoreApk.Availability#SUPPORTED_NOT_INSTALLED
   * Availability#SUPPORTED_NOT_INSTALLED}.
   *
   * <p>Note: A return value of {@link com.google.ar.core.ArCoreApk.Availability#SUPPORTED_INSTALLED
   * Availability#SUPPORTED_INSTALLED} only indicates presence of a suitably versioned ARCore APK.
   * Session creation may still fail if the ARCore APK has been sideloaded onto an incompatible
   * device.
   *
   * <p>May be called prior to {@link com.google.ar.core.Session#Session(android.content.Context)
   * Session#Session(Context)}.
   *
   * @param applicationContext Your application's Android context.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.ArCoreApk.Availability checkAvailability(
      android.content.Context applicationContext) {
    // Method contents removed.
  }

  /**
   * Asynchronously determines if ARCore is supported on this device. This may initiate a query with
   * a remote service to determine if the device is compatible.
   *
   * <p>The callback will be invoked asynchronously on the Main thread. Unlike the synchronous
   * method {@link #checkAvailability(android.content.Context)}, the result will never be {@link
   * com.google.ar.core.ArCoreApk.Availability#UNKNOWN_CHECKING }.
   *
   * <p>For ARCore-required apps (as indicated by the <a
   * href="https://developers.google.com/ar/develop/java/enable-arcore#ar_required">manifest
   * meta-data</a>) this method will assume device compatibility and the callback will be
   * asynchronously invoked on the Main thread with one of {@link
   * com.google.ar.core.ArCoreApk.Availability#SUPPORTED_INSTALLED
   * Availability#SUPPORTED_INSTALLED}, {@link
   * com.google.ar.core.ArCoreApk.Availability#SUPPORTED_APK_TOO_OLD
   * Availability#SUPPORTED_APK_TOO_OLD}, or {@link
   * com.google.ar.core.ArCoreApk.Availability#SUPPORTED_NOT_INSTALLED
   * Availability#SUPPORTED_NOT_INSTALLED}.
   *
   * <p>Note: A result value of {@link com.google.ar.core.ArCoreApk.Availability#SUPPORTED_INSTALLED
   * Availability#SUPPORTED_INSTALLED} only indicates presence of a suitably versioned ARCore APK.
   * Session creation may still fail if the ARCore APK has been sideloaded onto an incompatible
   * device.
   *
   * <p>May be called prior to {@link com.google.ar.core.Session#Session(android.content.Context)
   * Session#Session(Context)}.
   *
   * @param applicationContext Your application's Android context.
   * @param callback The callback to receive the result on the Main thread.
   */
  public void checkAvailabilityAsync(
      android.content.Context applicationContext,
      @androidx.annotation.NonNull
          java.util.function.Consumer<com.google.ar.core.ArCoreApk.Availability> callback) {
    // Method contents removed.
  }

  /**
   * Initiates installation of ARCore when needed. When your apllication launches or enters an AR
   * mode, it should call this method with {@code userRequestedInstall = true}.
   *
   * <p>If ARCore is installed and compatible, this function will return {@link
   * com.google.ar.core.ArCoreApk.InstallStatus#INSTALLED }.
   *
   * <p>If ARCore is not currently installed or the installed version is not compatible, the
   * function will return {@link com.google.ar.core.ArCoreApk.InstallStatus#INSTALL_REQUESTED
   * InstallStatus#INSTALL_REQUESTED} immediately. Your current activity will then pause while the
   * user is offered the opportunity to install it.
   *
   * <p>When your activity resumes, you should call this method again, this time with {@code
   * userRequestedInstall = false}. This will either return {@link
   * com.google.ar.core.ArCoreApk.InstallStatus#INSTALLED InstallStatus#INSTALLED} or throw an
   * exception indicating the reason that installation could not be completed.
   *
   * <p>ARCore-optional applications must ensure that {@link
   * #checkAvailability(android.content.Context)} returns one of the {@link
   * com.google.ar.core.ArCoreApk.Availability#isSupported() SUPPORTED_...} values before calling
   * this method.
   *
   * <p>See <A href="https://github.com/google-ar/arcore-android-sdk/tree/master/samples">our sample
   * code</A> for an example of how an ARCore-required application should use this function.
   *
   * <p>May be called prior to {@link com.google.ar.core.Session#Session(android.content.Context)
   * Session#Session(Context)}.
   *
   * <p>For more control over the message displayed and ease of exiting the process, see {@link
   * #requestInstall(android.app.Activity,boolean,com.google.ar.core.ArCoreApk.InstallBehavior,com.google.ar.core.ArCoreApk.UserMessageType)}.
   *
   * @param applicationActivity Your application's current activity. Used for launching an intent to
   *     display the installation user interface.
   * @param userRequestedInstall if set, override the previous installation failure message and
   *     always show the installation interface.
   * @throws com.google.ar.core.exceptions.FatalException if an error occurs while checking
   *     compatibility or starting installation
   * @throws com.google.ar.core.exceptions.UnavailableDeviceNotCompatibleException if ARCore is not
   *     supported on this device.
   * @throws com.google.ar.core.exceptions.UnavailableUserDeclinedInstallationException if the user
   *     previously declined installation and userRequestedInstall is false.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.ArCoreApk.InstallStatus requestInstall(
      android.app.Activity applicationActivity, boolean userRequestedInstall)
      throws com.google.ar.core.exceptions.UnavailableDeviceNotCompatibleException,
          com.google.ar.core.exceptions.UnavailableUserDeclinedInstallationException {
    // Method contents removed.
  }

  /**
   * Initiates installation of ARCore when needed, with configurable behavior.
   *
   * <p>This is a more flexible version of {@link #requestInstall(android.app.Activity,boolean)}
   * allowing the application control over the initial informational dialog and ease of exiting or
   * cancelling the installation.
   *
   * <p>See {@link #requestInstall(android.app.Activity,boolean)} for details of use and behavior.
   *
   * @param applicationActivity Your application's current activity. Used for launching an intent to
   *     display the installation user interface.
   * @param userRequestedInstall if set, override the previous installation failure message and
   *     always show the installation interface.
   * @param installBehavior controls the presence of the cancel button at the user education screen
   *     and if tapping outside the education screen or install-in-progress screen causes them to
   *     dismiss.
   * @param messageType controls the text of the of message displayed before showing the install
   *     prompt, or disables display of this message.
   * @throws com.google.ar.core.exceptions.FatalException if an error occurs while checking
   *     compatibility or starting installation
   * @throws com.google.ar.core.exceptions.UnavailableDeviceNotCompatibleException if ARCore is not
   *     supported on this device.
   * @throws com.google.ar.core.exceptions.UnavailableUserDeclinedInstallationException if the user
   *     previously declined installation and userRequestedInstall is false.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.ArCoreApk.InstallStatus requestInstall(
      android.app.Activity applicationActivity,
      boolean userRequestedInstall,
      com.google.ar.core.ArCoreApk.InstallBehavior installBehavior,
      com.google.ar.core.ArCoreApk.UserMessageType messageType)
      throws com.google.ar.core.exceptions.UnavailableDeviceNotCompatibleException,
          com.google.ar.core.exceptions.UnavailableUserDeclinedInstallationException {
    // Method contents removed.
  }

  /** Describes the current state of ARCore availability on the device. */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum Availability {
    /**
     * An internal error occurred while determining ARCore availability. Check logcat for more
     * details.
     */
    UNKNOWN_ERROR,
    /** ARCore is not installed, and a query has been issued to check if ARCore is is supported. */
    UNKNOWN_CHECKING,
    /**
     * ARCore is not installed, and the query to check if ARCore is supported timed out. This may be
     * due to the device being offline.
     */
    UNKNOWN_TIMED_OUT,
    /** ARCore is not supported on this device. */
    UNSUPPORTED_DEVICE_NOT_CAPABLE,
    /** The device and Android version are supported, but the ARCore APK is not installed. */
    SUPPORTED_NOT_INSTALLED,
    /**
     * The device and Android version are supported, and a version of the ARCore APK is installed,
     * but that ARCore APK version is too old.
     */
    SUPPORTED_APK_TOO_OLD,
    /** ARCore is supported, installed, and available to use. */
    SUPPORTED_INSTALLED;

    /** True if this is one of the {@code UNKNOWN_...} values. */
    public boolean isUnknown() {
      // Method contents removed.
    }

    /** True if this is one of the {@code UNSUPPORTED_...} values. */
    public boolean isUnsupported() {
      // Method contents removed.
    }

    /** True if this is one of the {@code SUPPORTED_...} values. */
    public boolean isSupported() {
      // Method contents removed.
    }

    /** True if this state is temporary and the application should check again soon. */
    public boolean isTransient() {
      // Method contents removed.
    }
  }

  /** Controls the behavior of the installation UI. */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum InstallBehavior {
    /**
     * Hide the Cancel button during initial prompt and prevent user from exiting via tap-outside.
     *
     * <p>Note: The BACK button or tapping outside of any marketplace-provided install dialog will
     * still decline the installation.
     */
    REQUIRED,
    /**
     * Include Cancel button in initial prompt and allow easily backing out after installation has
     * been initiated.
     */
    OPTIONAL;
  }

  /** Indicates the outcome of a call to {@code requestInstall()}. */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum InstallStatus {
    /** The requested resource is already installed. */
    INSTALLED,
    /** Installation of the resource was requested. The current activity will be paused. */
    INSTALL_REQUESTED;
  }

  /** Controls the message displayed by the installation UI. */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum UserMessageType {
    /** Display a localized message like "This application requires ARCore...". */
    APPLICATION,
    /** Display a localized message like "This feature requires ARCore...". */
    FEATURE,
    /**
     * Application has explained why ARCore is required prior to calling requestInstall(), skip user
     * education dialog.
     */
    USER_ALREADY_INFORMED;
  }
}
