/*
 * Copyright 2018 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;

/**
 * Describes the current best knowledge of a real-world augmented image.
 *
 * <p>ARCore will return an AugmentedImage once it initially detects the image in the environment,
 * even if it does not yet have enough information to estimate its pose and physical size. In that
 * case, the AugmentedImage will have the tracking state Paused. Specifying the optional physical
 * size in the database will help speed up the initial pose and physical size estimation process.
 * Note that an AugmentedImage can have tracking state PAUSED even if the overall motion tracking
 * system is tracking (i.e. the frame's camera tracking state is TRACKING).
 */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class AugmentedImage implements com.google.ar.core.Trackable {

  AugmentedImage() {
    // Method contents removed.
  }

  /**
   * Returns the pose of the center of the augmented image, in world coordinates. The pose's
   * transformed +Y axis will be the normal out of the plane. The pose's transformed +X axis points
   * from left to right on the image, and the transformed +Z axis points from top to bottom on the
   * image.
   *
   * <p>If the tracking state is PAUSED/STOPPED, this returns the pose when the image state was last
   * TRACKING, or the identity pose if the image state has never been TRACKING.
   */
  public com.google.ar.core.Pose getCenterPose() {
    // Method contents removed.
  }

  /**
   * Returns the estimated width, in metres, of the corresponding physical image, as measured along
   * the local X-axis of the coordinate space centered on the image.
   *
   * <p>ARCore will attempt to estimate the physical image's width based on its understanding of the
   * world. If the optional physical size is specified in the database, this estimation process will
   * happen more quickly. However, the estimated size may be different from the specified size.
   *
   * <p>If the tracking state is PAUSED/STOPPED, this returns the estimated width when the image
   * state was last TRACKING. If the image state has never been TRACKING, this returns {@code 0},
   * even the image has a specified physical size in the image database.
   */
  public float getExtentX() {
    // Method contents removed.
  }

  /**
   * Returns the estimated height, in metres, of the corresponding physical image, as measured along
   * the local Z-axis of the coordinate space centered on the image.
   *
   * <p>ARCore will attempt to estimate the physical image's height based on its understanding of
   * the world. If an optional physical size is specified in the database, this estimation process
   * will happen more quickly. However, the estimated size may be different from the specified size.
   *
   * <p>If the tracking state is PAUSED/STOPPED, this returns the estimated height when the image
   * state was last TRACKING. If the image state has never been TRACKING, this returns {@code 0},
   * even the image has a specified physical size in the image database.
   */
  public float getExtentZ() {
    // Method contents removed.
  }

  /**
   * Returns the zero-based positional index of this augmented image from its originating image
   * database.
   *
   * <p>This index serves as the unique identifier for the image in the database.
   */
  public int getIndex() {
    // Method contents removed.
  }

  /**
   * Returns the name of this augmented image.
   *
   * <p>The image name is not guaranteed to be unique.
   */
  public java.lang.String getName() {
    // Method contents removed.
  }

  @androidx.annotation.NonNull
  public com.google.ar.core.AugmentedImage.TrackingMethod getTrackingMethod() {
    // Method contents removed.
  }

  /** Gets this trackable's {@link com.google.ar.core.TrackingState TrackingState}. */
  @androidx.annotation.NonNull
  public com.google.ar.core.TrackingState getTrackingState() {
    // Method contents removed.
  }

  /**
   * Returns a hash code value for the object. This method is supported for the benefit of hash
   * tables such as those provided by {@link java.util.HashMap}.
   *
   * @return a hash code value for this object.
   * @see #equals(Object)
   */
  public int hashCode() {
    // Method contents removed.
  }

  @androidx.annotation.NonNull
  public com.google.ar.core.Anchor createAnchor(com.google.ar.core.Pose pose) {
    // Method contents removed.
  }

  /**
   * Indicates whether some other object is a {@code Trackable} referencing the same logical
   * trackable as this one.
   *
   * @param obj the reference object with which to compare.
   * @return {@code true} if this object is the same as the obj argument; {@code false} otherwise.
   * @see #hashCode()
   * @see java.util.HashMap
   */
  public boolean equals(java.lang.Object obj) {
    // Method contents removed.
  }

  @androidx.annotation.NonNull
  public java.util.Collection<com.google.ar.core.Anchor> getAnchors() {
    // Method contents removed.
  }

  /**
   * Indicates whether an image is being tracked using the camera image, or is being tracked based
   * on its last known pose.
   */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum TrackingMethod {
    /**
     * The Augmented Image is not currently being tracked. This state indicates that the image
     * motion {@link com.google.ar.core.TrackingState TrackingState} is {@link
     * com.google.ar.core.TrackingState#PAUSED TrackingState#PAUSED} or {@link
     * com.google.ar.core.TrackingState#STOPPED }.
     */
    NOT_TRACKING,
    /**
     * The Augmented Image is currently being tracked using the camera image. This state can only
     * occur when the image motion {@link com.google.ar.core.TrackingState TrackingState} is {@link
     * com.google.ar.core.TrackingState#TRACKING TrackingState#TRACKING}.
     */
    FULL_TRACKING,
    /**
     * The Augmented Image is currently being tracked based on its last known pose, because it can
     * no longer be tracked using the camera image. This state can only occur when the image motion
     * {@link com.google.ar.core.TrackingState TrackingState} is {@link
     * com.google.ar.core.TrackingState#TRACKING TrackingState#TRACKING}.
     */
    LAST_KNOWN_POSE;
  }
}
