/*
 * Copyright 2018 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;


/**
 * Database containing a list of images to be detected and tracked by ARCore.
 *
 * <p>An image database supports up to 1000 images. A database can be generated by the
 * <c>arcoreimg</c> command-line database generation tool provided in the SDK, or dynamically
 * created at runtime by adding individual images to an AugmentedImageDatabase.
 *
 * <p>Only one image database can be active in a session. Any images in the currently active image
 * database that have a TRACKING/PAUSED state will immediately be set to the STOPPED state if a
 * different or null image database is made active in the current session Config.
 */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class AugmentedImageDatabase {

  /** Creates a new empty image database. */
  public AugmentedImageDatabase(com.google.ar.core.Session session) {
    // Method contents removed.
  }

  /**
   * Creates a new image database from an input stream. The stream contents must have been generated
   * by the command-line database generation tool provided in the SDK, or at runtime from {@link
   * #serialize(java.io.OutputStream)}.
   *
   * <p>Note: this method takes about 10-20ms for a 5MB byte input stream. Run this in a background
   * thread if this affects your application.
   *
   * @throws com.google.ar.core.exceptions.DataInvalidFormatException if the input stream is not
   *     formatted properly as an image database.
   * @throws com.google.ar.core.exceptions.DataUnsupportedVersionException if the database is
   *     incompatible with the current SDK.
   */
  public static com.google.ar.core.AugmentedImageDatabase deserialize(
      com.google.ar.core.Session session, java.io.InputStream inputStream)
      throws java.io.IOException {
    // Method contents removed.
  }

  /**
   * Adds a single named image of unknown physical size to the augmented image database from an
   * Android bitmap. Returns the zero-based positional index of the image within the database.
   *
   * <p>If the physical size of the image is known, use {@link
   * #addImage(java.lang.String,android.graphics.Bitmap,float)} instead, to improve image detection
   * time.
   *
   * <p>For images added via this method, ARCore estimates the physical image's size and pose at
   * runtime when the physical image is visible and is being tracked. This extra estimation step
   * will require the user to move their device to view the physical image from different viewpoints
   * before the size and pose of the physical image can be estimated.
   *
   * <p>This method takes time to perform non-trivial image processing (20ms - 30ms), and should be
   * run on a background thread to avoid blocking the UI thread.
   *
   * @param name Name metadata for this image, does not have to be unique.
   * @param bitmap Bitmap containing the image in ARGB_8888 format. The alpha channel is ignored in
   *     this bitmap, as only non-transparent images are currently supported.
   * @throws com.google.ar.core.exceptions.ImageInsufficientQualityException if the image quality is
   *     image is insufficient, e.g. if the image has not enough features.
   * @throws java.lang.IllegalArgumentException if the bitmap is not in ARGB_888 format.
   */
  public int addImage(java.lang.String name, android.graphics.Bitmap bitmap) {
    // Method contents removed.
  }

  /**
   * Adds a single named image with known physical size to the augmented image database from an
   * Android bitmap, with a specified physical width in meters. Returns the zero-based positional
   * index of the image within the database.
   *
   * <p>If the physical size of the image is not known, use {@link
   * #addImage(java.lang.String,android.graphics.Bitmap)} instead, at the expense of an increased
   * image detection time.
   *
   * <p>For images added via this method, ARCore can estimate the pose of the physical image at
   * runtime as soon as ARCore detects the physical image, without requiring the user to move the
   * device to view the physical image from different viewpoints. Note that ARCore will refine the
   * estimated size and pose of the physical image as it is viewed from different viewpoints.
   *
   * <p>This method takes time to perform non-trivial image processing (20ms - 30ms), and should be
   * run on a background thread to avoid blocking the UI thread.
   *
   * @param name Name metadata for this image, does not have to be unique.
   * @param bitmap Bitmap containing the image in ARGB_8888 format. The alpha channel is ignored in
   *     this bitmap, as only non-transparent images are currently supported.
   * @param widthInMeters Width in meters for this image, must be strictly greater than zero.
   * @throws com.google.ar.core.exceptions.ImageInsufficientQualityException if the image quality is
   *     image is insufficient, e.g. if the image has not enough features.
   * @throws java.lang.IllegalArgumentException if the bitmap is not in ARGB_888 format or the width
   *     in meters is less than or equal to zero.
   */
  public int addImage(java.lang.String name, android.graphics.Bitmap bitmap, float widthInMeters) {
    // Method contents removed.
  }

  /** Returns the number of images in the database. */
  public int getNumImages() {
    // Method contents removed.
  }

  /** Serializes the database to an OutputStream. */
  public void serialize(java.io.OutputStream outputStream) throws java.io.IOException {
    // Method contents removed.
  }

  /** @hide */
  protected void finalize() throws java.lang.Throwable {
    // Method contents removed.
  }
}
