/*
 * Copyright 2017 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;

/**
 * Provides information about the camera that is used to capture images. The {@link
 * com.google.ar.core.Camera Camera} is a long-lived object and the properties of {@link
 * com.google.ar.core.Camera Camera} are updated every time {@link
 * com.google.ar.core.Session#update() } is called.
 */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class Camera {

  Camera() {
    // Method contents removed.
  }

  /**
   * Indicates whether some other object is a {@code Camera} referencing the same logical camera as
   * this one.
   *
   * @param obj the reference object with which to compare.
   * @return {@code true} if this object is the same as the obj argument; {@code false} otherwise.
   * @see #hashCode()
   * @see java.util.HashMap
   */
  public boolean equals(java.lang.Object obj) {
    // Method contents removed.
  }

  /**
   * Returns a hash code value for the object. This method is supported for the benefit of hash
   * tables such as those provided by {@link java.util.HashMap}.
   *
   * @return a hash code value for this object.
   * @see #equals(Object)
   */
  public int hashCode() {
    // Method contents removed.
  }

  /** @hide */
  protected void finalize() throws java.lang.Throwable {
    // Method contents removed.
  }

  /**
   * Returns the current motion tracking state of this camera. If this state is anything other than
   * {@link com.google.ar.core.TrackingState#TRACKING TrackingState#TRACKING} the pose should not be
   * considered useful. Use {@link #getTrackingFailureReason()} to determine the best recommendation
   * to provide to the user to restore motion tracking.
   *
   * <p>Note: Starting in ARCore 1.12, changing the active camera config using {@link
   * com.google.ar.core.Session#setCameraConfig(com.google.ar.core.CameraConfig) } may cause the
   * tracking state on certain devices to become permanently {@link
   * com.google.ar.core.TrackingState#PAUSED TrackingState#PAUSED}. For consistent behavior across
   * all supported devices, release any previously created anchors and trackables when setting a new
   * camera config.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.TrackingState getTrackingState() {
    // Method contents removed.
  }

  /**
   * Returns the reason that {@link #getTrackingState()} is {@link
   * com.google.ar.core.TrackingState#PAUSED TrackingState#PAUSED}.
   *
   * <p>Returns {@link com.google.ar.core.TrackingFailureReason#NONE TrackingFailureReason#NONE}
   * briefly after {@link com.google.ar.core.Session#resume() Session#resume()}, while the motion
   * tracking is initializing. Always returns {@link com.google.ar.core.TrackingFailureReason#NONE
   * TrackingFailureReason#NONE} when {@link #getTrackingState()} is {@link
   * com.google.ar.core.TrackingState#TRACKING TrackingState#TRACKING}.
   *
   * <p>If multiple potential causes for motion tracking failure are detected, this reports the most
   * actionable failure reason.
   *
   * @return the reason for motion tracking failure.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.TrackingFailureReason getTrackingFailureReason() {
    // Method contents removed.
  }

  /**
   * Returns the pose of the physical camera in world space for the latest frame. This is an OpenGL
   * camera pose with +X pointing right, +Y pointing right up, and -Z pointing in the direction the
   * camera is looking, with "right" and "up" being relative to the image readout in the usual
   * left-to-right, top-to-bottom order. Specifically, this is the camera pose at the center of
   * exposure of the center row of the image.
   *
   * <p><b>For applications using the SDK for ARCore 1.5 and earlier</b>, the returned pose is
   * rotated around the Z axis by a multiple of 90&deg; so that the axes correspond approximately to
   * those of the <a
   * href="https://developer.android.com/guide/topics/sensors/sensors_overview#sensors-coords">Android
   * Sensor Coordinate System</a>.
   *
   * <p>See Also:
   *
   * <ul>
   *   <li>{@link #getDisplayOrientedPose()} for the pose of the virtual camera. It will differ by a
   *       local rotation about the Z axis by a multiple of 90&deg;.
   *   <li>{@link com.google.ar.core.Frame#getAndroidSensorPose() Frame#getAndroidSensorPose()} for
   *       the pose of the Android sensor frame. It will differ in both orientation and location.
   *   <li>{@link
   *       com.google.ar.core.Frame#transformCoordinates2d(com.google.ar.core.Coordinates2d,float[],com.google.ar.core.Coordinates2d,float[])
   *       Frame#transformCoordinates2d(Coordinates2d, float[], Coordinates2d, float[])} to convert
   *       viewport coordinates to texture coordinates.
   * </ul>
   *
   * Note: This pose is only useful when {@link #getTrackingState()} returns {@link
   * com.google.ar.core.TrackingState#TRACKING } and otherwise should not be used.
   */
  public com.google.ar.core.Pose getPose() {
    // Method contents removed.
  }

  /**
   * Returns the virtual camera pose in world space for rendering AR content onto the latest frame.
   * This is an OpenGL camera pose with +X pointing right, +Y pointing up, and -Z pointing in the
   * direction the camera is looking, with "right" and "up" being relative to current logical
   * display orientation.
   *
   * <p>See Also:
   *
   * <ul>
   *   <li>{@link #getViewMatrix(float[],int)} to conveniently compute the OpenGL View Matrix.
   *   <li>{@link #getPose()} for the physical pose of the camera. It will differ by a local
   *       rotation about the Z axis by a multiple of 90&deg;.
   *   <li>{@link com.google.ar.core.Frame#getAndroidSensorPose() Frame#getAndroidSensorPose()} for
   *       the pose of the android sensor frame. It will differ in both orientation and location.
   *   <li>{@link com.google.ar.core.Session#setDisplayGeometry(int,int,int)
   *       Session#setDisplayGeometry(int, int, int)} to update the display rotation.
   * </ul>
   *
   * Note: This pose is only useful when {@link #getTrackingState()} returns {@link
   * com.google.ar.core.TrackingState#TRACKING } and otherwise should not be used.
   */
  public com.google.ar.core.Pose getDisplayOrientedPose() {
    // Method contents removed.
  }

  /**
   * Returns the view matrix for the camera for this frame. Note that the view matrix incorporates
   * the display orientation. This is equivalent to: {@code
   * camera.getDisplayOrientedPose().inverse().asMatrix()}
   *
   * @param viewMatrix storage for at least 16 floats representing a 4x4 matrix in column major
   *     order
   * @param offset the offset in {@code viewMatrix} at which to begin writing the matrix
   * @see #getPose()
   * @see com.google.ar.core.Camera#getProjectionMatrix(float[], int, float, float)
   */
  public void getViewMatrix(float[] viewMatrix, int offset) {
    // Method contents removed.
  }

  /**
   * Returns a projection matrix for rendering virtual content on top of the camera image. Note that
   * the projection matrix reflects the current display geometry and display rotation.
   *
   * <p>Note: When using {@link com.google.ar.core.Session.Feature#FRONT_CAMERA
   * Session.Feature#FRONT_CAMERA}, the returned projection matrix will incorporate a horizontal
   * flip.
   *
   * @param dest storage for at least 16 floats representing a 4x4 matrix in column major order
   * @param offset the offset in {@code dest} at which to begin writing the matrix (often {@code 0})
   * @param near specifies the near clip plane, in meters
   * @param far specifies the far clip plane, in meters
   */
  public void getProjectionMatrix(float[] dest, int offset, float near, float far) {
    // Method contents removed.
  }

  /** Returns the unrotated camera intrinsics for the CPU image. */
  public com.google.ar.core.CameraIntrinsics getImageIntrinsics() {
    // Method contents removed.
  }

  /** Returns the unrotated camera intrinsics for the GPU texture. */
  public com.google.ar.core.CameraIntrinsics getTextureIntrinsics() {
    // Method contents removed.
  }
}
