/*
 * Copyright 2018 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;


/** Provides details of a camera configuration such as size of the CPU image and GPU texture. */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class CameraConfig {

  CameraConfig() {
    // Method contents removed.
  }

  /** @hide */
  protected void finalize() throws java.lang.Throwable {
    // Method contents removed.
  }

  /** Gets the dimensions of the image frames for processing that are sent on CPU stream. */
  @androidx.annotation.NonNull
  public android.util.Size getImageSize() {
    // Method contents removed.
  }

  /** Gets the dimensions of the image frames for texture that are sent on GPU stream. */
  @androidx.annotation.NonNull
  public android.util.Size getTextureSize() {
    // Method contents removed.
  }

  /**
   * Obtains the minimum and maximum camera capture rate in frames per second (fps) for the current
   * camera config. Actual capture frame rate will vary within this range, depending on current
   * lighting conditions. Frame rates will generally be lower under poor lighting conditions due to
   * longer exposure times.
   */
  @androidx.annotation.NonNull
  public android.util.Range<java.lang.Integer> getFpsRange() {
    // Method contents removed.
  }

  /** Obtains the depth sensor usage for the current camera config. */
  @androidx.annotation.NonNull
  public com.google.ar.core.CameraConfig.DepthSensorUsage getDepthSensorUsage() {
    // Method contents removed.
  }

  /**
   * Gets the camera identifier associated with this config. This camera ID is the same ID as
   * returned by Camera2 {@code CameraManager.getCameraIdList()}.
   */
  public java.lang.String getCameraId() {
    // Method contents removed.
  }

  /** Returns the direction a camera is facing relative to the device. */
  @androidx.annotation.NonNull
  public com.google.ar.core.CameraConfig.FacingDirection getFacingDirection() {
    // Method contents removed.
  }

  /**
   * Obtains the stereo <a
   * href="https://source.android.com/devices/camera/multi-camera">multi-camera</a> usage for the
   * current camera config.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.CameraConfig.StereoCameraUsage getStereoCameraUsage() {
    // Method contents removed.
  }

  /** Depth sensor usage. */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum DepthSensorUsage {
    /**
     * When used as a camera filter, via {@link
     * com.google.ar.core.CameraConfigFilter#setDepthSensorUsage(java.util.EnumSet)
     * CameraConfigFilter#setDepthSensorUsage(EnumSet)}, indicates that a depth sensor must be
     * present on the device, and the depth sensor will be used by ARCore. Not supported on all
     * devices.
     *
     * <p>Currently not supported when {@link com.google.ar.core.SharedCamera} API is used to share
     * control of the camera with ARCore.
     *
     * <p>When returned by {@link #getDepthSensorUsage()}, indicates that the camera config will use
     * a depth sensor.
     */
    REQUIRE_AND_USE,
    /**
     * When used as a camera filter, via {@link
     * com.google.ar.core.CameraConfigFilter#setDepthSensorUsage(java.util.EnumSet)
     * CameraConfigFilter#setDepthSensorUsage(EnumSet)}, indicates that ARCore will not attempt to
     * use a depth sensor, even if it is present. Most commonly used to filter camera configurations
     * when the app requires exclusive access to the depth sensor outside of ARCore, for example to
     * support 3D mesh reconstruction. Available on all ARCore supported devices.
     *
     * <p>When returned by {@link #getDepthSensorUsage()}, indicates that the camera config will not
     * use a depth sensor.
     */
    DO_NOT_USE;
  }

  /**
   * Describes the direction a camera looks relative to the device. Used by {@link
   * com.google.ar.core.CameraConfig#getFacingDirection() }.
   */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum FacingDirection {
    /**
     * Back-facing (world) camera (away from the user).
     *
     * <p>Available on all <a href="https://developers.google.com/ar/devices">ARCore supported
     * devices</a>.
     *
     * <p>When used as a camera filter, via {@link
     * com.google.ar.core.CameraConfigFilter#setFacingDirection(com.google.ar.core.CameraConfig.FacingDirection)
     * }, filters for camera configs that use a back-facing (world) camera.
     */
    BACK,
    /**
     * Front-facing (selfie) camera (toward the user).
     *
     * <p>See <a href="https://developers.google.com/ar/devices">ARCore supported devices</a> for
     * available camera configs by device.
     *
     * <p>To limit distribution of your app to only devices that have a front-facing camera, use <a
     * href="https://developer.android.com/guide/topics/manifest/uses-feature-element#camera-hw-features">uses-feature</a>
     * with {@code android.hardware.camera}.
     *
     * <p>When used as a camera filter, via {@link
     * com.google.ar.core.CameraConfigFilter#setFacingDirection(com.google.ar.core.CameraConfig.FacingDirection)
     * }, filters for camera configs that use a front-facing (selfie) camera.
     *
     * <p>To create a session using the front-facing (selfie) camera, use {@link
     * com.google.ar.core.Session#setCameraConfig(com.google.ar.core.CameraConfig) } to set a
     * front-facing (selfie) camera config retrieved from {@link
     * com.google.ar.core.Session#getSupportedCameraConfigs(com.google.ar.core.CameraConfigFilter)
     * Session#getSupportedCameraConfigs(CameraConfigFilter)}.
     *
     * <p>When the front camera is selected, ARCore's behavior changes in the following ways:
     *
     * <ul>
     *   <li>The display will be mirrored. Specifically, {@link
     *       com.google.ar.core.Camera#getProjectionMatrix(float[],int,float,float)
     *       Camera#getProjectionMatrix(float[], int, float, float)} will include a horizontal flip
     *       in the generated projection matrix and APIs that reason about things in screen space
     *       such as {@link
     *       com.google.ar.core.Frame#transformCoordinates2d(com.google.ar.core.Coordinates2d,float[],com.google.ar.core.Coordinates2d,float[])
     *       } will mirror screen coordinates. Open GL apps should consider using {@code
     *       glFrontFace} to render mirrored assets without changing their winding direction.
     *   <li>{@link com.google.ar.core.Camera#getTrackingState() Camera#getTrackingState()} will
     *       always return {@link com.google.ar.core.TrackingState#PAUSED TrackingState#PAUSED}.
     *   <li>All forms of {@code Frame.hitTest()} will always return an empty list.
     *   <li>{@link com.google.ar.core.Camera#getDisplayOrientedPose()
     *       Camera#getDisplayOrientedPose()} will always return an identity pose.
     *   <li>{@link com.google.ar.core.Session#createAnchor(com.google.ar.core.Pose)
     *       Session#createAnchor(Pose)} will always throw {@link
     *       com.google.ar.core.exceptions.NotTrackingException}.
     *   <li>Planes will never be detected.
     *   <li>{@link com.google.ar.core.Session#configure(com.google.ar.core.Config)
     *       Session#configure(Config)} will throw if the supplied configuration requests Cloud
     *       Anchors or Augmented Images.
     * </ul>
     */
    FRONT;
  }

  /** Stereo camera usage. */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum StereoCameraUsage {
    /**
     * When used as a camera filter, via {@link
     * com.google.ar.core.CameraConfigFilter#setStereoCameraUsage(java.util.EnumSet)
     * CameraConfigFilter#setStereoCameraUsage(EnumSet)}, indicates that a stereo <a
     * href="https://source.android.com/devices/camera/multi-camera">multi-camera</a> must be
     * present on the device, and the stereo camera must be used by ARCore. Increases CPU and device
     * power consumption. Not supported on all devices.
     *
     * <p>Currently not supported when {@link com.google.ar.core.SharedCamera} API is used to share
     * control of the camera with ARCore.
     *
     * <p>When returned by {@link #getStereoCameraUsage()}, indicates that a stereo camera is
     * present on the device and will be used by ARCore.
     */
    REQUIRE_AND_USE,
    /**
     * When used as a camera filter, via {@link
     * com.google.ar.core.CameraConfigFilter#setStereoCameraUsage(java.util.EnumSet)
     * CameraConfigFilter#setStereoCameraUsage(EnumSet)}, indicates that ARCore will not attempt to
     * use a stereo <a
     * href="https://source.android.com/devices/camera/multi-camera">multi-camera</a> , even if one
     * is present. Can be used to limit power consumption. Available on all ARCore supported
     * devices.
     *
     * <p>When returned by {@link #getStereoCameraUsage()}, indicates that the camera config will
     * not use a stereo camera, even if one is present on the device.
     */
    DO_NOT_USE;
  }

  /**
   * Target camera capture frame rates.
   *
   * <p>The target frame rate represents the maximum or desired frame rate. Actual camera capture
   * frame rates can be lower than the target frame rate under low light conditions, in order to
   * accommodate longer exposure times.
   */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum TargetFps {
    /**
     * Target 30fps camera capture frame rate.
     *
     * <p>Available on all ARCore supported devices.
     *
     * <p>When used as a camera filter, via {@link
     * com.google.ar.core.CameraConfigFilter#setTargetFps(java.util.EnumSet)
     * CameraConfigFilter#setTargetFps(EnumSet)}, filters for camera configs that support 30fps.
     */
    TARGET_FPS_30,
    /**
     * Target 60fps camera capture frame rate.
     *
     * <p>Increases power consumption and may increase app memory usage.
     *
     * <p>See the <a href="https://developers.google.com/ar/devices">ARCore Supported Devices</a>
     * page for a list of devices that currently support 60fps.
     *
     * <p>When used as a camera filter, via {@link
     * com.google.ar.core.CameraConfigFilter#setTargetFps(java.util.EnumSet)
     * CameraConfigFilter#setTargetFps(EnumSet)}, filters for camera configs that support 60fps.
     */
    TARGET_FPS_60;
  }
}
