/*
 * Copyright 2018 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;

/**
 * Allows the application to select the camera config filters it needs to enable/disable so that it
 * can obtain the list of camera configs that are supported on the device camera.
 */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class CameraConfigFilter {

  public CameraConfigFilter(com.google.ar.core.Session session) {
    // Method contents removed.
  }

  /** @hide */
  protected void finalize() throws java.lang.Throwable {
    // Method contents removed.
  }

  /**
   * Sets target camera capture frame rate filter.
   *
   * <p>Default is to not filter on target frame rate.
   *
   * <p>{@link com.google.ar.core.CameraConfig.TargetFps#TARGET_FPS_30} is guaranteed to be
   * available on all ARCore supported devices. Support for {@link
   * com.google.ar.core.CameraConfig.TargetFps#TARGET_FPS_60} is only available on certain devices.
   * See the <a href="https://developers.google.com/ar/devices">ARCore Supported Devices</a> page
   * for a list of affected devices.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.CameraConfigFilter setTargetFps(
      java.util.EnumSet<com.google.ar.core.CameraConfig.TargetFps> frameRates) {
    // Method contents removed.
  }

  /** Get the frame rate filter state. */
  @androidx.annotation.NonNull
  public java.util.EnumSet<com.google.ar.core.CameraConfig.TargetFps> getTargetFps() {
    // Method contents removed.
  }

  /**
   * Sets hardware depth sensor, such as a time-of-flight sensor (or ToF sensor), usage filter.
   * Default is to not filter.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.CameraConfigFilter setDepthSensorUsage(
      java.util.EnumSet<com.google.ar.core.CameraConfig.DepthSensorUsage> depthSensorUsageFilters) {
    // Method contents removed.
  }

  /**
   * Get the hardware depth sensor, such as a time-of-flight sensor (or ToF sensor), usage filter
   * state.
   */
  @androidx.annotation.NonNull
  public java.util.EnumSet<com.google.ar.core.CameraConfig.DepthSensorUsage> getDepthSensorUsage() {
    // Method contents removed.
  }

  /**
   * Sets the stereo <a
   * href="https://source.android.com/devices/camera/multi-camera">multi-camera</a> usage filter.
   * Default is to not filter.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.CameraConfigFilter setStereoCameraUsage(
      java.util.EnumSet<com.google.ar.core.CameraConfig.StereoCameraUsage>
          stereoCameraUsageFilters) {
    // Method contents removed.
  }

  /**
   * Get the stereo <a
   * href="https://source.android.com/devices/camera/multi-camera">multi-camera</a> usage filter
   * state.
   */
  @androidx.annotation.NonNull
  public java.util.EnumSet<com.google.ar.core.CameraConfig.StereoCameraUsage>
      getStereoCameraUsage() {
    // Method contents removed.
  }

  /**
   * Sets camera facing direction filter.
   *
   * <p>The default value is {@link com.google.ar.core.CameraConfig.FacingDirection#BACK
   * CameraConfig.FacingDirection#BACK}.
   *
   * <p>Currently, a back-facing (world) camera is guaranteed to be available on all ARCore
   * supported devices. Most ARCore supported devices also include support for a front-facing
   * (selfie) camera. See <a href="https://developers.google.com/ar/devices">ARCore supported
   * devices</a> for available camera configs by device.
   *
   * <p>Beginning with ARCore SDK 1.23.0, the default value is {@link
   * com.google.ar.core.CameraConfig.FacingDirection#FRONT } if the Session is created using the
   * deprecated {@link com.google.ar.core.Session.Feature#FRONT_CAMERA } feature.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.CameraConfigFilter setFacingDirection(
      com.google.ar.core.CameraConfig.FacingDirection facingDirections) {
    // Method contents removed.
  }

  /** Get the camera facing direction filter state. */
  @androidx.annotation.NonNull
  public com.google.ar.core.CameraConfig.FacingDirection getFacingDirection() {
    // Method contents removed.
  }
}
