/*
 * Copyright 2018 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;

/**
 * Provides information about the physical characteristics of the device camera, for the camera
 * image (CPU) or texture (GPU). The {@code CameraIntrinsics} is a long-lived object, and the
 * properties of CameraIntrinsics may be updated every time Session.update() is called.
 */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class CameraIntrinsics {

  CameraIntrinsics() {
    // Method contents removed.
  }

  /** @hide */
  protected void finalize() throws java.lang.Throwable {
    // Method contents removed.
  }

  /**
   * Returns the camera's focal length in pixels.
   *
   * <p>The focal length is conventionally represented in pixels. For a detailed explanation, please
   * see <a href="https://ksimek.github.io/2013/08/13/intrinsic">Disecting the Camera Matrix, Part
   * 3: The Intrinsic Matrix</a>. Pixels-to-meters conversion can use {@code
   * SENSOR_INFO_PHYSICAL_SIZE} and {@code SENSOR_INFO_PIXEL_ARRAY_SIZE} in the Android
   * Characteristics API.
   *
   * @param focalLength storage for at least 2 floats representing the focal length. The order of
   *     values is {fx, fy}.
   * @param offset the offset in {@code focalLength} at which to begin writing the focal length
   *     values.
   */
  public void getFocalLength(float[] focalLength, int offset) {
    // Method contents removed.
  }

  /**
   * Returns the camera's focal length in pixels.
   *
   * <p>The focal length is conventionally represented in pixels. For a detailed explanation, please
   * see <a href="https://ksimek.github.io/2013/08/13/intrinsic">Disecting the Camera Matrix, Part
   * 3: The Intrinsic Matrix</a>. Pixels-to-meters conversion can use {@code
   * SENSOR_INFO_PHYSICAL_SIZE} and {@code SENSOR_INFO_PIXEL_ARRAY_SIZE} in the Android
   * Characteristics API.
   *
   * @return a {@code float[2]} containing the focal length. The order of values is {fx, fy}.
   */
  public float[] getFocalLength() {
    // Method contents removed.
  }

  /**
   * Returns the camera's principal point. The order of values is {cx, cy}.
   *
   * @param principalPoint storage for at least 2 floats representing the principal point.
   * @param offset the offset in {@code principalPoint} at which to begin writing the principal
   *     point's values.
   */
  public void getPrincipalPoint(float[] principalPoint, int offset) {
    // Method contents removed.
  }

  /** Returns a {@code float[2]} containing the principal point. The order of values is {cx, cy}. */
  public float[] getPrincipalPoint() {
    // Method contents removed.
  }

  /**
   * Returns the camera's image dimensions. The order of values is {width, height}.
   *
   * @param dimensions storage for at least 2 ints representing the image's width and height.
   * @param offset the offset in {@code dimensions} at which to begin writing the image dimension's
   *     values.
   */
  public void getImageDimensions(int[] dimensions, int offset) {
    // Method contents removed.
  }

  /**
   * Returns a {@code int[2]} containing the image dimensions. The order of values is {width,
   * height}.
   */
  public int[] getImageDimensions() {
    // Method contents removed.
  }
}
