/*
 * Copyright 2017 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;


/**
 * Holds settings that are used to configure the session. To apply a configuration, use {@link
 * com.google.ar.core.Session#configure(com.google.ar.core.Config) }.
 */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public class Config {

  /**
   * Constructs a sensible default configuration. Plane detection and lighting estimation are
   * enabled, and blocking update is selected. This configuration is guaranteed to be supported on
   * all devices that support ARCore.
   */
  public Config(com.google.ar.core.Session session) {
    // Method contents removed.
  }

  /** Returns the currently configured lighting estimation mode. */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config.LightEstimationMode getLightEstimationMode() {
    // Method contents removed.
  }

  /**
   * Sets the desired lighting estimation mode. See the {@link
   * com.google.ar.core.Config.LightEstimationMode LightEstimationMode} enum for available options.
   *
   * @param lightEstimationMode The lighting estimation mode to select.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config setLightEstimationMode(
      com.google.ar.core.Config.LightEstimationMode lightEstimationMode) {
    // Method contents removed.
  }

  /** Returns the currently configured plane finding mode. */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config.PlaneFindingMode getPlaneFindingMode() {
    // Method contents removed.
  }

  /**
   * Sets the desired plane finding mode. See the {@link com.google.ar.core.Config.PlaneFindingMode
   * PlaneFindingMode} enum for available options.
   *
   * @param planeFindingMode The plane finding mode to select.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config setPlaneFindingMode(
      com.google.ar.core.Config.PlaneFindingMode planeFindingMode) {
    // Method contents removed.
  }

  /**
   * Returns the currently configured behavior of {@link com.google.ar.core.Session#update()
   * Session#update()}.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config.UpdateMode getUpdateMode() {
    // Method contents removed.
  }

  /**
   * Sets the behavior of {@link com.google.ar.core.Session#update() Session#update()}. See the
   * {@link com.google.ar.core.Config.UpdateMode UpdateMode} enum for available options.
   *
   * @param updateMode The behavior to select.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config setUpdateMode(com.google.ar.core.Config.UpdateMode updateMode) {
    // Method contents removed.
  }

  /**
   * Sets the cloud anchor mode of the {@link com.google.ar.core.Session Session}.
   *
   * @param cloudAnchorMode The cloud anchor mode.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config setCloudAnchorMode(
      com.google.ar.core.Config.CloudAnchorMode cloudAnchorMode) {
    // Method contents removed.
  }

  /** Returns the currently configured cloud anchor mode. */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config.CloudAnchorMode getCloudAnchorMode() {
    // Method contents removed.
  }

  /**
   * Sets the currently active {@link com.google.ar.core.AugmentedImageDatabase
   * AugmentedImageDatabase}.
   *
   * <p>Overrides the existing {@link com.google.ar.core.AugmentedImageDatabase
   * AugmentedImageDatabase} in the configuration, if any. Any images in the currently active image
   * database that have a TRACKING/PAUSED state will immediately be set to the STOPPED state if a
   * different or null image database is set.
   *
   * <p>This makes a copy of the database, so any changes to the database after calling this method
   * will not be reflected in the current configuration or session.
   *
   * @param augmentedImageDatabase The {@link com.google.ar.core.AugmentedImageDatabase
   *     AugmentedImageDatabase} to be used, or null to disable augmented images.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config setAugmentedImageDatabase(
      com.google.ar.core.AugmentedImageDatabase augmentedImageDatabase) {
    // Method contents removed.
  }

  /**
   * Returns the currently configured {@link com.google.ar.core.AugmentedImageDatabase
   * AugmentedImageDatabase}.
   *
   * <p>This returns a copy of the internally stored database, so any changes to the copy will not
   * affect the current configuration or session.
   *
   * @return The {@link com.google.ar.core.AugmentedImageDatabase AugmentedImageDatabase} from the
   *     session config, or an empty {@link com.google.ar.core.AugmentedImageDatabase
   *     AugmentedImageDatabase} constructed by {@link
   *     com.google.ar.core.AugmentedImageDatabase#AugmentedImageDatabase(com.google.ar.core.Session)
   *     } if no {@link com.google.ar.core.AugmentedImageDatabase AugmentedImageDatabase} has been
   *     configured.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.AugmentedImageDatabase getAugmentedImageDatabase() {
    // Method contents removed.
  }

  /** Returns the currently configured Augmented Faces mode. */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config.AugmentedFaceMode getAugmentedFaceMode() {
    // Method contents removed.
  }

  /**
   * Sets the desired Augmented Faces mode. See {@link com.google.ar.core.Config.AugmentedFaceMode
   * AugmentedFaceMode} for available options. Augmented Faces is currently only supported when
   * using the front-facing (selfie) camera. See {@link
   * com.google.ar.core.Session.Feature#FRONT_CAMERA Session.Feature#FRONT_CAMERA} for details and
   * restrictions.
   *
   * @param augmentedFaceMode The Augmented Face mode to select.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config setAugmentedFaceMode(
      com.google.ar.core.Config.AugmentedFaceMode augmentedFaceMode) {
    // Method contents removed.
  }

  /**
   * Returns the currently configured desired focus mode.
   *
   * <p><b>Note:</b> Desired focus mode may be different from the actual focus mode. See the <a
   * href="https://developers.google.com/ar/devices">ARCore supported devices</a> page for a list of
   * affected devices.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config.FocusMode getFocusMode() {
    // Method contents removed.
  }

  /**
   * Sets the desired focus mode. See {@link com.google.ar.core.Config.FocusMode FocusMode} for
   * available options.
   *
   * <p>The default focus mode varies by device and camera, and is set to optimize AR tracking.
   * Currently the default on most ARCore devices and cameras is {@link
   * com.google.ar.core.Config.FocusMode#FIXED Config.FocusMode#FIXED}, although this default might
   * change in the future.
   *
   * <p><b>Note:</b> On devices where ARCore does not support auto focus due to the use of a fixed
   * focus camera, setting {@link com.google.ar.core.Config.FocusMode#AUTO Config.FocusMode#AUTO}
   * will be ignored. Similarly, on devices where tracking requires auto focus, setting {@link
   * com.google.ar.core.Config.FocusMode#FIXED Config.FocusMode#FIXED} will be ignored. See the <a
   * href="https://developers.google.com/ar/devices">ARCore supported devices</a> page for a list of
   * affected devices.
   *
   * <p>To determine whether the configured ARCore camera supports auto focus, query {@link
   * android.hardware.camera2.CameraCharacteristics#CONTROL_AF_AVAILABLE_MODES}.
   *
   * @param focusMode The desired focus mode.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config setFocusMode(com.google.ar.core.Config.FocusMode focusMode) {
    // Method contents removed.
  }

  /** Returns the Geospatial mode set on this {@link com.google.ar.core.Config Config}. */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config.GeospatialMode getGeospatialMode() {
    // Method contents removed.
  }

  /**
   * Sets the desired Geospatial mode. See {@link com.google.ar.core.Config.GeospatialMode
   * GeospatialMode} for available options.
   *
   * @param geospatialMode The Geospatial mode to select.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config setGeospatialMode(
      com.google.ar.core.Config.GeospatialMode geospatialMode) {
    // Method contents removed.
  }

  /** Returns the Streetscape Geometry mode set on this {@link com.google.ar.core.Config Config}. */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config.StreetscapeGeometryMode getStreetscapeGeometryMode() {
    // Method contents removed.
  }

  /**
   * Sets the desired configuration for the Streetscape Geometry API. See {@link
   * com.google.ar.core.Config.StreetscapeGeometryMode StreetscapeGeometryMode} for available
   * options and usage information.
   *
   * @param streetscapeGeometryMode The Streetscape Geometry mode to set.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config setStreetscapeGeometryMode(
      com.google.ar.core.Config.StreetscapeGeometryMode streetscapeGeometryMode) {
    // Method contents removed.
  }

  /**
   * Sets the desired Instant Placement mode. See {@link
   * com.google.ar.core.Config.InstantPlacementMode InstantPlacementMode} for available options.
   *
   * @param instantPlacementMode the desired Instant Placement mode
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config setInstantPlacementMode(
      com.google.ar.core.Config.InstantPlacementMode instantPlacementMode) {
    // Method contents removed.
  }

  /**
   * Returns the currently configured {@link com.google.ar.core.Config.InstantPlacementMode
   * InstantPlacementMode}.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config.InstantPlacementMode getInstantPlacementMode() {
    // Method contents removed.
  }

  /** Gets the camera image stabilization mode set. */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config.ImageStabilizationMode getImageStabilizationMode() {
    // Method contents removed.
  }

  /**
   * Sets the camera image stabilization mode. See {@link
   * com.google.ar.core.Config.ImageStabilizationMode ImageStabilizationMode} for available options.
   *
   * @param imageStabilizationMode The image stabilization mode to set.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config setImageStabilizationMode(
      com.google.ar.core.Config.ImageStabilizationMode imageStabilizationMode) {
    // Method contents removed.
  }

  /**
   * Sets the desired {@link com.google.ar.core.Config.DepthMode DepthMode}.
   *
   * <p><b>Notes:</b>
   *
   * <ul>
   *   <li>Not all devices support all modes. Use {@link
   *       com.google.ar.core.Session#isDepthModeSupported Session#isDepthModeSupported} to
   *       determine whether the current device and the selected camera support a particular depth
   *       mode.
   *   <li>With depth enabled through this call, calls to {@link
   *       com.google.ar.core.Frame#acquireDepthImage16Bits Frame#acquireDepthImage16Bits} and
   *       {@link com.google.ar.core.Frame#acquireRawDepthImage16Bits
   *       Frame#acquireRawDepthImage16Bits} can be made to acquire the latest computed depth image.
   * </ul>
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config setDepthMode(com.google.ar.core.Config.DepthMode mode) {
    // Method contents removed.
  }

  /** Gets the currently configured {@link com.google.ar.core.Config.DepthMode DepthMode}. */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config.DepthMode getDepthMode() {
    // Method contents removed.
  }

  /** Gets the currently configured {@link com.google.ar.core.Config.SemanticMode SemanticMode}. */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config.SemanticMode getSemanticMode() {
    // Method contents removed.
  }

  /**
   * Sets the desired configuration for the Scene Semantics API. See {@link
   * com.google.ar.core.Config.SemanticMode SemanticMode} for available options and usage
   * information.
   *
   * <p>Not all devices support all modes. Use {@link
   * com.google.ar.core.Session#isSemanticModeSupported Session#isSemanticModeSupported} to
   * determine whether the current device and the selected camera support a particular semantic
   * mode.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config setSemanticMode(
      com.google.ar.core.Config.SemanticMode semanticMode) {
    // Method contents removed.
  }

  /**
   * Gets the currently configured {@link com.google.ar.core.Config.TextureUpdateMode
   * TextureUpdateMode}.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config.TextureUpdateMode getTextureUpdateMode() {
    // Method contents removed.
  }

  /**
   * Sets the desired Texture Update Mode. See {@link com.google.ar.core.Config.TextureUpdateMode
   * TextureUpdateMode} for available options.
   *
   * @param textureUpdateMode The Texture Update Mode to select.
   */
  @androidx.annotation.NonNull
  public com.google.ar.core.Config setTextureUpdateMode(
      com.google.ar.core.Config.TextureUpdateMode textureUpdateMode) {
    // Method contents removed.
  }

  /** @hide */
  protected void finalize() throws java.lang.Throwable {
    // Method contents removed.
  }

  /** Selects the behavior of Augmented Faces subsystem. */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum AugmentedFaceMode {
    /** Disable Augmented Faces mode. */
    DISABLED,
    /**
     * Face 3D mesh is enabled. Augmented Faces is currently only supported when using the
     * front-facing (selfie) camera. See {@link com.google.ar.core.Session.Feature#FRONT_CAMERA
     * Session.Feature#FRONT_CAMERA} for details and additional restrictions.
     */
    MESH3D;
  }

  /**
   * Describes the desired behavior of the ARCore Cloud Anchor API. The Cloud Anchor API uses
   * feature maps to persist an anchor throughout sessions and across devices. See the <a
   * href="https://developers.google.com/ar/develop/java/cloud-anchors/developer-guide">Cloud
   * Anchors developer guide</a> for more information.
   *
   * <p>The default value is {@link com.google.ar.core.Config.CloudAnchorMode#DISABLED
   * Config.CloudAnchorMode#DISABLED}. Use {@link com.google.ar.core.Config#setCloudAnchorMode } to
   * set the Cloud Anchor API mode and {@link com.google.ar.core.Session#configure
   * Session#configure} to configure the session.
   */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum CloudAnchorMode {
    /**
     * The Cloud Anchor API is disabled. Calling {@link
     * com.google.ar.core.Session#hostCloudAnchorAsync Session#hostCloudAnchorAsync} and {@link
     * com.google.ar.core.Session#resolveCloudAnchorAsync } will throw {@link
     * com.google.ar.core.exceptions.CloudAnchorsNotConfiguredException}.
     *
     * <p>This is the default mode.
     */
    DISABLED,
    /**
     * The Cloud Anchor API is enabled. {@link com.google.ar.core.Session#hostCloudAnchorAsync
     * Session#hostCloudAnchorAsync} and {@link com.google.ar.core.Session#resolveCloudAnchorAsync }
     * can be used to host and resolve Cloud Anchors.
     *
     * <p>Using this mode requires your app to do the following:
     *
     * <ul>
     *   <li>Include the <a
     *       href="https://developer.android.com/training/basics/network-ops/connecting"><code>
     *       ACCESS_INTERNET</code></a> permission to the app's AndroidManifest; otherwise, {@link
     *       com.google.ar.core.Session#configure(com.google.ar.core.Config) } throws {@link
     *       java.lang.SecurityException SecurityException}.
     *   <li>Configure <a
     *       href="https://developers.google.com/ar/develop/java/cloud-anchors/developer-guide#authorize_your_app_to_call_the_arcore_api">Keyless
     *       or API Key authorization</a>.
     * </ul>
     *
     * <p>Use {@link com.google.ar.core.Config#setCloudAnchorMode Config#setCloudAnchorMode} to set
     * the Cloud Anchor API mode and {@link com.google.ar.core.Session#configure } to configure the
     * session.
     */
    ENABLED;
  }

  /**
   * Selects the desired depth mode. Not all devices support all modes. Use {@link
   * com.google.ar.core.Session#isDepthModeSupported } to find whether the current device and the
   * selected camera supports a particular depth mode.
   */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum DepthMode {
    /**
     * No depth information will be provided. Calling {@link
     * com.google.ar.core.Frame#acquireDepthImage16Bits Frame#acquireDepthImage16Bits} throws {@link
     * java.lang.IllegalStateException}.
     */
    DISABLED,
    /**
     * On <a href="https://developers.google.com/ar/devices">supported devices</a>, the best
     * possible depth is estimated based on hardware and software sources. Available sources of
     * automatic depth are:
     *
     * <ul>
     *   <li>Depth from motion, using the main RGB camera
     *   <li>Hardware depth sensor, such as a time-of-flight sensor (or ToF sensor)
     * </ul>
     *
     * Provides depth estimation for every pixel in the image, and works best for static scenes.
     * Adds significant computational load.
     *
     * <p>With this mode enabled, {@link com.google.ar.core.Frame#hitTest Frame#hitTest} also
     * returns {@link com.google.ar.core.DepthPoint DepthPoint} in the output {@code
     * List<HitResult>}, which are sampled from the generated depth image for the current frame if
     * available.
     */
    AUTOMATIC,
    /**
     * On <a href="https://developers.google.com/ar/devices">ARCore supported devices</a> that also
     * support the Depth API, provides a "raw", mostly unfiltered, depth image ({@link
     * com.google.ar.core.Frame#acquireRawDepthImage16Bits }) and depth confidence image ({@link
     * com.google.ar.core.Frame#acquireRawDepthConfidenceImage }).
     *
     * <p>The raw depth image is sparse and does not provide valid depth for all pixels. Pixels
     * without a valid depth estimate have a pixel value of 0.
     *
     * <p>Raw depth data is also available when {@link com.google.ar.core.Config.DepthMode#AUTOMATIC
     * DepthMode#AUTOMATIC} is selected.
     *
     * <p>Raw depth is intended to be used in cases that involve understanding of the geometry in
     * the environment.
     */
    RAW_DEPTH_ONLY;
  }

  /**
   * On supported devices, selects the desired camera focus mode. On these devices, the default
   * desired focus mode is currently {@link com.google.ar.core.Config.FocusMode#FIXED
   * Config.FocusMode#FIXED}, although this default might change in the future. See the <a
   * href="https://developers.google.com/ar/devices">ARCore supported devices</a> page for a list of
   * devices on which ARCore does not support changing the desired focus mode.
   *
   * <p>For optimal AR tracking performance, use the focus mode provided by the default session
   * config. While capturing pictures or video, use {@link com.google.ar.core.Config.FocusMode#AUTO
   * Config.FocusMode#AUTO}. For optimal AR tracking, revert to the default focus mode once auto
   * focus behavior is no longer needed. If your app requires fixed focus camera, call {@link
   * #setFocusMode} using {@link com.google.ar.core.Config.FocusMode#FIXED } before enabling the AR
   * session. This ensures that your app always uses fixed focus, even if the default camera config
   * focus mode changes in a future release.
   */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum FocusMode {
    /** Fixed focus mode. */
    FIXED,
    /** Auto focus mode. */
    AUTO;
  }

  /**
   * Describes the desired behavior of the ARCore Geospatial API. The Geospatial API uses a
   * combination of Google's Visual Positioning System (VPS) and GPS to determine the geospatial
   * pose.
   *
   * <p>The Geospatial API is able to provide the best user experience when it is able to generate
   * high accuracy poses. However, the Geospatial API can be used anywhere, as long as the device is
   * able to determine its location, even if the available location information has low accuracy.
   *
   * <ul>
   *   <li>In areas with VPS coverage, the Geospatial API is able to generate high accuracy poses.
   *       This can work even where GPS accuracy is low, such as dense urban environments. Under
   *       typical conditions, VPS can be expected to provide positional accuracy typically better
   *       than 5 meters and often around 1 meter, and a rotational accuracy of better than 5
   *       degrees. Use {@link
   *       com.google.ar.core.Session#checkVpsAvailabilityAsync(double,double,Consumer)
   *       Session#checkVpsAvailabilityAsync(double, double, Consumer)} to determine if a given
   *       location has VPS coverage.
   *   <li>In outdoor environments with few or no overhead obstructions, GPS may be sufficient to
   *       generate high accuracy poses. GPS accuracy may be low in dense urban environments and
   *       indoors.
   * </ul>
   *
   * <p>A small number of ARCore supported devices do not support the Geospatial API. Use {@link
   * com.google.ar.core.Session#isGeospatialModeSupported(com.google.ar.core.Config.GeospatialMode)
   * } to determine if the current device is supported. Affected devices are also indicated on the
   * <a href="https://developers.google.com/ar/devices">ARCore supported devices page</a>.
   *
   * <p>When the Geospatial API and the Depth API are enabled, output images from the Depth API will
   * include terrain and building geometry when in a location with VPS coverage. See the <a
   * href="https://developers.google.com/ar/develop/java/depth/geospatial-depth">Geospatial Depth
   * Developer Guide</a> for more information.
   *
   * <p>The default value is {@link com.google.ar.core.Config.GeospatialMode#DISABLED
   * Config.GeospatialMode#DISABLED}. Use {@link com.google.ar.core.Config#setGeospatialMode } to
   * set the desired mode.
   */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum GeospatialMode {
    /**
     * The Geospatial API is disabled. When a configuration with {@link
     * com.google.ar.core.Config.GeospatialMode#DISABLED } becomes active on the {@link
     * com.google.ar.core.Session Session}, current {@link com.google.ar.core.Earth Earth} and
     * {@link com.google.ar.core.Anchor Anchor} objects created from {@link
     * com.google.ar.core.Earth#createAnchor(double,double,double,float,float,float,float)
     * Earth#createAnchor(double, double, double, float, float, float, float)} will stop updating;
     * have their {@link com.google.ar.core.TrackingState TrackingState} set to {@link
     * com.google.ar.core.TrackingState#STOPPED TrackingState#STOPPED}; and {@link
     * com.google.ar.core.Session#getEarth Session#getEarth} will return {@code null}. If
     * re-enabled, you will need to call {@link com.google.ar.core.Session#getEarth
     * Session#getEarth} again to obtain a new {@link com.google.ar.core.Earth Earth} object.
     */
    DISABLED,
    /**
     * The Geospatial API is enabled. {@link com.google.ar.core.Session#getEarth Session#getEarth}
     * will return valid {@link com.google.ar.core.Earth Earth} objects when a configuration becomes
     * active with this mode through {@link com.google.ar.core.Session#configure Session#configure}.
     *
     * <p>Using this mode requires your app do the following:
     *
     * <ul>
     *   <li>Include the <a
     *       href="https://developer.android.com/training/basics/network-ops/connecting"><code>
     *       ACCESS_INTERNET</code></a> permission to the app's AndroidManifest; otherwise, {@link
     *       com.google.ar.core.Session#configure(com.google.ar.core.Config) } throws {@link
     *       java.lang.SecurityException SecurityException}.
     *   <li>Include the Google Play Services Location Library as a dependency for your app. See <a
     *       href="https://developers.google.com/android/guides/setup#declare-dependencies">Declare
     *       dependencies for Google Play services</a> for instructions on how to include this
     *       library in your app. If this library is not linked, {@link
     *       com.google.ar.core.Session#configure(com.google.ar.core.Config)
     *       Session#configure(Config)} throws {@link
     *       com.google.ar.core.exceptions.GooglePlayServicesLocationLibraryNotLinkedException
     *       GooglePlayServicesLocationLibraryNotLinkedException}.
     *   <li>Request and be granted the <a
     *       href="https://developer.android.com/training/location/permissions">Android <code>
     *       ACCESS_FINE_LOCATION</code> permission</a>; otherwise, {@link
     *       com.google.ar.core.Session#configure(com.google.ar.core.Config) } throws {@link
     *       com.google.ar.core.exceptions.FineLocationPermissionNotGrantedException
     *       FineLocationPermissionNotGrantedException}.
     * </ul>
     *
     * <p>Location is tracked only while the {@link com.google.ar.core.Session Session} is resumed.
     * While the {@link com.google.ar.core.Session Session} is paused, {@link
     * com.google.ar.core.Earth Earth}'s {@link com.google.ar.core.TrackingState TrackingState} will
     * be {@link com.google.ar.core.TrackingState#PAUSED TrackingState#PAUSED}.
     *
     * <p>For more information, see documentation on <a
     * href="https://developers.google.com/ar/develop/java/geospatial/developer-guide">the
     * Geospatial API on Google Developers</a>.
     *
     * <p>When the Geospatial API and the Depth API are enabled, output images from the Depth API
     * will include terrain and building geometry when in a location with VPS coverage. See the <a
     * href="https://developers.google.com/ar/develop/java/depth/geospatial-depth">Geospatial Depth
     * Developer Guide</a> for more information.
     *
     * <p>This mode is not compatible with the front-facing (selfie) camera. If {@link
     * com.google.ar.core.Config.GeospatialMode Config.GeospatialMode} is {@link #ENABLED} on a
     * session using the front-facing (selfie) camera, {@link
     * com.google.ar.core.Session#configure(com.google.ar.core.Config) Session#configure(Config)}
     * will throw {@link com.google.ar.core.exceptions.UnsupportedConfigurationException}.
     *
     * <p>Not all devices support {@link com.google.ar.core.Config.GeospatialMode#ENABLED
     * Config.GeospatialMode#ENABLED}, use {@link
     * com.google.ar.core.Session#isGeospatialModeSupported } to check if the current device and
     * selected camera support enabling this mode. These checks are done in the call to {@link
     * com.google.ar.core.Session#configure(com.google.ar.core.Config) Session#configure(Config)}.
     */
    ENABLED;
  }

  /**
   * Describes the behavior of the Electronic Image Stabilization (EIS) API. When enabled, EIS
   * smoothes the camera feed and helps correct video shakes in the camera preview. See the <a
   * href="https://developers.google.com/ar/develop/java/electronic-image-stabilization">Electronic
   * Image Stabilization developer guide</a> for more information.
   *
   * <p>Not all devices support all modes. Use {@link
   * com.google.ar.core.Session#isImageStabilizationModeSupported(com.google.ar.core.Config.ImageStabilizationMode)
   * } to check if a {@link com.google.ar.core.Config.ImageStabilizationMode
   * Config.ImageStabilizationMode} is supported with the selected camera configuration.
   *
   * <p>Attempting to use {@link com.google.ar.core.Session#configure(com.google.ar.core.Config)
   * Session#configure(Config)} to configure a {@link
   * com.google.ar.core.Config.ImageStabilizationMode Config.ImageStabilizationMode} mode on a
   * device that that isn't supported, {@link
   * com.google.ar.core.Session#configure(com.google.ar.core.Config) } will throw {@link
   * com.google.ar.core.exceptions.UnsupportedConfigurationException}.
   *
   * <p>The default value is {@link com.google.ar.core.Config.ImageStabilizationMode#OFF
   * Config.ImageStabilizationMode#OFF}. Use {@link
   * com.google.ar.core.Config#setImageStabilizationMode } to set the desired mode.
   */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum ImageStabilizationMode {
    /**
     * Image stabilization is off.
     *
     * <p>This is the default mode.
     */
    OFF,
    /**
     * Image stabilization is on. {@link
     * com.google.ar.core.Frame#transformCoordinates3d(com.google.ar.core.Coordinates2d,FloatBuffer,com.google.ar.core.Coordinates3d,FloatBuffer)
     * Frame#transformCoordinates3d(Coordinates2d, FloatBuffer, Coordinates3d, FloatBuffer)} can be
     * used to convert 2D coordinates to {@link
     * com.google.ar.core.Coordinates3d#EIS_NORMALIZED_DEVICE_COORDINATES } and {@link
     * com.google.ar.core.Coordinates3d#EIS_TEXTURE_NORMALIZED }.
     */
    EIS;
  }

  /**
   * Select the behavior of Instant Placement. Default value is {@link #DISABLED}.
   *
   * <p>Use {@link
   * com.google.ar.core.Config#setInstantPlacementMode(com.google.ar.core.Config.InstantPlacementMode)
   * Config#setInstantPlacementMode(InstantPlacementMode)} to set the desired mode.
   */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum InstantPlacementMode {
    /**
     * Disable Instant Placement. {@link
     * com.google.ar.core.Frame#hitTestInstantPlacement(float,float,float)
     * Frame#hitTestInstantPlacement(float, float, float)} will return an empty list.
     *
     * <p>When Instant Placement is disabled, any {@link com.google.ar.core.InstantPlacementPoint
     * InstantPlacementPoint} that has {@link
     * com.google.ar.core.InstantPlacementPoint.TrackingMethod#SCREENSPACE_WITH_APPROXIMATE_DISTANCE
     * } tracking method will result in tracking state becoming permanently {@link
     * com.google.ar.core.TrackingState#STOPPED TrackingState#STOPPED}.
     */
    DISABLED,
    /**
     * Enable Instant Placement. If the hit test is successful, {@link
     * com.google.ar.core.Frame#hitTestInstantPlacement(float,float,float) } will return a single
     * {@link com.google.ar.core.InstantPlacementPoint InstantPlacementPoint} with the +Y pointing
     * upward, against gravity. Otherwise, returns an empty result set.
     *
     * <p>This mode is currently intended to be used with hit tests against horizontal surfaces.
     *
     * <p>Hit tests may also be performed against surfaces with any orientation, however:
     *
     * <ul>
     *   <li>The resulting Instant Placement point will always have a pose with +Y pointing upward,
     *       against gravity.
     *   <li>No guarantees are made with respect to orientation of +X and +Z. Specifically, a hit
     *       test against a vertical surface, such as a wall, will not result in a pose that's in
     *       any way aligned to the plane of the wall, other than +Y being up, against gravity.
     *   <li>The {@link com.google.ar.core.InstantPlacementPoint InstantPlacementPoint}'s tracking
     *       method may never become {@link
     *       com.google.ar.core.InstantPlacementPoint.TrackingMethod#FULL_TRACKING } or may take a
     *       long time to reach this state. The tracking method remains {@link
     *       com.google.ar.core.InstantPlacementPoint.TrackingMethod#SCREENSPACE_WITH_APPROXIMATE_DISTANCE
     *       } until a (tiny) horizontal plane is fitted at the point of the hit test.
     * </ul>
     */
    LOCAL_Y_UP;
  }

  /** Select the behavior of the lighting estimation subsystem. */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum LightEstimationMode {
    /** Lighting estimation is disabled. */
    DISABLED,
    /**
     * Lighting estimation is enabled, generating a single-value intensity estimate and three (R, G,
     * B) color correction values.
     */
    AMBIENT_INTENSITY,
    /**
     * Lighting estimation is enabled, generating inferred Environmental HDR lighting estimation in
     * linear color space.
     *
     * <p>This mode is incompatible with the front-facing (selfie) camera. If set on a Session
     * created for the front-facing camera, the call to configure will fail.
     */
    ENVIRONMENTAL_HDR;
  }

  /** Select the behavior of the plane detection subsystem. */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum PlaneFindingMode {
    /** Plane detection is disabled. */
    DISABLED,
    /** Detection of only horizontal planes is enabled. */
    HORIZONTAL,
    /** Detection of only vertical planes is enabled. */
    VERTICAL,
    /** Detection of both horizontal and vertical planes is enabled. */
    HORIZONTAL_AND_VERTICAL;
  }

  /**
   * Describes the desired behavior of the Scene Semantics API. Scene Semantics uses a machine
   * learning model to label each pixel from the camera feed with a {@link
   * com.google.ar.core.SemanticLabel SemanticLabel}. See the <a
   * href="https://developers.google.com/ar/develop/java/scene-semantics">Scene Semantics Developer
   * Guide</a> for more information.
   *
   * <p>The Scene Semantics API is currently able to distinguish between outdoor labels specified by
   * {@link com.google.ar.core.SemanticLabel SemanticLabel}. Usage indoors is currently unsupported
   * and may yield unreliable results.
   *
   * <p>A small number of ARCore supported devices do not support the Scene Semantics API. Use
   * {@link
   * com.google.ar.core.Session#isSemanticModeSupported(com.google.ar.core.Config.SemanticMode)
   * Session#isSemanticModeSupported(Config.SemanticMode)} to query for support for Scene Semantics.
   * Affected devices are also indicated on the <a
   * href="https://developers.google.com/ar/devices">ARCore supported devices page</a>.
   *
   * <p>The default value is {@link com.google.ar.core.Config.SemanticMode#DISABLED
   * Config.SemanticMode#DISABLED}. Use {@link com.google.ar.core.Config#setSemanticMode } to set
   * the desired mode.
   */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum SemanticMode {
    /**
     * The Scene Semantics API is disabled. Calls to {@link
     * com.google.ar.core.Frame#acquireSemanticImage() Frame#acquireSemanticImage()}, {@link
     * com.google.ar.core.Frame#acquireSemanticConfidenceImage() }, and {@link
     * com.google.ar.core.Frame#getSemanticLabelFraction(com.google.ar.core.SemanticLabel) } will
     * not return valid results.
     *
     * <p>This is the default mode.
     */
    DISABLED,
    /**
     * The Scene Semantics API is enabled. Calls to {@link
     * com.google.ar.core.Frame#acquireSemanticImage() Frame#acquireSemanticImage()}, {@link
     * com.google.ar.core.Frame#acquireSemanticConfidenceImage() }, and {@link
     * com.google.ar.core.Frame#getSemanticLabelFraction(com.google.ar.core.SemanticLabel) } will
     * return valid results.
     *
     * <p>Use {@link com.google.ar.core.Config#setSemanticMode Config#setSemanticMode} to set this
     * mode.
     */
    ENABLED;
  }

  /**
   * Describes the behavior of the Geospatial Streetscape Geometry API. The Streetscape Geometry API
   * provides polygon meshes of terrain, buildings, and other structures in a radius surrounding the
   * device. See the <a
   * href="https://developers.google.com/ar/develop/java/geospatial/streetscape-geometry">Streetscape
   * Geometry Developer Guide</a> for additional information.
   *
   * <p>When Streetscape Geometry is enabled, {@link
   * com.google.ar.core.Session#getAllTrackables(java.lang.Class) Session#getAllTrackables(Class)}
   * and {@link com.google.ar.core.Frame#getUpdatedTrackables(java.lang.Class) }} may additionally
   * return {@link com.google.ar.core.StreetscapeGeometry StreetscapeGeometry} objects.
   *
   * <p>The Streetscape Geometry API requires both {@link Config.StreetscapeGeometry} to be set to
   * {@link com.google.ar.core.Config.StreetscapeGeometryMode#ENABLED
   * Config.StreetscapeGeometryMode#ENABLED} and {@link com.google.ar.core.Config.GeospatialMode
   * Config.GeospatialMode} to be set to {@link com.google.ar.core.Config.GeospatialMode#ENABLED
   * Config.GeospatialMode#ENABLED}.
   *
   * <p>The default value is {@link com.google.ar.core.Config.StreetscapeGeometryMode#DISABLED
   * Config.StreetscapeGeometryMode#DISABLED}. Use {@link
   * com.google.ar.core.Config#setStreetscapeGeometryMode(com.google.ar.core.Config.StreetscapeGeometryMode)
   * } to set the desired mode.
   */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum StreetscapeGeometryMode {
    /**
     * The Streetscape Geometry API is disabled.
     *
     * <p>This is the default mode.
     */
    DISABLED,
    /**
     * The Streetscape Geometry API is enabled. {@link
     * com.google.ar.core.Session#getAllTrackables(java.lang.Class) Session#getAllTrackables(Class)}
     * and {@link com.google.ar.core.Frame#getUpdatedTrackables(java.lang.Class) }} may additionally
     * return {@link com.google.ar.core.StreetscapeGeometry StreetscapeGeometry} objects. This mode
     * requires {@link com.google.ar.core.Config.GeospatialMode Config.GeospatialMode} to be set to
     * {@link com.google.ar.core.Config.GeospatialMode#ENABLED }.
     *
     * <p>Use {@link
     * com.google.ar.core.Config#setStreetscapeGeometryMode(com.google.ar.core.Config.StreetscapeGeometryMode)
     * Config#setStreetscapeGeometryMode(StreetscapeGeometryMode)} to set this mode.
     */
    ENABLED;
  }

  /**
   * Describes how ARCore will update the camera texture. See <a
   * href="https://developers.google.com/ar/develop/java/vulkan">Vulkan Rendering developer
   * guide</a> for more information.
   *
   * <p>The default value is {@link
   * com.google.ar.core.Config.TextureUpdateMode#BIND_TO_TEXTURE_EXTERNAL_OES
   * Config.TextureUpdateMode#BIND_TO_TEXTURE_EXTERNAL_OES}. Use {@link
   * com.google.ar.core.Config#setTextureUpdateMode(com.google.ar.core.Config.TextureUpdateMode)
   * Config#setTextureUpdateMode(Config.TextureUpdateMode)} to set the desired mode.
   */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum TextureUpdateMode {
    /**
     * ARCore provides the camera image through the {@code GL_TEXTURE_EXTERNAL_OES} texture provided
     * to {@link com.google.ar.core.Session#setCameraTextureName(int)
     * Session#setCameraTextureName(int)} or {@link
     * com.google.ar.core.Session#setCameraTextureNames(int[])
     * Session#setCameraTextureNames(int[])}.
     *
     * <p>This is the default mode.
     */
    BIND_TO_TEXTURE_EXTERNAL_OES,
    /**
     * ARCore provides the camera image through a {@link android.hardware.HardwareBuffer}. The
     * hardware buffer for a {@link com.google.ar.core.Frame Frame} is accessible via {@link
     * com.google.ar.core.Frame#getHardwareBuffer() Frame#getHardwareBuffer()}. See documentation on
     * <a href="https://developer.android.com/ndk/reference/group/a-hardware-buffer">Native Hardware
     * Buffer</a> in the Android NDK.
     *
     * <p>The client app is responsible for binding it to a {@code GL_TEXTURE_EXTERNAL_OES} (OpenGL
     * ES) or {@code VkImage} (Vulkan).
     *
     * <p>When a configuration is active with {@link
     * com.google.ar.core.Config.TextureUpdateMode#EXPOSE_HARDWARE_BUFFER }, texture names provided
     * to {@link com.google.ar.core.Session#setCameraTextureName(int) } and {@link
     * com.google.ar.core.Session#setCameraTextureNames(int[])
     * Session#setCameraTextureNames(int[])}.are ignored.
     *
     * <p>This is only available on Android API levels 27 and above. Using {@link
     * com.google.ar.core.Session#configure(com.google.ar.core.Config) } to set {@link
     * com.google.ar.core.Config.TextureUpdateMode#EXPOSE_HARDWARE_BUFFER
     * Config.TextureUpdateMode#EXPOSE_HARDWARE_BUFFER} on an incompatible device will throw {@link
     * com.google.ar.core.exceptions.UnsupportedConfigurationException}.
     */
    EXPOSE_HARDWARE_BUFFER;
  }

  /** Selects the behavior of {@link com.google.ar.core.Session#update() Session#update()}. */
  @SuppressWarnings({"unchecked", "deprecation", "all"})
  public enum UpdateMode {
    /**
     * {@code update()} will normally wait until a new camera image is available. On most devices
     * the camera is configured to capture 30 frames per second.
     *
     * <p>Note: If the camera image does not arrive by the built-in timeout (currently 66ms), then
     * {@code update()} will instead return the most recent {@link com.google.ar.core.Frame Frame}
     * object.
     */
    BLOCKING,
    /**
     * {@code update()} will return immediately without blocking. If no new camera image is
     * available, then {@code update()} will return the most recent {@link com.google.ar.core.Frame
     * Frame} object.
     */
    LATEST_CAMERA_IMAGE;
  }
}
