/*
 * Copyright 2018 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;

/** 2D coordinate systems supported by ARCore. */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum Coordinates2d {
  /** GPU texture, (x,y) in pixels. */
  TEXTURE_TEXELS,
  /** GPU texture coordinates, (s,t) normalized to [0.0f, 1.0f] range. */
  TEXTURE_NORMALIZED,
  /** CPU image, (x,y) in pixels. */
  IMAGE_PIXELS,
  /** CPU image, (x,y) normalized to [0.0f, 1.0f] range. */
  IMAGE_NORMALIZED,
  /**
   * OpenGL Normalized Device Coordinates, display-rotated, (x,y) normalized to [-1.0f, 1.0f] range.
   */
  OPENGL_NORMALIZED_DEVICE_COORDINATES,
  /** Android view, display-rotated, (x,y) in pixels. */
  VIEW,
  /** Android view, display-rotated, (x,y) normalized to [0.0f, 1.0f] range. */
  VIEW_NORMALIZED;
}
