/*
 * Copyright 2023 Google LLC
 *
 * Licensed for use under "ARCore Additional Terms of Service". You may obtain
 * a copy of the license at https://developers.google.com/ar/develop/terms.
 */

package com.google.ar.core;

/** 3D coordinates supported by ARCore. */
@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum Coordinates3d {
  /**
   * GPU texture coordinates, using the Z component to compensate for perspective shift when using
   * Electronic Image Stabilization (EIS).
   *
   * <p>Use with {@link
   * com.google.ar.core.Frame#transformCoordinates3d(com.google.ar.core.Coordinates2d,float[],com.google.ar.core.Coordinates3d,float[])
   * Frame#transformCoordinates3d(Coordinates2d, float[], Coordinates3d, float[])}. See the <a
   * href="https://developers.google.com/ar/develop/java/electronic-image-stabilization">Electronic
   * Image Stabilization developer guide</a> for more information.
   */
  EIS_TEXTURE_NORMALIZED,
  /**
   * Normalized Device Coordinates (NDC), display-rotated, (x,y) normalized to [-1.0f, 1.0f] range
   * to compensate for perspective shift for EIS.
   *
   * <p>Use with {@link
   * com.google.ar.core.Frame#transformCoordinates3d(com.google.ar.core.Coordinates2d,float[],com.google.ar.core.Coordinates3d,float[])
   * Frame#transformCoordinates3d(Coordinates2d, float[], Coordinates3d, float[])}. See the <a
   * href="https://developers.google.com/ar/develop/java/electronic-image-stabilization">Electronic
   * Image Stabilization developer guide</a> for more information.
   */
  EIS_NORMALIZED_DEVICE_COORDINATES;
}
